#include <stdio.h>
#include <stdlib.h>
#include "bmp.h"

extern int fexist (char *);                     // User supplied routine that
                                                // returns TRUE if file exists
                                                // or FALSE if not.  Pass the
                                                // routine your filename as "char *"   

extern int AccessBMP (char *);                  // func to check BMP file 

                                                // func to convert BMP to BGI
extern void ProcessBMP (char *, char far *VidBuf[5]);

BITMAPFILEHEADER BMPHeader;
BITMAPINFOHEADER BMPInfo;

unsigned _stklen = 10240;                       // I like larger stacks

void main (int argc, char *argv[])
{
        int x;
        char far *VidBuf[5];                    // stores image


        if (argc != 2 || !fexist(argv[1]))      // Yo: tell me what to convert
        {
                printf("\n\aUseage: BMP2BGI <filename.BMP>\n");
                if (argc == 2) printf("\n\t Check to make sure %s exists\n", argv[1]);
                exit(0);
        }

        x  = AccessBMP(argv[1]);                // Check out the BMP image to
                                                // see if it's legitimate   

////////////////////////////////////////////////// Inform user about image's characteristx  
        clrscr();
        printf("\nFILE: %s",argv[1]);
        printf("\n");
        printf("\nType of BMP: ");
                       if (BMPInfo.biBitCount == 1) printf("Monochrome");
                       else if (BMPInfo.biBitCount == 4) printf("16-Color");
                       else if (BMPInfo.biBitCount == 8) printf("256-Color");
                       else printf("24-Bit RGB");
        if (BMPInfo.biCompression==0) printf("\nCompression Scheme: NONE");
        else                          printf("\nCompression Scheme: %u",BMPInfo.biCompression);
        printf("\nStructure Size: %u",BMPHeader.bfSize-BMPHeader.bfOffBits);
        printf("\nHoriz. Resolution: %u",BMPInfo.biXPelsPerMeter);
        printf("\nVert. Resolution: %u",BMPInfo.biYPelsPerMeter);
        printf("\nPicture Width: %u",BMPInfo.biWidth);
        printf("\nPicture Height: %u",BMPInfo.biHeight);
        printf("\n# of Bits per pixel: %u",BMPInfo.biBitCount);
        printf("\n# of Bitmap Bytes: %u",BMPInfo.biSizeImage);
        printf("\n# of Color Planes: %u",BMPInfo.biPlanes);
        printf("\n");
        printf("\n\nConversion Status:");

        switch(x)
        {
                case BMP_OK:            printf("\n\t A-Ok. Proceeding to Convert.\n\n");
                                        break;
                case BMP_BadDriver:     printf("\n\tGraphics Driver not found.");
                                        printf("\n\tCheck your Video Card.\n\n");
                                        break;
                case BMP_TooBig:        printf("\n\tBMP file is okay, but the image");
                                        printf("\n\tis larger than your video card");
                                        printf("\n\tcan display.  The BGI image will");
                                        printf("\n\tbe right-clipped, and you will see which");
                                        printf("\n\tparts will remain intact.\n\n");
                                        break;
                case BMP_WrongVideo:    printf("\n\tThis verison of BMP2BGI can only");
                                        printf("\n\taccomodate 16-Color BMP's. Support");
                                        printf("\n\tshareware and I\'ll be more motivated");
                                        printf("\n\tto implement Mono- & 256-color BMP");
                                        printf("\n\tconversions.\n\n");
                                        break;
                case BMP_Compression:   printf("\n\tBMP file was saved in a Compressed");
                                        printf("\n\tformat.  BMP2BGI does not support");
                                        printf("\n\tthis feature as of yet.\n\n");
                                        break;
                default:                printf("\n\t* INTERNAL ERROR *");
                                        printf("\n\t  **** ABORT ****\n\n");
                                        break;
        }

        if (x == BMP_OK || x == BMP_TooBig)
        { 
           printf("\n\n> PRESS ANY KEY WHEN READY...");
           getch();
           ProcessBMP(argv[1],VidBuf);

           clrscr();                            // PLEASE DO NOT ERASE THIS!
           printf("\n\nConversion Complete. Saved w/ \'.BGI\' file extension");
           printf("\n\n");
           printf("\nBMP2BGI: A shareware program by R.G.Rasulis, Jr.");
           printf("\n         Please support by sending $10 to me:");
           printf("\n         Rich Rasulis, Jr.");
           printf("\n         c/o Dep\'t of Psych.");
           printf("\n         U. of Montana");
           printf("\n         Missoula, MT  59801\n\n");
        }

}