{ Hardware Panning & Split Screen / VGA Text Mode 720x400 }

uses Txt;

{  Split2Static  }
procedure Split2Static;
var A:byte;
begin
  A:=Port[$3DA];                  { Attribute mode control }
  Port[$3C0]:=$10 or $20;
  Port[$3C0]:=Port[$3C1] or $20;
end;
{  SplitScreen  }
procedure SplitScr(N:integer);         { 1023..0 }
var A:byte;
begin             { Screen-up is Start addr high/low, -down is $B800 }
  Port[$3D4]:=$18; Port[$3D5]:=Lo(N);  { Bit 0-7, Line compare }
  Port[$3D4]:=$07; A:=Port[$3D5];      { Bit 8, Overflow }
  if N<$100 then A:=A and $EF else A:=A or $10;
  Port[$3D5]:=A;
  Port[$3D4]:=$09; A:=Port[$3D5];      { Bit 9, Maximum scan line }
  if N<$200 then A:=A and $BF else A:=A or $40;
  Port[$3D5]:=A;
end;
{  SetSize  }
procedure SetSize(X,Y:integer);
begin
  Port[$3D4]:=$13; Port[$3D5]:=X shr 1;
  MemW[0:$44A]:=X;
  MemW[0:$484]:=Y-1;
  MemW[0:$44C]:=X*Y;
end;
{  SetTextDisplay  }
procedure SetTextDisp(X,Y:integer);
var A:byte;
begin
  repeat until Port[$3DA] and 8<>8;
  repeat until Port[$3DA] and 8=8;
  Port[$3D4]:=$0C; Port[$3D5]:=Hi(Y shr 4*160+X div 9);  { Start XY addr }
  Port[$3D4]:=$0D; Port[$3D5]:=Lo(Y shr 4*160+X div 9);
  repeat until Port[$3DA] and 1<>1;
  repeat until Port[$3DA] and 1=1;
  Port[$3D4]:=$08; Port[$3D5]:=Port[$3D5] and $E0 or (Y and 15);
  A:=Port[$3DA];                                         { Horizental PEL }
  Port[$3C0]:=$13 or $20; Port[$3C0]:=(X+8) mod 9;
end;
{  Scroll  }
procedure Scroll;
var K,K2,X,Y,N:integer;
begin
  VideoMode(3); TextWidth:=320;
  SetSize(160,50);
  TextBar(1,1,160,50,$1F,' '); TextBox(1,1,160,50,$1F,2);
  for K:=0 to 87 do PrintText(35*(K and 3)+10,2*(K shr 2)+4,$19+K mod 7,
    'Hardware Panning...Smooth......');
  PrintBig(47,10,8,16,$5F,'','Hardware',GetFontAddr(6)^);
  PrintBig(47,25,8,16,$5F,'','Panning',GetFontAddr(6)^);
  X:=0; Y:=0; K:=0; K2:=-1; N:=6;
  SplitScr(299); Split2Static;
  repeat
    SetTextDisp(X,Y);
    if KeyPressed=1 then begin K:=Key; if K=K2 then K:=Key; K2:=K; end;
    case K of
      $4B00:Dec(X,N);  $4D00:Inc(X,N);      { Left,Right }
      $4800:Dec(Y,N);  $5000:Inc(Y,N);      { Up,Down }
      $4700:begin Dec(X,N); Dec(Y,N); end;  { Home }
      $4F00:begin Dec(X,N); Inc(Y,N); end;  { End }
      $4900:begin Inc(X,N); Dec(Y,N); end;  { PgUp }
      $5100:begin Inc(X,N); Inc(Y,N); end;  { PgDn }
    end;
    if X<0 then X:=0; if X>720 then X:=720;
    if Y<0 then Y:=0; if Y>500 then Y:=500;
  until (K=$011B) or (K=$1C0D);             { Esc,Enter }
  SetTextDisp(0,0); VideoMode(3);
end;

begin
  Scroll;
end.
