{ķ
                                   
   ۱      ۱   ۱  SVGA/VESA Graph Demo     
   ۱  ۱ ۱   640x480--1024x768 256C   
   ۱   ۱ ۱   ۱  Written by Jou-Nan Chen  
                                       
 ͼ}

uses Crt,Graph,Txt;

const Name:array[0..9] of string[8]=(
	'Line1','Line2' ,'Line3' ,'Line4', 'Line5',
	'Rose' ,'Dough1','Dough2','Mirror','Flowers');
var Ratio:real;    { 1=640, 1.25=800, 1.6=1024 }
    Pal:array[0..767] of byte;

{  Graph1  }
procedure Graph1(Xc,Yc,Xr,Yr:integer);
var X0,Y0,X1,Y1,I,X,Y:integer;
    A,M:real;
begin
  A:=0; X:=Trunc(Xr*0.4); Y:=Trunc(Yr*0.4);
  for I:=0 to 800 do begin
    X0:=Xc+Trunc(Xr*Cos(A));
    Y0:=Yc+Trunc(Yr*Sin(5*A)*Cos(A/1.5));
    M:=Sin(A);
    X1:=Trunc(X*M);
    Y1:=Trunc(Y*M);
    SetColor(I div 12+32);
    Line(X0,Y0,X0+X1,Y0+Y1);
    Line(X0,Y0,X0+X1,Y0-Y1);
    A:=A+Pi/400;
  end;
end;
{  Graph2  }
procedure Graph2(Xc,Yc,Xr,Yr:integer);
var X1,Y1,X2,Y2,I:integer;
    A,M,N:real;
begin
  A:=0;
  for I:=0 to 500 do begin
    M:=Sin(A); N:=Cos(A);
    X1:=Xc+Trunc(1.2*(Xr+Xr/3*(1+0.5*Cos(12*A))*N)*N);
    X2:=Xc+Trunc(1.2*(Yr+Yr/3*(1+0.5*Sin(12*A))*N)*N);
    Y1:=Yc-Trunc((Xr+Xr/3*(1+0.5*Cos(10*A))*M)*M);
    Y2:=Yc-Trunc((Yr+Yr/2*(1+0.5*Cos(15*A))*M)*M);
    SetColor(I div 7+32);
    Line(X1,Y1,X2,Y2);
    A:=A+Pi/250;
  end;
end;
{  Graph3  }
procedure Graph3(Xc,Yc,R:integer);
var X1,Y1,X2,Y2,I:integer;
    A,F:real;
begin
  A:=0;
  for I:=0 to 1600 do begin
    F:=R*(1+0.25*Cos(20*A))*(1+Sin(4*A));
    X1:=Xc+Trunc(F*Cos(A));
    X2:=Xc+Trunc(F*Cos(A+Pi/5));
    Y1:=Yc-Trunc(F*Sin(A));
    Y2:=Yc-Trunc(F*Sin(A+Pi/5));
    SetColor(I div 23+32);
    Line(X1,Y1,X2,Y2);
    A:=A+Pi/800;
  end;
end;
{  Graph4  }
procedure Graph4(Xc,Yc,R:integer);
var X1,Y1,X2,Y2,I:integer;
    A,F:real;
begin
  A:=0;
  for I:=0 to 1600 do begin
    F:=R*(1+0.25*Cos(4*A))*(1+Sin(8*A));
    X1:=Xc+Trunc(F*Cos(A));
    X2:=Xc+Trunc(F*Cos(A+Pi/8));
    Y1:=Yc-Trunc(F*Sin(A));
    Y2:=Yc-Trunc(F*Sin(A+Pi/8));
    SetColor(I div 23+32);
    Line(X1,Y1,X2,Y2);
    A:=A+Pi/800;
  end;
end;
{  Graph5  }
procedure Graph5(Xc,Yc,R:integer);
var X1,Y1,X2,Y2,I:integer;
    A,E:real;
begin
  A:=0;
  for I:=0 to 800 do begin
    E:=R*(1+0.5*Sin(2.5*A));
    X1:=Xc+Trunc(E*Cos(A));
    X2:=Xc+Trunc(E*Cos(A+Pi/4));
    Y1:=Yc-Trunc(E*Sin(A));
    Y2:=Yc-Trunc(E*Sin(A+Pi/4));
    SetColor(I div 12+32);
    Line(X1,Y1,X2,Y2);
    A:=A+Pi/200;
  end;
end;
{  Graph6  }
procedure Graph6(Xi,Yi,R,Xr,Yr:integer);
var X,Y,N,P,K,I,Bx,By:integer;
    A,E:real;
begin
  for N:=2 to 7 do
    for P:=1 to 6 do begin
      if N mod 2=0 then K:=2 else K:=1;
      A:=0; SetColor(6*N+P+48);
      for I:=0 to 15*N*K do begin
	E:=R/5*Sin(N*P*A)+R*Sin(N*A);
	X:=Xr*(N-2)+Xi+Trunc(E*Cos(A));
	Y:=Yr*(P-1)+Yi+Trunc(E*Sin(A));
	if I=0 then begin MoveTo(X,Y); Bx:=X; By:=Y; end;
	LineTo(X,Y);
	A:=A+Pi/15/N;
      end;
      LineTo(Bx,By);
    end;
end;
{  Graph7  }
procedure Graph7(Xc,Yc,R:integer);
var XX,YY:array[1..120] of integer;
    X,Px,Py,Bx,By,X1,Y1,X2,Y2,I:integer;
    Th,A:real;
begin
  A:=0; X:=4*R;
  for I:=1 to 120 do begin
    Th:=66*Sqrt(Abs(Cos(3*A)))+12*Sqrt(Abs(Cos(9*A)));
    XX[I]:=Trunc(Th*Cos(A)*1.2/320*R);
    YY[I]:=Trunc(Th*Sin(A)/320*R);
    A:=A+Pi/60;
  end;
  for Py:=1 to 2 do
    for Px:=1 to 8 do begin
      for I:=1 to 120 do begin
	X1:=XX[I]+Px*R shr 1-R shr 2;
	Y1:=YY[I]+Py*R shr 1-R shr 2;
	Th:=2*Pi*(X-X1)/X;
	X2:=Xc+Trunc(Y1*Cos(Th));
	Y2:=Yc+Trunc(Y1*Sin(Th));
	if I=1 then begin MoveTo(X2,Y2); Bx:=X2; By:=Y2; end;
	SetColor((120*(2*Py+Px)+I) div 22+32);
	LineTo(X2,Y2);
      end;
      LineTo(Bx,By);
    end;
end;
{  Graph8  }
procedure Graph8(Xc,Yc,R:integer);
var XX,YY:array[1..120] of integer;
    X,Px,Py,Bx,By,X1,Y1,X2,Y2,I:integer;
    Th,A,M,N:real;
begin
  A:=0; X:=4*R;
  for I:=1 to 120 do begin
    Th:=40*Sin(4*(A+Pi/8));
    M:=Sin(A); N:=Cos(A);
    XX[I]:=Trunc((Th*N+45*N*N*N)/320*R);
    YY[I]:=Trunc((Th*M+45*M*M*M)/320*R);
    A:=A+Pi/60;
  end;
  for Py:=1 to 2 do
    for Px:=1 to 8 do begin
      for I:=1 to 120 do begin
	X1:=XX[I]+Px*R shr 1-R shr 2;
	Y1:=YY[I]+Py*R shr 1-R shr 2;
	Th:=2*Pi*(X-X1)/X;
	X2:=Xc+Trunc(Y1*Cos(Th));
	Y2:=Yc+Trunc(Y1*Sin(Th));
	if I=1 then begin MoveTo(X2,Y2); Bx:=X2; By:=Y2; end;
	SetColor((120*(2*Py+Px)+I) div 22+32);
	LineTo(X2,Y2);
      end;
      LineTo(Bx,By);
    end;
end;
{  Graph9  }
procedure Graph9(Xc,Yc,D,R:integer);
var XX,YY:array[1..120] of integer;
    D2,Un,Uv,K,S,X,Y,Px,Py,Bx,By,I,Sq:longint;
    Th,Sc,A,M:real;
begin
  A:=0; Un:=12; Uv:=D div Un; K:=Uv div 2; Sc:=Uv/100; D2:=D shr 1;
  for I:=1 to 120 do begin
    Th:=90*(0.8+0.2*Sin(12*A))*(0.5+0.5*Sin(4*A));
    XX[I]:=Trunc(Th*Cos(A));
    YY[I]:=Trunc(Th*Sin(A));
    A:=A+Pi/60;
  end;
  for Px:=1 to Un do
    for Py:=1 to Un do begin
      for I:=1 to 120 do begin
	X:=Trunc(XX[I]*Sc)+Px*Uv-D2-K;
	Y:=Trunc(YY[I]*Sc)+Py*Uv-D2-K;
	Sq:=X*X+Y*Y;
	if Sq<R*R then begin
	  if X<0 then S:=-1 else S:=1;
	  Th:=ArcTan(Y/(X+0.1));
	  M:=R*Sin(2*ArcTan(Sqrt(Sq)/R));
	  X:=S*Trunc(M*Cos(Th));
	  Y:=S*Trunc(M*Sin(Th));
	end;
	X:=X*23 div 15+Xc; Y:=Y*23 div 15+Yc;
	if I=1 then begin MoveTo(X,Y); Bx:=X; By:=Y; end;
	SetColor((120*(Px+Py)+I) div 42+32);
	LineTo(X,Y);
      end;
      LineTo(Bx,By);
    end;
end;
{  Graph10  }
procedure Graph10(Xc,Yc:integer;Rr:real);
const Data:array[1..9] of integer=(7,436,245,17,775,180,31,1020,130);
var Ste,Re,K,S,X,Y,Px,Py,Bx,By,I:integer;
    A,AA,Ls,Di,R:real;
begin
  Px:=Xc; Py:=Yc; R:=50*Rr;
  S:=8-Random(5);
  if S mod 2=0 then K:=2 else K:=1;
  A:=0; SetColor(32);
  while A<=K*Pi+Pi/10/S do begin
    X:=Trunc((R/4*Sin(3*S*A)+R*Sin(S*A))*Cos(A))+Px;
    Y:=Trunc((R/4*Sin(3*S*A)+R*Sin(S*A))*Sin(A))+Py;
    if A=0 then MoveTo(X,Y);
    LineTo(X,Y);
    A:=A+Pi/8/S;
  end;
  I:=0;
  for Re:=1 to 3 do begin
    Ste:=Data[3*Re-2]; Di:=Data[3*Re-1]/6*Rr; R:=Data[3*Re]/6*Rr;
    if Re=2 then Ls:=(2*Pi/Ste)-0.1 else Ls:=0;
    AA:=0;
    while AA<=2*Pi-Ls do begin
      Px:=Xc+Trunc(Di*Cos(AA));
      Py:=Yc+Trunc(Di*Sin(AA));
      S:=8-Random(5);
      if S mod 2=0 then K:=2 else K:=1;
      A:=0;
      SetColor(I+33);
      while A<=K*Pi+Pi/10/S do begin
	X:=Trunc((R/4*Sin(3*S*A)+R*Sin(S*A))*Cos(A))+Px;
	Y:=Trunc((R/4*Sin(3*S*A)+R*Sin(S*A))*Sin(A))+Py;
	if A=0 then MoveTo(X,Y);
	LineTo(X,Y);
	A:=A+Pi/8/S;
      end;
      AA:=AA+2*Pi/Ste; I:=I+1;
    end;
  end;
  A:=0; I:=0;
  while A<=14*Pi do begin
    X:=Xc+Trunc(Trunc(250*Rr)*(1+1/5*Sin(9.06*A))*Cos(A));
    Y:=Yc+Trunc(Trunc(250*Rr)*(1+1/5*Sin(9.06*A))*Sin(A));
    if A=0 then MoveTo(X,Y);
    SetColor(I mod 72+32); LineTo(X,Y);
    A:=A+Pi/60; I:=I+1;
  end;
end;
{  Ratio(Number)  }
function R(Num:integer):integer;
begin
  R:=Trunc(Num*Ratio);
end;
{  Print  }
procedure Print(X,Y,Color,BkColor:integer;St:string);
begin
  Dec(Y,R(6));
  SetColor(BkColor);
  OutTextXY(X+1,Y+1,St);
  SetColor(Color);
  OutTextXY(X,Y,St);
  OutTextXY(X+1,Y,St);
end;
{  Screen  }
procedure Screen;
const St:array[0..7] of string[24]=(
	'SVGA/VESA 256 Colors','Graph Demo',
	'Designed by Jou-Nan Chen','Rewritten in 1994',
	'Arrow keys to select','Enter to show graph',
	'* key to colorize','Esc to quit graph demo');
var I:integer;
begin
  SetFillStyle(1,1);
  Bar(0,R(400),R(640)-1,R(480)-1);
  SetColor(11);
  Rectangle(1,R(400)+1,R(640)-2,R(480)-2);
  SetTextStyle(5,0,4);
  SetUserCharSize(R(4),4,R(4),4);
  for I:=0 to 7 do
    Print(R(40),R(20)+R(40*I),64+3*I,4,St[I]);
  for I:=0 to 9 do
    Print(R(120)*(I mod 5)+R(20),R(32)*(I div 5)+R(400),64+3*I+120,0,Name[I]);
end;
{  GraphMenu  }
procedure GraphMenu;
var P,A,B:integer;
    Ch:char;
begin
  Screen; P:=0;
  repeat
    SetFillStyle(1,104+120);
    Bar(R(120)*(P mod 5)+R(12),R(32)*(P div 5)+R(407),R(120)*(P mod 5)+R(135),R(32)*(P div 5)+R(440));
    Print(R(120)*(P mod 5)+R(20),R(32)*(P div 5)+R(400),64+3*P+120,0,Name[P]);
    Ch:=ReadKey; if Ch=#0 then Ch:=ReadKey;
    SetFillStyle(1,1);
    Bar(R(120)*(P mod 5)+R(12),R(32)*(P div 5)+R(407),R(120)*(P mod 5)+R(135),R(32)*(P div 5)+R(440));
    Print(R(120)*(P mod 5)+R(20),R(32)*(P div 5)+R(400),64+3*P+120,0,Name[P]);
    case Ch of
      #13:begin
	    SetFillStyle(1,0); Bar(0,0,R(640)-1,R(400)-1);
	    case P of
	      0:Graph1(R(320),R(200),R(250),R(100));
	      1:Graph2(R(280),R(245),R(160),R(40));
	      2:Graph3(R(320),R(195),R(80));
	      3:Graph4(R(320),R(195),R(80));
	      4:Graph5(R(320),R(200),R(120));
	      5:Graph6(R(85),R(45),R(28),R(90),R(62));
	      6:Graph7(R(320),R(200),R(200));
	      7:Graph8(R(320),R(200),R(200));
	      8:Graph9(R(320),R(200),R(245),R(100));
	      9:Graph10(R(320),R(200),0.6*Ratio);
	    end;
	    CirclePalette(32,72,72,30,Pal);
	  end;
      'H':Dec(P,5); 'P':Inc(P,5);
      'K':Dec(P);   'M':Inc(P);
      '*':repeat CirclePalette(32,72,72,30,Pal); until KeyPressed=1;
    end;
    if P<0 then Inc(P,10); if P>9 then Dec(P,10);
  until Ch=#27;
end;

var A,B,C:integer;
    Ch:char;
begin
  TextMode(Co80);
  repeat
    TextAttr:=$1B; ClrScr;
    Writeln('     ');
    Writeln('  ۱      ۱   ۱  SVGA/VESA Graph Demo');
    Writeln('  ۱  ۱ ۱   640x480--1024x768 256C');
    Writeln('  ۱   ۱ ۱   ۱  Written by Jou-Nan Chen');
    Writeln('          ');
    TextAttr:=$1F;
    Writeln('  Select a graph mode :');
    TextAttr:=$1E;
    Writeln('  (1)  640x480, 256 Colors');
    Writeln('  (2)  800x600, 256 Colors');
    Writeln('  (3) 1024x768, 256 Colors');
    TextAttr:=$1F;
    Write  ('  Enter your selection ? ');
    Ch:=ReadKey; C:=Ord(Ch)-48;
  until C in [1,2,3];
  case C of
    1:Ratio:=1;
    2:Ratio:=1.25;
    3:Ratio:=1.6;
  end;
  A:=InstallUserDriver('SVGA256',nil); B:=1+C;
  InitGraph(A,B,'');
  GetPalette(0,104,Pal); SetPalette(120,104,Pal);
  GraphMenu;
  CloseGraph;
  RestoreCrtMode;
end.
