{ EXTRLABS.pas
  used in POSTOGRF}

procedure ExtractLabels;
{ types & vars used specifically for Postscript files }
type FontSpec = record
                         TFont: FontList;     {type face - Helv. bold, etc}
                         TSize: integer;      {font size in points}
                         FontNum: string[10]; {font ID number; e.g., 'font3'}
                      end;
var Fonts       : array[0..20] of FontSpec;
    TempFont   : FontSpec;
    FontCounter: word;

{LIPSOGRF & general purpose var's}
var counter, Xpos, Ypos, temp, error  : integer;
    s,s1, s2                   : string80;
    done                       : boolean;
    tempstyle                  : Fontlist;

    procedure GetFontNum;    { here points to 'FONT' on entry }
    begin if here > JimFileStart
          then begin done := true; exit; end;
          done := false;
          GetaWord(s);
          Val(s,temp,error);
          If temp > FontTotal then FontTotal := temp;
          counter := here;   { save pointer because GetaWord moves it}
    end; {GetFontNum}

    procedure GetFontStr(fontnum:integer); { saves & restores here }
    begin if done then exit;
          counter := here; here := 1;
          repeat
               repeat GetaWord(s) until s = 'GENF';
               GetaWord(s);
               Val(s,temp,error);
         until (temp = fontnum) or (here > JimFileStart);
         repeat here := succ(here) until JimFile^[here] in quotes;
         GetaQuote(s);
         str(fontnum, s2);
         Val(s[length(s)],temp,error) ;
         tempstyle := fontlist(temp -1);
                              { convert from CIEFLEX to Postscript font}
         TempText.LIPSFont.LIPSStyle := tempstyle;
         GetaWord(s); Val(s,temp,error);
         if error <>0 then begin GetAWord(s); end;
         TempText.prtSize := temp;
         here := counter;     {restore pointer }
    end; {GetFontStr}

    procedure GetLabel ;        { here points to 'FONT' on entry }
    begin if done then exit;     { call this routine right after GetFontNum }
          repeat GetAWord(s) until s = 'MAP';
          GetAWord(s); Val(s,Xpos,error);
          GetAWord(s); Val(s,Ypos,error);
          ScrConv(XPos, YPos);
          TempText.CurrText.Horiz := Xpos;
          TempText.CurrText.Vert := Ypos;
          repeat GetaWord(s) until s = 'TEXT';  { find the label's text }
          GetAQuote(s);                         { get the text }
          TempText.Tstr := s;
          TempText.LabelBkGround := trans;
    end;

    (*procedure GetLIPSStyle;       { figure out the CIEFLEX # in TempText }
    var tempstyle: FontList;
    begin tempstyle := SansSerif;
          while LIPSStyleStr[tempstyle] <> s1
                do tempstyle := succ(tempstyle);
          TempText.LIPSFont.LIPSStyle := tempstyle;
    end;*)

   procedure LinkDefaultLabel;      { make label structure & link into list }
   begin AddRec;                    { use this before GetFontNum, etc. }
         SetLabelDefaults(cp);
         SetUpLabel(cp);
         TempText := cp^;           { copy into TempText}
   end;

   { ----------------------------------------------------------------------
     Font table format:  an array called Fonts:
                    TFont       (FontList, Helvetica, etc)
       1st font:    TSize       (integer, size in points)
                    FontNum     ('font1', 'font2' , etc)

                    TFont
       2nd font:    TSize
                    FontNum
                    ...
     --------------------------------------------------------------------- }
   procedure BuildPSFontTable;      { start with here pointing to font area}
   type fontType = array[1..length('/font')] of char;
        fontTypePtr = ^fontType;
   var f1: fontlist;
       t1, t2, nn: word;
   const fontStrArray : fontType = '/font';
   begin
        s := '';
        font0str := '';
        { ------------------- scan for '/font0' --------------------- }
        while (fontTypePtr(@JimFile^[here])^ <> fontStrArray)
              and (here < EndFonts) do inc(here);
        Getaword(s);
        if s = '/font0' then begin
              t1 := mark;
              repeat GetAWord(s) until s = 'def';
              for nn := t1 to here-1 do font0str := font0str + JimFile^[nn];
              while (font0str[length(font0str)] in [LF, CR]) do
                 delete(font0str,length(font0str),1);
           end
           else begin
              here := mark;
              font0str := defaultFont0str;
           end;
        Fonts[0].FontNum := '0';
        s := font0str; delete(s,1,1);
        delete(s, 1, pos('/',s) );
        f1 := fontlist(0);
           while (s <> POSTStyleStr[f1]) and (f1 <> MitreLogo) do
                 inc(f1);
           if s <> POSTStyleStr[f1] then f1 := HelvBold;
                             {default to HelvBold if not recognized}
        Fonts[0].Tfont := f1;
        t1 := pos(' scalefont',s) ;
        if t1 = 0 then t1 := pos(' sf',s);
        t2 := t1;
        while s[t1] in whitespace do dec(t1); dec(t1);
        while not (s[t1] in whitespace) do dec(t1);
        s := copy(s,t1,t2 - t1);
        val(s, temp, error);
        Fonts[0].Tsize := integer(round(temp*72.0/1000));

        FontCounter := 0;
        repeat                        { until '%EndFonts'}
           dec(here); GetaWordBack(s,here);
           while (fontTypePtr(@JimFile^[here])^ <> fontStrArray)
               and (here < EndFonts) do inc(here);
           if here >= EndFonts then exit;
           inc(FontCounter);
           GetaWord(s);               { '/fontxx' }
           Delete(s,1,1);             { change to 'fontxx' }
           Fonts[FontCounter].FontNum := s;
           Repeat GetAWord(s) until s[1] = '/';
                              {should be '/Helvetica-Bold', or similar}
           Delete(s,1,1);
           f1 := fontlist(0);
           while (s <> POSTStyleStr[f1]) and (f1 <> MitreLogo) do
           {repeat}
                 inc(f1);
           {until (s = POSTStyleStr[f1]) or (f1 = MitreLogo);}
           if s <> POSTStyleStr[f1] then f1 := HelvBold;
                             {default to HelvBold if not recognized}
           Fonts[FontCounter].TFont := f1;
           repeat GetAWord(s) until (s = 'scalefont') or (s = 'sf');
           t1 := here-1;
           GetAWordBack(s, t1);
           GetAWordBack(s, t1);       {get font size in 1/1000'2 inch}
           Val(s,temp,error);          {convert to number}
           Fonts[FontCounter].TSize := integer(round(temp*72.0/1000));
           GetAWord(s);
           if s = 'def' then GetAWord(s);
        until here > EndFonts;
   end; {BuildPSFontTable}

   { ----------------------------------------------------------------------
     Labels have the following identifying structure:
       fontxx sf                % xx is a number. Might use setfont instead.
       x y m                    % x,y are numbers; could use moveto.
       (text) s                 % text could have embedded or leading spaces,
                                  could use show for s.

       If we encounter a label, we can extract the text using
       ParsePSstring(destination, offset), which leaves offset pointing
       just past the string's trailing parenthesis.
     ----------------------------------------------------------------------- }

   procedure LookForFontxx;    {gets font style & size}
   type fontType = array[1..length('font')] of char;
        fontTypePtr = ^fontType;
   var t1: word;
   const fontStrArray : fontType = 'font';
   begin
        if here > EndLabels then exit;
        repeat
              GetAWord(s)
        until (s = 'sf') or (s = 'setfont') or (here > EndLabels);
        if here > EndLabels then exit;
        t1 := here-1;
        GetAWordBack(s, t1);
        GetAWordBack(s, t1);
        tempFont.FontNum := s;
        t1 := 0;
        {repeat}
        while (s <> Fonts[t1].FontNum) and (t1 <> FontCounter) do inc(t1);
        {until (s = Fonts[t1].FontNum) or (t1 = FontCounter);}
        tempText.PrtSize := Fonts[t1].TSize;
        tempText.LipsFont.LipsStyle := Fonts[t1].TFont;
   end; {LookForFontxx}

   procedure GetPSLabelCoords;
   var t1:word; temphere:word;
   begin
        if here > EndLabels then exit;
        repeat GetAWord(s)
        until (s[1] = '(') or (here > EndLabels);
                            {find start of string to print}
        dec(here);
        repeat GetAWordBack(s,here) until (s = 'm') or (s = 'moveto');
        GetAWordBack(s,here);                  {Y coord}
        val(s,YPos,error);
        if error <> 0 then YPos := 100;       {dumb default if error}
        GetAWordBack(s, here);
        val(s, XPos, error);
        if error <> 0 then XPos := 100;       {same dumb default}
        {convert from Postscript to screen coords }
        PStoScreen(XPos, YPos);
        tempText.CurrText.Horiz := XPos;
        tempText.CurrText.Vert := YPos;
   end; {GetPSLabelCoords}

   procedure GetPSLabel;
   var t1:word;
   begin
        if here > EndLabels then exit;
        if s[1] <> '(' then
           repeat                      {find '(' to locate string}
                 GetAWord(s)
           until (s[1] = '(') or (here > EndLabels);
           if here > EndLabels then begin s := ''; exit; end;
        ParsePSstring(s, mark);        {mark points to start of string}
        TempText.Tstr := s;
        here := mark ;
        repeat GetAWord(s) until (s = 's') or (s = 'show')
              or (s = 'rs') or (s = 'rsho');
        if (s = 'show') or (s = 'rsho') then TempText.LabelBkGround := trans
           else TempText.LabelBkGround := opaque;
        if (s = 'rs') or (s = 'rsho')
          then TempText.CurrText.Direction := VertDir
          else TempText.CurrText.Direction := HorizDir;
   end; {GetPSLabel}

begin {ExtractLabels}
      if GraphFile = GRAPHL then exit; { no labels to find }
      if GRAPHLIName = '' then exit;
      here := 1;
      cp := nil; head := nil; select := nil; s := '';
      clrscr;
      writeln('looking for existing labels');
      case GraphFile of
         GRAPHL, LIPSGRF:
            while here < JimFileStart do begin
              repeat GetaWord(s) until ((s = 'FONT') or (s = 'EXIT'));
              if here < JimFileStart
              then begin LinkDefaultLabel;
                         GetFontNum;
                         GetLabel;
                         GetFontStr(temp);
                         (*GetLIPSStyle;*)
                         cp^ := TempText;
                   end;
            end; {while}
         POSTSCRIPT: begin
            if FontDefinitions < count then begin
               here := FontDefinitions;
               BuildPSFontTable;
               {here := EndFonts;}
               if (GraphFile = POSTSCRIPT) and (StartLabels < count)
                  then here := StartLabels else here := EndFonts;
               while here <= EndLabels do begin
                  LinkDefaultLabel;
                  LookForFontXX;
                  GetPsLabelCoords;
                  GetPSLabel;
                  if TempText.Tstr <> '' then cp^ := TempText
                  else begin
                     head := head^.link;
                     dispose(cp);
                     cp := nil;
                     with TempText do begin
                          CurrText.horiz := 100;
                          CurrText.Vert := 100;
                     end;
                  end;
                  TempText.Tstr := '';
               end; {while}
            end; {if FontDefinitions < ...}
         end; {POSTSCRIPT}
      end; {case GraphFile of ...}
      select := nil;
      DefaultFSize := 20;
end; {ExtractLabels}
