\ Memory Allocation Word Set

\ Code Copyright (c) 1995 by Thomas Almy.  All rights reserved.
\ Permission is granted to registered users of ForthCMP to sell or distribute
\ computer programs incorporating the compiled contents of this file.

\ This file combined with MEMORY1.4TH provides the Memory Allocation Word Set.

10 DECIMAL .( Loading MEMORY2) CR

0 VALUE membuf \ pointer to first free memory area (zero if none)
0 VALUE memend \ end of DATA free memory  (zero if not initialized)

CODE settop 
SEPSSEG? 0= [IF] SP AX MOV 256 # AX SUB [ELSE]
SEPDSEG? [IF] dssize 16 * # AX MOV  [ELSE]
FIND PSIZE [IF] DROP PSIZE [ELSE] -2 [THEN] # AX MOV
[THEN] [THEN] AX ' memend [] MOV RET END-CODE

U: UNUSED memend 0= IF settop THEN memend DP @ - ;

U: VALIDATE-FREE \ validate free memory pool
  membuf BEGIN
    DUP WHILE
    DUP CELL+ @ ?DUP IF OVER U< IF
        ." SEQ!" CR DISPLAY-FREE BYE THEN THEN
    DUP CELL+ @ ?DUP IF OVER DUP @ + U< IF 
        ." OVR!" CR DISPLAY-FREE BYE THEN THEN
    CELL+ @
  REPEAT
  DROP
;  

U: DISPLAY-FREE \ display free memory pool
  membuf BEGIN
    DUP WHILE
    ." start=" DUP U.
    ." length=" DUP @ U. CR
    CELL+ @
  REPEAT
  DROP
; 


\ free memory areas start with size, followed by pointer to next area
\ allocated areas have size in cell before start

0 VALUE memlst \ holds pointer to current freeseg
?DEFINE RESIZE [IF]

2 2 IN/OUT
: RESIZE ( area newSize -- newArea flag )
   CELL+ SWAP CELL- SWAP \ the real start addr and real new size
   2DUP SWAP @ CELL+ 2DUP U> IF \ req size is larger
      - ?mergein IF EXIT THEN
      CELL- ALLOCATE IF DROP CELL+ TRUE EXIT THEN
      >R DUP @ >R \ newArea and currentSize
      CELL+ DUP R> R@ SWAP MOVE 
      FREE DROP
      R> FALSE EXIT
   THEN
   SWAP - 16 U< IF \ smaller, but not enough to free
       DROP CELL+ FALSE EXIT THEN
   \ smaller -- free the excess
   2DUP + >R OVER @ OVER  - R@ ! R> CELL+ FREE DROP
   OVER ! CELL+ FALSE
;

: ?mergein ( area newSize addedSize -- area newSize FALSE or area FALSE TRUE)
   \ if possible, merge a following freeArea into area (and return TRUE)
   membuf 0= IF DROP FALSE EXIT THEN \ no free areas
   >R OVER DUP @ + \ added size on ret stack, end of current on stack
   ['] membuf TO memlst
   membuf BEGIN
       2DUP = IF DUP @ R@ U< 0= IF \ Merge in
            NIP
            DUP @ R@ 16 + U< IF \ take it all, rather than having small seg
                R> DROP resize1 EXIT THEN
            R> resize2
          EXIT THEN
       THEN
       CELL+ DUP TO memlst @
   DUP 0= UNTIL 
   R> DROP 2DROP FALSE
;
 
: resize1 ( area newSize freeArea -- area FALSE TRUE )
\ merge all of freeArea into area
    DUP CELL+ @ memlst !
    NIP @ OVER +! CELL+ FALSE TRUE
;

: resize2 ( area newSize freeArea addedSize -- area FALSE TRUE )
\ merge addedSize bytes of freeArea into area, readjust freeArea
    >R
    DUP R@ + DUP memlst ! TO memlst
    DUP CELL+ @ memlst CELL+ !
    @ R@ - memlst !
    DROP R> OVER +! CELL+ FALSE TRUE 
;
[THEN]

?DEFINE ALLOCATE [IF]
1 2 IN/OUT
: allocnew ( size -- addr flag )
  memend 0= IF settop THEN 
  CELL+
  memend HERE 128 94 + + - OVER U< IF \ no memory left
	0 TRUE EXIT THEN
  memend OVER - DUP TO memend !
  memend CELL+ FALSE ;

            

1 2 IN/OUT
: ALLOCATE ( size -- addr flag )
   DUP 4 U< IF DROP 4 THEN \ min size will be 4 bytes
   membuf 0= IF allocnew EXIT THEN
   ['] membuf TO memlst
   CELL+ membuf BEGIN
     2DUP @ U> WHILE \ no match
     CELL+ DUP TO memlst @  \ goto next free region
     DUP 0= IF DROP allocnew EXIT THEN \ no free regions left
   REPEAT
   \ Stack has size freeSeg
   2DUP @ SWAP - 16 U< IF \ allocate it all
      NIP DUP CELL+ @ memlst ! CELL+ 0 EXIT THEN
   2DUP SWAP NEGATE SWAP +! \ subtract off size
   2DUP + OVER SWAP 2 CELLS MOVE \ move free area header
   OVER memlst +!
   2DUP ! NIP CELL+ 0 
;
[THEN]

1 1 IN/OUT
U: FREE ( area -- 0 )
  CELL-
  membuf 0= IF DUP memend = IF @ memend + TO memend 0 EXIT THEN
       DUP TO membuf CELL+ 0 SWAP ! 0 EXIT THEN
  membuf 2DUP U< IF OVER CELL+ ! DUP TO membuf ELSE
    \ find free area just before us
    BEGIN 2DUP CELL+ @ DUP 0<> >R U> R> AND WHILE CELL+ @ REPEAT
    2DUP DUP @ + = IF \ merge
         2DUP SWAP @ SWAP +!  NIP
    ELSE \ non-adjacient
      2DUP CELL+ @ SWAP CELL+ !
      2DUP CELL+ ! DROP
    THEN
  THEN
  \ merge with following free area?
  DUP CELL+ @ OVER @ - OVER = IF
     DUP CELL+ @
     2DUP CELL+ @ SWAP CELL+ !
     @ OVER +!
  THEN
  memend membuf = IF membuf DUP @ + TO memend membuf CELL+ @ TO membuf THEN
  DROP 0
;   

16 = [IF] HEX [THEN]


