{These are support routines to the mini-editor (cursor movement}

PROCEDURE ed_up;
(*****************************************************************************
move cursor up one line
******************************************************************************)
BEGIN
    IF ln>top_ln THEN
        ln:=ln-1
    ELSE
        IF top_ln>1 THEN BEGIN
            top_ln:=top_ln-1;
            ln:=ln-1;
            dr_page
        END
    {end}
END; {PROCEDURE ed_up}

PROCEDURE ed_down;
(*****************************************************************************
move cursor down one line
******************************************************************************)
BEGIN
    If ln-top_ln+1<Ln_Pg THEN
        ln:=ln+1
    ELSE
        IF ln<Max_Ed_Lines THEN BEGIN
            top_ln:=top_ln+1;
            ln:=ln+1;
            dr_page
        END
    {end}
END; {PROCEDURE ed_down}

PROCEDURE ed_left;
(*****************************************************************************
move cursor left one space
******************************************************************************)
BEGIN
    IF cc>1 THEN
        cc:=cc-1
    ELSE
        IF top_ln<ln THEN BEGIN
            ln:=ln-1;
            cc:=Max_Tty_Width
        END ELSE
            IF top_ln>1 THEN BEGIN
                top_ln:=top_ln-1;
                ln:=ln-1;
                cc:=Max_Tty_Width;
                dr_page
            END
        {end}
    {end}
END; {PROCEDURE ed_left}

PROCEDURE ed_right;
(*****************************************************************************
move one space right (cursor one position forward)
******************************************************************************)
BEGIN
    IF cc<Max_Tty_Width+1 THEN
        cc:=cc+1
    ELSE
        IF ln-top_ln+1<Ln_Pg THEN BEGIN
            cc:=1;
            ln:=ln+1
        END ELSE
            IF ln<Max_Ed_Lines THEN BEGIN
                top_ln:=top_ln+1;
                ln:=ln+1;
                cc:=1;
                dr_page
            END
        {end}
    {end}
END; {PROCEDURE ed_right}

PROCEDURE ed_pgup;
(*****************************************************************************
move one page up
******************************************************************************)
BEGIN
    IF top_ln>Ln_Pg THEN BEGIN
        top_ln:=top_ln-Ln_Pg;
        ln:=ln-Ln_Pg
    END ELSE BEGIN
        top_ln:=1;
        ln:=1
    END;
    dr_page
END; {PROCEDURE ed_pgup}

PROCEDURE ed_pgdn;
(*****************************************************************************
move one page down
******************************************************************************)
BEGIN
    IF top_ln+Ln_Pg<Max_Ed_Lines-Ln_Pg+1 THEN BEGIN
        top_ln:=top_ln+Ln_Pg;
        ln:=ln+Ln_Pg
    END ELSE BEGIN
        top_ln:=Max_Ed_Lines-Ln_Pg+1;
        ln:=Max_Ed_Lines
    END;
    dr_page
END; {PROCEDURE ed_pgdn}

PROCEDURE ed_tof;
(*****************************************************************************
move to top of file
******************************************************************************)
BEGIN
    top_ln:=1;
    ln:=1;
    cc:=1;
    dr_page
END; {PROCEDURE ed_tof}

PROCEDURE ed_eof;
(*****************************************************************************
move to end of file
******************************************************************************)
BEGIN
    top_ln:=last_ln-15;
    ln:=last_ln+1;
    cc:=1;
    dr_page
END; {PROCEDURE ed_eof}

PROCEDURE ed_bol;
(*****************************************************************************
move to beginning of line
******************************************************************************)
BEGIN
    cc:=1;
END; {PROCEDURE ed_bol}

PROCEDURE ed_eol;
(*****************************************************************************
move to end of line (last non-blank character on line}
******************************************************************************)
VAR i:INTEGER;
BEGIN
    cc:=Max_Tty_Width;
    WHILE (ed_text[ln][cc]=' ') AND (cc>1) DO
        cc:=cc-1;
    cc:=cc+1
END; {PROCEDURE ed_eol}

PROCEDURE ed_home;
(*****************************************************************************
move to top of screen
******************************************************************************)
BEGIN
    ln:=top_ln;
    cc:=1
END; {PROCEDURE ed_home}

PROCEDURE ed_end;
(*****************************************************************************
move to end of screen
******************************************************************************)
BEGIN
    cc:=1;
    ln:=top_ln+Ln_Pg-1
END; {PROCEDURE ed_end}

PROCEDURE ed_fwdwd;
(*****************************************************************************
forward a word
******************************************************************************)
BEGIN
    IF ed_text[ln][cc]<>' ' THEN        {move to end of present word}
	WHILE (ed_text[ln][cc]<>' ') AND (cc<Max_Tty_Width) DO cc:=cc+1;
    {end}
    IF cc=Max_Tty_Width THEN BEGIN    {if present word runs all}
        cc:=1;                          {the way to the right margin}
        ed_down
    END;
    WHILE (ed_text[ln][cc]=' ') AND (cc<Max_Tty_Width) DO
        cc:=cc+1;                       {find first non-blank space}
    IF (ed_text[ln][cc]=' ') THEN BEGIN
        cc:=1;
        ed_down
    END
END; {PROCEDURE ed_fwdwd}

PROCEDURE ed_bckwd;
(*****************************************************************************
backwards one word
******************************************************************************)
BEGIN
    IF cc>1 THEN cc:=cc-1;
    IF (cc=1) AND (ln>1) THEN BEGIN
        ed_up;
        cc:=Max_Tty_Width
    END;
    IF ed_text[ln][cc]=' ' THEN
        WHILE (ed_text[ln][cc]=' ') AND (cc>1) DO cc:=cc-1;
    {end}
    WHILE (ed_text[ln][cc]<>' ') AND (cc>1) DO cc:=cc-1;
    IF (ed_text[ln][cc]=' ') AND (cc>1) THEN ed_right;
END; {PROCEDURE ed_bckwd}

PROCEDURE ed_scrlup;
(*****************************************************************************
scroll up (forward) one line
******************************************************************************)
BEGIN
    IF top_ln+Ln_Pg<Max_Ed_Lines THEN BEGIN
        IF ln=top_ln THEN ln:=ln+1;
        top_ln:=top_ln+1;
        dr_page
    END
END; {PROCEDURE ed_scrlup}

PROCEDURE ed_scrldown;
(*****************************************************************************
scroll down (back) one line
******************************************************************************)
BEGIN
    IF top_ln>1 THEN BEGIN
        IF ln=top_ln+19 THEN ln:=ln-1;
        top_ln:=top_ln-1;
        dr_page
    END
END; {PROCEDURE ed_scrldown}

