/* ------------------------------------------------------------------------ */
/* XSHOP.C (C) CopyLeft Bill Buckels 1991-1999                              */
/* All Rights Reversed.                                                     */
/*                                                                          */
/* Licence Agreement                                                        */
/* -----------------                                                        */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* If you don't agree, remove this source code from your computer now.      */
/*                                                                          */
/* Written by   : Bill Buckels                                              */
/*                589 Oxford Street                                         */
/*                Winnipeg, Manitoba, Canada R3M 3J2                        */
/*                                                                          */
/* Email: bbuckels@escape.ca                                                */
/* WebSite: http://www.escape.ca/~bbuckels                                  */
/*                                                                          */
/* Date Written : November 10, 1991                                         */
/* Purpose      : Cross Conversion Between Printshop and Printmaster        */
/* Revision     : 2.0 Last Release                                          */
/* ------------------------------------------------------------------------ */
/* Written in Large Model Mix Power C Version 2.0                           */
/* ------------------------------------------------------------------------ */

#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <bios.h>
#include <conio.h>
#include <direct.h>
#include <fcntl.h>
#include <malloc.h>
#include <io.h>
#include <stdlib.h>

#ifndef S_IWRITE
   #define S_IWRITE    0000200     /* write permission, owner   */
#endif

char messagebuffer[128];

/* a group of handy definitions */

#define BLACK   0
#define BLUE    1
#define GREEN   2
#define CYAN    3
#define RED     4
#define MAGENTA 5
#define BROWN   6
#define WHITE   7
#define GRAY      8
#define LBLUE     9
#define LGREEN    10
#define LCYAN     11
#define LRED      12
#define LMAGENTA  13
#define YELLOW    14
#define BWHITE    15

#define ESCAPE  '\x1b'
#define CGA  3
#define HERCULES 99

int ADAPTER = CGA   ;

#define BLANK     32
#define FAT       219

#define ENTERKEY   '\x0d' /* character generated by the Enter Key          */
#define ESCKEY     '\x1b' /* character generated by the Esc key            */
#define FUNCKEY    '\x00' /* first character generated by function keys    */
#define UPARROW    'H'    /* second character generated by up-arrow key    */
#define DOWNARROW  'P'    /* second character generated by down-arrow key  */
#define LTARROW    'K'    /* second character generated by left-arrow key  */
#define RTARROW    'M'    /* second character generated by right-arrow key */
#define PGUP       'I'    /* second character generated by page up key     */
#define PGDOWN     'Q'    /* second character generated by page down key   */

/* starting at character 59*/
#define F1         ';'    /* second character generated by numerical fkeys */
#define F2         '<'
#define F3         '='
#define F4         '>'
#define F5         '?'
#define F6         '@'
#define F7         'A'
#define F8         'B'
#define F9         'C'
#define F10        'D'
/* ending at character 68  */

#define CRETURN '\x0d'
#define LFEED   '\x0A'
#define CTRLZ   '\x1a'
#define DELETE  '\x7f'

#define SINGLE    218
#define DOUBLE    201

char wildfiles[200][15];

int filecords[84][2]=
{
    2,  4,  2,  23,  2, 42,  2, 61,
    3,  4,  3,  23,  3, 42,  3, 61,
    4,  4,  4,  23,  4, 42,  4, 61,
    5,  4,  5,  23,  5, 42,  5, 61,
    6,  4,  6,  23,  6, 42,  6, 61,
    7,  4,  7,  23,  7, 42,  7, 61,
    8,  4,  8,  23,  8, 42,  8, 61,
    9,  4,  9,  23,  9, 42,  9, 61,
    10, 4, 10,  23, 10, 42, 10, 61,
    11, 4, 11,  23, 11, 42, 11, 61,
    12, 4, 12,  23, 12, 42, 12, 61,
    13, 4, 13,  23, 13, 42, 13, 61,
    14, 4, 14,  23, 14, 42, 14, 61,
    15, 4, 15,  23, 15, 42, 15, 61,
    16, 4, 16,  23, 16, 42, 16, 61,
    17, 4, 17,  23, 17, 42, 17, 61,
    18, 4, 18,  23, 18, 42, 18, 61,
    19, 4, 19,  23, 19, 42, 19, 61,
    20, 4, 20,  23, 20, 42, 20, 61,
    21, 4, 21,  23, 21, 42, 21, 61,
    22, 4, 22,  23, 22, 42, 22, 61};


int getfiles(char *filetype)
{
  char buffer[15];
  int wildcounter = 0;
  
  struct ffblk wild_card;
  
  memset(wildfiles, 0, sizeof(wildfiles));
  sprintf(buffer, "*.%s", filetype);
  
  if(findfirst(buffer, &wild_card, FA_NORMAL) == 0) { 
    strcpy(wildfiles[wildcounter], wild_card.ff_name);
    wildcounter++;
    
    while(findnext(&wild_card) == 0) { 
      strcpy(wildfiles[wildcounter], wild_card.ff_name);
      wildcounter++;
    }
  }
  if(wildcounter > 1)qsort(wildfiles, wildcounter, 15, strcmp);
  return wildcounter;
}


void cursoroff(void)
{
  union REGS regs;
  
  regs.h.ah = 0x01;
  regs.x.cx = 0x2000;
  int86(0x10, &regs, &regs);
}


void cursoron(void)
{
  union REGS regs;
  
  regs.h.ah = 0x01;
  regs.x.cx = 0x0607;
  int86(0x10, &regs, &regs);
}


void cls(int BACK, int FRONT)
{
  union REGS reg;
  
  reg.h.ah = 6;
  reg.h.al = 0;
  reg.h.ch = 0;
  reg.h.cl = 0;
  reg.h.dh = 24;
  reg.h.dl = 79;
  reg.h.bh = (BACK << 4) + FRONT;
  int86(0x10, &reg, &reg);
}


void setcrtmode(unsigned char m)
{
  union REGS rin,rout;
  
  if(ADAPTER == HERCULES) return 0;
  rin.h.ah = 0;
  rin.h.al = m;
  int86(0x10, &rin, &rout);
}


void DMC(int Row, int Column, unsigned BYTE, int BACK, int FRONT, int QUANT)
{
  /*  DMA replacement for writechs function */
  
  unsigned segment = 0xB000, offset;
  int One_Too_Many = (QUANT + 1);
  int i, Attribute;
  
  Attribute = (BACK << 4) + FRONT;
  
  if(ADAPTER != HERCULES)segment = 0xB800;
  /* CGA or Equivalent */
  offset = 160 * Row + 2 * Column ;
  for(i = 1; i < One_Too_Many ; i++) { 
    poke(segment, offset, BYTE | Attribute << 8);
    offset += 2;
  }
}


void DMM(char *String, int Row, int Column, int BACK, int FRONT)
{
  /*  DMA replacement for puts
  centre justified string    */
  
  unsigned Character, segment = 0xB000, offset;
  int Attribute;
  
  Attribute = (BACK << 4) + FRONT;
  
  Column = ((Column + 1) - (.5*(strlen(String))));
  
  if(ADAPTER != HERCULES)segment = 0xB800;
  /* CGA or Equivalent */
  offset = 160 * Row + 2 * Column ;
  while((Character = *String++) != 0) { 
    if(Character != '\n') { 
      poke(segment, offset, Character | Attribute << 8);
      offset += 2;
    }
  }
}


void DML(char *String, int Row, int Column, int BACK, int FRONT)
{
  /*  DMA replacement for puts
  left justified string    */
  unsigned Character, segment = 0xB000, offset;
  int Attribute;
  
  Attribute = (BACK << 4) + FRONT;
  
  if(ADAPTER != HERCULES)segment = 0xB800;
  /* CGA or Equivalent */
  offset = 160 * Row + 2 * Column ;
  while((Character = *String++) != 0) { 
    if(Character != '\n') { 
      poke(segment, offset, Character | Attribute << 8);
      offset += 2;
    }
  }
}


void BORDERBOX(int *cor, int fore, int bk, unsigned char BRDR)
{
  int trow = cor[0],tcol = cor[1],brow = cor[2],bcol = cor[3];
  /* draws an outline only using a specified border character */
  int index;
  int homerow = (brow - 1);
  int homecol = (tcol + 1);
  int linelength = ((bcol) - (tcol + 1));
  
  int TLcorner,TRcorner,BLcorner,BRcorner,HORT,VERT;
  
  switch(BRDR) { 
    case DOUBLE:
    TLcorner = 201;
    TRcorner = 187;
    BLcorner = 200;
    BRcorner = 188;
    HORT = 205;
    VERT = 186;
    break;
    
    case SINGLE:
    TLcorner = 218;
    TRcorner = 191;
    BLcorner = 192;
    BRcorner = 217;
    HORT = 196;
    VERT = 179;
    break;
    
    default:
    TLcorner = BRDR;
    TRcorner = BRDR;
    BLcorner = BRDR;
    BRcorner = BRDR;
    HORT = BRDR;
    VERT = BRDR;
  }
  DMC(trow, tcol, TLcorner, bk, fore, 1);
  /* top */
  DMC(trow, homecol, HORT, bk, fore, linelength);
  DMC(trow, bcol, TRcorner, bk, fore, 1);
  for(index = (trow + 1); index < brow; index++) { 
    DMC(index, tcol, VERT, bk, fore, 1);
    DMC(index, bcol, VERT, bk, fore, 1);
  }
  DMC(brow, tcol, BLcorner, bk, fore, 1);
  DMC(brow, homecol, HORT, bk, fore, linelength);
  DMC(brow, bcol, BRcorner, bk, fore, 1);
  /* bottom */
}

void getadaptertype(void)
{
  if(((biosequip() >> 4) &3) < 3)ADAPTER = CGA;
  else ADAPTER = HERCULES;
  
}

char poghead[8]={
    0x00,0x00,0x00,0x01,
    0x00,0x00,0x00,0x00};

char shphead[4]={0x0b,0x34,0x58,0x00};

char shptail[1]={0x00};

unsigned pchangetarget;

unsigned char *pchangebuffer;

unsigned csize = 572;
unsigned dsize = 577;


int DAT2POG(char *datname, char *pogname)
{
  int fh,fh2;
  
  if((fh2 = open(datname, O_RDONLY | O_BINARY)) == - 1) { 
    return - 1;
  }
  if((fh = open(pogname, O_CREAT | O_TRUNC | O_WRONLY | O_BINARY, S_IWRITE)) == - 1) { 
    sprintf(messagebuffer, "ERROR CREATING %s", pogname);
    close(fh2);
    return - 1;
  }
  
  /* write the new header */
  /* this is all that changes between the new and old style printshop */
  write(fh, poghead, 8);
  write(fh, (char *)&pchangetarget, 2);
  
  pchangebuffer = malloc(csize);
  
  while(read(fh2, pchangebuffer, csize) == csize)
    write(fh, pchangebuffer, csize);
  
  close(fh);
  close(fh2);
  free(pchangebuffer);
  
  sprintf(messagebuffer, "%s CREATED!", pogname);
  return (0);
  
}


int POG2DAT(char *pogname, char *datname)
{
  int fh,fh2;
  
  if((fh2 = open(pogname, O_RDONLY | O_BINARY)) == - 1)return - 1;
  
  if((fh = open(datname, O_CREAT | O_TRUNC | O_WRONLY | O_BINARY, S_IWRITE)) == - 1) { 
    sprintf(messagebuffer, "ERROR CREATING %s", datname);
    close(fh2);
    return - 1;
  }
  
  pchangebuffer = malloc(csize);
  
  read(fh2, pchangebuffer, 10);        /* blow away the 10 byte header */
  
  while(read(fh2, pchangebuffer, csize) == csize)
    write(fh, pchangebuffer, csize);
  
  close(fh);
  close(fh2);
  free(pchangebuffer);
  
  sprintf(messagebuffer, "%s CREATED!", datname);
  return (0);
  
}


int SHP2POG(char *shpname, char *pogname)
{
  int fh,fh2;
  
  if((fh2 = open(shpname, O_RDONLY | O_BINARY)) == - 1)return - 1;
  
  if((fh = open(pogname, O_CREAT | O_TRUNC | O_WRONLY | O_BINARY, S_IWRITE)) == - 1) { 
    sprintf(messagebuffer, "ERROR CREATING %s", pogname);
    close(fh2);
    return - 1;
  }
  
  /* write the new header */
  /* this is all that changes between the new and old style printshop */
  write(fh, poghead, 8);
  write(fh, (char *)&pchangetarget, 2);
  
  pchangebuffer = malloc(dsize);
  
  while(read(fh2, pchangebuffer, dsize) == dsize)
    write(fh, (char *)&pchangebuffer[4], csize);
  
  close(fh);
  close(fh2);
  free(pchangebuffer);
  
  sprintf(messagebuffer, "%s CREATED!", pogname);
  return (0);
  
}

int POG2SHP(char *pogname, char *shpname)
{
  int fh,fh2;
  
  if((fh2 = open(pogname, O_RDONLY | O_BINARY)) == - 1)return - 1;
  
  if((fh = open(shpname, O_CREAT | O_TRUNC | O_WRONLY | O_BINARY, S_IWRITE)) == - 1) { 
    sprintf(messagebuffer, "ERROR CREATING %s", shpname);
    close(fh2);
    return - 1;
  }
  
  pchangebuffer = malloc(csize);
  
  read(fh2, pchangebuffer, 10);        /* remove the 10 byte header */
  while(read(fh2, pchangebuffer, csize) == csize) { 
    write(fh, shphead, 4);
    write(fh, pchangebuffer, csize);
    write(fh, shptail, 1);
  }
  close(fh);
  close(fh2);
  free(pchangebuffer);
  
  sprintf(messagebuffer, "%s CREATED!", shpname);
  return (0);
  
}


int SHP2DAT(char *shpname, char *datname)
{
  int fh,fh2;
  
  if((fh2 = open(shpname, O_RDONLY | O_BINARY)) == - 1)return - 1;
  
  if((fh = open(datname, O_CREAT | O_TRUNC | O_WRONLY | O_BINARY, S_IWRITE)) == - 1) { 
    sprintf(messagebuffer, "ERROR CREATING %s", datname);
    close(fh2);
    return - 1;
  }
  
  
  pchangebuffer = malloc(dsize);
  while(read(fh2, pchangebuffer, dsize) == dsize)
    write(fh, (char *)&pchangebuffer[4], csize);
  
  close(fh);
  close(fh2);
  free(pchangebuffer);
  
  sprintf(messagebuffer, "%s CREATED!", datname);
  return (0);
  
}


int DAT2SHP(char *datname, char *shpname)
{
  int fh,fh2;
  
  if((fh2 = open(datname, O_RDONLY | O_BINARY)) == - 1)return - 1;
  
  if((fh = open(shpname, O_CREAT | O_TRUNC | O_WRONLY | O_BINARY, S_IWRITE)) == - 1) { 
    sprintf(messagebuffer, "ERROR CREATING %s", shpname);
    close(fh2);
    return - 1;
  }
  
  pchangebuffer = malloc(csize);
  
  while(read(fh2, pchangebuffer, csize) == csize) { 
    write(fh, shphead, 4);
    write(fh, pchangebuffer, csize);
    write(fh, shptail, 1);
  }
  close(fh);
  close(fh2);
  free(pchangebuffer);
  
  sprintf(messagebuffer, "%s CREATED!", shpname);
  return (0);
  
}


int convert(char *seedname, char *target_type)
{
  int fh,fh2;
  FILE *fp;
  char *bptr;
  char c,d;
  unsigned outfile = atoi(target_type);
  
  char oldshopbuf1[66],oldshopbuf2[66];
  char newshopbuf1[66],newshopbuf2[66];
  char masterbuf1[66],masterbuf2[66];
  char tempbuf[66];
  
  /* make file names... the old printshop wanted a GR prefix */
  
  strcpy(tempbuf, seedname);
  bptr = strtok(tempbuf, " .\\:*");
  sprintf(masterbuf1, "%s.SHP", tempbuf);
  sprintf(masterbuf2, "%s.SDR", tempbuf);
  
  c = toupper(tempbuf[0]);
  d = toupper(tempbuf[1]);
  
  if(c == 'G' && d == 'R') { 
    sprintf(newshopbuf1, "%s.POG", tempbuf);
    sprintf(newshopbuf2, "%s.PNM", tempbuf);
    sprintf(oldshopbuf1, "%s.DAT", tempbuf);
    sprintf(oldshopbuf2, "%s.NAM", tempbuf);
  }
  else { 
    tempbuf[6] = 0;
    sprintf(newshopbuf1, "GR%s.POG", tempbuf);
    sprintf(newshopbuf2, "GR%s.PNM", tempbuf);
    sprintf(oldshopbuf1, "GR%s.DAT", tempbuf);
    sprintf(oldshopbuf2, "GR%s.NAM", tempbuf);
  }
  
  switch(outfile) { 
    /* OLD PRINTSHOP to NEW PRINTSHOP */
    case 0:
    if((fp = fopen(newshopbuf1, "rb")) != NULL) { 
      fclose(fp);
      sprintf(messagebuffer, "%s already exists!", 
        newshopbuf1);
      return - 1;
    }
    sprintf(messagebuffer, "Could Not Find %s!", oldshopbuf2);
    if((fp = fopen(oldshopbuf2, "rb")) == NULL)return - 1;
    /* get the total number of files in the name file */
    pchangetarget = (unsigned )(filelength(fileno(fp)) / 16);
    fclose(fp);
    
    sprintf(tempbuf, "COPY %s %s >nul", oldshopbuf2, newshopbuf2);
    system(tempbuf);
    return DAT2POG(oldshopbuf1, newshopbuf1);
    
    /* NEW PRINTSHOP to OLD PRINTSHOP */
    case 1:
    if((fp = fopen(oldshopbuf1, "rb")) != NULL) { 
      sprintf(messagebuffer, "%s already exists!", 
        oldshopbuf1);
      fclose(fp);
      return - 1;
    }
    sprintf(messagebuffer, "Could Not Find %s!", newshopbuf2);
    if((fp = fopen(newshopbuf2, "rb")) == NULL)return - 1;
    fclose(fp);
    sprintf(tempbuf, "COPY %s %s >nul", newshopbuf2, oldshopbuf2);
    system(tempbuf);
    return POG2DAT(newshopbuf1, oldshopbuf1);
    
    /* PRINTMASTER   to NEW PRINTSHOP */
    case 2:
    if((fp = fopen(newshopbuf1, "rb")) != NULL) { 
      sprintf(messagebuffer, "%s already exists!", 
        newshopbuf1);
      fclose(fp);
      return - 1;
    }
    sprintf(messagebuffer, "Could Not Find %s!", masterbuf2);
    if((fp = fopen(masterbuf2, "rb")) == NULL)return - 1;
    /* get the total number of files in the name file */
    pchangetarget = (unsigned )(filelength(fileno(fp)) / 16);
    fclose(fp);
    
    sprintf(tempbuf, "COPY %s %s >nul", masterbuf2, newshopbuf2);
    system(tempbuf);
    return SHP2POG(masterbuf1, newshopbuf1);
    
    /* NEW PRINTSHOP to   PRINTMASTER */
    case 3:
    if((fp = fopen(masterbuf1, "rb")) != NULL) { 
      sprintf(messagebuffer, "%s already exists!", 
        masterbuf1);
      fclose(fp);
      return - 1;
    }
    
    sprintf(messagebuffer, "Could Not Find %s!", newshopbuf2);
    if((fp = fopen(newshopbuf2, "rb")) == NULL)return - 1;
    fclose(fp);
    sprintf(tempbuf, "COPY %s %s >nul", newshopbuf2, masterbuf2);
    system(tempbuf);
    return POG2SHP(newshopbuf1, masterbuf1);
    
    /* PRINTMASTER   to OLD PRINTSHOP */
    case 4:
    if((fp = fopen(oldshopbuf1, "rb")) != NULL) { 
      sprintf(messagebuffer, "%s already exists!", 
        oldshopbuf1);
      fclose(fp);
      return - 1;
    }
    sprintf(messagebuffer, "Could Not Find %s!", masterbuf2);
    if((fp = fopen(masterbuf2, "rb")) == NULL)return - 1;
    fclose(fp);
    sprintf(tempbuf, "COPY %s %s >nul", masterbuf2, oldshopbuf2);
    system(tempbuf);
    return SHP2DAT(masterbuf1, oldshopbuf1);
    
    /* OLD PRINTSHOP to   PRINTMASTER */
    case 5:
    if((fp = fopen(masterbuf1, "rb")) != NULL) { 
      sprintf(messagebuffer, "%s already exists!", 
        masterbuf1);
      fclose(fp);
      return - 1;
    }
    
    sprintf(messagebuffer, "Could Not Find %s!", oldshopbuf2);
    if((fp = fopen(oldshopbuf2, "rb")) == NULL)return - 1;
    fclose(fp);
    sprintf(tempbuf, "COPY %s %s >nul", oldshopbuf2, masterbuf2);
    system(tempbuf);
    return DAT2SHP(oldshopbuf1, masterbuf1);
  }
  
  strcpy(messagebuffer, "Unknown Error");
  return - 1;
  
  
}





/* the main stuff */
char *mainchoices[6][3]={
     " OLD PRINTSHOP to NEW PRINTSHOP " , "DAT", "0",
     " NEW PRINTSHOP to OLD PRINTSHOP " , "POG", "1",
     " PRINTMASTER   to NEW PRINTSHOP " , "SHP", "2",
     " NEW PRINTSHOP to   PRINTMASTER " , "POG", "3",
     " PRINTMASTER   to OLD PRINTSHOP " , "SHP", "4",
     " OLD PRINTSHOP to   PRINTMASTER " , "DAT", "5"};

int displayfiles(char *filetype, char *target_type)
{
  int i;
  int hotfile = 0;
  int coldfile = 0;
  int filecount = getfiles(filetype);
  char c;
  int background = BLUE, foreground = LCYAN;
  int cor[4];
  char errorbuf[128];
  
  int breverse = RED,freverse = BWHITE;
  if(ADAPTER == HERCULES) { 
    breverse = WHITE;
    freverse = BLACK;
  }
  
  if(filecount == 0)return 0;
  
  RESTART:;
  
  cls(background, foreground);
  
  cor[0] = 0;
  cor[1] = 0;
  cor[2] = 24;
  cor[3] = 79;
  
  BORDERBOX(cor, foreground, background, DOUBLE);
  DMC(0, 1, 1, background, foreground, 78);
  DMM(mainchoices[atoi(target_type)][0], 0, 40, background, BWHITE);
  DMM(
    " Use Arrows to Select * Enter to Convert * ESCape to Return To Main Menu ", 
    24, 40, background, BWHITE);
  
  
  if(filecount > 84)filecount = 84;
  
  
  for(i = 0;i < filecount;i++)
    DML(wildfiles[i], filecords[i][0], filecords[i][1], 
      background, foreground);
  DML(wildfiles[hotfile], filecords[hotfile][0], filecords[hotfile][1], 
    breverse, freverse);
  
  while((c = getch()) != ESCKEY) { 
    if(c == ENTERKEY) { 
      cls(background, foreground);
      DMM("One Moment Please...", 13, 40, background + 8, BWHITE);
      cor[0] = 10;
      cor[2] = 16;
      BORDERBOX(cor, foreground, background, SINGLE);
      
      if(convert(wildfiles[hotfile], target_type) != 0) { 
        sprintf(errorbuf, 
          "An Error Ocurred While Attempting To Convert %s", 
          wildfiles[hotfile]);
        DMM("One Moment Please...", 13, 40, background, background);
        DMM(errorbuf, 12, 40, background, BWHITE);
        DMM("Press Any Key....", 14, 40, background, BWHITE);
        DMM(messagebuffer, 8, 40, background + 8, BWHITE);
      }
      else { 
        sprintf(errorbuf, "File %s Successfully Converted.", 
          wildfiles[hotfile]);
        DMM("One Moment Please...", 13, 40, background, background);
        DMM(errorbuf, 12, 40, background, BWHITE);
        DMM("Press Any Key....", 14, 40, background, BWHITE);
        DMM(messagebuffer, 8, 40, background + 8, BWHITE);
      }
      printf("%c", 7);
      if(getch() == FUNCKEY)getch();
      goto RESTART;
    }
    
    if(c == FUNCKEY) { 
      c = getch();
      switch(c) { 
        case UPARROW  : if(hotfile < 4)break;
        hotfile -= 4;
        break;
        
        case DOWNARROW: if(hotfile > (filecount - 5))break;
        hotfile += 4;
        break;
        
        case RTARROW  :
        if(hotfile < (filecount - 1))
          hotfile++;
        break;
        
        case LTARROW  : if(hotfile == 0)break;
        hotfile--;
        break;
        case PGUP     :
        case PGDOWN   : break;
      }
    }
    if(hotfile != coldfile) { 
      DML(wildfiles[coldfile], 
        filecords[coldfile][0], filecords[coldfile][1], 
        background, foreground);
      DML(wildfiles[hotfile], 
        filecords[hotfile][0], filecords[hotfile][1], 
        breverse, freverse);
      coldfile = hotfile;
    }
  }
  
  return filecount;
  
}




int mainlocation[6]={ 7,9,11,13,15,17};
int mainlimit=6;
int hotmain= 0;
int coldmain=0;

char *help[]={
"In order to use the DAT files that XSHOP creates with the 1985 IBM",
"version of Printshop(tm), put the DAT file and its NAM file on-floppy.",
"When Printshop(tm) gives the user a choice to \"SELECT A GRAPHIC\", one",
"of the options is \"FROM DISK\". This option is selected and Printshop",
"then prompts the user to put the DATA DISK into the disk drive. The NEW",
"Printshop(c) works much the same way, and the POG file and its PNM file",
"are required rather than the DAT file and the NAM file.",
"****",
"The DAT and NAM files and POG and PNM files that are used with this",
"program must be prefaced with the two letters GR.",
"****",
"Since I am not too familiar with Printmaster(tm) I was able to perform",
"only the most rudimentary compatibility tests with my samples, which",
"were limited to SHP files of 88 pixels in width by 52 rasters in length.",
"The Printmaster(tm) SHP file format allows for variable size graphics.",
"****",
"The same holds true for the new Printshop(tm) Format which I do",
"not attempt to convert except for files with the POG extension.",
"The Files That I Handle are The Same Format To Which The NEW Printshop(tm)",
"Convert Utility Changes the Original Printshop(tm) Graphics.",
NULL};

main(int argc, char **argv)
{
  char c;
  int i,col = 40;
  int cor[4];
  int background = BLUE, foreground = LCYAN;
  int breverse = RED,freverse = BWHITE;
  char *bigbuff,*screen;
  
  cor[0] = 0;
  cor[1] = 0;
  cor[2] = 21;
  cor[3] = 79;
  
  getadaptertype();
  cursoroff();
  bigbuff = malloc(4000);
  
  if(ADAPTER == HERCULES) { 
    screen = (char far *)0xb0000000l;
    breverse = WHITE;
    freverse = BLACK;
  }
  screen = (char far*)0xb8000000l;
  
  RESTART:;
  
  cls(background, foreground);
  cor[0] = 0;
  cor[1] = 0;
  cor[2] = 2;
  cor[3] = 79;
  BORDERBOX(cor, BWHITE, background, SINGLE);
  cor[0] = 5;
  cor[2] = 19;
  BORDERBOX(cor, foreground, background, DOUBLE);
  cor[0] = 21;
  cor[2] = 24;
  BORDERBOX(cor, BWHITE, background, SINGLE);
  
  DMM(" XSHOP(C) CopyLeft 1991-1999 Teacher's Choice(tm) Productions ", 
    1, 40, background, BWHITE);
  DMM(
    " F1 For HELP * Use Arrows to Select and Press Enter * ESCape to Exit ", 
    20, 40, background, foreground);
  DMM("This Utility Will Convert Between The Graphics Formats Below", 
    3, 40, background, foreground);
  DMM("Files Will Be Read And Written In The Current Directory Only", 
    4, 40, background, foreground);
  
  
  DMM("By Bill Buckels * bbuckels@escape.ca * http://www.escape.ca/bbuckels",
    22, 40, background, BWHITE);
  DMM("589 Oxford St. * Winnipeg, Manitoba, Cdn * R3M 2J3",
    23, 40, background, BWHITE);
  
  for(i = 0;i < mainlimit;i++)
    DMM(mainchoices[i][0], mainlocation[i], col, 
      background, foreground);
  
  DMM(mainchoices[hotmain][0], mainlocation[hotmain], col, 
    breverse, freverse);
  
  while((c = getch()) != ESCKEY) { 
    if(c == ENTERKEY) { 
      if(displayfiles(mainchoices[hotmain][1], 
          mainchoices[hotmain][2]) != 0)goto RESTART;
      else
        printf("%c", 7);
    }
    
    if(c == FUNCKEY) { 
      c = getch();
      switch(c) { 
        case F1:
        memcpy(bigbuff, screen, 4000);
        cls(background, foreground);
        cor[0] = 1;
        cor[1] = 0;
        cor[2] = 22;
        cor[3] = 79;
        BORDERBOX(cor, foreground, background, DOUBLE);
        cor[0] = 2;
        cor[1] = 1;
        cor[2] = 21;
        cor[3] = 78;
        
        DMM("XSHOP(C) by Bill Buckels", 0, 40, 
          background, foreground);
        DMM("Leave Yourself Lots Of Disk Space To Work In", 
          23, 40, 
          background, BWHITE);
        DMM("Press Any Key To Return To The Menu ", 
          24, 40, background, foreground);
        
        for(i = 0;help[i] != NULL;i++)
          DMM(help[i], i + 2, 40, background, BWHITE);
        
        if(getch() == 0)getch();
        memcpy(screen, bigbuff, 4000);
        break;
        
        case DOWNARROW  :
        if(hotmain < (mainlimit - 1))
          hotmain++;
        else
          hotmain = 0;
        break;
        
        case UPARROW  :
        if(hotmain == 0)
          hotmain = (mainlimit - 1);
        else
          hotmain--;
        break;
      }
    }
    if(hotmain != coldmain) { 
      DMM(mainchoices[coldmain][0], 
        mainlocation[coldmain], col, 
        background, foreground);
      DMM(mainchoices[hotmain][0], 
        mainlocation[hotmain], col, 
        breverse, freverse);
      coldmain = hotmain;
    }
  }
  
  cursoron();
  free(bigbuff);
  cls(BLACK, BWHITE);
  poscurs(0,0);
  puts(" Have A Nice DOS! ");
  exit(0);
}
