;////////////////////////////////////////////////////////////////////////////
;name:          FRAGMENT.exe
;author:        Samuel Igwe
;description:   This program allows one to break up one large file (.exe,.zip or
;               data file) into a bunch of little files, that can be stored on
;               a floppy and transported across the serial line or to another
;               computer. Then once the files have been transferred they maybe
;               rejoined together by executing this program. I did this in lieu
;               of the myriads of large files (expecially executables) currently
;               being written. These files cannot fit on a standard floppy so
;               a means had to be developed to break them up into chunks and
;               reassemble them.
;date:          10/24/97
;/////////////////////////////////////////////////////////////////////////////
IDEAL
P386N           ;Minimum processor supported

;for this program I will write a .com format is the only one needed
;besides,this is a wonderful opportunity to practice DOS memory allocation

SEGMENT         FRAGMENT        PARA    'code'
org     100h    ;origin of .com file

main:
ASSUME CS:FRAGMENT;DS:FRAGMENT;SS:FRAGMENT

;it is safe to assume that when this program runs it will have ES=DS=CS=SP
;nonetheless i wish to allocate my own stack segment
jmp program_beginning           ;skip over data below
;////////////////////////////////////////////////////////////////////////////
swStack             dw      100 dup(0)
wdSegmentaddress    dw      0
wdFilehandle        dw      0,0           ;source file and destination
					  ;file handles
  
sbOptions           db      "fragment -[options] filename",0
		    db      "         -d     defragment files",0
		    db      "         -m#    #=maximum file size",0
		    db      "         -n#    #=number of output files",0
		    db      "         -r     remove source files",0
sbProcess           db      "PROCESS INDICATOR",0             ;18

;in the event that no options are chosen, I shall implement the default which
;will chop up the file into 1.44mb peices.
;NOTE:  WHEN THE PROGRAM IS TYPED ALONE IT IS ASSUMED THE USER WANTS TO FRAG-
;       MENT, THAT IS BREAK UP A FILE. WHEN THE -d OPTION IS PASSED THEN THE
;       PROGRAM DEFRAGMENTS A FILE. THIS IS SIMILAR TO THE FUNCTION OF THE UNIX
;       PROGRAM gzip AND gzip -d.

sbErrors            db      "Invalid Commandline Parameter",0
		    db      "Non Existent File/ File Error",0
		    db      "Unable To Allocate Needed Memory",0
		    db      "User Abort Initiated",0
sbBytes             db      "bytes",0                   ;used to complete a
sbSource            db      "Source File(s)       =",0
sbDestination       db      "Destination Files(s) =",0
sbPresskey          db      "Press A Key!",0    
							;sentence
sbFilenames         db      13 dup(0)
		    db      13 dup(0)
sbCommandline       db      80 dup(0)       ;holds contents of commandline
byLinelength        db      0               ;holds length of commandline            
byOperationbits     db      0
;set conditions
;bit 0              ==      fragment files
;bit 1              ==      defragment files
;bit 2              ==      remove source files1
;bit 3              ==      undefined

;bit 4              ==      m# option has been specified
;bit 5              ==      n# option has been specified

;NOTE: FOR THE COMMANDLINE OPTIONS THE USER MAY SPECIFY -n# [OR] -m# BUT
;NOTE: DEFENITELY NOT BOTH -- ITS EITHER ONE OR THE OTHER NOT BOTH OPTIONS

byNumber_of_files   db      0   ;maximum value is 99
			      ;this value may be determined is one of many 
			      ;ways

			      ;the user may specify this value with the -n#
			      ;option

			      ;the value may be calculated by taking the size of
			      ;the arguement file (filename in commandline), divi-
			      ;ding this value by the value of the -m# option

			      ;or in the case where neither the -n# nor the -m# is
			      ;not specified -- divid the size of the arguement file
			      ;(filename in commandline), by the default value of
			      ;1.44m.

dwRemaining_bytes   dd      0 ;the above value byNumber_of_files specifies the
			      ;number of files of size dwMaximum_filesize that is to
			      ;be written to disk. Often times these two numbers are not
			      ;evenly divisible in which case the remainder of the division
			      ;will be stored in this variable and will be written to disk
			      ;e.g maximum_filesize ==560 and number_of_files=2
			      ;560/2 =256 remainder 48 == meaning that 2 files of 256 bytes
			      ;each will be written to disk along with a 48 byte file to complete
			      ;the fragmenting process

dwMaximum_filesize  dd      0 ;maximum size of individual files
			      ;this value may be determined as follows

			      ;the user may specify this value with the -m#
			      ;option

			      ;the value may be calculated by taking the size of
			      ;the arguement file (filename in commandline), divi-
			      ;ding this value by the value of the -n# option

			      ;or in the case where neither the -m# or the -n# is
			      ;not specified assume the default of 1.44m
dwFilesize          dd      0 ;this is the size of the file whose name is passed
			      ;as an arguement in the commandline
byCurrentrow        db      0 ;screen address
sbBanner            db      "F"+128,"R"+128,"A"+128,"G"+128,"M"+128,"E"+128,"N"+128,"T"+128,160
		    db      "w"+128,"r"+128,"i"+128,"t"+128,"t"+128,"e"+128,"n"+128,160
		    db      "b"+128,"y"+128,160    ,"S"+128,"a"+128,"m"+128,"u"+128,"e"+128,"l"+128,160
		    db      "I"+128,"g"+128,"w"+128,"e"+128,160    ,"("+128,"c"+128,")"+128
		    db      "1"+128,"9"+128,"9"+128,"7"+128,       ,"."+128,160,0
;EQUATES
CHARCOLOR           equ     1   ;red
ASCIICHAR           equ     254 ;block    

;----------------------------------------------------------------------------
program_beginning:
;,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
mov ax,cs
mov ss,ax                       ;initialize stack
mov es,ax                       ;initialize es but not ds since i need it
				;pointing at Program Segment Prefix
mov sp,offset swStack           ;initialize stack offset
add sp,200                      ;100 words -- reference top of stack
call func_cls                   ;clear the screen

or [byte ds:80h],0              ;is there command line paramenters available?
jnz save_commandline
				;else return commandline parameters
push es
pop  ds                         ;initialize ds in preparation for func
				;tion call down below        
call func_display_options
mov ax,4c00h
int 21h                         ;SIMPLY EXIT DONT BOTHER CLEANING UP

       
        save_commandline:       ;SAVE COMMAND LINE STRING (PARAMETERS)
                                ;*************************************
	cld                     ;prepare for autoincrement
	xor cx,cx
	mov cl,[byte ds:80h]    ;copy x number of bytes from commandline
	mov [es:byLinelength],cl        ;save number
	mov si,81h              ;parameters begin at 81h of the PSP

	mov di,offset sbCommandline
	rep movs [byte es:di],[byte ds:si]

	mov ax,es
	mov ds,ax               ;initialize ds to point to this segment


				;PREPARE TO RESIZE MEMORY
                                ;************************
mov bx,offset program_end       ;end of current segment label
				;RESIZE MEMORY
add bx,15                       ;adjust for next paragraph in memory
shr bx,4                        ;divide by 16 (number of paragraphs)
inc bx                          ;leave a lot of room for running program
mov ah,04ah                     ;DOS function-- modify memory
				;es:bx---address of block to modify
int 21h
				;assume reallocation was done if not--just proceed

mov ah,48h                      ;DOS function-- allocate memory
mov bx,4000                     ;number of paragraphs to allocate
				;16 * 4000 == 64k buffer
int 21h
jnc save_segment_address
				;else flag error
mov al,3
call func_flag_errors           ;display null terminated string

mov ax,4c00h
int 21h                         ;SIMPLY EXIT DONT BOTHER CLEANING UP
;,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,

save_segment_address:
mov [ds:wdSegmentaddress],ax    ;save segment address
				;now check commandline parameters
				;**************
				;DISPLAY BANNER
				;**************

	mov si,offset sbBanner
	mov di,si

	@@banner:
	sub [byte es:di],128    ;continuously convert encoded string into
				;normal string
	inc di                  ;next byte
	or [byte es:di],00h     ;stop when 0 is detected
	jnz @@banner
				;else assume we are done and display
	mov dh,[ds:byCurrentrow]
	inc dh
        inc [byte ds:byCurrentrow]      ;adjust variable
        xor dl,dl               ;col 0
	mov ah,07h              ;attribute
	call func_writestr
				;END OF BANNER
                                ;*************


                                ;PARSE STRING CONVERTING SPACE TO NULLS
                                ;**************************************
	mov cl,[ds:byLinelength]        ;number of bytes read from commandline
	mov si,offset sbCommandline
	mov di,si
        
        @@parseloop:
        cmp [byte ds:si],20h    ;is this a blank or space char?
        je @@nullify
        cmp [byte ds:si],0dh    ;is the final character (return)?
        jne @@next
				;else
        @@nullify:              ;at this location assume blank char has been found
	and [byte ds:si],0000h  ;place NULL char at this location

	@@next:
	inc si                  ;next address
	dec cl
        jnz @@parseloop         ;optimized loop
				;assume that all space chars have been converted
				;to nulls

				;now assume that the last arguement on the
				;commandline is the filename
				;so scan backwards looking for the end of the string


                                ;COPY FILENAME OUT OF COMMANDLINE BUFFER
                                ;***************************************
        xor cx,cx
        mov cl,[byte ds:byLinelength]   ;number of bytes to search through
	add di,cx               ;begin from end of commandline
        xor al,al               ;search char
        cld

                @@find_first_nonzero:
                or [byte es:di],0
                jnz @@find_first_zero
                                ;else assume 0 proceed
                dec di          ;next location going backwards
                jmp @@find_first_nonzero



                @@find_first_zero:
                or [byte es:di],0
                jz @@prepare_get_string
                                ;else assume non zero
                dec di          ;next location going backwards
                jnz @@find_first_zero



                @@prepare_get_string:
                inc di                  ;increment pointer to reference char
                mov si,offset sbFilenames
                xchg si,di              ;si==initial char of commandline filename
                                        ;di==offset 0 of sbFilename        


                @@get_string:
                or [byte ds:si],0       ;is this 0==end of string?
                                        ;REMEMBER THAT SI NOW ADDRESSES COMMAND
                                        ;LINE
                jz @@get_string_done
                                ;else
                movs [byte es:di],[byte ds:si]
                jmp @@get_string


        @@get_string_done:
        cld                             ;simply slide down to code below

                                ;PARSE COMMANDLINE FOR OPTION PARAMETERS
                                ;***************************************
	mov di,offset sbCommandline
	and cx,0000h            ;clear out cx
	mov cl,[ds:byLinelength]        ;number of bytes read from command line
	mov al,"-"              ;commandline option divisor


	@@options:
	repne scas [byte es:di]
	jne prepare_files
				;else assume that the "-" has been found --
				;di is autoincremented
	cmp [byte es:di],"d"    ;defragment files?
	jne @@checkn
				;set bit 1
	or [byte ds:byOperationbits],02h
	jmp @@options           ;


	@@checkn:
	cmp [byte es:di],"m"    ;number of files parameter?
	jne @@checkm
				;else increment by 1 and read the string at
				;this location which is to
				;be converted into a binary doubleword and
				;stored in dwMaximum_file_size
	inc di                          ;reference correct address
        or [byte es:di],00              ;make sure the next char is not null
                                        ;such would appear if the user typed
					;in -n 2 which should really be -n2
        jz @@options                    ;else proceed to code below
	mov si,di                       ;prepare for call to function below
	call func_stringlength
					;return in cx
	call func_string_to_dword       ;convert string to 32 bit doubleword
	test [ds:byOperationbits],20h   ;has the user already specified the m# option?
	jz @@save_number_of_files       ;ONE OR THE OTHER (m# OR n#) BUT NOT BOTH
					;else
	jmp @@options


	@@save_number_of_files:
	or [ds:byOperationbits],10h     ;set number of files bit
	mov [dword ds:dwMaximum_filesize],ebx  ;save value
	jmp @@options


	@@checkm:                       
	cmp [byte es:di],"n"            ;maximum file size parameter?
	jne @@checkr
					;else increment by 1 and read the 
					;string at this location which is to
					;be converted into a binary byte
					;and stored in byNumber_of_files
	inc di
        or [byte es:di],00              ;make sure the next char is not null
                                        ;such would appear if the user typed
					;in -m 200000 which should really be
                                        ;-m200000
        jz @@options                    ;else proceed to code below

	mov si,di                       ;prepare for call to function below
	call func_stringlength
					;return in cx
	call func_string_to_dword       ;convert string to 32 bit doubleword
	test [ds:byOperationbits],10h   ;has the user already specified the n# option?
	jz @@save_maximum_number        ;ONE OR THE OTHER (m# OR n#) BUT NOT BOTH
					;else
	jmp @@options


	@@save_maximum_number:
	or [ds:byOperationbits],20h     ;set maximum number bit
	mov [byte ds:byNumber_of_files],bl      ;save value
	jmp @@options


	@@checkr:
	cmp [byte es:di],"r"            ;remove (delete) source files?
	jne @@options
					;else set bit 3
	or [byte ds:byOperationbits],04h
	jnz @@options                   ;just jump to location



;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
prepare_files:                  ;DUPLICATE sbFilename TO sbFilename +13
                                ;**************************************
					;copy filename in sbFilename to
					;sbFilename +13
mov si,offset sbFilenames
mov di,offset sbFilenames
add di,13                               ;reference next location
mov cx,8


	@@loop:
					;search through source string looking
					;for "." or 0
					;if found exit from search and append ~00
					;to the remainder
					;of the file
	cmp [byte ds:si],"."            ;look for extension
	je @@append_extension
	cmp [byte ds:si],0              ;look for end of file
	je @@append_extension
					;else
	movs [byte es:di],[byte ds:si]  ;automatically updates the registers
	dec cx                          ;optimized loop
	jnz @@loop



@@append_extension:
                                ;TACK IN APPROPRIATE EXTENSION
                                ;*****************************
mov al,"~"                              ;~
mov ah,30h                              ;0
movs [byte es:di],[byte ds:si]          ;copy "." while automatically increm- 
					;ting address
stos [word es:di]                       ;store at sbFilenames +13
mov [byte es:di],30h                    ;di was incremented from last command
					;we are done


;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
;NOW DETERMINE WHETHER OR NOT WE ARE TO FRAGMENT A FILE OR DEFRAGMENT A FILE
;BEARING IN MIND THAT FILE FRAGMENTATION IS THE DEFAULT WHEN NO OPTION IS
;OTHERWISE PASSED.
;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
test [ds:byOperationbits],02h           ;defragment file?
jnz CS_DEFRAGMENT_FILE
					;else assume file fragmentation
jmp CS_FRAGMENT_FILE
;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''



CS_DEFRAGMENT_FILE:
;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
				;attempt to create the file in sbFilename
mov ah,3ch                      ;DOS function --create file
xor cx,cx                       ;attributes --normal file 
mov dx,offset sbFilenames
int 21h
jnc @@initialize_variables

				;else flag error
	mov al,2                ;file error byte
	mov dh,[ds:byCurrentrow]
        inc dh                  ;reference correct location        
        xor dl,dl               ;dh,dl == row column
	call func_flag_errors
	jmp exit_program        ;lets get out of here


@@initialize_variables:
mov [ds:wdFilehandle],ax                ;save destination file handle
and [dword ds:dwFilesize],00000000h     ;clear this variable as it will be
					;used by defragment write function to
					;maintain a tally or sum of the total
					;number of bytes read and written

call func_display_source_dest_defrag

					;next determine location of file "~"
					;marker
	mov al,"~"                      ;search char
	mov cx,13
	mov di,offset sbFilenames
	add di,13                       ;reference correct location
	mov dx,di                       ;needed as arguement to DOS
					;open file function
	repne scas [byte es:di]
					;assume that at the end of the scan di
					;points at char after search
					;char hence at "0"
					;this di address is not to be changed
	xchg bp,di                      ;safely store away di in bp
	mov di,[ds:wdFilehandle]        ;store destination file handle
                                        ;permanently



        @@file_defragmentation_loop:    
	mov ax,3d00h                    ;DOS function --open file for reading
					;ds:dx address null terminated filename
	int 21h
        jnc @@call_function_
                                        ;else


        @@file_defragmentation_done:
					;alert user that file is done and is x
					;bytes in size close source and destin-
					;ation files
	mov bx,[ds:wdFilehandle]
	mov ah,3eh                      ;DOS function --close file function
	int 21h

	mov dh,[ds:byCurrentrow]        ;initialize addresses
        add dh,2                        ;reference correct address
        xor dl,dl                       ;
        mov si,offset sbFilenames
        mov ah,07h                      ;attribute
	call func_writestr              ;at the end the string on this line
					;should read "filename" = #string bytes
        add dl,21
	mov al,"="                      ;char to write
	mov cx,1                        ;arguement to function below
	call func_writecharcx

	mov eax,[ds:dwFilesize]         ;get total numnber of bytes written to
					;"filename"
	mov di,offset sbCommandline     ;use commandline to hold string
	call func_dword_to_string
					;should return es:di pointing at null
					;terminated string as well as cx=string
					;length.
        add dl,3
        xchg si,di                      ;prepare to display
        mov ah,07h                      ;attribute
	call func_writestr

	inc cx                          ;formatting
	add dl,cl                       ;reference next location for char
	mov si,offset sbBytes
	call func_writestr              ;DONE
	jmp exit_program                ;EXIT AND CLEANUP


        @@call_function_:
					;place source filehandle (ax) into si
	xchg si,ax                      ;place source handle into si
	call func_write_defragment_file
        jc @@file_defragmentation_done
					;now create the new source filename

        push ax
        push di
        mov di,bp                       ;retrieve address
	mov ax,[word es:di]             ;get filenames extensions
	sub ax,3030h                    ;convert to decimal values
        xchg al,ah

        inc al                          ;next file
	aaa                             ;adjust ah in reference to the new value of al
	add ax,3030h                    ;convert back into ascii chars
	xchg ah,al                      ;adjust for memory little endian format
					;since after ah technically contains 
					;the value we want -- i could of course
					;have said mov ah,[es:di] mov al,[es:di +1]
					;after aaa i could then mov [es:di],ah
					;mov [es:di +1],al
	
	stos [word es:di]               ;put back into memory
	pop di
        pop ax
					;continue loop
	jmp @@file_defragmentation_loop



;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
CS_FRAGMENT_FILE:
					;attempt to open the file in sbFilename
mov ax,3d00h                            ;open file for reading
mov dx,offset sbFilenames
int 21h
jnc @@initialize_variables

				;else flag error
	mov al,2                ;file error byte
	mov dh,[ds:byCurrentrow]
        inc dh                  ;adjust address
        xor dl,dl               ;dh,dl == row column
	call func_flag_errors
	jmp exit_program        ;lets get out of here


@@initialize_variables:
				;FIRST SAVE THE FILE HANDLE TO wdFilehandles
mov [ds:wdFilehandle],ax        ;save source file handle
				;NOW SEEK TO END OF FILE TO DETERMINE FILE
				;SIZE AND STORE THIS VALUE IN dwFilesize

@@determine_filesize:
xchg bx,ax                      ;place file handle in bx into ax
mov ax,4202h                    ;DOS function--seek to end of file
xor cx,cx
xor dx,dx                       ;cx:dx is an arguement to function
int 21h
jnc @@savefilesize

				;else flag error
	mov al,2                ;file error byte
	mov dh,[ds:byCurrentrow]
        inc dh                  ;adjust address
	xor dl,dl               ;dh,dl == row column
	call func_flag_errors
	jmp exit_program        ;lets get out of here


@@savefilesize:
				;dx:ax contains the files size
mov [word ds:dwFilesize],ax
mov [word ds:dwFilesize +2],dx





				;now reset file pointer to the beginning of the file
mov ax,4200h                    ;DOS function--seek to file beginning
xor cx,cx
xor dx,dx                       ;arguements to function
int 21h
jnc @@continue

				;else flag error
	mov al,2                ;file error byte
	mov dh,[ds:byCurrentrow]
        inc dh                  ;adjust address
	xor dl,dl               ;dh,dl == row column
	call func_flag_errors
	jmp exit_program        ;lets get out of here


@@continue:
				;next write the string "PROCESS INDICATOR"
                                ;centered to the screen then display the process
                                ;indicator box, and copy clear the first 4
                                ;bytes of the sbCommandline variable. These four
                                ;bytes will be used by func_write_defragment_file
                                ;to accumulate the number of bytes written and also
                                ;by func_update_process to do as its name implies
                                ;the gradeschool formula (percentage/base)=(rate/100)
                                ;will be used with appropriate modifications of the
				;end result. In this case percentage=the dword value
                                ;as seen from offset 0 of sbCommandline and base = the
                                ;dword value of dwFilesize
mov si,offset sbProcess
mov ah,07h                              ;attribute
mov dh,[ds:byCurrentrow]
add dh,2                                ;address
add [ds:byCurrentrow],2                 ;update variable
mov dl,21h                              ;col 33
call func_writestr                      ;display

					;NOW DISPLAY THE PROCESS INDICATOR BOX
mov dh,[ds:byCurrentrow]
inc dh
add [ds:byCurrentrow],3                 ;update variable
mov [byte ds:sbCommandline +5],11h
mov [byte ds:sbCommandline +6],dh       ;PLACE VALUE AT OFFSET 5 FOR THE CALL
                                        ;TO func_update_process offset 0 -4 are
                                        ;not to be tampered with
inc [byte ds:sbCommandline +6]          ;increment this value -- formatting
mov dl,0fh                              ;col 15
mov ah,07h                              ;attribute
mov bx,0336h                            ;row length =3 col length =50
call func_singlebox


					;calculate values for number of files,maximum
					;file size, remainder bytes
test [ds:byOperationbits],10h           ;has user specified the m# option
jz @@checkn
					;else use dwMaximum_filesize to calculate the
					;number of files
					;here is where the 32 bit registers come into play


@@calculatem:                           ;-m OPTION
mov eax,[dword ds:dwFilesize]           ;get file size
xor edx,edx                             ;prepare for division
mov ecx,[dword ds:dwMaximum_filesize]   ;get divisor
div ecx
cmp eax,99                              ;quotient must be less than or equal
                                        ;to 99
jbe @@save_number_of_files
					;else
mov al,99

@@save_number_of_files:
mov [ds:byNumber_of_files],al           ;save quotient
mov [ds:dwRemaining_bytes],edx          ;save remainder

jmp begin_file_fragmentation



@@checkn:                               ;-n OPTION
test [ds:byOperationbits],20h           ;has the user specified the n# option
mov [ds:dwMaximum_filesize],1440000     ;place default value here and prepare for
					;possible conditional jump
jz @@calculatem                         ;jump to above location using 1.44m in
					;place of user arguement
					;else
mov eax,[dword ds:dwFilesize]           ;get filesize
xor edx,edx                             ;prepare for division
xor ecx,ecx
mov cl,[ds:byNumber_of_files]
div ecx                                 ;get divisor
mov [dword ds:dwMaximum_filesize],eax   ;save qoutient
mov [dword ds:dwRemaining_bytes],edx    ;save remainder
                                        ;slide down to code belwo

	
	begin_file_fragmentation:
        call func_display_source_dest_frag
        and [dword ds:sbCommandline],00000000h
                                        ;the function func_process_indicator needs to
                                        ;use the double word from offset 0 of sbCommand-
                                        ;line variable to maintain a sum of bytes read
                                        ;and written
        cld
					;first determine location of file "~"
	mov al,"~"                      ;search char
	mov cx,13                       ;number of bytes to search through
	mov di,offset sbFilenames
	add di,13                       ;reference correct location
	mov dx,di                       ;needed as arguement to DOS--
					;open file function
	repne scas [byte es:di]
					;assume that at the end of the scan di
					;points at char after search
					;char hence at "0"
					;this di address is not to be changed
	xchg bp,di                      ;safely store away di in bp
	mov si,[ds:wdFilehandle]        ;store source file handle
                                        ;permanently
					;NOW CHECK TO SEE IF THE DIVISION OF
					;FILESIZE/MAXIMUM FILE SIZE YIELDED A
					;VALUE OF ZERO (in number_of_files
					;variable).
	or [byte ds:byNumber_of_files],00h
        jz @@write_remainder_bytes      ;if so jump to location to write just
                                        ;the remainder bytes
					;else proceed to code below


	@@file_fragmentation_loop:
	mov ah,3ch                      ;DOS function--create file
	xor cx,cx                       ;normal file attributes
                                        ;ds:dx address null terminated filename
        int 21h
        jnc @@call_function_
					;else

	@@doserror:
	mov al,2                        ;error number
	mov dh,[ds:byCurrentrow]
        inc dh                          ;adjust address
        xor dl,dl
	call func_flag_errors
	jmp exit_program


        @@call_function_:
	xchg di,ax                      ;place destination handle in di

        push ax
        push dx

        mov ax,[word ds:dwMaximum_filesize]
	mov dx,[word ds:dwMaximum_filesize +2]
	call func_write_fragment_file

        pop dx
        pop ax
        jc @@doserror
                                        ;else proceed to code below
        push ax
        push di
					;now create the new filename
	mov di,bp                       ;retrieve address
	mov ax,[word es:di]             ;get filenames extensions
	sub ax,3030h                    ;convert to decimal values
					;
        xchg al,ah                      ;adjust
        inc al                          ;next file index
	aaa                             ;adjust ah in reference to the new value of al
	add ax,3030h                    ;convert back to ascii
        xchg al,ah                      ;adjust for memory little endian format
					;since after ah technically contains 
					;the value we want -- i could of course
					;have said mov ah,[es:di] mov al,[es:di +1]
					;after aaa i could then mov [es:di],ah
					;mov [es:di +1],al
	stos [word es:di]               ;put back into memory 
        pop di
        pop ax

	dec [byte ds:byNumber_of_files] ;optimized loop
	jnz @@file_fragmentation_loop





        @@write_remainder_bytes:
                                        ;now assume that all that remains is to
                                        ;write out the remainder bytes
	mov ah,3ch                      ;DOS function--create file
	xor cx,cx                       ;normal file attributes
	mov dx,offset sbFilenames       ;ds:dx address null terminated filename
        add dx,13                       ;reference correct location
	int 21h
        jnc @@call_function2_
					;else
	jmp @@doserror


        @@call_function2_:
	xchg di,ax                      ;place destination handle in di
        push ax
        push dx

        mov ax,[word ds:dwRemaining_bytes]
	mov dx,[word ds:dwRemaining_bytes +2]
        call func_write_fragment_file

        pop dx
        pop ax
        jc @@doserror
					;else
                                        ;now close down the source file name and exit

	mov ah,3eh                      ;DOS function--close file 
        xchg bx,si                      ;place handle in bx
        int 21h

					;slide down to label BELOW


exit_program:
					;FIRST DEALLOCATE MEMORY
                                        ;***********************
mov ah,49h                              ;DOS function--deallocate memory
push [word ds:wdSegmentaddress]
pop es                                  ;es:0 must hold address of allocated segment
int 21h

mov ah,07h                              ;attribute
mov dx,1800h                            ;screen address
mov si,offset sbPresskey                ;user alert
call func_writestr

xor ah,ah
int 16h                                 ;AWAIT FOR USER TO PRESS A KEY
					;WHEN DONE EXIT PROGRAM
call func_cls
mov ax,4c00h
int 21h                                 ;exit stage left



;****************************************************************************
;                   SUBROUTINES PERTAINING TO THIS PROGRAM
;****************************************************************************
;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
;name:          func_cls
;description:   emulates the DOS cls (clear screen) command
;inputs:        none
;outputs:       cleared screen
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
func_cls:
				;affected registers are saved
push es                         ;save segment to be changed
push ax                         ;save general register
push di                         ;save offset
push cx                         ;save general register
cld

mov ax,0b800h                   ;initialize segment of video memory
mov es,ax
xor di,di                       ;start from column 0 row 0
mov  ax,0700h                   ;blank screen, white attribute   (using 0f00h= bright white)
				;could have used 255d or 32d which both represent the blank
				;ascii char (al)
mov cx,2000d                    ;half of 4000 since I plan to use stosw
rep stos [word es:di]

pop cx                          ;restore general register
pop di                          ;restore register
pop ax                          ;restore register
pop es                          ;restore changed segment
ret


;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
;name:          func_writestr
;function:      writes a string of a specified length,color to a given loc-
;               ation. A NULL (0) TERMINATED STRING IS THE ARGUEMENT POINTED TO
;               BY SI.
;inputs:        ah=color
;               ds=string segment address
;               si=string offset address
;               dh=row
;               dl=column
;outputs:       string at specified location of specified color.
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
func_writestr:
push es                         ;segment register es which func_char_address
                                ;initializes must be save and restored
pusha                           ;save registers

call func_char_address          ;initialize es:di with the video address
call func_stringlength
cld                             ;prepare to increment

@@loop_write_string:
lods  [byte ds:si]              ;load al with the value in ds:si

stos  [word es:di]              ;store ax at the video memory address.
				;ah contains color and al contains character
				;remember that even memory addresses hold
				;chars while odd addresses (video) hold color
				;finally remember that 8086 stores words (2
				;bytes) in byte swapped order hence ax would
				;be stored as al,ah.
dec cx
jnz @@loop_write_string

popa                            ;restore all registesr
pop es                          ;source of a full day debug
ret                             ;return


;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
;name:          func_stringlength
;description:   calculates the string length of a null terminated string
;inputs:        ds:si pointer to string
;outputs:       cx=stringlength
;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
func_stringlength:
push es
push ax
push di

mov ax,ds
mov es,ax                       ;initialize es
mov di,si                       ;place si in di

xor al,al                       ;null char
mov cx,0ffffh                   ;-1 (trick)
cld
repnz scas [byte es:di]         ;scan for 0

not cx                          ;get string length
dec cx                          ;adjust for autoincrementing

pop di
pop ax
pop es
ret


;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
;name:          func_char_address
;function:      calculates the address of the character or beginning of a
;               string that is to be displayed. utilizes the formula char
;               address= (row# * 80) + column.
;inputs:        dh=row
;               dl=column
;output:        es= segment address
;               di= offset address
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
func_char_address:
				;char address=  (row # * num char per row (79))
				;+ column
push ax                         ;save all affected registers
push dx                         ;save all affected registers

mov di,0b800h
mov es,di                       ;initialize es with address of video segment

xchg dl,dh                      ;switch dl and dh to make processing rows easier
				;dl=row
				;dh=col
mov al,dh                       ;place col in al
mov di,dx                       ;place row in di        ;for second 2^4 multiplication.

				;the plan is simple shift the row # 6 times to the left.
				;shift the original #
				;(not the result) 4 times to the left. finally add the two results and the
				;value of the col.
xor ah,ah                       ;clear top 8 bits
xor dh,dh                       ;clear top 8 bits
and di,00ffh                    ;clear top 8 bits

shl dx,6                        ;80286 allows me to shift immediates
shl di,4                        ;80286 allows me to shift immediates

add di,dx                       ;add the two results= (row# * 64) + (row# * 16)
add di,ax                       ;add in the col # to the net result.
shl di,1                        ;we are using stosw instead of stosb so we must
				;compensate for the addition of 2 bytes to the address.
				;one way or another we would have had to multiply by
				;two since there are really 160 bytes on one row if
				;one includes the ascii char  code as well as the
				;attribute byte.

pop dx                          ;retrieve all saved registers
pop ax                          ;retrieve all saved registers
ret                             ;return


;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
;name:          func_writecharcx
;function:      writes the char in al to the specified video screen location,
;               cx number of times
;inputs:        ah= color
;               al= character
;               dh= row
;               dl= column
;               cx= # of times to write char
;output:        char at specified screen location with specified color.
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
func_writecharcx:
push di                         ;save offset
push es                         ;save modified segment register
push cx                         ;save count
cld

call func_char_address          ;initialize address
rep stos [word es:di]           ;store ax at video segment

pop cx                          ;restore count
pop es                          ;retrieve modified segment register
pop di                          ;retrieve offset
ret                             ;return


;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
;procedure:     func_singlebox
;description:   this procedure will aid me in drawing a single line box
;inputs:        ah= color
;               al= single ascii chars 218,196,191,179,217,192
;               dh= initial y (row)
;               dl= initial x (col)
;               bh= lenght of y (width)
;               bl= lenght of x (lenght)
;outputs:       box at specified address
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
func_singlebox:
pusha                           ;save all registers
				;adjustment for formatting
sub bx,0202h                    ;subtract 2 from both the bh and the bl register

cld
				;char_address need only be called once, afterwards
				;di may be saved in another
				;register such as si or pushed and popped from
				;the stack memory.
push es                         ;save modified segment register

call func_char_address
mov dx,di                       ;save initial offset address in dx
mov al,218d                     ;ascii graphic
stos [word es:di]

xor cx,cx                       ;clear count register
mov cl,bl                       ;x repetition

mov al,196d                     ;ascii graphic
rep stos [word es:di]
				;note that after the rep prefix di now points to
				;the next column. hence it
				;would not be wise to use another stos as this
				;will increment di too far.
mov al,191d                     ;ascii graphic
mov [word es:di],ax
mov cl,bh                       ;y repetition
mov al,179d                     ;ascii graphic

@@loop_drawbox_single:
add di,160d                     ;this should automatically set the address to the next
				;row
				;since a char and color each occupy a byte we have 2
				;bytes needed to display a character. with 809 being
				;the maximum amount of characters displayable on a the
				;screen we need 80 * 2 =160 bytes to move to the next
				;row (160 bytes equals 80 words).
mov [word ptr es:di],ax
dec cx
jnz @@loop_drawbox_single

add di,160d                     ;next row
mov al,217d                     ;ascii graphic
mov [word es:di],ax

mov di,dx                       ;restore original offset from dx
mov cl,bh                       ;y repetition
mov al,179d                     ;ascii graphic

@@loop_drawbox_single2:
add di,160d                     ;this should automatically set the address to the next
				;row
mov [word es:di],ax
dec cx
jnz @@loop_drawbox_single2

add di,160d                     ;next row
mov al,192d                     ;ascii graphic
mov [word es:di],ax
				
add di,2d                       ;next column
mov cl,bl                       ;x repetition
mov al,196d                     ;ascii graphic
rep stos [word es:di]

pop es                          ;retrieve modified segment register
popa
ret


;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
;name:          func_string_to_dword
;description:   converts string pointed to by ds:si to a straight binary num-
;               ber (dword -32 bit) in the ebx register. 
;inputs:        ds: strings segment address
;               si: strings offset  address (the first char in the string)
;               cx: stringlenght
;outputs:       ebx: binary value of string with a theoretical maximum of
;                    4 billion.
;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
func_string_to_dword:
push eax                        ;save all 32 bit registers
push cx
push edx
push si
push edi

cld                             ;clear direction flag
and cx,000Fh                    ;max stringlength equals 15
xor eax,eax                     ;clear out all register
xor ebx,ebx                     ;clear register that is to hold ouput value
mov edi,1                       ;used for calculating divisor
push cx                         ;save count to stack

	@@string_convert:
	sub [byte ds:si],30h    ;convert to BCD value
	inc si                  ;next ascii code

	loop @@string_convert   ;loop

				;at the end of this routine si points to the character
				;after the last number
				;since si is incremented at the end of each subtraction.
	pop cx                  ;restore ecx

	@@binary_convert:
	dec si                  ;last char
	mov al,[byte ds:si]     ;get char begining with the ones column
	mul edi                 ;multiply by 10^x where x=>0 x=<8
				;add result in eax to ebx
	add ebx,eax

				;multiply contents of esi by 10
	mov eax,edi             ;place esi in eax
	shl eax,3               ;*8
	shl edi,1               ;*2
	add edi,eax             ;==*10


	xor eax,eax             ;clear out register

				;note: recall from elementary that we were taught the
				;100280 is equal
				;to [0*1]+[8*10]+[2*100]+[0*1000]+[0*10000]+[1*100000].
				;this is essentially
				;the method i have chosen to use in converting these
				;strings to a binary value
				;use of dword directive because i plan on working with the
				;full 32 bit maximum
				;value of 4 billion.
	loopw  @@binary_convert

pop edi                         ;restore registers
pop si
pop edx
pop cx
pop eax
ret


;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
;name:          func_dword_to_string
;description:   converts a straight binary number in the eax register to a
;               string in es:di.
;               divide by 10 saving each remainder to the stack until a
;               0 quotient is detected. save the last remainder to the
;               stack and pop then off the stack one by one. I have already
;               tried this out a thousand times and it works well  with
;               100280 the first division (by 10) yields a remainder of 0,
;               a division of the quotient by 10 (10028) yields a remainder
;               of 8 then 0 then 0 then 1.
;
;inputs:        es: string segment to store number
;               di: offset address to store number
;               edx:eax= straight binary number to convert to ascii string
;
;output:        es:di (string) holds ascii string of number
;               cx=string length of converted string
;               string at es:di should be at least 11 bytes in length.
;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
func_dword_to_string:           
push eax                        ;save registers
push ebx
				;do not save ecx its to return the string
				;length of the converted value
push edx
push di                         ;save initial offset
cld

xor ecx,ecx                     ;clear ecx
xor edx,edx                     ;clear 32 bit top most register
mov ebx,10d                     ;permanent divisor value
				;ebx was chosen since edx:eax are affected by division

@@convert_binary:
div ebx                         ;divide by 10d, remainder in edx
				;else
inc cx                          ;maintain count
push dx                         ;save remainder to the stack

cmp eax,0d                      ;check to see if were done
je @@prepare_to_convert
				;else
xor edx,edx                     ;clear edx,edx so that it does not affect next div

jmp @@convert_binary            ;begin anew
				;personal note: dont tamper with eax for it holds
				;the quotient that will have
				;to be divided by 10 again and again until it yields 0.

@@prepare_to_convert:
				;assume two things --
				;1. register cx holds the count (string length or number
				;of values pushed onto the stack
				
				;
				;2. register ebx is now free for other purposes, one of
				;which will be to hold
				;the count value (equal to the string length) until
				;the @@convert_string
				;looping statement terminates
mov bx,cx                       ;place string length or number of values pushed onto the stack
				;in bx

@@convert_string:
pop ax                          ;retrieve remainder into ax from dx where it was originally
				;saved to
add al,30h                      ;convert to ascii code

stos [byte es:di]               ;store at address

loopw @@convert_string          ;CX HOLDS THE COUNT
				;append 0 to end of string in order to have a null terminated
				;string
and [byte es:di],00h            ;null terminated string

xchg cx,bx                      ;restore cx with string length from bx

pop di                          ;restore offset register
pop edx                         ;restore general registers
pop ebx
pop eax
ret


;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
;name:          func_write_fragment_file
;description:   this function is called recursively and servers one major
;               purpose-- that is it calculates the number of 64k blocks to
;               read and write from source file to destination file as well
;               as the remainder bytes. It then proceeds to read and write
;               the destination file.
;inputs:        dx:ax=filesize (usually the value of dwMaximum_filesize)
;               si=   handle of source file
;               di=   handle of destination file
;outputs:       carry flag returns file status- set on error cleared otherwise
;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
func_write_fragment_file:
push ds
pusha

;display screen destination filename
push ax
push dx
push si
mov dl,[byte ds:sbCommandline +9]
mov dh,[byte ds:sbCommandline +10]
mov ah,07h                      ;attribute
mov si,offset sbFilenames
add si,13                       ;reference correct offset
call func_writestr
pop si
pop dx
pop ax

				;allocate stack variables (2 words)
enter 6,0
				;now calculate the number of 64k blocks to read and write.
mov cx,64000                    ;permanent value will be used as divisor and as arguement
				;to Dos read and write function
div cx                          ;ax=quotient
				;dx=remainder
mov [word ss:bp -2],ax          ;save number of 64k iterations
mov [word ss:bp -4],dx          ;save remainder bytes to write

				;now place allocated DOS segment address into ds register
	push [word ds:wdSegmentaddress]
	pop ds                  ;now ds holds allocated segment address
                                ;DS NO LONGER POINTS AT THIS SEGMENT BUT TO
                                ;DOS ALLOCATED SEGMENT ADDRESS
        xor dx,dx               ;clear offset register as arguement for DOS
				;now determine whether or not the quotient was 0 in which
				;case i should jump
				;to alternate location
or ax,ax
jz @@write_remainder_bytes

	@@readloop64:
	mov bx,si               ;source file handle
	mov ah,3fh              ;DOS read function
				;cx currently holds 64000
	int 21h
	jnc @@writeloop64

	@@doserror:
	stc                     ;return carry flag on error
	leave                   ;deallocate stack space
	popa
	pop ds                  ;restore saved registers
	ret                     ;exit from function

	@@writeloop64:
	mov bx,di               ;destination file handle
	mov ah,40h              ;DOS write function
				;cx currently holds 64000
	int 21h
	jc @@doserror
				;else

        push ds                 ;SAVE DOS ALLOCATED MEMORY SEGMENT
        push es
        pop ds                  ;reinitialize ds to point to this segment
                                ;for memory reference and call to function
                                ;below
        add [dword ds:sbCommandline],64000      ;maintain number of bytes
                                                ;processed
        call func_update_process                ;summon the process indicator
        pop ds                  ;RESTORE DS TO ADDRESS DOS ALLOCATED MEMORY

        dec [word ss:bp -2]     ;optimized loop
	jnz @@readloop64


	@@write_remainder_bytes:
	xor ecx,ecx		;for addition of double word to sbCommandline
				;below
        mov cx,[word ss:bp -4]  ;get remaining bytes of remainder
	mov bx,si               ;source file handle
	mov ah,3fh              ;DOS read function
	int 21h
	jc @@doserror
				;else

	mov bx,di               ;destination file handle
	mov ah,40h              ;DOS write file function
	int 21h
	jc @@doserror
        				;else assume we are done

        push ds                 ;SAVE DOS ALLOCATED MEMORY SEGMENT
        push es
        pop ds                  ;reinitialize ds to address this segment
                                ;for memory reference and call to function
                                ;below
        add [dword ds:sbCommandline],ecx        ;maintain number of bytes
                                                ;processed
        call func_update_process                ;summon the process indicator
        pop ds                  ;RESTORE DS TO ADDRESS DOS ALLOCATED MEMORY

        mov ah,3eh              ;DOS close file function
	int 21h

leave                           ;deallocate stack variables
popa                            ;restore pushed registers
pop ds
clc                             ;return carry flag cleared
ret


;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
;name:           func_write_defragment_file
;description:    this function is pretty simple. It just reads the source file
;                and writes it to the destination until the file is complete,
;                that is empty.it will also update the dwFile_size used to
;                record total number of bytes.
;input           si= handle of source file
;                di= handle of destination file
;output          carry flag holds status set on error
;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
func_write_defragment_file:
push ds                         ;save affected registers
pusha

;display screen source filename
push ax
push dx
push si
mov dl,[byte ds:sbCommandline +7]
mov dh,[byte ds:sbCommandline +8]
mov ah,07h                      ;attribute
mov si,offset sbFilenames
add si,13
call func_writestr
pop si
pop dx
pop ax


				;just loop reading from the file and writing to
				;the destination until the read file returns ax < cx
xor ecx,ecx                     ;clear out
mov cx,64000                    ;amount to read each time
push [word ds:wdSegmentaddress]
pop ds                          ;initialize ds:dx to buffer (allocated through DOS)
                                ;DS NO LONGER POINTS TO THIS SEGMENT REMEMBER
                                ;THIS FOR ALL ACCESSES
xor dx,dx                       ;clear offset location serving as buffer

	@@readloop:
	mov bx,si               ;initialize source file handle
	mov ah,3fh              ;DOS function--read from file
				;cx holds number of bytes
				;ds:dx points to initialized buffer
	int 21h
	jnc @@writeloop
				;else

	@@doserror:
	stc                     ;return carry flag set
	popa
	pop ds
	ret

	@@writeloop:
	cmp ax,cx               ;did DOS read the number of bytes i specified?
	jb @@finalwrite
				;else continue
        add [dword es:dwFilesize],64000 ;maintain total of bytes read
                                ;ES instead of DS since DS now points to allo-
                                ;cated memory        
	mov bx,di               ;initialize destination file handle
	mov ah,40h              ;DOS write to file
				;cx holds number of bytes
				;ds:dx points to initialized buffer
	int 21h
	jc @@doserror
				;else loop
	jmp @@readloop


	@@finalwrite:
	xchg cx,ax              ;place into cx number of bytes actually read from file
        add [dword es:dwFilesize],ecx    ;maintain total of bytes read
                                ;ES instead of DS since DS now points to allo-
                                ;cated memory
	mov ah,40h              ;DOS write file
        mov bx,di               ;initialize destination file handle
	int 21h
	jc @@doserror
				;else lets get out of here

	mov ah,3eh              ;DOS function--close file function
        mov bx,si               ;close source file
        int 21h
				;now check to see if the user had passed the
				;-r (remove source file) options in commandline        
        test [es:byOperationbits],04h   ;is this bit set, did the user wish to
                                        ;delete source filenames?
        jz @@exit               ;ES not DS since DS now points to allocated
                                ;memory
				;else
        push es
        pop ds                  ;DS must reference this segment since offset
                                ;will be taken from there besides ds:dx must
                                ;match for dos function call below
        mov dx,offset sbFilenames
	add dx,13               ;reference string
	mov ah,41h              ;DOS function--delete file
	int 21h                 ;ignore any error code
				;slide down to code below

@@exit:
clc                             ;return carry flag cleared
popa
pop ds
ret


;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''        
;name:          func_update_process
;description:   this subroutine updates the screen as a file is written. It
;               uses the formula (percentage/base)=(rate/100). the result is
;               then divide in 2 (since i can only display a maximum of 50
;               ascii bars on screen) and placed in the cx register. after
;               setting the appropriate addresses func_writecharcx then handles
;               the rest
;inputs:        none--internally uses dword at offset 0 of sbCommandline 
;               which represents the sume of bytes transfered. This particular
;               subroutine will be called by the func_write_fragmentfile.               
;outputs:       on screen
;note that this function should be called at the end of a SUCCESSFULE loop of
;or within func_write_fragment_file.
;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
func_update_process:
pusha

mov eax,[dword ds:sbCommandline]        ;get accumulation of total number of
                                        ;bytes processed
mov ecx,100                     ;multiplicand
mul ecx                         ;product in edx:eax

mov ecx,[ds:dwFilesize]         ;get divisor
div ecx                         ;quotient in eax , remainder in edx
or eax,eax                      ;is the quotient 0?
jz @@end
                                ;else proceed to code below
                                ;becuase of the formula the maximum value in
                                ;eax = 100 so i can just process ax instead
                                ;divide this value by 2 since i can display
				;only 50 ascii bars as opposed to 100
				;quotient is in ax
shr ax,1                        ;quick division by 2

	xchg cx,ax              ;place new value in ax
        mov dl,[byte ds:sbCommandline +5]  ;JUST TAKE THE VALUE AT OFFSET 5
                                           ;---DO NOT CHANGE IT!!!
        mov dh,[byte ds:sbCommandline +6]  ;row and column 
	mov ah,CHARCOLOR        ;EQU
	mov al,ASCIICHAR        ;EQU
	call func_writecharcx   ;update screen

@@end:
popa
ret


;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
;name:          func_flag_errors
;description:   this routine takes an arguement in the al register which repr-
;               sents the error string from sbErrors that i wish displayed on
;               screen. the only other parameter is in dh,dl and represents
;               the row and column where that error string is to be displayed.
;               routine works as follows -- since the strings in sbErrors are
;               null terminated strings, this routine scans through string al-1
;               times. the repne instruction should have al=0 and ah holding the
;               original al parameter (string #).the instruction scas automatically
;               increments (or decrements) di so i am assured that di will in
;               the end point to the char after the last string (null string end
;               marker).
;inputs:        al=# =>0
;               dh=row where string is to be displayed
;               dl=col where string is to be displayed
;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
func_flag_errors:
pusha

mov di,offset sbErrors
xchg ah,al                      ;place arguement in ah
xor al,al                       ;search parameter
xor cx,cx                       ;arguement to repne
dec ah                          ;adjust value of ah
cld                             ;prepare for automatic increment
or ah,ah                        ;is this 0?
jz @@display_string

	@@loop:
	repne scas [byte es:di] ;scan throughout string searching for 00h
	dec ah                  ;optimized loop
	jnz @@loop
				;at this point, di should automatically point
				;to the next char after null place di value
				;into si and call func_writestr
@@display_string:
xchg si,di
mov ah,0fh                      ;attribute
mov dh,[ds:byCurrentrow]
inc dh
inc [ds:byCurrentrow]           ;reset to next address
call func_writestr              ;display null terminated error string.

popa
ret


;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
;name:          func_display_options
;description:   this is relatively simple, i just needed a method to quickly
;               display the null terminated strings that represent program
;               options in a more independent manner, so i decided to encaps
;               ulate this into a function.
;inputs:        none
;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
func_display_options:
pusha

mov di,offset sbOptions
mov bh,4                        ;number of options -1 for loop
mov ah,0fh                      ;attribute for display
xor al,al                       ;search parameter
xor dx,dx
cld
	@@loop:
	mov si,di               ;as arguement to function call below
	mov dh,[ds:byCurrentrow]        ;initialize row address
	inc dh
	inc [ds:byCurrentrow]   ;reset for next call
	call func_writestr

	mov cx,100              ;arguement to repnz 100 is just a random
				;chosen in order for repnz to execute the loop
        repnz scas [byte es:di] ;scas autoincrement should automatically point
				;at the char to be displayed
	dec bh                  ;optimized loop
	jnz @@loop

popa
ret


;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
;name:          func_display_source_dest_frag
;description:   this subroutine is not really needed but was written to make
;               the source code readable. subroutine simply displays the
;               strings "source file(s) =" and "destination file(s) ="
;               routine also displays the files at sbFilename and sbFilename +13
;               CALLED FOR FORMATTING OF OUTPUT IN FRAGMENT MODE.
;input:         none
;output:        none
;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
func_display_source_dest_frag:
push ax
push dx
push si

xor dl,dl                               ;
mov dh,[ds:byCurrentrow]
add [ds:byCurrentrow],7                 ;reposition
add dh,3                                ;adjust address

;save addresses for calling routines that need them
mov [byte ds:sbCommandline +7],24
mov [byte ds:sbCommandline +8],dh
mov [byte ds:sbCommandline +9],24
mov [byte ds:sbCommandline +10],dh
add [byte ds:sbCommandline +10],2

;display source string and destination string
mov ah,0fh                              ;attribute    
mov si,offset sbSource
call func_writestr
add dh,2                                ;next row
mov si,offset sbDestination
call func_writestr

;display actual strings
mov ah,07h                              ;attribute
add dl,24
mov si,offset sbFilenames
add si,13                               ;display destination "filename"
call func_writestr
sub dh,2                                ;above row
sub si,13
call func_writestr                      ;display source "filename"

pop si
pop dx
pop ax
ret


;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
;name:          func_display_source_dest_defrag
;description:   this subroutine is not really needed but was written to make
;               the source code readable. subroutine simply displays the
;               strings "source file(s) =" and "destination file(s) ="
;               routine also displays the files at sbFilename and sbFilename +13
;               CALLED FOR FORMATTING OF OUTPUT IN DEFRAGMENT MODE.
;input:         none
;output:        none
;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
func_display_source_dest_defrag:
push ax
push dx
push si

xor dl,dl                               ;
mov dh,[ds:byCurrentrow]
add [ds:byCurrentrow],7                 ;reposition
add dh,3                                ;adjust address

;save addresses for calling routines that need them
mov [byte ds:sbCommandline +7],24
mov [byte ds:sbCommandline +8],dh
mov [byte ds:sbCommandline +9],24
mov [byte ds:sbCommandline +10],dh
add [byte ds:sbCommandline +10],2

;display source string and destination string
mov ah,0fh                              ;attribute    
mov si,offset sbSource
call func_writestr
add dh,2                                ;next row
mov si,offset sbDestination
call func_writestr

;display actual strings
mov ah,07h                              ;attribute
add dl,24
mov si,offset sbFilenames               ;display source "filename"
call func_writestr
sub dh,2                                ;above row
add si,13
call func_writestr                      ;display destination "filename"

pop si
pop dx
pop ax
ret

;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
program_end:                    ;marker for help in calculating memory allocatation
ENDS    FRAGMENT
END     main


;SAMUEL IGWE
;20 WEST MOSHOLU PARKWAY SOUTH
;BRONX NY 10468

;SAMIGWE@worldnet.att.net

