*	C_Simple(C)  Ver C1.2	 RiverSide Software Corp (204)477-4235
*	ST. VITAL PO BOX 345  WINNIPEG  MANITOBA  CANADA  R2M 3C5
*		CLIPPER (R) EXTENDED Version Summer 87 
*
*       Program Name :          WORKMAKE.PRG
*       CopyRight (C): Teacher's Choice Productions
*       Author       : Bill Buckels
*                    :
*       Date         : August 8, 1991
*       Project      : WORKVGA(C) version 1
*       Comments     : rewrite of WORKBOOK for the MCGA and
*                    : revised Script format to DBASE III
*                    :
*	Co-Pilot     :		Leslie E. Gros 


	*******************************************************

*	Inquiry Functions supplied in C_Simple.Lib

EXTERNAL INQ_CHAR
EXTERNAL INQ_NUM
EXTERNAL INQ_DATE
EXTERNAL INQ_LOGIC
EXTERNAL INQ_COUNT

	*******************************************************

SET PROCEDURE TO WORKMAKE

	SET DELETED   ON
	SET SAFETY    OFF
	SET EXACT     OFF
	SET TALK      OFF
	SET SOFTSEEK  ON
	SET EXCLUSIVE ON
	
*	Declare Program Variables at top Level for Global Visibility

	OK = .T.		&&	Global Confirm Variable
	INQ_FILTER = SPACE(0)	&&	Inquirey Variable
	WORK_FLTR  = SPACE(0)	&&	Inquirey Variable
	MAIN_SEL   = SPACE(0)	&&	Global Menu Variable
	WORK_DFLAG = .F.	&&	Delete Flag

        WORKMAKE_1 = SPACE(0)   &&      Variable for Field 1  IMAGENAME
        WORKMAKE_2 = SPACE(0)   &&      Variable for Field 2  CAPTION
        WORKMAKE_3 = SPACE(0)   &&      Variable for Field 3  SECONDS
        WORKMAKE_4 = SPACE(0)   &&      Variable for Field 4  SOUNDFILE


	*******************************************************

	DO WORK_SCRN		&&	Display to Screen
	SELECT 1		&&	Programmer SELECT Area
	DO WORK_FILE		&&	Open dbf and indexes
	DO WORK_MAIN		&&	Program Main Body
        SELECT WORKMAKE         &&      Recall by Alias
	DO WORK_PACK		&&	Check for Deleted Records
	USE			&&	Close the Database File
	CLOSE PROCEDURE		&&	Logical End of Module.

	*******************************************************

PROCEDURE WORK_MAIN		&&	 Main Body
	
	WORK_DONE = .F.		&&	Local Flag variable

	DO WHILE .NOT. WORK_DONE

	*	Update ScoreBoard Header
		IF .NOT. EMPTY(WORK_FLTR)
			@ 00,35 SAY "<*QUERY*>"
		ELSE
			@ 00,35 SAY "         "
		ENDIF
		IF DELETED()
			@ 00,50 SAY "<*DELETED*>"
		ELSE
			@ 00,50 SAY "           "
		ENDIF
	
	*	Update Display Information
		DO WORK_VIN	&&	Swap Var IN from dbf
		DO WORK_GET	&&	See Next Line
		CLEAR GETS	&&	Display data inverse on screen
	*	DO WORK_SAY 

	*	Select operation from Menu Bar
		@ 23,00 CLEAR
		SET MESSAGE to 24 CENTER
                @23,00  PROMPT  " Quit "        MESSAGE "Quit WORKMAKE(C)"
		@23,06	PROMPT	" Add "		MESSAGE	"Add a New Record"
		@23,11	PROMPT	" Edit "	MESSAGE	"Edit this Record"
		@23,17	PROMPT	" Delete "	MESSAGE	"Delete this Record"
		@23,25	PROMPT	" Top "		MESSAGE	"Go to First Record"
		@23,30	PROMPT	" Next "	MESSAGE	"Next Record in File"
		@23,36	PROMPT	" Back "	MESSAGE	"Back Up one Record"
		@23,42	PROMPT	" Last "	MESSAGE	"Go to Last Record"
		@23,48	PROMPT	" Seek "	MESSAGE	"Get Record by Index"
		@23,54	PROMPT	" Inquire "	MESSAGE	"Query the database"
		@23,63	PROMPT	" Utility "	MESSAGE	"Utilities Menu"

		MENU TO MENU_SEL

		DO CASE

			CASE MENU_SEL = 1
				WORK_DONE = .T.
				LOOP

			CASE MENU_SEL = 2
				DO WORK_ADD

			CASE MENU_SEL = 3
				DO WORK_EDIT

			CASE MENU_SEL = 4
				DO WORK_DEL

			CASE MENU_SEL = 5
				DO TOP

			CASE MENU_SEL = 6
				DO NEXT

			CASE MENU_SEL = 7
				DO BACK

			CASE MENU_SEL = 8
				DO LAST

			CASE MENU_SEL = 9
				DO WORK_SEEK

			CASE MENU_SEL = 10
				DO WORK_INQU

*
			CASE MENU_SEL = 11
				DO WORK_UTIL


		ENDCASE
	ENDDO
	

	*******************************************************

PROCEDURE WORK_FILE		&& check files exist

        IF .NOT. FILE ("WORKMAKE.DBF")
		DO PAUSE WITH "Warning The DBF File is MISSING "
		DO CONFIRM WITH "Create New Database Shell " 
		IF OK
			DO WORK_CREA
		ELSE
			DO PAUSE WITH "Press Return to Quit"
		ENDIF
	ENDIF
	
        USE WORKMAKE.DBF
        IF .NOT. FILE ("WORKMAKE.NTX")
		DO WORK_NTX
	ENDIF
	
        SET INDEX TO WORKMAKE.NTX
	

	*******************************************************

PROCEDURE WORK_CREA		&& create dbf

	CREATE TEMP
	USE    TEMP

	APPEND BLANK
	REPLACE FIELD_NAME WITH "IMAGENAME"
	REPLACE FIELD_TYPE WITH "C"
	REPLACE FIELD_LEN  WITH 12
	REPLACE FIELD_DEC  WITH 0
	APPEND BLANK
	REPLACE FIELD_NAME WITH "CAPTION"
	REPLACE FIELD_TYPE WITH "C"
	REPLACE FIELD_LEN  WITH 40
	REPLACE FIELD_DEC  WITH 0
	APPEND BLANK
	REPLACE FIELD_NAME WITH "SECONDS"
	REPLACE FIELD_TYPE WITH "C"
	REPLACE FIELD_LEN  WITH 2
	REPLACE FIELD_DEC  WITH 0
	APPEND BLANK
	REPLACE FIELD_NAME WITH "SOUNDFILE"
	REPLACE FIELD_TYPE WITH "C"
	REPLACE FIELD_LEN  WITH 12
	REPLACE FIELD_DEC  WITH 0
	COMMIT
	USE

        CREATE WORKMAKE.DBF FROM TEMP.DBF
	ERASE TEMP.DBF


	*******************************************************

PROCEDURE WORK_NTX		&& Re-Index routine

	@ 24,00 CLEAR
	@ 24,35 SAY "RE-INDEXING"
        INDEX ON UPPER(WORKMAKE->IMAGENAME) TO WORKMAKE.NTX
	@ 24,00 CLEAR

	*******************************************************

PROCEDURE WORK_PACK		&& Pack if Required

	IF WORK_DFLAG		&& Delete Flag
		@ 23,00 CLEAR
		@ 24,30 SAY "Packing Deleted Records"
		PACK
		@ 23,00 CLEAR
	ENDIF

	*******************************************************

PROCEDURE WORK_SCRN		&& Screen Shell

        DO COLOURS WITH "bg+/b,w+/n"
	CLEAR
	@ 01,00 TO 22,79 DOUBLE
        @ 00,05 SAY "WORKMAKE(C) by Bill Buckels"
	@  2, 1 SAY "IMAGENAME   :"
	@  3, 1 SAY "CAPTION     :"
	@  4, 1 SAY "SECONDS     :"
	@  5, 1 SAY "SOUNDFILE   :"

	*******************************************************

PROCEDURE WORK_ADD		&& Add New Record

	DO WORK_BLNK
	DO WORK_GET
	READ
	DO CONFIRM WITH "Confirm to Save New Record "
	IF OK
		APPEND BLANK
*		Request Locking on this Record
		IF .NOT. LOCK()
			DO PAUSE WITH "Appended Record is Locked"
		ELSE
			DO WORK_VOUT
			UNLOCK
		ENDIF
	ENDIF

	*******************************************************

PROCEDURE WORK_EDIT		&& Edit Record

*	Request Locking on this Record
	IF .NOT. LOCK()
		DO PAUSE WITH "Record is Locked by Other User"
		RETURN
	ENDIF

	DO WORK_VIN
	DO WORK_GET
	READ
	DO CONFIRM WITH "Confirm to Save Changes "
	IF OK
		DO WORK_VOUT
	ENDIF
	UNLOCK

	*******************************************************

PROCEDURE WORK_DEL		&& Delete Record


*	Request Locking on this Record
	IF .NOT. LOCK()
		DO PAUSE WITH "Record is Locked by Other User"
		RETURN
	ENDIF

	DO CONFIRM WITH "CONFIRM TO DELETE RECORD "
	IF OK
		DELETE
		WORK_DFLAG = .T.	&&	Delete Flag
		DO BACK
	ENDIF
	UNLOCK

	*******************************************************

PROCEDURE WORK_SEEK		&& Index Find Routine
	DO WORK_BLNK
*		DO WORK_GET	&&	See Next Line
*		CLEAR GETS	&&	Display data inverse on screen
		DO WORK_SAY 
        @  2,15 GET WORKMAKE_1  PICTURE "@S20"
	READ
        SEEK UPPER(WORKMAKE_1)
	IF .NOT. FOUND()
		DO PAUSE WITH "Exact Match NOT Found"
	ENDIF
	

	*******************************************************

PROCEDURE WORK_INQU		&& Inquirey Module

	@ 23,00 CLEAR
	DUMMY = ""
	MENU_SEL = 1
	SET MESSAGE to 24 CENTER	&& message at line 24
	@ 23,00 CLEAR
	@ 23,01 PROMPT " Exit "		;
		MESSAGE "Exit with NO Change"
	@ 23,08 PROMPT " Reset "	;
		MESSAGE "Clear Query "
	@ 23,16 PROMPT " Query "	;
		MESSAGE "Query DataBase to Display and Selective Export"
	@ 23,24 PROMPT " Count "	;
		MESSAGE "Count the Number of Active Records "
	MENU TO MENU_SEL
	DO CASE
		CASE	MENU_SEL = 2
			INQ_FILTER = ""
			WORK_FLTR = SPACE(0)
			SET FILTER TO &WORK_FLTR

		CASE	MENU_SEL= 3
			INQ_FILTER = ""
			DO WORK_BLNK
			DO WORK_IGET
			WORK_FLTR = INQ_FILTER
			SET FILTER TO &WORK_FLTR
			DO TOP

		CASE	MENU_SEL = 4
			DO INQ_COUNT
	ENDCASE
	MENU_SEL = 10
	RETURN


	*******************************************************

PROCEDURE WORK_IGET	&& Set a Filter Condition

*	INQ_ CHAR NUM DATE LOGIC are provided in C_SIMPLE.LIB
*	Link  your_prog.obj c_simple.lib clipper.lib extend.lib
*	These functions build a string that is used by FILTER
*		First  Parameter is the Variable Value
*		Second parameter is the DBF Field Name
*
*	IMAGENAME
        @  2,15 GET WORKMAKE_1  PICTURE "@KS20" ;
                VALID INQ_CHAR (WORKMAKE_1,"IMAGENAME")

*	CAPTION
        @  3,15 GET WORKMAKE_2  PICTURE "@KS20" ;
                VALID INQ_CHAR (WORKMAKE_2,"CAPTION")

*	SECONDS
        @  4,15 GET WORKMAKE_3  PICTURE "@KS20" ;
                VALID INQ_CHAR (WORKMAKE_3,"SECONDS")

*	SOUNDFILE
        @  5,15 GET WORKMAKE_4  PICTURE "@KS20" ;
                VALID INQ_CHAR (WORKMAKE_4,"SOUNDFILE")

	READ


	*******************************************************

PROCEDURE WORK_UTIL		&& Utility routines

	MENU_SEL = 1
	UT_NAME = SPACE(13)
	@ 23,00 CLEAR
	SET MESSAGE TO 24 CENTER
	@ 23,01	PROMPT	" Main Menu "	MESSAGE	"Return to Main Menu"
        @ 23,13 PROMPT  " Dos "         MESSAGE "Dos Services"
	@ 23,19	PROMPT	" Import "	MESSAGE	"Import Ascii Delimited File"
	@ 23,28	PROMPT	" Export "	MESSAGE	"Export Ascii Delimited File"
	@ 23,37	PROMPT	" SDF in "	MESSAGE	"Import Ascii SDF Files"
	@ 23,46	PROMPT	" Out sdf "	MESSAGE	"Export Ascii SDF File"
	@ 23,56	PROMPT	" Merge ";
		MESSAGE	"Export Mail Merge Header and Ascii Data"
	@ 23,64 PROMPT " Report ";
		MESSAGE	"Print Report to Printer (Query or All)"
	@ 23,72 PROMPT " Labels ";
		MESSAGE	"Print Labels on Printer (Query or All)"
		MENU TO  MENU_SEL

	DO CASE

		CASE MENU_SEL = 1

			* Do Nothing Exit

		CASE MENU_SEL = 2

			Do SERVICE
			DO WORK_SCRN

		CASE MENU_SEL = 3

			DO EXTN_NAME WITH UT_NAME
			DO CONFIRM WITH "CONFIRM TO APPEND FROM " + UT_NAME
			IF OK
				APPEND FROM &UT_NAME DELIMITED
			ENDIF

		CASE MENU_SEL = 4

			DO EXTN_NAME WITH UT_NAME
			DO CONFIRM WITH "CONFIRM TO EXPORT TO " + UT_NAME
			IF OK
				COPY TO &UT_NAME DELIMITED
				GO TOP
			ENDIF

		CASE MENU_SEL = 5

			DO EXTN_NAME WITH UT_NAME
			DO CONFIRM WITH "CONFIRM SDF APPEND FROM " + UT_NAME
			IF OK
				APPEND FROM &UT_NAME SDF
			ENDIF

		CASE MENU_SEL = 6

			DO EXTN_NAME WITH UT_NAME
			DO CONFIRM WITH "CONFIRM SDF EXPORT TO " + UT_NAME
			IF OK
				COPY TO &UT_NAME SDF
				GO TOP
			ENDIF

		CASE MENU_SEL = 7

			UT_NAME = SPACE(8)
			DO EXTN_NAME WITH UT_NAME
			COPY TO &UT_NAME DELIMITED
			UT_NAME = TRIM(UT_NAME) + ".DAT"
			SET ALTERNATE TO &UT_NAME
			SET CONSOLE OFF
			SET ALTERNATE ON
				?? TRIM("IMAGENAME   ") + ","
				?? TRIM("CAPTION     ") + ","
				?? TRIM("SECONDS     ") + ","
				?? TRIM("SOUNDFILE   ")
			SET ALTERNATE OFF
			CLOSE ALTERNATE
			SET CONSOLE ON
			GO TOP

		CASE MENU_SEL = 8
                        DO REPORTS WITH "WORKMAKE.FRM"  && Report.Frm

		CASE MENU_SEL = 9
                        DO LABELS  WITH "WORKMAKE.LBL"  && Label.Lbl

	ENDCASE
	MENU_SEL = 11
	RETURN


	*******************************************************

PROCEDURE WORK_GET		&& Keyboard to Variables

*	Validation Functions are written at bottom of this source code.
*		Modify them to your application needs.
*	
*	IMAGENAME
        @  2,15 GET WORKMAKE_1  PICTURE "@KS20" ;
                VALID VWORK_1   (WORKMAKE_1)

*	CAPTION
        @  3,15 GET WORKMAKE_2  PICTURE "@KS20" ;
                VALID VWORK_2   (WORKMAKE_2)

*	SECONDS
        @  4,15 GET WORKMAKE_3  PICTURE "@KS20" ;
                VALID VWORK_3   (WORKMAKE_3)

*	SOUNDFILE
        @  5,15 GET WORKMAKE_4  PICTURE "@KS20" ;
                VALID VWORK_4   (WORKMAKE_4)


	*******************************************************

PROCEDURE WORK_SAY		&& Variables to Screen

        @  2,15 SAY WORKMAKE_1  PICTURE "@S20"
        @  3,15 SAY WORKMAKE_2  PICTURE "@S20"
        @  4,15 SAY WORKMAKE_3  PICTURE "@S20"
        @  5,15 SAY WORKMAKE_4  PICTURE "@S20"

	*******************************************************

PROCEDURE WORK_BLNK		&& Blanks to Variables

        WORKMAKE_1   =   SPACE(12)      && Character Field
        WORKMAKE_2   =   SPACE(40)      && Character Field
        WORKMAKE_3   =   SPACE(2 )      && Character Field
        WORKMAKE_4   =   SPACE(12)      && Character Field

	*******************************************************

PROCEDURE WORK_VIN		&& Variables IN from dbf
*				Memo Fields are Not effected

        WORKMAKE_1   =   WORKMAKE->IMAGENAME
        WORKMAKE_2   =   WORKMAKE->CAPTION
        WORKMAKE_3   =   WORKMAKE->SECONDS
        WORKMAKE_4   =   WORKMAKE->SOUNDFILE

	*******************************************************

PROCEDURE WORK_VOUT		&& Variables OUT to dbf
*				Memo Fields are Not effected

        REPLACE WORKMAKE->IMAGENAME   WITH WORKMAKE_1
        REPLACE WORKMAKE->CAPTION     WITH WORKMAKE_2
        REPLACE WORKMAKE->SECONDS     WITH WORKMAKE_3
        REPLACE WORKMAKE->SOUNDFILE   WITH WORKMAKE_4
	COMMIT

	*******************************************************

*
*		The  Following  Routines are  Generic
*		And common to Multi-database programs
*

	*******************************************************

PROCEDURE TOP		&& Top of File

	@ 23,00 CLEAR
	@ 23,35 SAY "SEARCHING"
	GOTO TOP

	*******************************************************

PROCEDURE NEXT		&& Next Record

	IF RECCOUNT() = 0
		DO PAUSE WITH "DataBase is Empty"
		RETURN
	ENDIF
	
	@ 23,00 CLEAR
	@ 23,35 SAY "SEARCHING"
	IF EOF()
		SKIP -1
	ENDIF
	SKIP
	IF EOF()
		@ 24,00 CLEAR
		DO PAUSE WITH "Last Record  / Press Return"
		@ 24,00 CLEAR
		GOTO BOTTOM
	ENDIF

	*******************************************************

PROCEDURE BACK		&& Prior Record

	@ 23,00 CLEAR
	@ 23,35 SAY "SEARCHING"
	IF BOF()
		@ 24,00 CLEAR
		DO PAUSE WITH "First Record  / Press Return"
		@ 24,00 CLEAR
		GOTO TOP
	ELSE
		SKIP -1
	ENDIF

	*******************************************************

PROCEDURE LAST		&& Last Record in File

	@ 23,00 CLEAR
	@ 23,35 SAY "SEARCHING"
	GOTO BOTTOM

	*******************************************************

PROCEDURE PAUSE		&& Support Routine
PARAMETER MESSAGE

	IF LEN(MESSAGE) = 0
		 MESSAGE = "Press Enter to Continue"
	ENDIF
	STR_DUMMY = LEN(MESSAGE)
	STR_DUMMY = ((80 - (STR_DUMMY)) / 2)
	@ 24,00
	?? CHR(7)
	@ 24,00 CLEAR
	@ 23,79
	WAIT (SPACE(STR_DUMMY) + MESSAGE)
	@ 24,00 CLEAR

	*******************************************************

PROCEDURE CONFIRM		&& Support Routine
PARAMETER CON_MESSAGE

	IF LEN(CON_MESSAGE) = 0
		CON_MESSAGE = "Please Confirm "
	ENDIF
	STR_DUMMY = LEN(CON_MESSAGE)
	STR_DUMMY = ((80 - (STR_DUMMY)) / 2)
	@ 24,00
	?? CHR(7)
	@ 24,00 CLEAR
	@ 24,STR_DUMMY SAY CON_MESSAGE GET OK PICTURE "@L"
	READ

	*******************************************************

PROCEDURE SERVICE		&& Dos Service

	OK = .T.
	DO WHILE OK
		CLEAR
		M_COMMAND = SPACE(60)
		@ 0, 0 SAY "Simple Dos Service    Type EXIT to return"
		@ 2,1 GET M_COMMAND
		READ
		IF "EXIT"$(UPPER(M_COMMAND))
			OK = .F.
		ELSE
			! &M_COMMAND
		DO PAUSE WITH "Press Return to Continue "
		ENDIF
	ENDDO

	*******************************************************

PROCEDURE EXTN_NAME		&& External Name
PARAMETER UT_NAME

	@ 24,00 CLEAR
	@ 24,30 SAY "FILE NAME => " GET UT_NAME	PICTURE "!!!!!!!!!!!!"
	READ
	IF "" = TRIM(UT_NAME)
		UT_NAME = "NONAME"
	ENDIF


	*******************************************************

PROCEDURE REPORTS		&& Report Module
PARAMETER REPORT_FRM

	IF .NOT. FILE (REPORT_FRM)
		DO PAUSE WITH "REPORT FILE " + REPORT_FRM + " NOT FOUND"
	ELSE
		IF PRINTER_READY()
			SET CONSOLE OFF
			REPORT FORM &REPORT_FRM TO PRINT
			SET CONSOLE ON
			DO TOP
		ENDIF
	ENDIF

	*******************************************************

PROCEDURE LABELS		&& Labels Module
PARAMETER LABEL_LBL

	IF .NOT. FILE (LABEL_LBL)
		DO PAUSE WITH "LABEL FILE " + LABEL_LBL + " NOT FOUND"
	ELSE
		IF PRINTER_READY()
			SET CONSOLE OFF
			LABEL FORM &LABEL_LBL SAMPLE TO PRINT
			SET CONSOLE ON
			DO TOP
		ENDIF
	ENDIF

	*******************************************************

PROCEDURE COLOURS		&& Set Screen Colour
PARAMETER THE_COLOUR

	IF ISCOLOUR()
		SET COLOR TO &THE_COLOUR
	ENDIF


*	=======================================================
*
*			USER FUNCTIONS LISTED BELOW
*	User Defined Functions are difrent than Procedures.
*		A Function must have a return value.

	*******************************************************

FUNCTION	PRINTER_READY	&&	General Printer Ready Routine
PRIVATE		RESPONSE

	@ 24,00 CLEAR
	DO WHILE .NOT. ISPRINTER()
		@ 24,24 SAY "Printer is NOT Ready :  Retry Y/N"
		RESPONSE = INKEY(0)
		IF CHR(RESPONSE)$"Nn"
			@ 24,00 CLEAR
			RETURN (.F.)
		ENDIF
	ENDDO
	@ 24,00 CLEAR
	RETURN (.T.)	&& DEFAULT



	*******************************************************

*		Validation Functions for Gets


FUNCTION	VWORK_1  
PARAMETER       WORKMAKE_1

                IF EMPTY (WORKMAKE_1)
			DO PAUSE WITH "Field must be Filled"
			RETURN	(.F.)
		ENDIF

		RETURN	.T.


FUNCTION	VWORK_2  
PARAMETER       WORKMAKE_2

                IF EMPTY (WORKMAKE_2)
			DO PAUSE WITH "Field must be Filled"
			RETURN	(.F.)
		ENDIF

		RETURN	.T.


FUNCTION	VWORK_3  
PARAMETER       WORKMAKE_3

                IF EMPTY (WORKMAKE_3)
			DO PAUSE WITH "Field must be Filled"
			RETURN	(.F.)
		ENDIF

		RETURN	.T.


FUNCTION	VWORK_4  
PARAMETER       WORKMAKE_4

                IF EMPTY (WORKMAKE_4)
			DO PAUSE WITH "Field must be Filled"
			RETURN	(.F.)
		ENDIF

		RETURN	.T.


	*******************************************************


*               End of C_Simple program  WORKMAKE.PRG source code
