#include <stdio.h>
#include <curses.h>
#ifdef UNIX
#   include <sys/signal.h>
#endif

/* game - utilities
 *
 * by Steve Spearman
 */

/********************************************************
 *
 *  error ()
 * 
 *  Error() halts with an error message which is passed
 *  as an argument
 ********************************************************/

int
error(reason)
char reason[];
{
	move(22,0);
	clrtoeol();
	printw("Fatal Game Error - %s\n",reason);
	refresh();
	nodelay(stdscr,FALSE); 
	endwin();
	exit(1);
}

int
goodbye()
{
	move(23,0);
	refresh();
	nodelay(stdscr,FALSE); 
	endwin();
	exit(0);
}

int
sighandle()
{
	error("Unexpected signal received");
}

int
initialize()
{
	initscr();	/* initialize screen*/
	cbreak();	/* get characters in immediate mode*/
	nodelay(stdscr,TRUE); 
	noecho(); 	/* don't echo input */

#ifndef MSDOS
	if (clear()==ERR)
		error("Your terminal to too dumb");	/* clear the screen*/
	if (clrtoeol()==ERR)
		error("Your terminal to too dumb");	/* check for function*/
	if (move(23,79)==ERR)
		error("Your terminal to too small");	/* check for size*/
	signal(SIGINT,sighandle);
	signal(SIGQUIT,sighandle);
	signal(SIGILL,sighandle);
	signal(SIGBUS,sighandle);
	signal(SIGTRAP,sighandle);
	signal(SIGIOT,sighandle);
	signal(SIGEMT,sighandle);
	signal(SIGSEGV,sighandle);
	signal(SIGSYS,sighandle);
	signal(SIGTERM,sighandle);
#else
	clear();
#endif
}


int
mygetchar(c)
int *c;
{
	if (read(0,c,1) <= 0)
		return(0);
	*c &= 0177;
	return(1);
}
