10 PRINT "TEXAS SPACELINES INC.   SPACE TRANSPORTATION FOR THE REST OF US!"
20 PRINT "WEB.WT.NET/~MARKGOLL/   MARKGOLL@WT.NET"
30 PRINT "REENTRY 2.1 BY MARK GOLL 2000, SEND IMPROVEMENTS TO 1210 651 6558"
40 INPUT "WEIGHT #"; PW
50 INPUT "AREA SQ FT"; AF
60 INPUT "PROCESSOR DELAY (486-33=1)"; DL
70 INPUT "HIGH ALTITUDE (H) OR BALLISTIC (B) REENTRY TYPE"; C$
80 IF C$ = "H" THEN 160 ELSE 90
90 IF C$ = "B" THEN 100 ELSE 70
100 INPUT "SHAPE FACTOR CD"; CD
110 INPUT "DROUGE CHUTE AREA SQ FT"; DF
120 INPUT "DROUGE CHUTE DEPLOY ALTITUDE FT"; DA
130 INPUT "MAIN CHUTE AREA SQ FT"; MF
140 INPUT "MAIN CHUTE DEPLOY ALTITUDE FT"; MA
150 GOTO 180
160 AN = 45
170 INPUT "DRAG DEVICE AREA SQ FT"; DDA
180 REM MODEL ATMOSPHERE DATA
190 DATA 2.381E-3,2.30E-3,2.25E-3,2.175E-3,2.125E-3,2.06E-3,2.0E-3,1.93E-3,1.88E-3,1.82E-3
200 DATA 1.744E-3,1.25E-3,8.797E-4,6.021E-4,3.837E-4,2.364E-4,8.861E-5
210 DATA 5.353E-5,3.294E-5,2.062E-5,1.312E-5,8.472E-6,5.565E-6,3.781E-6
220 DATA 2.569E-6,1.747E-6,1.188E-6,8.795E-7,5.777E-7,3.999E-7,2.711E-7
230 DATA 1.797E-7,1.160E-7,7.273E-8,4.159E-8
240 DATA 2.312E-8,1.344E-8,8.189E-9,5.213E-9,3.456E-9,2.381E-9,1.679E-9
250 DATA 1.148E-9,7.938E-10,5.553E-10,3.926E-10,2.804E-10,2.022E-10
260 DATA 1.471E-10,1.079E-10,7.785E-11,5.953E-11,4.471E-11,3.381E-11
270 DATA 2.574E-11,1.972E-11,1.520E-11,1.179E-11,9.180E-12,8.000E-12
280 DATA 7.0E-12,6.0E-12,5.0E-12,4.0E-12,3.0E-12,2.0E-12,1.0E-12,5.0E-13,1.0E-14,0
290 REM DIMENSION ATMOSPHERE DATA
300 DIM A(10), B(60)
310 FOR X = 0 TO 9
320 READ A(X)
330 NEXT X
340 FOR X = 0 TO 59
350 READ B(X)
360 NEXT X
370 REM FREE SPACE!
380 REM MERCURY CAPSULE; WEIGHT 2460# AREA 30.17SQFT CD 0.8, DROUGE 31? @ 21000 FT MAIN 3115 @ 9800 FT
390 TC = O: HV = 25610: VV = 0: VD = 0: HD = 0: DR = 0: AL = 600000!: VA = 0: HA = 0: HT = 0: OV = 25610: RA = 0: HD = 0
400 REM STOP/CONT
410 CLS
420 PRINT "CHANGE VARIABLES OR CONT"
430 STOP
440 REM MAIN PROGRAM  *************************
450 REM GO TO DISPLAY TO SET UP SCREEN
460 GOSUB 760
470 INPUT "REENTER Y-N ?  A=ABORT S=S TURN"; B$
480 IF B$ = "Y" THEN 500
490 IF B$ = "N" THEN 430 ELSE 470
500 HV = HV - 500
510 REM GO TO ATMOSPHERE SUBROUTINE ******
520 GOSUB 1310
530 IF C$ = "H" THEN 540 ELSE 570
540 REM HIGH ALTITUDE DRAG AND LIFT *****
550 GOSUB 1530
560 GOTO 640
570 REM BALLISTIC DRAG ****
580 CH = AF * CD
590 CV = AF * CD
600 REM CHUTE DEPLOY***
610 IF AL < DA THEN GOSUB 1770
620 IF AL < MA THEN GOSUB 1810
630 GOSUB 1430
640 REM GO TO FORCES SUBROUTINE **********
650 GOSUB 1150
660 IF INKEY$ = "S" THEN 670 ELSE 680
670 VV = VV - 200
680 REM USE DISPLAY SUB TO INSERT NUMBERS*
690 GOSUB 760
700 REM TIME DELAY LOOP
710 FOR X = 0 TO DL
720 Y = 1 / 10
730 NEXT X
740 IF INKEY$ = "A" THEN 400 ELSE 510
750 END
760 REM DISPLAY SUBROUTINE ***************
770 SCREEN 2
780 DK = INT(SQR((DVH * DVH) + (DH * DH)))
790 TA = INT(SQR((VA * VA) + (HA * HA)))
800 VK = INT(SQR((VV * VV) + (HV * HV)))
810 LOCATE 8, 15: PRINT , TC
820 LOCATE 8, 1: PRINT , "TIME/10S"
830 LOCATE 9, 15: PRINT , INT(HD)
840 LOCATE 9, 1: PRINT , "RANGE MI"
850 LOCATE 10, 15: PRINT , INT(AL)
860 LOCATE 10, 1: PRINT , "ALTITUDE"
870 LOCATE 11, 15: PRINT , INT(VV)
880 LOCATE 11, 1: PRINT , "VERT VEL"
890 LOCATE 12, 15: PRINT , VK
900 LOCATE 12, 1: PRINT , "VELOCITY"
910 LOCATE 13, 15: PRINT , DK
920 LOCATE 13, 1: PRINT , "DRAG"
930 LOCATE 14, 15: PRINT , TA
940 LOCATE 14, 1: PRINT , "ACCEL"
950 LOCATE 15, 15: PRINT , INT(HT)
960 LOCATE 15, 1: PRINT , "HT?/SQFT"
970 REM LINE DRAWING OF ANGLE OF ATTACK AND VELOCITY VECTOR
980 LOCATE 20, 1
990 PRINT "TOP DISPLAY IS ANGLE OF ATTACK, BOTTOM IS VELOCITY VECTOR"
1000 IF C$ = "B" THEN 1060
1010 XA = INT(100 * CO)
1020 YA = (INT(SQR(10000 - (XA * XA)))) * .33
1030 X = 500 - XA
1040 Y = 50 - YA
1050 LINE (500, 50)-(X, Y), 1
1060 IF VK <= 0 THEN 1130
1070 IF AL <= 0 THEN 1130
1080 XB = INT(100 * (INT(HV) / VK))
1090 YB = INT((SQR(10000 - (XB * XB))) * .43) * SGN(VV)
1100 X = 500 - XB
1110 Y = 120 - YB
1120 LINE (500, 120)-(X, Y), 2
1130 RETURN
1140 REM ORBIT = 25610 FT/SEC AT 600K FT ALTITUDE
1150 REM FORCES SUBROUTINE ******
1160 VA = ((-1 * DV) / (PW / 32)) - 32
1170 HA = (-1 * DH) / (PW / 32)
1180 VV = VV + ((VA * .1) + ((HV / OV) * 3.2))
1190 HV = HV + (HA * .1)
1200 IF HV < 0 THEN HV = 0
1210 RA = RA + (HV * .1)
1220 HD = RA / 5280
1230 AL = AL + (VV * .1)
1240 TC = TC + 1
1250 REM VEHICLE TOUCHDOWN
1260 IF AL < 0 THEN 1270 ELSE 1300
1270 LOCATE 18, 1
1280 PRINT , "TOUCHDOWN"
1290 GOTO 430
1300 RETURN
1310 REM ATMOSPHERE SUBROUTINE *****
1320 AK = INT(AL / 1000)
1330 AT = INT(AL / 10000)
1340 IF AK < 10 THEN GOSUB 1370
1350 IF AT > 1 THEN GOSUB 1400
1360 RETURN
1370 REM LOW ALTITUDE BY 1 000 FT
1380 AD = A(AK)
1390 RETURN
1400 REM HIGH ALTITUDE BY 10 000 FT ***
1410 AD = B(AT)
1420 RETURN
1430 REM BALLISTIC DRAG SUBROUTINE ******
1440 IF AT < 10 THEN 1460
1450 IF AT < 42 THEN ECFB = ((AT - 10) * .0315) + .01
1460 DH = .5 * (AD * ((HV * ABS(HV)) * CH))
1470 DV = .5 * (AD * ((VV * ABS(VV)) * CV))
1480 HTH = .5 * HV * DH * ECFB / AF
1490 HTV = .5 * VV * DV * ECFB / AF
1500 HT = HTH + HTV
1510 DVH = DV
1520 RETURN
1530 REM HIGH ALTITUDE LIFT AND DRAG SUBROUTINE ******
1540 IF VV = 0 THEN 1620
1550 IF VV > 0 THEN 1570
1560 IF VV < 0 THEN 1600
1570 IF AN < 6 THEN 1620
1580 AN = AN - 1
1590 GOTO 1620
1600 IF AN = 45 THEN 1620
1610 IF AN < 45 THEN AN = AN + 1
1620 AR = AN / 57.32
1630 SI = SIN(AR)
1640 CO = COS(AR)
1650 CH = AF * SI
1660 DH = .5 * (AD * ((HV * ABS(HV)) * CH))
1670 DV = -1 * ((DH / SI) * CO)
1680 CH = (AF * SI) + (AF / 10) + DDA
1690 DH = .5 * (AD * ((HV * ABS(HV)) * CH))
1700 CV = AF * CO
1710 ECFH = .5
1720 HTH = .5 * HV * DH * ECFH / AF
1730 DVH = .5 * AD * VV * ABS(VV) * CV
1740 HTV = .5 * VV * DVH * ECFH / AF
1750 HT = HTH + HTV
1760 RETURN
1770 REM DROUGE CHUTE ***
1780 CH = (AF * CD) + DF
1790 CV = (AF * CD) + DF
1800 RETURN
1810 REM MAIN CHUTE ***
1820 CH = (AF * CD) + (MF * 1.2)
1830 CV = (AF * CD) + (MF * 1.2)
1840 RETURN
