/* ---------------------------------------------------------------------- */
/*  BSVU(C) Copyright Bill Buckels 1990-1999                              */
/*  All Rights Reserved.                                                  */
/*                                                                        */
/*  A Loader/Viewer for .BSV Saved Text Screen files                      */
/*                                                                        */
/*  Licence Agreement                                                     */
/*  -----------------                                                     */
/*                                                                        */
/*  Suggested Registration is $10.00 per commercial site, free for        */
/*  family users at home.                                                 */
/*                                                                        */
/*  Commercial users are expected to register with the Author if using    */
/*  this program beyond a 30-day evaluation period. Send registration     */
/*  in the  form of cheque, or money order to:                            */
/*                                                                        */
/*  Bill Buckels                                                          */
/*  589 Oxford Street                                                     */
/*  Winnipeg, Manitoba, Canada R3M 3J2                                    */
/*                                                                        */
/*  Email: bbuckels@escape.ca                                             */
/*  WebSite: http://www.escape.ca/~bbuckels                               */
/*                                                                        */
/*  Registered users have a royalty-free right to use,                    */
/*  modify, reproduce and distribute this source code (and/or any         */
/*  modified version) in any way you find useful, provided you do not     */
/*  compete with Bill Buckels or his agents, and that you agree that      */
/*  Bill Buckels has no warranty obligations or liability whatsoever      */
/*  resulting from any associated loss or damage.                         */
/*                                                                        */
/*  If you do not agree with these terms, remove this source and          */
/*  all associated files from your computer now.                          */
/*                                                                        */
/*  Description                                                           */
/*  -----------                                                           */
/*                                                                        */
/*  This is a companion utility to be used with BSAVED text images        */
/*  I hope this code proves informative to those of you interested in     */
/*  computer graphics.                                                    */
/*                                                                        */
/*  Supported Screen Mode is CGA COLOR TEXT Mode                          */
/*                                                                        */
/*  These .BSV files can be created in the THEDRAW or in GWBASIC, etc.    */
/*  or aquired using a screen capture program that saves .BSV files.      */
/*                                                                        */
/*  This program turns off the cursor, loads the file, waits for a        */
/*  key press then turns the cursor on and returns the key value as       */
/*  an exit code. can be used as a slide show driver or batch menu.       */
/*                                                                        */
/*  Bill Buckels 1999                                                     */
/* ---------------------------------------------------------------------- */


#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <malloc.h>

#define SCREENSIZE 4000

/* this macro converts a base and offset to a far pointer */
#ifndef MK_FP
#define MK_FP(seg,off) ((char far *)(((long)(seg) << 16) | (off)))
#endif

void main(int argc, char **argv)
{
    FILE *fp;                                    /* screen image file ptr */
    unsigned char *psnDataBuf;                   /* screen image buffer */
    unsigned char far *lpCrt;                    /* screen memory address */
    unsigned uiRetVal = 0,                       /* exit code */
             SCREENSEG = 0xb000;                 /* initial screen segment */
    union REGS inregs, outregs;                  /* regs structures for asm */
    int idx;                                     /* scratch counter */

    if (argc < 2) {
      /* put usage help if no args entered on command line */
      puts("BSVU(C) Copyright Bill Buckels 1990-1999");
      puts("All Rights Reserved.");
      puts("Usage is \"BSVU [image.bsv]\"");
    }
    else {
      /* if we can't allocate memory just bail-out */
      if (NULL != (psnDataBuf=malloc(SCREENSIZE))) {
        /* if we can open it... */
        if (NULL != (fp = fopen(argv[1], "rb"))) {
          fread(psnDataBuf,7, 1, fp);
          /* check header for valid image */
          if (psnDataBuf[0] == (unsigned char)'\xfd' &&
              psnDataBuf[1] == (unsigned char)'\x00') {
            /* if valid, read it in! */
            fread(psnDataBuf,SCREENSIZE, 1, fp);
            fclose(fp);
            /* get equipment list from the bios */
            int86(0x11, &inregs, &outregs);
            /* get display type (bits 4 and 5 of ax) */
            if ((outregs.x.ax & 0x30) < 0x30)
              SCREENSEG=0xb800;
            /* point to the screen */
            lpCrt = MK_FP(SCREENSEG,0x0000);
            /* turn cursor off */
            inregs.x.ax = 0x0100;
            inregs.x.cx = 0x2000;
            int86(0x10,&inregs,&outregs);
            /* read the buffer into the screen */
            for(idx=0; idx<SCREENSIZE; idx++)
              lpCrt[idx] = psnDataBuf[idx];
            /* wait for a key press */
            inregs.x.ax = 0x0000;
            inregs.x.dx = 0x0000;
            /* generate int 16h */
            int86(0x16,&inregs,&outregs);
            /* return the low order char */
            uiRetVal = outregs.x.ax&0x00ff;
            /* turn cursor on */
            inregs.x.ax = 0x0100;
            inregs.x.cx = 0x0607;
            int86(0x10,&inregs,&outregs);
          }
          else {
            fclose(fp);
            puts("Invalid Screen Image!");
          }
        }
        else
          perror(argv[1]);
        free(psnDataBuf);
      }
    }
    /* exit with a keypress value if no error */
    exit(uiRetVal);
}
