#include <time.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>

extern void normal(void);
extern void read(char filename[]);
void run5(void);
extern void readdata(char ext[]);
extern void readinst(char filename[]);
extern int sort_function( const void *a, const void *b);


extern void memory(void) {

 char choice;

 for(;;) {
  normal();
  _setcursortype(_NOCURSOR);
  window(18,6,62,19);
  textbackground(LIGHTGRAY);
  clrscr();
  window(20,7,60,18);
  textcolor(WHITE);
  textbackground(BLUE);
  clrscr();
   gotoxy(15,2);
  cprintf("MEMORY MENU:");
  gotoxy(5,4);
  cprintf("1. Run the experiment");
  gotoxy(5,5);
  cprintf("2. Show individual results ");
  gotoxy(5,6);
  cprintf("3. Show SPSS ready file ");
  gotoxy(5,7);
  cprintf("4. Details of design");
  gotoxy(5,8);
  cprintf("5. References for further reading");
  gotoxy(5,9);
  cprintf("6. Return to main menu");
  gotoxy(2,12);
  cprintf("Enter choice (1-6)");

  Repeat:
  choice=getch();
  switch (choice) {

   case '1': run5();break;
   case '2': readdata(".mem");break;
   case '3': read("memory.cat");break;
   case '4': read("MEMDets.txt");break;
   case '5': read("MEMrefs.txt");break;
   case '6': return;
   default: goto Repeat;
  }
 }
}





 /*RUN5 (): Runs the experiment */
 void run5(void)
 {
  clock_t start, end;
  int hit1,  miss1, crej1, fpos1;
  float mrthit1, mrtmiss1,  mrtcrej1, mrtfpos1, rthit1, rtmiss1, rtcrej1, rtfpos1;
  int hit2,  miss2, crej2, fpos2;
  float mrthit2, mrtmiss2,  mrtcrej2, mrtfpos2, rthit2, rtmiss2, rtcrej2, rtfpos2;
  int hit3,  miss3, crej3, fpos3;
  float mrthit3, mrtmiss3,  mrtcrej3, mrtfpos3, rthit3, rtmiss3, rtcrej3, rtfpos3;
  int hit4,  miss4, crej4, fpos4;
  float mrthit4, mrtmiss4,  mrtcrej4, mrtfpos4, rthit4, rtmiss4, rtcrej4, rtfpos4;
  int hit5,  miss5, crej5, fpos5;
  float mrthit5, mrtmiss5,  mrtcrej5, mrtfpos5, rthit5, rtmiss5, rtcrej5, rtfpos5;
  int hit6,  miss6, crej6, fpos6;
  float mrthit6, mrtmiss6,  mrtcrej6, mrtfpos6, rthit6, rtmiss6, rtcrej6, rtfpos6;
  int hit7,  miss7, crej7, fpos7;
  float mrthit7, mrtmiss7,  mrtcrej7, mrtfpos7, rthit7, rtmiss7, rtcrej7, rtfpos7;
  int hit8,  miss8, crej8, fpos8;
  float mrthit8, mrtmiss8,  mrtcrej8, mrtfpos8, rthit8, rtmiss8, rtcrej8, rtfpos8;
  int hit9,  miss9, crej9, fpos9;
  float mrthit9, mrtmiss9,  mrtcrej9, mrtfpos9, rthit9, rtmiss9, rtcrej9, rtfpos9;
  char *strng;
  float value,temp;
  int dec, sign;
  int ndig = 1;
  int b,correct,finish=1;
  int cond[300];
  int set1, set2, size,count,a,i,sexno, x, y, comp;
  int rnumber, rnum2[300],rnum[300];
  int RT,rn;
  char init[5], sex;
  char sexstr[2];
  char filename[20],filetemp[20],fileinfo[20],word[300][20];
  char ch_ins, quit, cha, resp;
  char ch, string[80];
  char setstr[80];
  FILE *fpword,*fpins,*fpmaster,*fp,*fpset;
  struct find_t ffblk;

  normal();
  if((fpset=fopen("memsys.txt","r"))==NULL) {
   printf("Cannot open 'memory' system file: memsys.txt file");
   exit(1);
  }
  for(i=0;;i++) {
   ch=fgetc(fpset);
   if(isdigit(ch)) setstr[i]=ch;
   if(ch=='\n') {
    setstr[i]=0;
    set1=atoi(setstr);
    break;
   }
  }

  for(i=0;;i++) {
   ch=fgetc(fpset);
   if(isdigit(ch)) setstr[i]=ch;
   else {
    setstr[i]=0;
    set2=atoi(setstr);
    fclose(fpset);
    break;
   }
  }

  if(set2<2||set2>9) {
   printf("ERROR in memsys.txt file\nNumber conditions should be between 1 and 9");
   exit(0);
  }


  /* record personal data */
   textcolor(WHITE);
   for(;;) {

    do{
     clrscr();
     printf("\nPlease, enter up to four initials\n(press 'enter' when finished): ");
     gets(init);
    } while (strlen(init)>4);

    do {
     clrscr();
     printf("\nMale or female? (just press 'm' or 'f'): ");
     sex=getche();
     delay(300);
    } while (tolower(sex)!='m'&&tolower(sex)!='f');
    sexstr[0]=sex;
    sexstr[1]=0;



    do {
     clrscr();
     printf("\nInitials: %s\nSex: %c\n",init, sex);
     printf("\nAre these correct? (press 'y' or 'n')");
     resp=getche();
    } while (tolower(resp)!='y' && tolower(resp)!='n');

    if (tolower(resp)=='y') break;
    clrscr();
   }


   /*CHECK IF THE FILE EXISTS, ADD NUMBER AND SAVE*/

   value=0;
   ndig=1;
   strcpy(filename,init);
   strcat(filename,sexstr);

   for(;;){
    strcpy(filetemp,filename);
    if(value>9) ndig=2;
    strng = ecvt(value, ndig, &dec, &sign);
    strcat(filetemp,strng);
    strcpy(fileinfo,filetemp);
    strcat(filetemp,".mem");
    if(ch=='q') exit(0);
    if(!_dos_findfirst(filetemp,_A_NORMAL,&ffblk)) value++;
    else break;
   }


   if((fp=fopen(filetemp,"w"))==NULL) {
    printf("Error: Cannot open %s file",filename);
    exit(1);
   }

   fprintf(fp,"Initials: %s \nSex: %c\n",init,sex);
   fclose(fp);
   clrscr();


    /* instructions */

   readinst("memins.txt");
   textcolor(WHITE);
   clrscr();
   printf("\a");
   delay(1000);
   textcolor(WHITE);




   if((fpword=fopen("memword.txt","r"))==NULL) {
    printf("Cannot open memword.txt file");
    exit(1);
   }

    /*get words and conditions and put them to an array*/
   size=0;
   finish=1;
   for(a=0;finish&&a<=400;a++) {
    for(b=0;finish;b++) {
     if(!feof(fpword)) {
      ch=fgetc(fpword);
      if(isalpha(ch)) word[a][b]=ch;
      if(isdigit(ch)) {
       cond[a]=ch-48;
       word[a][b]=0;
       if(cond[a]<1||cond[a]>set2) {
	printf("Invalid value for condition in line #%d", a+1);
	exit(0);
       }
      }
      if(ch=='\n') {
       if(!strlen(word[a])) finish=0;
       break;
      }
     }
     else finish=0;
    }
   }
   fclose(fpword);

   size=a-1;


   /*present Practice trials*/
   _setcursortype(_NOCURSOR);

    /* create random numbers */
   randomize();
   for(a=0;a<set1;) {
    comp=0;
    rnumber=random(set1);
    for(i=0;i<a;i++) if(rnumber==rnum2[i]) comp++;
    if(comp==0) {
     rnum2[a]=rnumber;
     a++;
    }
   }


    /*present words */
   for(count=0;count<set1;count++) {

    gotoxy(35,10);
    printf("%s",word[rnum2[count]]);
    delay(1000);
    clrscr();
    delay(500);

   }


   printf("\a");
   clrscr();

   if((fpins=fopen("memins2.txt","r"))==NULL) {
    printf("Cannot open 'MEMINS2.TXT' file!");
    exit(1);
   }

   while((ch_ins=fgetc(fpins))!=EOF) putchar(ch_ins);
   fclose(fpins);
   while(kbhit()) getch();
   getch();
   clrscr();
   printf("\a");
   delay(1000);







  /* create random numbers */

   randomize();
   for(a=0;a<size;) {
    comp=0;
    rnumber=random(size);
    for(i=0;i<a;i++) if(rnumber==rnum[i]) comp++;
    if(comp==0) {
     rnum[a]=rnumber;
     a++;
    }
   }



   /*presentations*/

    hit1=0;
    rthit1=0;
    miss1=0;
    rtmiss1=0;
    crej1=0;
    rtcrej1=0;
    fpos1=0;
    rtfpos1=0;


    hit2=0;
    rthit2=0;
    miss2=0;
    rtmiss2=0;
    crej2=0;
    rtcrej2=0;
    fpos2=0;
    rtfpos2=0;


    hit3=0;
    rthit3=0;
    miss3=0;
    rtmiss3=0;
    crej3=0;
    rtcrej3=0;
    fpos3=0;
    rtfpos3=0;


    hit4=0;
    rthit4=0;
    miss4=0;
    rtmiss4=0;
    crej4=0;
    rtcrej4=0;
    fpos4=0;
    rtfpos4=0;


    hit5=0;
    rthit5=0;
    miss5=0;
    rtmiss5=0;
    crej5=0;
    rtcrej5=0;
    fpos5=0;
    rtfpos5=0;

    hit6=0;
    rthit6=0;
    miss6=0;
    rtmiss6=0;
    crej6=0;
    rtcrej6=0;
    fpos6=0;
    rtfpos6=0;

    hit7=0;
    rthit7=0;
    miss7=0;
    rtmiss7=0;
    crej7=0;
    rtcrej7=0;
    fpos7=0;
    rtfpos7=0;

    hit8=0;
    rthit8=0;
    miss8=0;
    rtmiss8=0;
    crej8=0;
    rtcrej8=0;
    fpos8=0;
    rtfpos8=0;

    hit9=0;
    rthit9=0;
    miss9=0;
    rtmiss9=0;
    crej9=0;
    rtcrej9=0;
    fpos9=0;
    rtfpos9=0;


   for(i=0;i<size;i++) {

    gotoxy(35,10);
    cprintf("%s", word[rnum[i]]);

    while(kbhit()) getch();

    start = clock();
    do {
     ch=getch();
    } while(tolower(ch)!='1'&&tolower(ch)!='0');

    end = clock();
    RT=(end-start)/CLK_TCK*1000;
    if(RT>3000) RT=3000;
    sound(500);
    delay(20);
    nosound();
    clrscr();



    switch (cond[rnum[i]]) {
     case 1:
      if(rnum[i]<set1) {
       if(tolower(ch)=='1') {
	miss1++;
	rtmiss1=rtmiss1+RT;
       }
       else {
	hit1++;
	rthit1=rthit1+RT;
       }
      }
      else {
       if(tolower(ch)=='1') {
	crej1++;
	rtcrej1=rtcrej1+RT;
       }
       else {
	fpos1++;
	rtfpos1=rtfpos1+RT;
       }
      }
      break;
     case 2:
      if(rnum[i]<set1) {
       if(tolower(ch)=='1') {
	miss2++;
	rtmiss2=rtmiss2+RT;
       }
       else {
	hit2++;
	rthit2=rthit2+RT;
       }
      }
      else {
       if(tolower(ch)=='1') {
	crej2++;
	rtcrej2=rtcrej2+RT;
       }
       else {
	fpos2++;
	rtfpos2=rtfpos2+RT;
       }
      }
      break;
     case 3:
      if(rnum[i]<set1) {
       if(tolower(ch)=='1') {
	miss3++;
	rtmiss3=rtmiss3+RT;
       }
       else {
	hit3++;
	rthit3=rthit3+RT;
       }
      }
      else {
       if(tolower(ch)=='1') {
	crej3++;
	rtcrej3=rtcrej3+RT;
       }
       else {
	fpos3++;
	rtfpos3=rtfpos3+RT;
       }
      }
      break;
     case 4:
      if(rnum[i]<set1) {
       if(tolower(ch)=='1') {
	miss4++;
	rtmiss4=rtmiss4+RT;
       }
       else {
	hit4++;
	rthit4=rthit4+RT;
       }
      }
      else {
       if(tolower(ch)=='1') {
	crej4++;
	rtcrej4=rtcrej4+RT;
       }
       else {
	fpos4++;
	rtfpos4=rtfpos4+RT;
       }
      }
      break;
     case 5:
      if(rnum[i]<set1) {
       if(tolower(ch)=='1') {
	miss5++;
	rtmiss5=rtmiss5+RT;
       }
       else {
	hit5++;
	rthit5=rthit5+RT;
       }
      }
      else {
       if(tolower(ch)=='1') {
	crej5++;
	rtcrej5=rtcrej5+RT;
       }
       else {
	fpos5++;
	rtfpos5=rtfpos5+RT;
       }
      }
      break;
     case 6:
      if(rnum[i]<set1) {
       if(tolower(ch)=='1') {
	miss6++;
	rtmiss6=rtmiss6+RT;
       }
       else {
	hit6++;
	rthit6=rthit6+RT;
       }
      }
      else {
       if(tolower(ch)=='1') {
	crej6++;
	rtcrej6=rtcrej6+RT;
       }
       else {
	fpos6++;
	rtfpos6=rtfpos6+RT;
       }
      }
      break;
     case 7:
      if(rnum[i]<set1) {
       if(tolower(ch)=='1') {
	miss7++;
	rtmiss7=rtmiss7+RT;
       }
       else {
	hit7++;
	rthit7=rthit7+RT;
       }
      }
      else {
       if(tolower(ch)=='1') {
	crej7++;
	rtcrej7=rtcrej7+RT;
       }
       else {
	fpos7++;
	rtfpos7=rtfpos7+RT;
       }
      }
      break;
     case 8:
      if(rnum[i]<set1) {
       if(tolower(ch)=='1') {
	miss8++;
	rtmiss8=rtmiss8+RT;
       }
       else {
	hit8++;
	rthit8=rthit8+RT;
       }
      }
      else {
       if(tolower(ch)=='1') {
	crej8++;
	rtcrej8=rtcrej8+RT;
       }
       else {
	fpos8++;
	rtfpos8=rtfpos8+RT;
       }
      }
      break;

     case 9:
      if(rnum[i]<set1) {
       if(tolower(ch)=='1') {
	miss9++;
	rtmiss9=rtmiss9+RT;
       }
       else {
	hit9++;
	rthit9=rthit9+RT;
       }
      }
      else {
       if(tolower(ch)=='1') {
	crej9++;
	rtcrej9=rtcrej9+RT;
       }
       else {
	fpos9++;
	rtfpos9=rtfpos9+RT;
       }
      }
      break;
    }


    /*pause*/

    if(i>0 && i%(size/5)==0) {
     clrscr();
     printf("\a");
     gotoxy(20,10);
     printf("Have a short rest.");
     gotoxy(1,25);
     printf("Press any key to continue...");
     getch();
     clrscr();
     printf("\a");
     delay(1000);

    }

    delay(400);
   }



   /*calculate averages for all conditions*/

    if(hit1) mrthit1=rthit1/hit1;
    else mrthit1=0;
    if(miss1) mrtmiss1=rtmiss1/miss1;
    else mrtmiss1=0;
    if(crej1) mrtcrej1=rtcrej1/crej1;
    else mrtcrej1=0;
    if(fpos1) mrtfpos1=rtfpos1/fpos1;
    else mrtfpos1=0;

    if(hit2) mrthit2=rthit2/hit2;
    else mrthit2=0;
    if(miss2) mrtmiss2=rtmiss2/miss2;
    else mrtmiss2=0;
    if(crej2) mrtcrej2=rtcrej2/crej2;
    else mrtcrej2=0;
    if(fpos2) mrtfpos2=rtfpos2/fpos2;
    else mrtfpos2=0;

    if(set2>2) {
     if(hit3) mrthit3=rthit3/hit3;
     else mrthit3=0;
     if(miss3) mrtmiss3=rtmiss3/miss3;
     else mrtmiss3=0;
     if(crej3) mrtcrej3=rtcrej3/crej3;
     else mrtcrej3=0;
     if(fpos3) mrtfpos3=rtfpos3/fpos3;
     else mrtfpos3=0;
    }

    if(set2>3) {
     if(hit4) mrthit4=rthit4/hit4;
     else mrthit4=0;
     if(miss4) mrtmiss4=rtmiss4/miss4;
     else mrtmiss4=0;
     if(crej4) mrtcrej4=rtcrej4/crej4;
     else mrtcrej4=0;
     if(fpos4) mrtfpos4=rtfpos4/fpos4;
     else mrtfpos4=0;
    }

    if(set2>4) {
     if(hit5) mrthit5=rthit5/hit5;
     else mrthit5=0;
     if(miss5) mrtmiss5=rtmiss5/miss5;
     else mrtmiss5=0;
     if(crej5) mrtcrej5=rtcrej5/crej5;
     else mrtcrej5=0;
     if(fpos5) mrtfpos5=rtfpos5/fpos5;
     else mrtfpos5=0;
    }
    if(set2>5) {
     if(hit6) mrthit6=rthit6/hit6;
     else mrthit6=0;
     if(miss6) mrtmiss6=rtmiss6/miss6;
     else mrtmiss6=0;
     if(crej6) mrtcrej6=rtcrej6/crej6;
     else mrtcrej6=0;
     if(fpos6) mrtfpos6=rtfpos6/fpos6;
     else mrtfpos6=0;
    }
    if(set2>6) {
     if(hit7) mrthit7=rthit7/hit7;
     else mrthit7=0;
     if(miss7) mrtmiss7=rtmiss7/miss7;
     else mrtmiss7=0;
     if(crej7) mrtcrej7=rtcrej7/crej7;
     else mrtcrej7=0;
     if(fpos7) mrtfpos7=rtfpos7/fpos7;
     else mrtfpos7=0;
    }
    if(set2>7) {
     if(hit8) mrthit8=rthit8/hit8;
     else mrthit8=0;
     if(miss8) mrtmiss8=rtmiss8/miss8;
     else mrtmiss8=0;
     if(crej8) mrtcrej8=rtcrej8/crej8;
     else mrtcrej8=0;
     if(fpos8) mrtfpos8=rtfpos8/fpos8;
     else mrtfpos8=0;
    }
    if(set2>8) {
     if(hit9) mrthit9=rthit9/hit9;
     else mrthit9=0;
     if(miss9) mrtmiss9=rtmiss9/miss9;
     else mrtmiss9=0;
     if(crej9) mrtcrej9=rtcrej9/crej9;
     else mrtcrej9=0;
     if(fpos9) mrtfpos9=rtfpos9/fpos9;
     else mrtfpos9=0;
    }


   if((fp=fopen(filetemp,"a"))==NULL) {
    printf("Cannot open '%s' file!",filetemp);
    exit(1);
   }

   fprintf(fp,"\n            #hits (mean RT) #misses (mean RT) #corect (mean RT) #false (mean RT)");
   fprintf(fp,"                                                 rej.             pos.\n");
	       fprintf(fp,"\nCondition 1:   %2d    %4.0f       %2d     %4.0f        %2d     %4.0f      %2d     %4.0f", hit1,mrthit1,miss1,mrtmiss1,crej1,mrtcrej1,fpos1,mrtfpos1);
	       fprintf(fp,"\nCondition 2:   %2d    %4.0f       %2d     %4.0f        %2d     %4.0f      %2d     %4.0f", hit2,mrthit2,miss2,mrtmiss2,crej2,mrtcrej2,fpos2,mrtfpos2);
   if(set2>2)  fprintf(fp,"\nCondition 3:   %2d    %4.0f       %2d     %4.0f        %2d     %4.0f      %2d     %4.0f", hit3,mrthit3,miss3,mrtmiss3,crej3,mrtcrej3,fpos3,mrtfpos3);
   if(set2>3)  fprintf(fp,"\nCondition 4:   %2d    %4.0f       %2d     %4.0f        %2d     %4.0f      %2d     %4.0f", hit4,mrthit4,miss4,mrtmiss4,crej4,mrtcrej4,fpos4,mrtfpos4);
   if(set2>4)  fprintf(fp,"\nCondition 5:   %2d    %4.0f       %2d     %4.0f        %2d     %4.0f      %2d     %4.0f", hit5,mrthit5,miss5,mrtmiss5,crej5,mrtcrej5,fpos5,mrtfpos5);
   if(set2>5)  fprintf(fp,"\nCondition 6:   %2d    %4.0f       %2d     %4.0f        %2d     %4.0f      %2d     %4.0f", hit6,mrthit6,miss6,mrtmiss6,crej6,mrtcrej6,fpos6,mrtfpos6);
   if(set2>6)  fprintf(fp,"\nCondition 7:   %2d    %4.0f       %2d     %4.0f        %2d     %4.0f      %2d     %4.0f", hit7,mrthit7,miss7,mrtmiss7,crej7,mrtcrej7,fpos7,mrtfpos7);
   if(set2>7)  fprintf(fp,"\nCondition 8:   %2d    %4.0f       %2d     %4.0f        %2d     %4.0f      %2d     %4.0f", hit8,mrthit8,miss8,mrtmiss8,crej8,mrtcrej8,fpos8,mrtfpos8);
   if(set2>8)  fprintf(fp,"\nCondition 9:   %2d    %4.0f       %2d     %4.0f        %2d     %4.0f      %2d     %4.0f", hit9,mrthit9,miss9,mrtmiss9,crej9,mrtcrej9,fpos9,mrtfpos9);
   fclose(fp);

      /* Update master catalogue */
   if((fpmaster=fopen("memory.cat","a"))==NULL) {
    printf("Error: Cannot open MEMORY.CAT file\n");
    exit(1);
   }
   if (tolower(sex)=='m') sexno=1;
   else if(tolower(sex)=='f') sexno=2;

   fprintf(fpmaster,"\n%4s %d %2d %4.0f %2d %4.0f %2d %4.0f %2d %4.0f", init, sexno, hit1, mrthit1,miss1, mrtmiss1, crej1, mrtcrej1, fpos1, mrtfpos1);
   fprintf(fpmaster," %2d %4.0f %2d %4.0f %2d %4.0f %2d %4.0f",  hit2, mrthit2,miss2, mrtmiss2, crej2, mrtcrej2, fpos2, mrtfpos2);
   if(set2>2)    fprintf(fpmaster,"\n%2d %4.0f %2d %4.0f %2d %4.0f %2d %4.0f",  hit3, mrthit3,miss3, mrtmiss3, crej3, mrtcrej3, fpos3, mrtfpos3);
   if(set2>3)     fprintf(fpmaster," %2d %4.0f %2d %4.0f %2d %4.0f %2d %4.0f",  hit4, mrthit4,miss4, mrtmiss4, crej4, mrtcrej4, fpos4, mrtfpos4);
   if(set2>4)    fprintf(fpmaster,"\n%2d %4.0f %2d %4.0f %2d %4.0f %2d %4.0f",  hit5, mrthit5,miss5, mrtmiss5, crej5, mrtcrej5, fpos5, mrtfpos5);
   if(set2>5)      fprintf(fpmaster,"%2d %4.0f %2d %4.0f %2d %4.0f %2d %4.0f",  hit6, mrthit6,miss6, mrtmiss6, crej6, mrtcrej6, fpos6, mrtfpos6);
   if(set2>6)    fprintf(fpmaster,"\n%2d %4.0f %2d %4.0f %2d %4.0f %2d %4.0f",  hit7, mrthit7,miss7, mrtmiss7, crej7, mrtcrej7, fpos7, mrtfpos7);
   if(set2>7)      fprintf(fpmaster,"%2d %4.0f %2d %4.0f %2d %4.0f %2d %4.0f",  hit8, mrthit8,miss8, mrtmiss8, crej8, mrtcrej8, fpos8, mrtfpos8);
   if(set2>8)    fprintf(fpmaster,"\n%2d %4.0f %2d %4.0f %2d %4.0f %2d %4.0f",  hit9, mrthit9,miss9, mrtmiss9, crej9, mrtcrej9, fpos9, mrtfpos9);
   fclose(fpmaster);

   /* END MESSAGE*/
   clrscr();
   window(9,8,71,17);
   textbackground(LIGHTGRAY);
   clrscr();
   window(10,9,70,16);
   textbackground(GREEN);
   textcolor(BLACK);
   clrscr();
   gotoxy(3,2);
   printf("THIS IS THE END OF THE EXPERIMENT");
   gotoxy(3,5);
   printf("Your complete results were saved in the '%s' file.",filetemp);
   getch();
   return;






 }



