unit jpfcts;
{
This unit was written for JugglePro on March 16, 1993
It consist of various stand-alone functions and one which uses
demoinput.tpu.
}

Interface

function unspace(s:string):string; {discards leading and ending spaces}

function parse1(s:string; i:byte; c:char):string;
{
finds the first appearance of character specified after index i of string s
first character of parse1 has ordinate = index immediately after first
occurrence of c or 0 if no such character found.
the rest of parse1 is the substring from i to the character's index - 1
primary use: comma parsing ,
}
function parse2(s:string; i:byte; c1,c2:char):string;
{
finds the first occurrence of c1 followed by c2 in string s at index i
first character of parse2 has ordinate = index immediately after c2
or 0 if no such character found
rest of parse2 is substring in between c1 and c2
primary use: paranthesis parsing ()
}
function count(a:char; s:string):integer;
{
returns a count of characters = a in string s
}
function changeval(oldval:integer; name:string; lim1,lim2:integer):integer;
{
allows user to change value of oldval
name is the name of oldval (i.e. speed is name of smoothe variable)
lim1 is the lower limit admissible
lim2 is the upper limit admissible
}
function cvtnum(c:char):integer;     {Converts hex to decimal}
function cvtnumtohex(nn:byte):char;  {Converts decimal to hex}
procedure hitenter(msg:string); {Prompt user to hit enter key after error}
function oktoplot(x1,y1:integer):boolean;
function hi(hh,t:integer):integer;
procedure transform(var x,y:real);  {Performs rotation of vectors}

Implementation
uses demoinput,crt,header;

function unspace;
begin
  while (length(s)>0) and (s[1]=' ') do delete(s,1,1);
  while (length(s)>0) and (s[length(s)]=' ') do
    delete(s,length(s),1);
  unspace:=s;
end;

function parse1;
var
  a,b:string;
  j:byte;

begin
  if length(s)>=i then
    begin
      a:=copy(s,i,length(s)-i+1);
      j:=pos(c,a);
      if j<2 then
       begin
         b:=a;
         i:=0;
       end
      else
       begin
         b:=copy(a,1,j-1);
         i:=i+j;
       end;
      insert(chr(i),b,1);
      parse1:=b;
    end
  else parse1:=chr(0);
end;

function parse2;
var
 a,b:string;
 j1,j2:byte;
begin
  if length(s)>=i then
    begin
      a:=copy(s,i,length(s)-i+1);
      j1:=pos(c1,a);
      j2:=pos(c2,a);
      if (j1=0) or (j2=0) then
       begin
         b:=a;
         i:=0;
       end
      else
       begin
         b:=copy(a,j1+1,j2-j1-1);
         i:=i+j2;
       end;
      insert(chr(i),b,1);
      parse2:=b;
    end
  else parse2:=chr(0);
end;

function count(a:char; s:string):integer;
var
  cnt,i:integer;
begin
  cnt:=0;
  for i:=1 to length(s) do
    if a=s[i] then cnt:=cnt+1;
  count:=cnt;
end;

function changeval;
var
  i:integer;
  e:integer;
  s:string;

begin
  writeln('Current ',name,' is ',oldval,'.');
  write('New ',name,'? (',lim1,'-',lim2,')');
  repeat
    readlndemo(s);
    val(s,i,e);
    if length(s)=0 then i:=oldval;
  until (i>=lim1) and (i<=lim2);
  changeval:=i;
end;

function cvtnum;
var
  a:byte;
  nn:integer;
begin
  a:=ord(c);
  if a>64 then nn:=a-55
          else nn:=a-48;
  cvtnum:=nn;
end;

function cvtnumtohex;
var
  a:byte;

begin
  if nn>9 then a:=55+nn
          else a:=48+nn;
  cvtnumtohex:=chr(a);
end;

procedure hitenter(msg:string);
var q:string;
begin
  clrscr;
  writeln('Error:  ',msg);
  writeln('Hit enter');
  readlndemo(q);
  clrscr;
end;

function oktoplot(x1,y1:integer):boolean;
begin
oktoplot:=(x1>=0) and (y1>=0) and (x1<=maximumx-8) and
(y1<=maximumy-17);
end;

function hi(hh,t:integer):integer;
begin
  hi:=(hh-1)*(nt*ti+1)+t;
end;

procedure transform(var x,y:real);
var xx,yy:real;
begin
  xx:=cda*x+sda*y;
  yy:=-sda*x+cda*y;
  x:=xx;
  y:=yy;
end;

end.