.TH XCOLOREDIT l "18 March 1989"
.SH NAME
xcoloredit \- find colour values by graphical colour mixing
.SH SYNOPSIS
\fBxcoloredit\fP [ standard X Toolkit arguments ] [ -silent ] [ -format
"format string" ] [ -text "example text" ][ {0-255} .. ]
.SH DESCRIPTION
\fIxcoloredit\fP provides a graphical method of mixing the three primary
colors available on a colour workstation.  This mixing can be done using the
Red, Green and Blue slider controls on the left of the window or using the
Hue, Saturation and Value slider controls on the right.

The three boxes above the Red, Green and Blue slider controls are used for
linking the controls together via the fourth slider to the right of the blue
slider.  Whilst in the slider controls the first mouse button increments
the colour components value, the third mouse button decrements the value
(this only works with the Red, Green, Blue and Linked sliders).
The middle mouse button allows the user to continually change the value.

The results of the colour mixing is shown in the four central squares.
The three smaller squares showing the intensities of the red, green and blue
components.  The hexidecimal value below these squares is the corresponding
colour value which can be used in defaults files.  This value is also placed
in the PRIMARY_COLOR selection property.  If the user presses the colour
value button the button is highlighted and the colour value is placed in
PRIMARY_SELECTION as well (useful for pasting into defaults files).

At the bottom of the main window are 36 colour cells.  The current colour
cell is highlighted by box drawn around it.  By clicking with the first
mouse button in another cell this new cell's current value can be edited
(if the cell has no defined value the current cells value is copied to it
and the cell is highlighted with a dashed box).  These colour cells can be
connected to cells in the default colourmap of the display.  To do this
the user must give the colourmap entry number(s) (pixel number) as a command
line argument(s).

The text shown in the mixed colour window can be displayed in one of the
36 colour cell colours.  Typing "c" or "t" in this window changes the
colour of the text to that of the currently selected colour cell.  This
can be used to see what text will look like with different foreground and
background colours.  The example text can be modified using the
\fI-text\fP command line option.
.SH OPTIONS
Apart from standard X Toolkit options, the following are available:
.IP \fI-silent\fP
Do not print out the edited colour values when \fIxcoloredit\fP quits.
.IP \fI-text\fP\ \fB"example\ text"\fP
This sets the example text to display in the mixed colour window.
Newlines are allowed in this string.
.IP \fI-format\fP\ \fB"format\ string"\fP
This string is the format used to display the RGB value of the colour.
This format is used by the printf(2) function call.  By default the
format is set to "#%02x%02x%02x" which is the standard RGB format for X.
.SH SELECTION ATOMS
The following selection atoms are used/defined:
.br
PRIMARY_COLOR \- current colour selection value
.br
PRIMARY_SELECTION \- current colour selection value when highlighted.
.SH AUTHOR
Richard Hesketh, University of Kent at Canterbury, March 1989
.br
rlh2@ukc.ac.uk
