/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, 1992, William Cheng.
 * 
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /amnt/kona/tangram/u/william/X11/TGIF2/RCS/stk.c,v 2.37.1.2 1992/10/21 05:00:55 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "align.e"
#include "button.e"
#include "choice.e"
#include "cmd.e"
#include "color.e"
#include "cursor.e"
#include "drawing.e"
#include "dup.e"
#include "file.e"
#include "font.e"
#include "grid.e"
#include "mainmenu.e"
#include "mark.e"
#include "menu.e"
#include "msg.e"
#include "names.e"
#include "obj.e"
#include "pattern.e"
#include "ruler.e"
#include "scroll.e"
#include "select.e"
#include "setup.e"
#include "text.e"

static struct StkRec	* topStk = NULL;

int AncesterModified ()
{
   struct StkRec	* stk_ptr;

   for (stk_ptr = topStk; stk_ptr != NULL; stk_ptr = stk_ptr->next)
      if (stk_ptr->file_mod) return (TRUE);
   return (FALSE);
}

void InitStk ()
{
   curSymDir[0] = '\0';
}

void PushIcon ()
{
   struct StkRec	* stk_ptr;
   struct ObjRec	* obj_ptr;
   char			sym_name[MAXPATHLENGTH], path_name[MAXPATHLENGTH];
   char			file_name[MAXPATHLENGTH], s[MAXPATHLENGTH], * rest;
   int			read_status, short_name;
   FILE			* fp;
   int			tmp_linenum;
   char			tmp_filename[MAXPATHLENGTH];

   if (topSel == NULL || topSel != botSel || topSel->obj->type != OBJ_ICON)
   {
      Msg ("Please select one ICON object to push into.");
      return;
   }

   strcpy (sym_name, topSel->obj->detail.r->s);
   if (!GetSymbolPath (sym_name, path_name))
   {
      sprintf (s, "Can not find '%s.%s' in %s", sym_name, SYM_FILE_EXT,
            curDomainPath);
      Msg (s);
      return;
   }

   strcat (sym_name, ".");
   strcat (sym_name, SYM_FILE_EXT);
   sprintf (file_name, "%s/%s", path_name, sym_name);

   if (short_name = IsPrefix (bootDir, file_name, &rest)) ++rest;

   if ((fp = fopen (file_name, "r")) == NULL)
   {
      if (short_name)
         sprintf (s, "Can not open '%s', icon not pushed into.", rest);
      else
         sprintf (s, "Can not open '%s', icon not pushed into.", file_name);
      Msg (s);
      return;
   }

   strcpy (tmp_filename, scanFileName);
   tmp_linenum = scanLineNum;
   strcpy (scanFileName, (short_name ? rest : file_name));
   scanLineNum = 0;

   HighLightReverse ();

   stk_ptr = (struct StkRec *) calloc (1, sizeof(struct StkRec));
   stk_ptr->next = topStk;
   stk_ptr->sel = topSel->obj;
   stk_ptr->first = topObj;
   stk_ptr->last = botObj;
   stk_ptr->file_mod = fileModified;
   stk_ptr->id = objId;
   stk_ptr->page_style = pageStyle;

   stk_ptr->orig_x = drawOrigX;
   stk_ptr->orig_y = drawOrigY;
   stk_ptr->zoom = zoomScale;
   stk_ptr->zoomed = zoomedIn;
   stk_ptr->grid_system = gridSystem;
   stk_ptr->english_grid = xyEnglishGrid;
   stk_ptr->metric_grid = xyMetricGrid;
   stk_ptr->grid_on = gridOn;
   stk_ptr->color = colorIndex;
   stk_ptr->h_align = horiAlign;
   stk_ptr->v_align = vertAlign;
   stk_ptr->line_w = lineWidth;
   stk_ptr->line_s = lineStyle;
   stk_ptr->fill = objFill;
   stk_ptr->pen = penPat;
   stk_ptr->just = textJust;
   stk_ptr->v_space = textVSpace;
   stk_ptr->font = curFont;
   stk_ptr->f_style = curStyle;
   stk_ptr->f_size = curSize;
   stk_ptr->f_dpi = curFontDPI;
   stk_ptr->print_mag = printMag;
   stk_ptr->grid_shown = gridShown;
   stk_ptr->move_mode = moveMode;
   stk_ptr->text_rotate = curRotate;
   stk_ptr->rcb_radius = rcbRadius;

   stk_ptr->first_cmd = firstCmd;
   stk_ptr->last_cmd = lastCmd;
   stk_ptr->cur_cmd = curCmd;
   stk_ptr->history_count = historyCount;
   firstCmd = lastCmd = curCmd = NULL;
   historyCount = 0;

   topObj = botObj = NULL;

   strcpy (stk_ptr->dir, curDir);
   if (stk_ptr->name_valid = curFileDefined)
      strcat (stk_ptr->name, curFileName);
   strcpy (stk_ptr->sym_dir, curSymDir);
   strcpy (stk_ptr->domain, curDomainName);

   stk_ptr->saved_comments = savedComments;
   stk_ptr->saved_comments_len = savedCommentsLen;
   savedComments = NULL;
   savedCommentsLen = 0;

   topStk = stk_ptr;

   if (short_name)
      sprintf (s, "Pushing into '%s' ...", rest);
   else
      sprintf (s, "Pushing into '%s' ...", file_name);
   Msg (s);
   CleanUpDrawingWindow ();
   XClearWindow (mainDisplay, drawWindow);
   somethingHighLighted = FALSE;
   SetFileModified (FALSE);

   SetWatchCursor (drawWindow);
   SetWatchCursor (mainWindow);
   numRedrawBBox = 0;
   while ((read_status = ReadObj (fp, &obj_ptr)) == TRUE)
      if (obj_ptr != NULL)
      {
         AdjForOldVersion (obj_ptr);
         AddObj (NULL, topObj, obj_ptr);
         if (PointInBBox (obj_ptr->x, obj_ptr->y, drawWinBBox) ||
               BBoxIntersect (obj_ptr->bbox, drawWinBBox))
            DrawObj (drawWindow, obj_ptr);
      }

   strcpy (scanFileName, tmp_filename);
   scanLineNum = tmp_linenum;

   fclose (fp);
   SetDefaultCursor (mainWindow);
   SetDefaultCursor (drawWindow);

   if (read_status == INVALID)
   {
      sprintf (s, "File version too large (=%1d).  Push aborted!",
            fileVersion);
      Msg (s);
      DrawPaperBoundary ();
      RedrawGridLines ();
      return;
   }

   strcpy (curFileName, sym_name);
   strcpy (curSymDir, path_name);
   curFileDefined = TRUE;

   if (short_name)
      sprintf (s, "Current file is '%s'.", rest);
   else
      sprintf (s, "Current file is '%s'.", file_name);
   Msg (s);

   RedrawTitleWindow ();

   UpdateSubMenu (MENU_HORIALIGN);
   UpdateSubMenu (MENU_VERTALIGN);
   UpdateSubMenu (MENU_STYLE);
   UpdateSubMenu (MENU_FONT);
   UpdateSubMenu (MENU_SIZE);
   UpdateSubMenu (MENU_LINEWIDTH);
   UpdateSubMenu (MENU_LINESTYLE);
   UpdateSubMenu (MENU_LINETYPE);
   UpdateSubMenu (MENU_LINEDASH);
   UpdateSubMenu (MENU_LAYOUT);
   UpdateSubMenu (MENU_MOVEMODE);
}

void PopIcon ()
{
   char	msg[MAXPATHLENGTH], dummy[MAXPATHLENGTH], * rest;

   if (topStk == NULL)
   {
      Msg ("Already at top level.");
      return;
   }
   while (fileModified)
   {
      switch (YesNoCancel ("File modified, save file before quit? [ync](y)",
            CONFIRM_YES))
      {
         case CONFIRM_YES: SaveFile (); break;
         case CONFIRM_NO: SetFileModified (FALSE); break;
         case CONFIRM_CANCEL: return;
      }
   }
   fileModified = topStk->file_mod;
   objId = topStk->id;

   CleanUpComments ();
   CleanUpDrawingWindow ();

   drawOrigX = topStk->orig_x;
   drawOrigY = topStk->orig_y;
   zoomScale = topStk->zoom;
   zoomedIn = topStk->zoomed;
   gridSystem = topStk->grid_system;
   xyEnglishGrid = topStk->english_grid;
   xyMetricGrid = topStk->metric_grid;
   gridOn = topStk->grid_on;
   colorIndex = topStk->color;
   horiAlign = topStk->h_align;
   vertAlign = topStk->v_align;
   lineWidth = topStk->line_w;
   lineStyle = topStk->line_s;
   objFill = topStk->fill;
   penPat = topStk->pen;
   textJust = topStk->just;
   textVSpace = topStk->v_space;
   curFont = topStk->font;
   curStyle = topStk->f_style;
   curSize = topStk->f_size;
   curFontDPI = topStk->f_dpi;
   printMag = topStk->print_mag;
   gridShown = topStk->grid_shown;
   moveMode = topStk->move_mode;
   curRotate = topStk->text_rotate;
   rcbRadius = topStk->rcb_radius;

   CleanUpCmds ();
   firstCmd = topStk->first_cmd;
   lastCmd = topStk->last_cmd;
   curCmd = topStk->cur_cmd;
   historyCount = topStk->history_count;

   topObj = topStk->first;
   botObj = topStk->last;
   strcpy (curDomainName, topStk->domain);
   strcpy (curSymDir, topStk->sym_dir);
   if (curFileDefined = topStk->name_valid)
   {
      strcpy (curFileName, topStk->name);
      if (*curSymDir == '\0')
         sprintf (dummy, "%s/%s", topStk->dir, curFileName);
      else
         sprintf (dummy, "%s/%s", curSymDir, curFileName);
      if (IsPrefix (bootDir, dummy, &rest))
         sprintf (msg, "Pop back to '%s'.", ++rest);
      else
         sprintf (msg, "Pop back to '%s'.", dummy);
      Msg (msg);
   }
   else
   {
      sprintf (dummy, "Poping back to parent level.  Current file undefined.");
      Msg (dummy);
   }
   if (strcmp (curDir, topStk->dir) != 0)
   {
      strcpy (curDir, topStk->dir);
      UpdateDirInfo ();
   }
   else
      strcpy (curDir, topStk->dir);

   savedComments = topStk->saved_comments;
   savedCommentsLen = topStk->saved_comments_len;

   topSel = botSel = (struct SelRec *) calloc (1, sizeof(struct SelRec));
   topSel->next = NULL;
   topSel->prev = NULL;
   topSel->obj = topStk->sel;
   UpdSelBBox ();

   if (UpdPageStyle (topStk->page_style))
   {
      UpdDrawWinBBox ();
      AdjSplineVs ();
   }
   UpdDrawWinWH ();
   SetCanvasFont ();
   RedrawRulers ();
   RedrawScrollBars ();
   RedrawChoiceWindow ();
   RedrawTitleWindow ();
   UpdDrawWinBBox ();
   UpdateSubMenu (MENU_HORIALIGN);
   UpdateSubMenu (MENU_VERTALIGN);
   UpdateSubMenu (MENU_STYLE);
   UpdateSubMenu (MENU_FONT);
   UpdateSubMenu (MENU_SIZE);
   UpdateSubMenu (MENU_LINEWIDTH);
   UpdateSubMenu (MENU_LINESTYLE);
   UpdateSubMenu (MENU_LINETYPE);
   UpdateSubMenu (MENU_LINEDASH);
   UpdateSubMenu (MENU_LAYOUT);
   UpdateSubMenu (MENU_MOVEMODE);

   free (topStk);
   topStk = topStk->next;
   ClearAndRedrawDrawWindow ();
   XSync (mainDisplay, True);
   justDupped = FALSE;
}

void CleanUpStk ()
{
   register struct StkRec	* next_stk;

   for ( ; topStk != NULL; topStk = next_stk)
   {
      next_stk = topStk->next;
      topObj = topStk->first;
      botObj = topStk->last;
      DelAllObj ();
      free (topStk);
   }
   curSymDir[0] = '\0';
}
