/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, 1992, William Cheng.
 * 
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /amnt/kona/tangram/u/william/X11/TGIF2/RCS/shortcut.c,v 2.35 1992/07/17 15:03:52 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "setup.e"

#define CNTRL_ONLY (ControlMask)
#define META_ONLY (Mod1Mask)
#define CNTRL_META (ControlMask|Mod1Mask)

struct ShortCutRec {
   char		code;
   unsigned int	state;
   char		name[80];
};

static struct ShortCutRec	shortCutXlateTbl[] =
{
/* Control Keys */
   { 'a', CNTRL_ONLY, "SelectAll()" },
   { 'b', CNTRL_ONLY, "Back()" },
   { 'c', CNTRL_ONLY, "ChangeDomain()" },
   { 'd', CNTRL_ONLY, "Duplicate()" },
   { 'e', CNTRL_ONLY, "PushCurChoice()" },
   { 'f', CNTRL_ONLY, "Front()" },
   { 'g', CNTRL_ONLY, "Group()" },
   { 'i', CNTRL_ONLY, "Instantiate()" },
   { 'k', CNTRL_ONLY, "Pop()" },
   { 'l', CNTRL_ONLY, "AlignObjs()" },
   { 'n', CNTRL_ONLY, "New()" },
   { 'o', CNTRL_ONLY, "Open()" },
   { 'p', CNTRL_ONLY, "Print()" },
   { 'q', CNTRL_ONLY, "Quit()" },
   { 'r', CNTRL_ONLY, "Redraw()" },
   { 's', CNTRL_ONLY, "Save()" },
   { 't', CNTRL_ONLY, "AlignToGrid()" },
   { 'u', CNTRL_ONLY, "UnGroup()" },
   { 'v', CNTRL_ONLY, "Push()" },
   { 'w', CNTRL_ONLY, "DrawText()" },
   { 'x', CNTRL_ONLY, "Delete()" },
   { 'y', CNTRL_ONLY, "Copy()" },
   { 'z', CNTRL_ONLY, "Animate()" },
   { ',', CNTRL_ONLY, "ScrollLeft()" },
   { '.', CNTRL_ONLY, "ScrollRight()" },
   { '-', CNTRL_ONLY, "PrintWithCmd()" },
/* Meta Keys */
   { 'a', META_ONLY,  "AttachAttrs()" },
   { 'b', META_ONLY,  "Probe()" },
   { 'c', META_ONLY,  "RotateCounter()" },
   { 'd', META_ONLY,  "-Grid()" },
   { 'e', META_ONLY,  "AnimateSend()" },
   { 'f', META_ONLY,  "AnimateFlash()" },
   { 'g', META_ONLY,  "ToggleGrid()" },
   { 'h', META_ONLY,  "FlipHorizontal()" },
   { 'i', META_ONLY,  "+Grid()" },
   { 'j', META_ONLY,  "HideAttrName()" },
   { 'k', META_ONLY,  "SelectMode()" },
   { 'l', META_ONLY,  "DistributeObjs()" },
   { 'm', META_ONLY,  "Move/JustfyAttr()" },
   { 'n', META_ONLY,  "ShowAttrName()" },
   { 'o', META_ONLY,  "ZoomOut()" },
   { 'p', META_ONLY,  "Import()" },
   { 'q', META_ONLY,  "DrawPoly()" },
   { 'r', META_ONLY,  "DrawBox()" },
   { 's', META_ONLY,  "Solve()" },
   { 't', META_ONLY,  "DetachAttrs()" },
   { 'u', META_ONLY,  "Undo()" },
   { 'v', META_ONLY,  "FlipVertical()" },
   { 'w', META_ONLY,  "RotateClockWise()" },
   { 'x', META_ONLY,  "Escape()" },
   { 'y', META_ONLY,  "Simulate()" },
   { 'z', META_ONLY,  "ZoomIn()" },
   { '9', META_ONLY,  "SpecifyAnArc()" },
   { '0', META_ONLY,  "Update()" },
   { ',', META_ONLY,  "ScrollUp()" },
   { '.', META_ONLY,  "ScrollDown()" },
   { '-', META_ONLY,  "ShowAttr()" },
   { '{', META_ONLY,  "AlignObjsTop()" },
   { '+', META_ONLY,  "AlignObjsMiddle()" },
   { '}', META_ONLY,  "AlignObjsBottom()" },
   { '[', META_ONLY,  "AlignObjsLeft()" },
   { '=', META_ONLY,  "AlignObjsCenter()" },
   { ']', META_ONLY,  "AlignObjsRight()" },
   { '"', META_ONLY,  "MakeRegPolygon()" },
   { '%', META_ONLY,  "SetReduction()" },
   { ':', META_ONLY,  "DefaultZoom()" },
   { '`', META_ONLY,  "ZoomWayOut()" },
   { '~', META_ONLY,  "SaveNew()" },
   { ';', META_ONLY,  "CutBit/Pixmap()" },
   { '_', META_ONLY,  "AbutHorizontal()" },
   { '|', META_ONLY,  "AbutVertical()" },
   { '#', META_ONLY,  "BreakUpText()" },
   { '^', META_ONLY,  "ScrollToOrig()" },
   { '@', META_ONLY,  "ToggleMoveMode()" },
   { '$', META_ONLY,  "SelectVertexMode()" },
   { '&', META_ONLY,  "AlignToPage()" },
   { '*', META_ONLY,  "Redo()" },
   { '(', META_ONLY,  "ImportEPSFile()" },
   { ')', META_ONLY,  "PreciseScale()" },
   { '<', META_ONLY,  "Lock()" },
   { '>', META_ONLY,  "UnLock()" },
/* Control Meta Keys */
   { 'a', CNTRL_META, "AddPoint()" },
   { 'b', CNTRL_META, "Bold()" },
   { 'c', CNTRL_META, "Center()" },
   { 'd', CNTRL_META, "DeletePoint()" },
   { 'e', CNTRL_META, "DrawRCBox()" },
   { 'f', CNTRL_META, "InvertXBitmap()" },
   { 'g', CNTRL_META, "ToggleSnap()" },
   { 'h', CNTRL_META, "HideAttr()" },
   { 'i', CNTRL_META, "MakeIconic()" },
   { 'j', CNTRL_META, "UnMakeIconic()" },
   { 'k', CNTRL_META, "ToggleBW/ColorPS()" },
   { 'l', CNTRL_META, "Left()" },
   { 'm', CNTRL_META, "MakeSymbolic()" },
   { 'n', CNTRL_META, "UnMakeSymbolic()" },
   { 'o', CNTRL_META, "Roman()" },
   { 'p', CNTRL_META, "BoldItalic()" },
   { 'q', CNTRL_META, "DrawPolygon()" },
   { 'r', CNTRL_META, "Right()" },
   { 's', CNTRL_META, "SaveSelectedAs()" },
   { 't', CNTRL_META, "Italic()" },
   { 'u', CNTRL_META, "UpdateSymbols()" },
   { 'v', CNTRL_META, "DrawOval()" },
   { 'w', CNTRL_META, "ToggleLineType()" },
   { 'x', CNTRL_META, "CyclePrintFormat()" },
   { 'y', CNTRL_META, "Paste()" },
   { 'z', CNTRL_META, "DrawArc()" },
   { '.', CNTRL_META, "ImportXBitmap()" },
   { ',', CNTRL_META, "ImportXPixmap()" },
   { '-', CNTRL_META, "ToggleGridSystem()" },
/* Miscellaneous */
   { '\0', 0, "ScrollPageUp()" },
   { '\0', 0, "ScrollPageDown()" },
   { '\0', 0, "ScrollPageLeft()" },
   { '\0', 0, "ScrollPageRight()" },
   { '\0', 0, "FlushUndoBuffer()" },
   { '\0', 0, "PrintMsgBuffer()" },
   { '\0', 0, "SaveOrigin()" },
   { '\0', 0, "RestoreImageWH()" },
   { '\0', 0, "UpdateEPS()" },
   { '\0', 0, "ToggleMapShown()" },
   { '\0', 0, "ToggleUseGrayScale()" },
   { '\0', 0, "FreeHandMode()" },
   { '\0', 0, "SaveSymInLibrary()" },
   { '\0', 0, "" }
};

static int	maxShortCuts = 0;
static int	shortCutIndex[256];

void InitShortCut ()
{
   register int	i, j;
   unsigned int	code;
   int		precise_match, ok, len;
   char		* c_ptr, * saved_c_ptr, * tmp_c_ptr, * buf;

   for (i = 0; i < 256; i++) shortCutIndex[i] = INVALID;

   maxShortCuts = 0;
   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "ShortCuts")) == NULL)
      return;

   len = strlen (c_ptr);
   if ((buf = (char *) calloc (len+1, sizeof(char))) == NULL)
   {
      fprintf (stderr, "Warning:  Can not calloc() to process shortcuts.\n");
      return;
   }
   while (*c_ptr!=':' && *c_ptr!='!' && *c_ptr!='<' && *c_ptr!='\0') c_ptr++;
   while (*c_ptr != '\0')
   {
      saved_c_ptr = c_ptr;
      precise_match = FALSE;
      ok = TRUE;
      if ((*c_ptr==':' || *c_ptr=='!') && strncmp(&c_ptr[1],"<Key>",5)==0)
      {
         precise_match = TRUE;
         strcpy (buf, &c_ptr[6]);
      }
      else if (strncmp(c_ptr,"<Key>",5)==0)
         strcpy (buf, &c_ptr[5]);
      else
         ok = FALSE;

      if (ok)
      {
         tmp_c_ptr = buf;
         while (*tmp_c_ptr != ')' && *tmp_c_ptr != '\0') tmp_c_ptr++;
         if (*tmp_c_ptr == '\0')
            ok = FALSE;
         else
         {
            *(++tmp_c_ptr) = '\0';
            code = buf[0]&0xff;
            if (buf[0] != '\0' && buf[1] == ':' &&
                  (code>0x20 && code<=0x7f || code>0xa0 && code<=0xff))
            {
               for (j = 0; *(shortCutXlateTbl[j].name) != '\0'; j++)
                  if (strcmp (shortCutXlateTbl[j].name, &buf[2]) == 0)
                  {
                     if (shortCutIndex[code] != INVALID)
                        fprintf (stderr, "Warning:  %s for '%c'.\n",
                              "duplicate shortcut entry", code);
                     shortCutIndex[code] = j;
                     if (!precise_match)
                     {
                        if (*buf>='a' && *buf<='z')
                        {
                           code = *buf-'a'+'A';
                           if (shortCutIndex[code] != INVALID)
                              fprintf (stderr, "Warning:  %s for '%c'.\n",
                                    "duplicate shortcut entry", code);
                           shortCutIndex[code] = j;
                        }
                        else if (*buf>='A' && *buf<='Z')
                        {
                           code = *buf-'A'+'a';
                           if (shortCutIndex[code] != INVALID)
                              fprintf (stderr, "Warning:  %s for '%c'.\n",
                                    "duplicate shortcut entry", code);
                           shortCutIndex[code] = j;
                        }
                     }
                     maxShortCuts++;
                     break;
                  }
               if (*(shortCutXlateTbl[j].name) == '\0')
                  fprintf (stderr, "Invalid shortcut entry:  '%s'; skipped.\n",
                        buf);
            }
            else
               fprintf (stderr, "Invalid shortcut entry:  '%s'; skipped.\n",
                     buf);
         }
      }
      if (ok)
      {
         while (*c_ptr!=')' && *c_ptr!='\0') c_ptr++;
         while (*c_ptr!=':' && *c_ptr!='!' && *c_ptr!='<' && *c_ptr!='\0')
            c_ptr++;
      }
      else
      {
         fprintf (stderr, "Invalid shortcut:  '%s'.\n", saved_c_ptr);
         break;
      }
   }
   free (buf);
}

int FetchShortCut (c, code, state, name)
   char		c, * code, * * name;
   unsigned int	* state;
{
   if (shortCutIndex[c] == INVALID) return (FALSE);

   *code = shortCutXlateTbl[shortCutIndex[c]].code;
   *state = shortCutXlateTbl[shortCutIndex[c]].state;
   *name = shortCutXlateTbl[shortCutIndex[c]].name;
   return (TRUE);
}
