/* bitorder.h: how to pack the bits */

#ifdef X11DVI

/* definitions for X11: pack into char, top row first */
#define BYTE            unsigned char
#define BYTESIZE        8
#define BYTEMASK        (BYTESIZE-1)
#define BYTESHIFT       3
/* position of start of row n: top row first */
#define row_start(n) (&(bits[(max_n-n)*rowbytes]))

#else /* ~X11DVI */
#ifdef XDVI

/* definitions for X11: pack into short, top row first */
#define BYTE            unsigned short
#define BYTESIZE        16
#define BYTEMASK        (BYTESIZE-1)
#define BYTESHIFT       4
/* position of start of row n: top row first */
#define row_start(n) (&(bits[(max_n-n)*rowbytes]))

#else /* ~X11DVI && ~XDVI */

/* definitions for Postscript: pack into bytes, MSBit/bottom row first */
#define BYTE            unsigned char
#define BYTESIZE        8
#define BYTEMASK        (BYTESIZE-1)
#define BYTESHIFT       3
#undef LSBITFIRST
#undef MSBITFIRST
#define MSBITFIRST
/* position of start of row n: bottom row first */
#define row_start(n) (&(bits[(n-min_n)*rowbytes]))

#endif
#endif

#ifdef MSBITFIRST
/* bit within BYTE for a given m: MSBit first */
#define m_bit(m) (BYTEMASK-(m-min_m)&BYTEMASK)
#define BITORDER MSBFirst
#else
/* bit within BYTE for a given m: LSBit first */
#define m_bit(m) ((m-min_m)&BYTEMASK)
#define BITORDER LSBFirst
#endif

/* BYTE within within a row containing bit m */
#define m_byte(m) ((m-min_m)>>BYTESHIFT)

#ifdef MSBYTEFIRST
#define BYTEORDER MSBFirst
#else
#define BYTEORDER LSBFirst
#endif

