/*  mfs.h       -- data about a Minix file system */
/*  Copyright 1988,1991 Steven W. Harrold. All rights reserved. */
/*  $Header: MFS.H_V 1.7 91/04/05 15:52:01 SWH Exp $ */

#define VERSION "1.1 (910405)"

/* Determine what compiler we are using.  The supported ones are:
**
**      TurboC
**      Microsoft C
*/

#if defined(__TURBOC__)
#define TURBOC
#endif

#if defined(M_I86)
#define MSC
#endif


#include    "mfs.x"

#define EXTERN      extern  /* used in *.h files */
#define PRIVATE     static  /* PRIVATE x limits the scope of x */
#define PUBLIC              /* PUBLIC is the opposite of PRIVATE */
#define FORWARD             /* some compilers require this to be 'static' */

#define BOOL        int
#define TRUE        1
#define FALSE       0


#define SECTOR_SIZE 512         /* physical sector size in bytes */
#define BLOCK_SIZE  1024        /* # of bytes in a disk block */
#define ZONE_SIZE   7           /* # of zones in an inode */
#define NAME_SIZE   14          /* # of bytes in a directory component */
#define SUPER_MAGIC 0x137F      /* magic number in super block */
#define MAX_PATH    128         /* max length of path names */

#define I_TYPE          0170000     /* bits that tell inode type */
#define I_REGULAR       0100000     /* regular file, not dir or spec */
#define I_BLOCK_SPECIAL 0060000     /* block special file */
#define I_DIRECTORY     0040000     /* i_mode says file is a directory */
#define I_CHAR_SPECIAL  0020000     /* character special file */
#define I_SET_UID_BIT   0004000     /* set effective uid on exec */
#define I_SET_GID_BIT   0002000     /* set effective gid on exec */
#define RWX_MODES       0000777     /* mode bits for r,w,x only */
#define R_BIT           0000004     /* Rwx protection bit */
#define W_BIT           0000002     /* rWx protection bit */
#define X_BIT           0000001     /* rwX protection bit */

#define BOOT_BLOCK  0           /* block number of boot block */
#define SUPER_BLOCK 1           /* block number of super block */
#define ROOT_INODE  1           /* inode number for root directory */

#define DRIVES  "ABCDEFGHIJKLMNOPQRSTUVWXYZ"

typedef unsigned char   byte ;
typedef unsigned short  ushort ;
typedef unsigned long   ulong ;


struct super_block              /* super block, as it is on disk */
{
    ushort  s_ninodes ;
    ushort  s_nzones ;
    ushort  s_imap_blocks ;
    ushort  s_zmap_blocks ;
    ushort  s_firstdatazone ;
    ushort  s_log_zone_size ;
    ulong   s_max_size ;
    ushort  s_magic ;
} ;

struct inode                    /* an i-node */
{
    ushort  i_mode ;
    ushort  i_uid ;
    ulong   i_size ;
    ulong   i_modtime ;
    byte    i_gid ;
    byte    i_nlinks ;
    ushort  i_zone[ZONE_SIZE] ;
    ushort  i_ind ;
    ushort  i_dbl_ind ;
} ;

struct directory                /* a directory block */
{
    ushort  d_inum ;            /* 0=empty entry */
    char    d_name[NAME_SIZE] ; /* terminated by \0 char or maxlen */
} ;


/*---eof---*/
