echo off
rem
rem ͻ
rem  First, we display a warning message if our hard disk is more than      
rem  75% full (/df:*:75).  The * matches the default disk drive.  To specify
rem  the "C:" drive, you could use "/df:C:75".  The                         
rem  /c:7070F4 demonstrates the use of a different color combination, and   
rem  /ns turns off the sound effects.                                       
rem                                                                         
rem  If the disk IS filling up, then we run the PCMANAGE program to         
rem  compress the disk.  To run the program only if it has been more        
rem  than 5 days since it was last run then change the /i:0 to /i:5.        
rem                                                                         
rem  The file r2_full.msg looks like this:                                  
rem                                                                         
rem       Warning, this disk is %P percent full!                            
rem                                                                         
rem       (Press any key to continue...)                                    
rem                                                                         
rem ͼ
lcg_rmnd /i:0 /df:*:75 /c:7070f4 /m:r2_full.msg /ns /d:r2_pcman.dat
if not errorlevel 1 goto :CHECK1
echo -----------------------------------------
echo Beginning PCMANAGE compression program...
echo pcmanage
lcg_rmnd /reset /d:r2_pcman.dat 
echo -----------------------------------------
:CHECK1
rem
rem ͻ
rem  Next, we use LCG/Remind to ask whether or not to load                  
rem  our print spooler.  Using /i:0 ensures that it will trigger every      
rem  time the system is reboot.  The /l:5 gives us 5 seconds to answer the  
rem  question.  If no answer is given, the default is to go ahead and load  
rem  the spooler.                                                           
rem                                                                         
rem  The file r2_spool.msg looks like this:                                 
rem                                                                         
rem       Would you like to load the 64K                                    
rem       print spooler?  %C                                                
rem ͼ
lcg_rmnd /i:0 /m:r2_spool.msg /l:5
if errorlevel 4 goto :CHECK1
if errorlevel 3 goto :NOSPOOL
echo ------------------------
echo Loading print spooler...
echo superspl lpt1:/m=64
echo ------------------------
:NOSPOOL
rem 
rem ͻ
rem  This runs our disk optimizer, VOPT.EXE no more than once per day  
rem  (/i:1), and only if it is before 10:00 AM (/tb:1000).             
rem           LCG/Remind will track using the date file r2_vopt.dat. No
rem  message will be displayed (/m:).  If the program triggers the     
rem  errorlevel will be set to 1, otherwise it will be set to 0.       
rem ͼ
lcg_rmnd /i:1 /d:r2_vopt.dat /m: /tb:1000
if not errorlevel 1 goto :CHECK2
echo -----------------------------
echo Beginning the Vopt program...
echo vopt c:
lcg_rmnd /reset /d:r2_vopt.dat 
echo -----------------------------
:CHECK2
rem 
rem ͻ
rem                                                                     
rem  In general, we do a complete back-up once a month, or whenever     
rem  we accumulated more than 1 MB of new files.  We do incremental     
rem  back-ups every 5 days.  The next command line will trigger on      
rem  the first of each month (/e:01), or, if we are out of the          
rem  office on the first, will trigger at least every 33 days, or       
rem  whenever there is more than 5 MB of data on the c: drive in        
rem  files with their archive bit set (/kt:5000 /pa:a:c:\*.*), but      
rem  NOT if there has been a complete backup in the past 4 days (/n:4). 
rem  When triggered, it will display the following multiple choice      
rem  message (/m:r2_month.msg):                                         
rem                                                                     
rem            You last made a complete disk backup                     
rem            on %d, and there are %f files that have                  
rem            changed since then (%k KB of data).                      
rem                                                                     
rem               1 -- Quit                                             
rem               2 -- Make an incremental backup (new files only)      
rem               3 -- Make a complete disk backup                      
rem                                                                     
rem               Your Choice -- %c                                     
rem                                                                     
rem  LCG/Remind will return an errorlevel of 0 if not triggered, or,    
rem  if triggered will set it according to the answer to the            
rem  question displayed.  Because this is a complicated question we     
rem  will allow 180 seconds for an answer (/l:180).                     
rem                                                                     
rem ͼ
lcg_rmnd /i:33 /e:01 /n:4 /kt:5000 /pa:a:c:\*.* /d:r2_all.dat /m:r2_month.msg /l:180
if errorlevel 4 goto :CHECK2
if errorlevel 3 goto :COMPLETE
if errorlevel 2 goto :NEWONLY
if errorlevel 1 goto :DONE
goto :CHECK3
:COMPLETE
echo ----------------------------
echo Beginning complete backup...
echo pcbackup all.set
lcg_rmnd /reset /d:r2_all.dat 
echo ----------------------------
goto :DONE
:CHECK3
rem 
rem ͻ
rem  The next series will "force" a backup if it has been more than 10  
rem  days, suggest one every Monday, or if it has been more than 5 days,
rem  and show a friendly message if the backup has been within the past 
rem  5 days.  It determines this by examining the data files r2_all.dat 
rem  (created everytime a complete backup is made), and r2_new.dat      
rem  (created everytime an incremental backup of the new files is made).
rem                                                                     
rem  The file r2_force.msg contains this message:                       
rem                                                                     
rem            The last disk backup was %n days                         
rem            ago (on %d).                                             
rem                                                                     
rem            A new backup is overdue.                                 
rem                                                                     
rem  The file r2_ask.msg contains this message:                         
rem                                                                     
rem            Your hard disks have not been backed                     
rem            up in %n days (since %d).                                
rem                                                                     
rem            Would you like to run your backup                        
rem            program now? %c                                          
rem                                                                     
rem  The file r2_nice.msg looks like this:                              
rem                                                                     
rem            Your hard disk was last backed up                        
rem            on %d.                                                   
rem ͼ
lcg_rmnd /i:10 /d:r2*.dat /m:r2_force.msg /s
if errorlevel 1 goto :NEWONLY                
lcg_rmnd /w:1 /i:0 /n:5 /d:r2*.dat /m:r2_ask.msg
if errorlevel 4 goto :CHECK3
if errorlevel 3 goto :DONE
if errorlevel 2 goto :NEWONLY
goto :CHECK4
:NEWONLY
echo ------------------------------------------------
echo Beginning incremental backup (new files only)...
echo pcbackup new.set
lcg_rmnd /reset /d:r2_new.dat
echo ------------------------------------------------
goto :DONE
:CHECK4
lcg_rmnd /i:0 /d:r2*.dat /m:r2_nice.msg /l:5 /ns
:DONE
echo Done with remind_2.bat
