; TIMER.ASM
;
;  This file is the ASM source for TIMER.OBJ which is necessary for compiling
;  TIMER.PAS.
;  I've assembled it with TASM 2.0, but as it doesn't use any
;  assembler-specific features, I think all versions of TASM or MASM should
;  work.
;
;  Sorry, it's a french version, but I was too lazy to translate it all  :-)
;
;
;  This file may be freely copied or distributed for any non-commercial use.
;  If you modify it, please let me know so I can upgrade it easily.
;
;  For any question or suggestion, please e-mail me at :
;      p6ip329@cicrp.jussieu.fr     until the middle of September 1995,
;  or
;      willy@U40024.citi2.fr        after this date.
;  (In a future release, I'll give my new address.)
;
;  You can also mail me at home:
;
;      Willy TARREAU
;      23, rue Richepanse
;      78500 Sartrouville
;      FRANCE
;
;      PS: I also accept postcards  :-)
;
;                                                                Willy.
;

	name	Timer

; routines de gestion d'horloge et de chronomtrage prcis allant de 0  24
; heures par pas de 838,0953445 nanoseconde !!!
; De plus, la routine DELAY est redfinie car elle ne fonctionne pas sur les
; ordinateurs rapides tels que les 486.


data	segment	word public

	extrn	TempsInitial : dword
	extrn	HeureInitiale : word
	extrn	HeureActuelle : word

data	ends

code	segment	word public
	assume	cs:code,ds:data

	PUBLIC	InitPIT	; initialisation du PIT.Obligatoire 1 fois
	PUBLIC	TempsActuel; longint : nbre de pas de comptage.
	PUBLIC	TempsAZero; remet le Temps  0 pour une nlle mesure.

PIT0	dw	0
C46C	dw	0
C46E	dw	0

InitPIT	proc	far
	mov	al,34h	; mode gnrateur de rythme
	out	43h,al
	mov	al,0	; 18,206507 hertz.frquence normale.
	out	40h,al
	out	40h,al
	ret
InitPIT	endp

TempsActuel	proc	far
	push	es
	xor	ax,ax
	mov	es,ax
	mov	dx,word ptr es:[046Ch]	; 18mes de seconde
	mov	bx,word ptr es:[046Eh]	; heures
	pop	es
	mov	al,04h	; blocage instantan pour lecture rapide.
	out	43h,al
	in	al,40h
	mov	ah,al
	in	al,40h
	xchg	al,ah
	neg	ax
	cmp	ax,word ptr PIT0	; vrifie le saut de valeur
	ja	TpsActNorm
	cmp	dx,word ptr C46C
	ja	TpsActNorm
	cmp	bx,word ptr C46E
	ja	TpsActNorm
; si on arrive ici, c'est que le compte est pass  0 pdt la lecture.
; alors, DX = ancienne valeur et AX = nlle valeur.Solution : incrmenter DX
	add	dx,1
	adc	bx,0
TpsActNorm:	mov	word ptr PIT0,ax
	mov	word ptr C46C,dx
	mov	word ptr C46E,bx
	sub	ax,word ptr TempsInitial
	sbb	dx,word ptr TempsInitial+2
	sbb	bx,word ptr HeureInitiale
	mov	HeureActuelle,bx
	ret	; ici, DX:AX = Nbre d'impulsions depuis TempsAZero
TempsActuel	endp

TempsAZero	proc	far
	push	es
	xor	ax,ax
	mov	es,ax
	mov	dx,word ptr es:[046Ch]	; 18mes de seconde
	mov	bx,word ptr es:[046Eh]	; heures
	pop	es
	mov	al,04h	; blocage instantan pour lecture rapide.
	out	43h,al
	in	al,40h
	mov	ah,al
	in	al,40h
	xchg	al,ah
	neg	ax
	mov	word ptr TempsInitial,ax
	mov	word ptr TempsInitial+2,dx
	mov	word ptr HeureInitiale,bx
	ret
TempsAZero	endp

code	ends
	end
