/*
    Filename: C:\include\fileio.h
    Author  : Dave Nelson
    Created : Sun 27-Dec-1998 06:21:16
    Modified: Tue 05-Jan-1999 21:03:06 - Dave Nelson
*/

#ifndef fileio_h
    #define fileio_h

#if __cplusplus
    extern "C" {
#endif

/*Function: filecpy
      Descr: Copy source file to target file.  Note that an actual target
             filename must be provided.  This will not work:

                 filecopy("myfile","a:");

             The target file will retain the timestamp of the source file.

       Args: char *     - Source filespec.
             char *     - Target filespec.
     Return: long         Number of bytes moved, if >0.  Otherwise:
                            -1  =   Unable to open source file.
                            -2  =   Unable to open target file.
                            -3  =   Unable to allocate buffers.
*/
long filecpy(char *src, char *dst);


/*Function: dos2time_t
      Descr: Convert wacky DOS-style time/date to time_t (long int) format.
       Args: unsigned   - DOS date
             unsigned   - DOS time
     Return: long       - Converted time/date value.
*/
long dos2time_t(unsigned di, unsigned ti);


/*Function: time_t2dos
      Descr: Convert time_t (long int) time/date to wacky DOS format.
       Args: long       - Normal time/date value.
             unsigned * - Address to catch DOS date.
             unsigned * - Address to catch DOS time.
     Return: void
*/
void time_t2dos(long ts, unsigned *di, unsigned *ti);


/*Function: gettimestamp
      Descr: Get the last-modified timestamp from a DOS file.
       Args: char *     - File in question
     Return: long
*/
long gettimestamp(char *fn);


/*Function: settimestamp
      Descr: Set the last-modified timestamp on a DOS file.
       Args: char *     - File in question
             long       - New timestamp
     Return: int          Zero if successful.
*/
int settimestamp(char *fn, long ts);


#if __cplusplus
    }
#endif

#endif  // fileio_h
