/*
    Filename: C:\DAVE\CPP\FCPY\fcpy.cpp
    Author  : Dave Nelson
    Created : Sat 26-Dec-1998 10:07:30
    Modified: Thu 15-Jul-1999 17:40:27 - Dave Nelson

    Copyright 1998, 1999 by David S. Nelson
    Permission is hereby given to use this code in any way you see fit.

    This source compiles with Zortech C/C++ v3.0r4, for sure.  It will
    probably compile with any other respectable DOS-based C++ compiler,
    with nothing more than header file changes. See MAKEFILE for linkage.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <ctype.h>
#include "filepath.hpp"
#include "fileio.h"

#if 0
struct FIND		/* struct used by findfirst() and findnext()	*/
{
	struct stat stat;
	unsigned short attribute;/* attribute found (FA_XXXX)		*/
	unsigned short time,date;/* file's time and date		*/
	unsigned long size;	/* file's size				*/
	char name[16];		/* filename followed by 0 byte		*/
};
#endif

void showusage(char *nm){
    printf("\n"
        "Copies files to a floppy until it's full, then continues on another.\n"
        "\nUsage:\t%s src d [flags]\n"
        "\n...where src is a source filespec, d is a destination drive,"
        "\nand [flags] are optional and may include:"
        "\n\t-l\tWrite a log file.\t\t(not implemented)"
        "\n\t-c\tContinue from log file.\t\t(not implemented)"
        "\n\t-h\tInclude hidden/system files."
        "\n\t-r\tRecurse subdirectories.\t\t(not implemented)"
        "\n", nm);
    }

struct entry {
    char nm[13];
    unsigned long sz;
    };

extern "C" int qscompare(entry *a, entry *b){   // Note that this compare func
    return(a->sz<b->sz? 1:(a->sz>b->sz? -1:0)); // works BACKWARDS!  (We are
    }                                           // sorting in reverse order.)

int main(int argc, char **argv){
struct FIND *ff;
int hidden = 0;
int attr = 0xff ^ (FA_DIREC|FA_LABEL);  // no dirs or vol labels, please.
char *cp, *target=NULL;
filepath *source=NULL;

    filepath p = argv[0];
    fprintf(stderr,"%s\t\tCopyright (c) 1998-99, Dave Nelson\n",
        p.base());

    for(argc--; argc; argc--){
        cp = argv[argc];
        if(*cp=='-'||*cp=='/'){
            switch(toupper(*(++cp))){
            case 'C':                       // continue
            case 'L':                       // logfile
                break;
            case 'H':                       // hidden/system okay
                hidden = 1;
                break;
            case '?':
                showusage(p.base());
                return 0;
                }
            }
        else {
            if(!target) target = argv[argc];
            else if(!source) source = new filepath(argv[argc]);
            else {
                fprintf(stderr,"Too many arguments.  Use %s -? for help.\n",p.base());
                return 1;
                }
            }
        }       // for(argc...)

    if(!source || !target){
        fprintf(stderr,"Missing argument.  Use %s -? for help.",p.base());
        return 2;
        }

    if(!hidden) {
        attr ^= FA_HIDDEN;
        attr ^= FA_SYSTEM;
        }

    strupr(target);
    long sp = dos_getdiskfreespace(*target-0x40);
    if(sp>0) printf("Drive %c: has %ld bytes free.\n", *target, sp);
    else {
        fprintf(stderr,"Error reading drive %c:.\n", *target);
        return 4;
        }

    entry *e = NULL;
    int cnt = 0;
    ff = findfirst(source->full(), attr);
    while(ff){
        cnt++;
        e = realloc(e, sizeof(entry)*cnt);
        if(!e){
            fprintf(stderr,"Too many files!\n");
            return 4;
            }
        strcpy(e[cnt-1].nm, ff->name);
        e[cnt-1].sz = ff->size;
        ff = findnext();
        }

    qsort(e, cnt, sizeof(entry), qscompare);
    int i, done;
    i = done = 0;
    while(sp>0 && done<cnt){
        if(i>=cnt){
            printf("Drive %c: full!  Hit  to continue, Esc to quit, "
                "or enter new drive letter:",*target);
            if(toupper(getch())=='Q') break;
            printf("\n");
            i = 0;
            sp = dos_getdiskfreespace(*target-0x40);
            printf("Drive %c: has %ld bytes free.\n", *target, sp);
            }
        if(*e[i].nm && e[i].sz <= sp){
            printf("%-13s\t%ld\n", e[i].nm, e[i].sz);
            filepath s = e[i].nm;
            s.setdrive(source->drive());
            s.setpath(source->path());
            filepath d = target;
            d.setbase(s.base());
            d.setext(s.ext());
            filecpy(s.full(), d.full());
            sp -= e[i].sz;
            *e[i].nm = 0;
            done++;
            }
        i++;
        }

    e = realloc(e, 0);
    return 0;
    } 
