/*
** DUG_IDE : Provides IDE disk info on all (up to 8) drives in the system
**           Version 2.0
**
** Copyright (c) 26 Apr 1998 by Doug Merrett - All rights reserved
**
** Email Address:  dcm@ozemail.com.au
**
** You may distribute freely, but no modifications without mailing me a copy.
** No profit can be made for distribution.  Blah Blah Blah etc.
*/

#include <stdlib.h>
#include <dos.h>
#include <stdio.h>
#include <conio.h>

char *getascii (unsigned short in_data [], unsigned short off_start, unsigned short off_end);

void cls (void)  /* Clear Screen */
{
  union _REGS inregs, outregs;
  inregs.h.ah = 0;
  inregs.h.al = 2;                   /* 80 x 25 mode */
  _int86 (0x10, &inregs, &outregs);  /* BIOS call    */
}

int main (void)
{
  unsigned short dd [256];   /* DiskData */
  unsigned short dd_off;     /* DiskData offset */
  unsigned short drive;      /* Loop variable */
  unsigned long  wait_loop;  /* Timeout loop */
  unsigned short base;       /* Base address of drive controller */
  unsigned short in_val;


  cls ();
  fprintf (stderr, "** DUG_IDE : Provides IDE disk info on both drives in the system\n");
  fprintf (stderr, "** Version 2.0\n");
  fprintf (stderr, "**\n");
  fprintf (stderr, "** Copyright (c) 12 Jan 1993 by Doug Merrett - All rights reserved\n");
  fprintf (stderr, "**               25 Apr 1998 by Doug Merrett - Version 2.0\n");
  fprintf (stderr, "**\n");
  fprintf (stderr, "** Email Address:  dcm@ozemail.com.au\n");
  fprintf (stderr, "**\n");
  fprintf (stderr, "** You may distribute freely, but no modifications without mailing me a copy.\n");
  fprintf (stderr, "** No profit can be made for distribution.  Blah Blah Blah etc.\n");
  fprintf (stderr, "**\n");
  fprintf (stderr, "** The newer features in this release owe a great deal to Ralf Brown's\n");
  fprintf (stderr, "** Interrrupt List as I used the PORTS.LST file to get some more detailed\n");
  fprintf (stderr, "** information about the results passed back by the drive.\n\n");

  fprintf (stderr, "Press any key to accept above limitations");

  getch ();

  for (drive = 0; drive < 8; drive++)  /* Loop through drives */
    {
      /* Get IDE Drive info */

      switch (drive / 2)
        {
        case 0: base = 0x1f0;
                break;
        case 1: base = 0x170;
                break;
        case 2: base = 0x1e8;
                break;
        case 3: base = 0x168;
                break;
        }

      /* Wait for controller not busy */
      wait_loop = 100000;
      while (--wait_loop > 0)
        {
        in_val = inp (base + 7);
        if (((in_val & 0x40) == 0x40) || ((in_val & 0x00) == 0x00))
           break;
        }

      if (wait_loop < 1)
        continue;

      outp (base + 6, ((drive % 2) == 0 ? 0xA0 : 0xB0)); /* Get Master/Slave drive */

      outp (base + 7, 0xEC);          /* Get drive info data */

      /* Wait for data ready */
      wait_loop = 100000;
      while (--wait_loop > 0)
        {
        in_val = inp (base + 7);
        if ((in_val & 0x48) == 0x48) /* drive ready and needs service */
          break;
        if ((in_val & 0x01) == 0x01) /* drive error */
          break;
        }

      if ((wait_loop < 1) || ((in_val & 0x01) == 0x01)) /* Timed Out or Error */
        continue;

      for (dd_off = 0; dd_off != 256; dd_off++) /* Read "sector" */
        dd [dd_off] = inpw (base);

      cls ();
      switch (drive / 2)
        {
        case 0: fprintf (stdout, "Primary ");
                break;
        case 1: fprintf (stdout, "Secondary ");
                break;
        case 2: fprintf (stdout, "Tertiary ");
                break;
        case 3: fprintf (stdout, "Quaternary ");
                break;
        }

      fprintf (stdout, "Controller - ");

      switch (drive % 2)
        {
        case 0: fprintf (stdout, "Master");
                break;
        case 1: fprintf (stdout, "Slave");
                break;
        }

      fprintf (stdout, " drive\n\n");

      fprintf (stdout, "Model Number______________________: %s\n", getascii (dd, 27, 46));
      fprintf (stdout, "Serial Number_____________________: %s\n", getascii (dd, 10, 19));
      fprintf (stdout, "Controller Revision Number________: %s\n\n", getascii (dd, 23, 26));
      if (dd [80] != 0 && dd [80] != 0xFFFF)
        fprintf (stdout, "ATA Version Number________________: %u.%u\n", dd [80], (dd [81] == 0xFFFF ? 0 : dd [81]));

      fprintf (stdout, "Able to do Double Word Transfer___: %s\n", (dd [48] == 0 ? "No" : "Yes"));
      fprintf (stdout, "Controller buffer size (bytes)____: %u\n", dd [21] * 512);
      fprintf (stdout, "Transfer Speed____________________: ");
      if (dd [0] & 0x0400)
        fprintf (stdout, "> 10 Mbit/sec\n");
      if (dd [0] & 0x0200)
        fprintf (stdout, "5-10 Mbit/sec\n");
      if (dd [0] & 0x0100)
        fprintf (stdout, "< 5 Mbit/sec\n");
      fprintf (stdout, "Drive Type________________________: ");
      if (dd [0] & 0x0080)
        fprintf (stdout, "Removable\n");
      if (dd [0] & 0x0040)
        fprintf (stdout, "Fixed\n");
      fprintf (stdout, "IORDY Supported___________________: %s\n", ((dd [49] & 0x0800) ? "Yes" : "No"));
      fprintf (stdout, "Can IORDY be disabled by device___: %s\n", ((dd [49] & 0x0400) ? "Yes" : "No"));
      fprintf (stdout, "LBA Mode supported________________: %s\n", ((dd [49] & 0x0200) ? "Yes" : "No"));
      fprintf (stdout, "DMA Supported_____________________: %s\n", ((dd [49] & 0x0100) ? "Yes" : "No"));
      fprintf (stdout, "Number of ECC bytes transferred___: %u\n", dd [22]);
      fprintf (stdout, "Number of sectors per interrupt___: %u\n\n", dd [47] % 256);
      fprintf (stdout, "Number of Cylinders_______________: %u\n", dd [1]);
      fprintf (stdout, "Number of Heads___________________: %u\n", dd [3]);
      fprintf (stdout, "Number of Sectors per Track_______: %u\n\n", dd [6]);

      fprintf (stdout, "Press a key");
      fflush (stdout);
      getch ();

    }
  return 1;
}

char *getascii (unsigned short in_data [], unsigned short off_start, unsigned short off_end)
{
  static char ret_val [255];
  int loop, loop1;

  for (loop = off_start, loop1 = 0; loop <= off_end; loop++)
    {
      ret_val [loop1++] = (char) (in_data [loop] / 256);  /* Get High byte */
      ret_val [loop1++] = (char) (in_data [loop] % 256);  /* Get Low byte */
    }
  ret_val [loop1] = '\0';  /* Make sure it ends in a NULL character */
  return (ret_val);
}