/*************************************************************
 *                                                           *
 * Program DCOPY - physical sector to sector copy     	     *
 * Copyright (c) 1986 Joerg Genius, Munich, West-Germany     *
 *                                                           *
 * Rev. 3.1.1 fixed verify by supplying length to memcpy()   *
 * Rev. 3.1.2 added /r command to verify only                *
 * Rev. 3.3.0 added support for 3.5" disks                   *
 *************************************************************/

#include <stdio.h>
#include <alloc.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>
#include "dcdefs.h"


dcopy (von,nach,verify)

int von,nach,verify;

{
   struct drive_data source,destination;

   char *ver_buffer;
   unsigned int blcnt=0;
   unsigned int max_blocks;
   int error;

   if (verify!=0) {
      if ((ver_buffer=malloc(512*blk_p_buffer))==NULL) {
         fprintf (stderr,text[2]);
         return 1;
      }
   }
   if (get_drive_data(von,&source)!=0)
      return 1;
   if (get_drive_data(nach,&destination)!=0)
      return 1;
   if (source.cluster_p_drive!=destination.cluster_p_drive ||
       source.sec_p_cluster  !=destination.sec_p_cluster   ||
       source.bytes_p_sec     !=destination.bytes_p_sec) {
      fprintf (stderr,text[14]);
      return 1;
   }
   max_blocks=get_max_blocks(source.sec_p_drive);
   printf (text[8],d_types[disk_type]);
   if (verify!=2)
      printf (text[15],source.sec_p_drive,von+'A',nach+'A');
   else
      printf (text[26],source.sec_p_drive,von+'A',nach+'A');
   for (blcnt=0;blcnt<source.sec_p_drive;blcnt+=max_blocks) {
      max_blocks=(blcnt+max_blocks>=source.sec_p_drive ? source.sec_p_drive-blcnt : max_blocks);
      if ((error=read_block(von,blcnt,max_blocks,disk_buffer))!=0) {
      	 fprintf (stderr,text[10],error,err_text[error]);
      	 return 1;
      }
      if (verify!=2) {
         if ((error=write_block(nach,blcnt,max_blocks,disk_buffer))!=0) {
            fprintf (stderr,text[16],error,err_text[error]);
            return 1;
         }
      }
      if (verify!=0) {
         if ((error=read_block(nach,blcnt,max_blocks,ver_buffer))!=0) {
            fprintf (stderr,text[17],error,err_text[error]);
            return 1;
         }
         if (memcmp(disk_buffer,ver_buffer,512*max_blocks)!=0) {
            fprintf (stderr,text[18]);
            return 1;
         }
      }
   }
   if (verify!=2)
      printf (text[19],source.sec_p_drive,von+'A',nach+'A');
   else
      printf (text[27],source.sec_p_drive,von+'A',nach+'A');
   return 0;
}

