#include <stdio.h>
#include "dv.h"

main()
{
   OBJECT *wind1;
   OBJECT *wind2;
   OBJECT *pointer;
   int pypos = 0, pxpos = 0, button = 0;
   char *str = "                                ";

   if( ! dv_installed() )
   {
      puts( "This program requires DesqView" );
      exit( 1 );
   }

   wind1 = dv_gethandle( MY_WINDOW, NULL );

   dv_visible( OFF, wind1 );
   dv_resize( 5, 30, wind1 );
   dv_poswindow( 1, 1, wind1 );
   dv_color( 0x1F, wind1 );
   dv_cls( wind1 );
   dv_rename( "Test_program", wind1 );
   dv_setcursorpos( 1, 3, wind1 );
   dv_putswindow( (char far *)"DesqView Test program...", 24, wind1 );
   dv_setcursorpos( 3, 8, wind1 );
   dv_putswindow( (char far *)"Press any key...", 16, wind1 );
   dv_visible( ON, wind1 );
   dv_redraw( wind1 );

   getch();

   dv_cls( wind1 );
   dv_setcursorpos( 3, 5, wind1 );
   dv_putswindow( (char far *)"Make a child window.", 20, wind1 );
   wind2 = dv_newwindow( 5, 30, wind1 );

   dv_visible( OFF, wind2 );
   dv_color( 0x4E, wind2 );
   dv_cls( wind2 );
   dv_poswindow( 3, 3, wind2 );
   dv_setcursorpos( 2, 5, wind2 );
   dv_putswindow( (char far *)"Independent movement", 20, wind2 );
   dv_visible( ON, wind2 );
   dv_redraw( wind2 );

   dv_cls( wind1 );
   dv_setcursorpos( 1, 1, wind1 );
   dv_putswindow( (char far *)" Use the DV menu to move\r\n", 26, wind1 );
   dv_putswindow( (char far *)" the window. Exit the\r\n", 23, wind1 );
   dv_putswindow( (char far *)" DV menu and press a key\r\n", 26, wind1 );
   dv_putswindow( (char far *)" to continue...\r\n", 17, wind1 );
   dv_redraw( wind1 );
   getch();

   dv_attach( ON, wind2 );
   dv_offsetwin( wind1, wind2, OFF_HRIGHT | OFF_VBOTTOM, 7, 16 );
   dv_cls( wind2 );
   dv_setcursorpos( 2, 6, wind2 );
   dv_putswindow( (char far *)"Attached movement.", 18, wind2 );
   dv_redraw( wind2 );
   getch();

   dv_freeobj( GENERIC, wind2 );
   dv_cls( wind1 );
   dv_setcursorpos( 2, 4, wind1 );
   dv_putswindow( (char far *)"Check mouse status...\r\n", 23, wind1 );
   dv_redraw( wind1 );

   if( dv_kmouse( KMOUSE_STAT ) != IS_REALMOUSE )
      dv_kmouse( KMOUSE_ON );

   pointer = dv_createobj( MAKE_POINTER, NULL );
   dv_openobj( GENERIC, wind1, NULL, pointer );
   dv_cls( wind1 );
   dv_setcursorpos( 0, 0, wind1 );
   dv_color( 0x1C, wind1 );
   dv_putswindow( (char far *)"ͻ\r\nQUIT\r\nͼ", 22, wind1 );
   dv_setcursorpos( 1, 7, wind1 );
   dv_color( 0x1F, wind1 );
   dv_putswindow( (char far *)"Press LEFT button or", 20, wind1 );
   dv_setcursorpos( 2, 8, wind1 );
   dv_putswindow( (char far *)"HOME to quit test.", 18, wind1 );
   dv_redraw( wind1 );
   dv_color( 0x1E, wind1 );

   while( 1 )
   {
      dv_ptrstat( &pypos, &pxpos, &button, pointer );
      if( pypos == 1 && ( pxpos > 0 && pxpos < 5 ) && button == 1 )
	 break;
      sprintf( str, "Y=%d X=%d B=%d       ", pypos, pxpos, button );
      dv_setcursorpos( 4, 0, wind1 );
      dv_putswindow( (char far *)str, strlen( str ), wind1 );
      dv_redraw( wind1 );
   }

   for( button = 0; button < 5; button++ )
   {
      dv_setcursorpos( 0, 0, wind1 );
      dv_color( 0x1C, wind1 );
      dv_putswindow( (char far *)"ͻ\r\nQUIT\r\nͼ", 22, wind1 );
      dv_redraw( wind1 );
      for( pypos = 0; pypos < 5000; pypos++ );

      dv_setcursorpos( 0, 0, wind1 );
      dv_color( 0x41, wind1 );
      dv_putswindow( (char far *)"ͻ\r\nQUIT\r\nͼ", 22, wind1 );
      dv_redraw( wind1 );
      for( pypos = 0; pypos < 5000; pypos++ );
   }
}
