;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1993 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File XDI.ASM			<Description>			*
;*									*
;************************************************************************
;LastEdit: 1/13/93

	INCLUDE	API.INC
	MIN_VERSION 2,26

	Header@

MAX_XDI_FUNC equ 10h

;========================================================================

DSeg@
initialized	db 0
PubSym@ XDI_MULTIPLEX_NUMBER,<DB 0DEh>,__PASCAL__

DSegEnd@

;========================================================================

CSeg@

ExtProc@ DVATEXIT,__PASCAL__


XDI_jumptable	db (MAX_XDI_FUNC+1)*cPtrSize

xdi_handler proc far
	cmp	ah,0DEh
$xdi$multiplex equ byte ptr ($-1)
	je	is_xdi
jmp_to_old:
	db	0EAh			; FAR JMP
old_INT2F dd	?

is_xdi:
	cmp	al,MAX_XDI_FUNC
	ja	jmp_to_old
	push	bx
	push	ax
	xor	bx,bx
	mov	bl,al
	add	bx,bx
IF LPROG
	add	bx,bx
ENDIF
	mov	ax,cs:[bx]
IF LPROG
	or	ax,cs:[bx+2]
ELSE
	or	ax,ax
ENDIF
	jz	skip_XDI

	pop	ax
	pop	bx


	iret

skip_XDI:
	pop	ax
	pop	bx
	jmp	jmp_to_old

xdi_handler endp

;------------------------------------------------------------------------
; determine whether an XDI driver is present on multiplex number AH

check_XDI proc near
	ASSUME	DS:DGROUP
	push	es
	push	ds
	push	bp
	push	di
	push	si
	push	dx
	push	cx
	push	bx
	push	ax
	mov	al,0
	mov	bx,4456h
	mov	cx,5844h
	mov	dx,4931h
	int	2Fh
	cmp	al,0FFh
	jne	check_XDI_no
	cmp	bx,4845h
	jne	check_XDI_no
	cmp	cx,5245h
	jne	check_XDI_no
	cmp	dx,4456h
	jne	check_XDI_no
check_XDI_yes:
	clc
	jmp short check_XDI_done

check_XDI_no:
	cmp	al,0
	jne	check_XDI_none
	cmp	XDI_multiplex_number,0
	jne	check_XDI_none
	pop	ax			; restore AX
	push	ax
	mov	XDI_multiplex_number,ah
check_XDI_none:
	stc
check_XDI_done:
	pop	ax
	pop	bx
	pop	cx
	pop	dx
	pop	si
	pop	di
	pop	bp
	pop	ds
	pop	es
	ret
check_XDI endp

;------------------------------------------------------------------------

PubProc@ XDIINIT,__PASCAL__
	SET_DS	ax
	mov	al,1
	xchg	al,DGROUP:initialized	; get and set 'init' flag
	or	al,al
	jnz	XDIinit_done
find_XDI:
	mov	ah,0DEh
find_XDI_loop:
	call	check_XDI
	jnc	found_XDI
	inc	ah
	cmp	ah,0DEh 		; if we make it back to DEh, there is
	je	no_XDI			;   no prior XDI driver loaded
	or	ah,ah
	jnz	find_XDI_loop
	mov	ah,0C0h
	jmp	find_XDI_loop

no_XDI:
	mov	ah,0
found_XDI:
	mov	XDI_multiplex_number,ah
	mov	$xdi$multiplex,ah	; patch our XDI handler
	mov	ax,offset __TEXT:XDIEXIT
	PUSHCPTR cs,ax
	call	DVATEXIT@
XDIinit_done:
	mov	al,XDI_multiplex_number
	mov	ah,0
	RESTORE_DS
	or	ax,ax
	ret
EndProc@ XDIINIT,__PASCAL__

;------------------------------------------------------------------------

PubProc@ XDIEXIT,__PASCAL__
	SET_DS
	mov	al,0
	xchg	al,DGROUP:initialized	; get and clear 'init' flag
	or	al,al
	jz	XDIexit_done



XDIexit_done:
	RESTORE_DS
	ret
EndProc@ XDIEXIT,__PASCAL__

;------------------------------------------------------------------------

PubProc@ XDIHANDLER,__PASCAL__
@num = word ptr [bp+2+2*cPtrSize]
@func = CPTR_ [bp+2+cPtrSize]
	push	bp
	mov	bp,sp


	pop	bp
	ret	2+cPtrSize
EndProc@ XDIHANDLER,__PASCAL__

CSegEnd@

	END
