/************************************************************************/
/*									*/
/*	DV-GLUE		DESQview and DESQview/X Function Library	*/
/*			(c) Copyright 1992 Ralf Brown			*/
/*			All Rights Reserved.				*/
/*									*/
/*	File UISIGNAL.C		Signal handling				*/
/*									*/
/************************************************************************/
/* LastEdit: 12/30/92							*/

#include <stdio.h>
#include "dvglue.h"
#include "dvstream.h"
#include "dvgui.h"

/*======================================================*/

#define FIRST_SIGNAL (MS_NOTIFY+DV_HMOVE)
#define LAST_SIGNAL  (MS_NOTIFY+DV_OTHER)

typedef struct _handler_list_
   {
   struct _handler_list_ *next, *same_window ;
   OBJECT window ;
   DVSIGNAL_HANDLER handlers[LAST_SIGNAL-FIRST_SIGNAL+1] ;
   long arg ;
   int id ; /* for identifying which item to delete */
   } HANDLER_LIST ;

/*======================================================*/

static HANDLER_LIST *signal_handlers = NULL ;
static int activated = 0 ;
static int sigID = 0 ;

/*======================================================*/
/*======================================================*/

static void UIsignal_handler(OBJECT window)
{
   NOTIFY_MSG msg ;
   int event ;
   int status ;
   HANDLER_LIST *handlers, *hnd ;

   window = DVcanon_handle(window) ;  /* canonicalize window's handle */
   handlers = signal_handlers ;
   while (handlers && handlers->window != window)
      handlers = handlers->next ;
   while (DVmbx_size(NIL) > 0)
      {
      (void) DVreadmail(NIL,(char *)&msg,sizeof(msg)) ;
      if (handlers)
	 {
	 status = DVmbx_status(NIL) ;
	 if (status != 0x80 || msg.event < FIRST_SIGNAL || msg.event > LAST_SIGNAL)
	    event = DV_OTHER ;
	 else
	    event = msg.event - MS_NOTIFY ;
	 for (hnd = handlers ; hnd ; hnd = hnd->same_window)
	    if (hnd->handlers[event])
	       (*(hnd->handlers[event]))(window,&msg,hnd->arg) ;
	 }
      }
}

/*======================================================*/
/*======================================================*/

static void UIsignal_atexit(void)
{
   HANDLER_LIST *hand1, *hand2 ;
   
   while (signal_handlers)
      {
      DVwin_async(signal_handlers->window,NULL,0) ;
      hand1 = signal_handlers ;
      signal_handlers = signal_handlers->next ;
      while (hand1)
	 {
	 hand2 = hand1 ;
	 hand1 = hand1->same_window ;
	 free(hand2) ;
	 }
      }
}

/*======================================================*/
/* UIsignal   set up handlers for specified notify msgs */
/*======================================================*/

int pascal UIsignal(OBJECT window,int direction,int num_signals,
	            SIGNAL_LIST *signals,long arg,int stacksize)
{
   int i, ID, signal ;
   HANDLER_LIST *handlers, *prev ;

   if (window == NIL)
      window = DVmywindow() ;
   if (direction == DVSIG_ADD)
      {
      if (!activated)
	 {
	 DVatexit(UIsignal_atexit) ;
	 activated = TRUE ;
	 }
      for (i = 0 ; i < num_signals ; i++)
	 if (signals[i].signal < DV_HMOVE || signals[i].signal > DV_OTHER)
	    return DVSIG_ERROR ;
      if ((handlers = (HANDLER_LIST *)calloc(1,sizeof(HANDLER_LIST))) == NULL)
	 return DVSIG_NOMEM ;
#if 0 /* don't need following inits, done implicitly by calloc() */
      handlers->next = handlers->same_window = NULL ;
      for (i = 0 ; i < lengthof(handlers->handlers) ; i++)
	 handlers->handlers[i] = NULL ;
#endif /* 0 */
      ID = ++sigID ;
      if (ID == DVSIG_MAXID)
	 sigID = 0 ;		/* wrap back to first identifier number */
      handlers->arg = arg ;
      handlers->id = ID ; /* to be able to identify this block later */
      handlers->window = window ;
      /* add the new handler structure to the end of the list */
      if (signal_handlers)
	 {
	 for (prev = signal_handlers ; prev->next ; prev = prev->next)
	    if (prev->window == window)
	       break ;
	 if (prev->window == window)
	    {
	    while (prev->same_window)
	       prev = prev->same_window ;
	    prev->same_window = handlers ;
	    }
	 else
	    prev->next = handlers ;
	 }
      else
	 signal_handlers = handlers ;
      /* now set and activate the requested signals */
      for (i = 0 ; i < num_signals ; i++)
	 {
	 signal = signals[i].signal ;
	 handlers->handlers[signal] = signals[i].func ;
	 if (signal != DV_OTHER && handlers->handlers[signal])
	    {
	    DVwin_notify(window,signal) ;
	    DVwin_allow(window,signal) ;
	    }
	 }
      /* we may not have installed the handler on this window yet */
      if (DVwin_async(window,UIsignal_handler,stacksize) == EOF)
         return DVSIG_ERROR ;
      }
   else /* direction == DVSIG_REMOVE */
      {
      ID = DVSIG_OK ;		/* assume no errors will occur */
      prev = NULL ;
      handlers = signal_handlers ;
      while (handlers && handlers->window != window)
	 {
	 prev = handlers ;
	 handlers = handlers->next ;
	 }
      if (!handlers)
	 return DVSIG_NOTFOUND ;
      else if (handlers->id == stacksize)
	 {
	 if (handlers->same_window)
	    {
	    handlers->same_window->next = handlers->next ;
	    if (prev)
	       prev->next = handlers->same_window ;
	    else
	       signal_handlers = handlers->same_window ;
	    }
	 else /* no other handlers for this window */
	    {
	    if (prev)
	       prev->next = handlers->next ;
	    else
	       signal_handlers = handlers->next ;
	    DVwin_async(window,NULL,0) ; /* cancel notification on this window */
	    }
	 }
      else
	 {
	 do {
	    prev = handlers ;
	    handlers = handlers->same_window ;
	    } while (handlers && handlers->id != stacksize) ;
	 if (handlers)
	    prev->same_window = handlers->same_window ;
	 else
	    return DVSIG_NOTFOUND ;
	 }
      free(handlers) ;
      }
   return ID ;
}

/* End of UISIGNAL.C */
