;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1993 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File SPAWNE.ASM	   Create new application, building environment *
;*									*
;************************************************************************
;LastEdit: 1/13/93

	INCLUDE API.INC
	MIN_VERSION 2,00

	Header@

;========================================================================

DSeg@
IF LDATA
ExtSym@ environ,DWORD,__CDECL__
ELSE
ExtSym@ environ,WORD,__CDECL__
ENDIF
DSegEnd@

;========================================================================

BSeg@
spawn_seg	dw ?
IF LPROG
spawn_env	dd ?
ELSE
spawn_env	dw ?
ENDIF

BSegEnd@

;========================================================================

CSeg@

ExtProc@ DVSPAWNVE,__PASCAL__

;------------------------------------------------------------------------

PubProc@ DVspawnle,__CDECL__
@win = dword ptr [bp+Overhead]
@row = word ptr [bp+Overhead+4]
@col = word ptr [bp+Overhead+6]
@rows = word ptr [bp+Overhead+8]
@cols = word ptr [bp+Overhead+10]
@switchmenu = word ptr [bp+Overhead+12]
@env = DPTR_ [bp+Overhead+14]
@program = DPTR_ [bp+Overhead+14+dPtrSize]
@args = word ptr [bp+Overhead+14+2*dPtrSize]
	@Enter
	PUSHDPTRMEM @env
	call	build_env
	; AX <- @envseg
	PUSHMEM32 @win
	push	@row
	push	@col
	push	@rows
	push	@cols
	push	@switchmenu
	PUSHDPTRMEM @program
	lea	bx,@args
	PUSHDPTR ss,bx
	push	ax			; AX still @envseg
	call	DVSPAWNVE@
	call	free_env
	@Exit	Y			; remove local variables from stack
	ret
EndProc@ DVspawnle,__CDECL__

;------------------------------------------------------------------------

__spawn_ASCIZ_length proc near
	push	ax
	mov	cx,0FFFFh
	xor	al,al
	cld
	repne	scasb
	not	cx			; CX <- num chars in string, incl NUL
	pop	ax
	ret
__spawn_ASCIZ_length endp

;----------------------------------------------------------------
; unsigned int pascal __spawn_buildenv(char **env) ;
;----------------------------------------------------------------

build_env proc near
; parameters
 @env = DPTR_ [bp+2+cPtrSize]
; local variables

; start of subroutine
	ASSUME	DS:DGROUP
	push	bp
	mov	bp,sp
	push	si
	push	di
	pushDS_
	LDS_	si,@env			; get address of pointer array
	ASSUME	DS:NOTHING
	DPTR_NULL ds,si,ax
	jnz	non_null_env
	popDS_
	ASSUME	DS:DGROUP
	pushDS_
	LDS_	si,environ@
	ASSUME	DS:NOTHING
non_null_env:
	mov	dx,1			; account for trailing NUL
get_length_loop:
	LES_	di,[si]
IF LDATA
	add	si,dPtrSize
ELSE
	push	ds
	pop	es
	inc	si
	inc	si
ENDIF ;LDATA
	DPTR_NULL es,di,ax
	jz	get_length_done
	call	__SPAWN_ASCIZ_length
	cmp	cx,1			; quit if null string
	je	get_length_done
	add	dx,cx			; add string's length to running total
	jmp	get_length_loop
get_length_done:
	popDS_
	ASSUME	DS:DGROUP
	mov	ax,dx
	add	ax,15
	push	ax			; remember required size
	ALLOC_MEM			; allocate AX bytes
	pop	bx			; get back required size
	mov	word ptr spawn_env,ax
IF LDATA
	mov	word ptr spawn_env+2,dx
ELSE
	mov	dx,ds	
ENDIF ;LDATA
	DPTR_NULL dx,ax,cx
	jnz	buildenv_gotmem
	mov	cl,4
	shr	bx,cl			; bytes to paragraphs
	mov	ah,48h			; request memory from DOS
	int	21h
	jnc	got_DOS_mem
	xor	ax,ax
	mov	spawn_seg,ax
	jmp short buildenv_quit
got_DOS_mem:
	mov	spawn_seg,ax
	jmp short buildenv_gotseg

buildenv_gotmem:
	add	ax,15			; normalize into paragraph alignment
	mov	cl,4
	shr	ax,cl
	add	ax,dx
buildenv_gotseg:
	pushDS_
	LDS_	si,@env			; get array of pointers to env strings
	ASSUME	DS:NOTHING
	mov	es,ax			; set up addressing to environment block
	ASSUME	ES:NOTHING
	xor	di,di
buildenv_loop:
	pushDS_
	push	si
	LDS_	si,[si]
	ASSUME	DS:NOTHING
	DPTR_NULL ds,si,ax
	jz	buildenv_done		; quit if NULL or empty string
	cmp	byte ptr [si],0
	je	buildenv_done
copy_loop:				; copy ASCIZ string including NUL
	lodsb
	stosb
	or	al,al
	jnz	copy_loop
	pop	si
	popDS_
IF LDATA
	add	si,dPtrSize		; advance to next pointer in array
ELSE
	inc	si
	inc	si
ENDIF ;LDATA
	jmp	buildenv_loop		; and copy the next string
buildenv_done:
	pop	si
	popDS_				; pop DS stacked inside loop
	popDS_				; pop DS stacked before loop
	ASSUME	DS:DGROUP
	mov	al,0
	stosb				; final terminating NUL
	mov	ax,es			; return segment containing built environment
buildenv_quit:
	pop	di
	pop	si
	pop	bp
	ret	dPtrSize
build_env endp

;----------------------------------------------------------------

free_env proc near
	ASSUME	DS:DGROUP
	LOADDPTR dx,ax,spawn_env
	DPTR_NULL dx,ax,bx
	jz	free_seg
	FREE_MEM dx,ax
	ret

free_seg:
	mov	ax,spawn_seg
	or	ax,ax
	jz	free_env_done
	mov	es,ax
	mov	ah,49h			; free memory block ES
	int	21h
free_env_done:
	ret
free_env endp

CSegEnd@

	END
