;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1992 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File DVXINIT.ASM	Initialize DV-GLUE system for DV/X	*
;*									*
;************************************************************************
;LastEdit: 12/20/92

	INCLUDE API.INC
	MIN_VERSION 2,00

	Header@

REQUIRED_DVX_VERSION equ 0100h	; v1.00 or higher

;========================================================================

DSeg@
bad_version_msg db "This program requires DESQview/X v"
major_version	db "1"
		db "."
minor_version	db "00"
		db " or higher.",13,10
		db "Press a key....",13,10
bad_version_msg_len equ $-bad_version_msg

initialized	db 0
exited		db 0

PubSym@ __DVX_REQUIRED_VERSION,<DW 0>,__PASCAL__
ExtSym@ _dvxversion,WORD,__CDECL__
DSegEnd@

;========================================================================

VerLastSeg@
start_version_list label byte
VerLastEnd@

XVerLastSeg@
end_version_list label byte
XVerLastEnd@

;========================================================================

CSeg@

ExtProc@ DVXVER,__PASCAL__
ExtProc@ DVINIT,__PASCAL__
ExtProc@ DVEXIT,__PASCAL__
ExtProc@ DVATEXIT,__PASCAL__

;------------------------------------------------------------------------

determine_req_version proc near
	mov	cx,REQUIRED_DVX_VERSION
	mov	bx,offset DGROUP:start_version_list
drv_loop:
	cmp	bx,offset DGROUP:end_version_list
	jae	got_req_version
	cmp	cx,[bx]
	jae	drv_loopend
	mov	cx,[bx]
drv_loopend:
	jmp	drv_loop
determine_req_version endp

PubProc@ DVXINIT,__PASCAL__
@req_ver = word ptr [bp+Overhead]
	@Enter
	mov	al,1
	xchg	al,DGROUP:initialized
	or	al,al
	jnz	DVXinit_done
	call	DVXVER@
	;
	; verify that we are running under a correct version of DESQview/X
	;
	mov	cx,@req_ver
	jcxz	determine_req_version
got_req_version:
	cmp	cx,ax			; AX still actual version, CX = req ver
	jbe	version_OK
bad_version:
	add	ah,'0'
	mov	major_version,ah
	aam
	add	ax,'00'
	mov	word ptr minor_version,ax
	mov	ah,40h			; write to file handle
	mov	bx,2			; stderr
	mov	cx,bad_version_msg_len
	mov	dx,offset DGROUP:bad_version_msg
	int	21h
	mov	ax,0C08h		; clear keyboard buffer and get key
	int	21h
	mov	ax,4CFFh		; terminate program
	int	21h
	int	20h			; just in case someone tries it under DOS 1.x

version_OK:
	call	DVINIT@
	mov	ax,offset __TEXT:DVXEXIT@
	PUSHCPTR cs,ax
	call	DVATEXIT@
	add	sp,cPtrSize
DVXinit_done:
	mov	ax,__dvxversion
	@Exit
	ret
EndProc@ DVXINIT,__PASCAL__

;------------------------------------------------------------------------

PubProc@ DVXEXIT,__PASCAL__
	SET_DS
	cmp	initialized,0
	je	DVXexit_done
	mov	al,1
	xchg	al,DGROUP:exited
	or	al,al
	jnz	DVXexit_done
	call	DVEXIT@

DVXexit_done:
	RESTORE_DS
	ret
EndProc@ DVXEXIT,__PASCAL__


CSegEnd@

	END
