;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1992 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File DVSI.ASM		functions related to the DVSI driver	*
;*									*
;************************************************************************
;LastEdit: 12/20/92

	INCLUDE	API.INC
	MIN_VERSION 2,26

	Header@

;========================================================================

CSeg@

ExtProc@ XDIINIT,__PASCAL__

;------------------------------------------------------------------------

DVSI_func	proc near
	call	XDIinit@
	jz	skip_DVSI		; don't try to call if no XDI handlers
	mov	ah,al			; set multiplex number
	mov	al,1
	mov	bx,7575h
	int	2Fh
skip_DVSI:
	ret
DVSI_func	endp

;------------------------------------------------------------------------

PubProc@ DVSI_INSTALLED,__PASCAL__
	mov	cl,00h			; function = installation check
	call	DVSI_func
	cmp	al,0FFh			; is the TSR installed?
	mov	ax,0
	jne	instchk_done
	mov	cl,03h			; function = get version
	call	DVSI_func		; AX <- version
instchk_done:
	or	ax,ax
	ret
EndProc@ DVSI_INSTALLED,__PASCAL__

;------------------------------------------------------------------------

PubProc@ DVSI_RUNTIME,__PASCAL__
	call	DVSI_installed@
	mov	cx,ax			; remember version
	mov	ax,0			; default return value = 00000000h
	mov	dx,ax
	jz	runtime_done
	push	cx			; store DVSI version
	mov	cl,5			; function = get time since DV start
	call	DVSI_func
	pop	cx			; retrieve DVSI version
	cmp	cx,010Ah		; v1.10 ?
	je	runtime_done		; if yes, time already in 1/100 seconds


runtime_done:
	ret
EndProc@ DVSI_RUNTIME,__PASCAL__

;------------------------------------------------------------------------

PubProc@ DVSI_TASKSWITCHES,__PASCAL__
@total = DPTR_ [bp+2+cPtrSize+dPtrSize]
@last = DPTR_ [bp+2+cPtrSize]
	call	DVSI_installed@
	jz	taskswitches_done
	mov	cl,6			; function = get task switches
	call	DVSI_func
	push	bp
	mov	bp,sp
	pushDS_
	LDS_	bx,@last
	mov	[bx],cx
	LDS_	bx,@total
	mov	[bx],ax
	mov	[bx+2],dx
	popDS_
	pop	bp
taskswitches_done:
	ret	2*dPtrSize
EndProc@ DVSI_TASKSWITCHES,__PASCAL__

CSegEnd@

	END
