/*
 *  Cheshiresoft Calendar-Almanac
 *  Copyright (C) 2003 by Andrew Ziem. All Rights Resreved.
 *
 *
 */

#ifndef __CDAY_H__
#define __CDAY_H__


/* -- compilers and #includes ---------------------------------------- */


/* GCC on Apple */
#if defined (__APPLE__) && defined (__GNUC__)
#define __UNIX__ 1
#define COMPILER_NAME     "Apple GNU GCC"
#define DIRECTORY_POSIX
#endif


/* GNU on Linux */
#if defined (__gnu_linux__) || defined (__linux__) || defined (__linux) || defined (linux)
#define __UNIX__ 1
#define COMPILER_NAME     "Linux GNU GCC"
#define DIRECTORY_POSIX
#endif

/* GCC on SunOS */
#if (defined (__sun__) || defined (__sun)) && defined(__GNUC__)
#define __UNIX__ 1
#define COMPILER_NAME     "SunOS GNU GCC"
#define DIRECTORY_POSIX
#endif

/* SunOS/BSD compatability package C compiler */
#if defined(__SUNPRO_C)
#define __UNIX__ 1
#define COMPILER_NAME     "SunOS Sunpro C"
#define DIRECTORY_POSIX
#endif

/* MinG32, GCC for Windows */
#if defined(__MINGW32__)
#define __DOS__ 1
#define COMPILER_NAME     "GNU GCC MinGW32"
#define MAXDIR            255	/* this is bad but works for now */
#define MAXPATH           255
#define MAXDRIVE            5
#define MAXFILE            60
#define MAXEXT             15
#define DIRECTORY_POSIX
#define INC_FNSPLIT
#define bzero(void, size)       memset(void, 0x00, size)
#endif /*  */

/* GNU EMX/GCC v0.9c (OS/2) */
#if defined(__EMX__) && !defined(__RSXNT__)
#define COMPILER_NAME     "GNU EMX/GCC"
#define __OS2__
#define __32__
#define __FLAT__
#define DIRECTORY_POSIX
#define strcmpi(a, b)     stricmp(a, b)
#define bzero(void, size)       memset(void, 0x00, size)
#endif /*  */

/* DJGPP v2.8 (DOS) */
#if defined(__DJGPP__)
#define COMPILER_NAME "DJGPP"
#define __DOS__
#define __32__
#define __FLAT__
#define DIRECTORY_DOS
#endif /* DJGPP */

/* Borland C v5.0 */
#if defined(__BORLANDC__)
#if defined(__WIN32__) == 1
#include <dos.h>
#define COMPILER_NAME     "Borland C v5"
#define __32__
#else /*  */
#include <dos.h>
#define COMPILER_NAME     "Borland C v5"
#define __DOS__
#define __16__
#endif /*  */
#define bzero(void, size)    memset(void, 0x00, size)
#define DIRECTORY_DOS
#endif /* BORLANDC */

/* Borland Turbo C v3.00 */
#if defined(__TURBOC__) && !defined(__BORLANDC__)
#include <dos.h>
#define COMPILER_NAME     "Borland Turbo C v3"
#define __DOS__
#define __16__
#define bzero(void, size)    memset(void, 0x00, size)
#define DIRECTORY_DOS
#endif /*  */

/* RSXNT v1.xx */
#if defined(__RSXNT__)
#define COMPILER_NAME     "RSX"
#include <dos.h>
#include <sys/types.h>
#include <sys/dir.h>
#define __32__
#define WIN32
#define USE_FOPEN
#define INC_DIRPORT
#define DIRECTORY_DOS
#define INC_FNSPLIT
#define MAXPATH   255		/* this is really bad */
#define MAXDRIVE  3
#define MAXDIR    200
#define MAXFILE   200
#define MAXEXT    10		/* but it'll do for now */
#define bzero(void, size)          memset(void, 0x00, size)
#define ffname(a)         (a).file.cFileName
#endif /*  */

#if !defined(COMPILER_NAME)
/* #error no compatible compiler found */
#define COMPILER_NAME "unknown compiler"
#define DIRECTORY_POSIX
#endif /* COMPILE_NAME */

/* -- #includes ------------------------------------------------------ */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <time.h>

/* EMX/GCC */
#if defined(INC_DIRPORT) && (defined(__EMX__) || defined(__RSXNT__))
#include "dirport.h"		/* SNIPPETS */
typedef DOSFileData DIRSTRUCT;
#endif /* EMX/GCC */

#if !defined(INC_DIRPORT)
#if defined(DIRECTORY_POSIX)
#include <dirent.h>
#else /* DOS-type directories, not POSIX */
#include <dir.h>
typedef struct ffblk DIRSTRUCT;

#define  ffname(a)            (a).ff_name
#endif /*  */
#endif /*  */

#ifdef DIRECTORY_DOS
#define FINDATTR            _A_NORMAL | _A_RDONLY | _A_ARCH
#endif /* DIRECTORY_DOS */

#if defined(INC_FNSPLIT)
#if defined(fnsplit)
#undef fnsplit
#endif /*  */
#if defined(fnmerge)
#undef fnmerge
#endif /*  */
#include "fnsplit.h"
#define fnsplit(a, b, c, d, e)     fnSplit(a, b, NULL, c, NULL, d, e)
#define fnmerge(a, b, c, d, e)     fnMerge(a, b, NULL, c, NULL, d, e)
#endif /*  */

#include "sniptype.h"

#include "maya.h"
#include "shire.h"
#include "numcnvrt.h"
#include "sdncal.h"

#include "scaldate.h"


/* -- some #definitions ---------------------------------------------- */

#define MAX_FGETS_READ       1024

#define PROG_NAME            "Cheshiresoft Calendar-Almanac"
#define PROG_VER             "1.20-pre2"
#define DEBUG

#define PROG_DATE            __DATE__

#define FALSE 0			/* nothing is true, nothing is sacred */
#define TRUE 1			/* only one is true: nothing is true */

#define MALLOC(size,type)   (type *) malloc( (size) * sizeof( type ))

#define ENGLISH

#define NUL '\0'

#define strip_trailing(a) if (a[strlen(a)-1]=='\n') a[strlen(a)-1]=NUL;

#define ERR_MEMORY          -1

/* -- variables ------------------------------------------------------ */
typedef unsigned int bit;	/* shorthand for C bit fields */
typedef int TYPE;
typedef int YEAR;
typedef long JDN;
typedef struct			/* command line options */
{
  bit sort:1;
  bit showmoon:1;		/* cmp */
  bit showfrench:1;		/* cf */
  bit showgue:1;		/* ce */
  bit showgregorian:1;		/* cg */
  bit showjewish:1;		/* cje */
  bit showjulian:1;		/* cju */
  bit showjdn:1;		/* cjd */
  bit showmaya:1;		/* cma */
  bit showshire:1;		/* cs */
  bit showevents:1;		/* le */
  bit showbirthdays:1;		/* lb */
  bit showreminders:1;		/* lr */
}
OPTS;

#define DISPLAY_TEXT 0
#define DISPLAY_HTML 1
#define DISPLAY_XML 2

typedef struct
{
  int debug;
  int quiet;
  int is_cgi;
  int display_mode;
}
MOPTS;

/*
#define GREGORIAN       1
#define JULIAN          2
#define FRENCH          3
#define MOON            8
*/
typedef struct
{
  unsigned int mday,		/* day of month (1-31) */
    month;			/* month of year (1-12) */
  YEAR year;			/* year (anything but 0) */
  unsigned int yday;		/* day of year (1-366) */
  unsigned int wday;		/* day of week (1-7, 1 = Sunday) */
  JDN jdn;			/* full Julian Day Number wo/ time of day */
}
GREG;

#define T_UNDEFINED 0
#define T_EVENT 1
#define T_REMINDER 2
#define T_BIRTHDAY 3
typedef struct
{
  YEAR year;			/* zero means year unknown or n/a */
  TYPE type;			/* T_... (above) */
  char *text;
}
EVENT;

typedef struct
{
  char *fname;
}
LIBRARY;

extern GREG greg;
extern OPTS opts;
extern MOPTS mopts;


/* -- prototypes ----------------------------------------------------- */
extern void criterr (char const *errmsg, ...);

int get_terminal_width (void);


#endif /* __CDAY_H__ */
