/*
 *  Cheshiresoft Calendar-Almanac
 *  Copyright (c) 2003 by Andrew Ziem.  All rights reserved.
 *  http://chesire.freeservers.com
 *  http://cday.sourceforge.net
 *
 *     SD_TRIMBOLI.C - Calculate a Stardate, David Trimboli's method
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/*
 *
 * CREDITS
 * Parts translated from David Trimboli's sdcode (Pascal), 1995-96.
 * http://members.aol.com/dtrimboli/stardate.html
 */

#define SD_DAYS_IN_YEAR 365.25
#define SD_DAYS_IN_CENTURY 36525


#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

/* Uncomment here to test SD */
/* #define TEST_SD */

int
sd_last_leap_year (int year)
{
  while (0 != (year % 4))
    {
      year--;;
    }

  return (year % 100);
}


#define days_up_to_leap_year(a) (a * SD_DAYS_IN_YEAR)


/* Returns the number of days between the first of the last leap year and
 * the first of the current year */
int
sd_days_since_leap_year (int current_year, int leap_year)
{
  int i;
  int days;

  i = leap_year;
  days = 0;

  while (i != (current_year % 100))
    {
      days += 365;

      if (i == leap_year)
	days++;
      i++;

    }
  return days;

}


/* Returns number of days beteween first of this year and first of month */
int
sd_previous_months (int year, int month)
{
  int month_index;
  int days;

  month_index = 1;
  days = 0;

  while (month_index < month)
    {
      switch (month_index)
	{

	case 1:
	case 3:
	case 5:
	case 7:
	case 8:
	case 10:
	  days += 31;
	  break;

	case 4:
	case 6:
	case 9:
	case 11:
	  days += 30;
	  break;
	case 2:
	  if (0 == (year % 4))	/* leap */
	    days += 29;
	  else
	    days += 28;
	  break;
	default:
	  fprintf (stderr, "stardate: sanity error: invalid month!\n");
	  break;

	}
      month_index++;
    }
  return days;
}


#define sd_days_in_month(a) (a - 1)

int
sd_dst (int month, int day, int year)
{
  time_t t;
  struct tm *my_tm;

  my_tm = malloc (sizeof (struct tm));

  if (NULL == my_tm)
    {
      return -1;
    }

  my_tm->tm_mon = month;
  my_tm->tm_mday = day;
  my_tm->tm_year = year;

  t = mktime (my_tm);
  free (my_tm);
  my_tm = gmtime (&t);

  return 0;
  /* not finished */

}

/* fix me: should this adjust for time zones, DST, and non-24 days (DST)? */
/* float sd_fraction_of_day(int month, int day, int day_of_week) */
float
sd_fraction_of_day (const struct tm *gmt_now)
{
  struct tm gmt_first;
  time_t t_first, t_now;

  t_now = mktime (gmt_now);

  if ((time_t) - 1 == t_now)
    {
      return -1;
    }

  memcpy (&gmt_first, gmt_now, sizeof (struct tm));

  gmt_first.tm_sec = 0;
  gmt_first.tm_min = 0;
  gmt_first.tm_hour = 0;

  t_first = mktime (&gmt_first);

  if ((time_t) - 1 == t_first)
    {
      return -1;
    }

/*  printf("debug: t_now(%i) - t_first(%i) = %i\n", t_now, t_first, t_now - t_first);     */

/*
  printf("debug: frac = %5.3f\n", (float)(t_now - t_first) );    
  printf("debug: frac = %5.3f\n", (float)(t_now - t_first) / (60 * 60 * 24));
*/

  return ((t_now - t_first) / (60 * 60 * 24));


}


float
sd_sd (float days)
{

  return (days / SD_DAYS_IN_CENTURY) * 100000;
}

float
sd_getdays (const struct tm *tm_now)
{
  int last_leap_year;
  float days;

  last_leap_year = sd_last_leap_year (tm_now->tm_year + 1900);
  days = days_up_to_leap_year (last_leap_year) +
    sd_days_since_leap_year (tm_now->tm_year + 1900, last_leap_year) +
    sd_previous_months (tm_now->tm_year + 1900, tm_now->tm_mon + 1) +
    sd_days_in_month (tm_now->tm_mday) + sd_fraction_of_day (tm_now);

  return (days);
}

/* sd_gets()
 * parameters: tm_now - time in GMT
 * returns: pointer to a string with Trimboli Stardate
 */

char *
sd_gets (const struct tm *tm_now)
{
  static char szSD[20];
  float days;
  float sd;

  days = sd_getdays (tm_now);
  sd = sd_sd (days);
  sprintf (szSD, "%5.2f", sd);

  return ((char *) &szSD);

}

#ifdef TEST_SD

int
main ()
{
  time_t t;
  struct tm *gmt_tm;
  float days;

  printf ("Calculating Trimboli Stardates for now and 1996-11-02...\n");

  t = time (NULL);
  gmt_tm = gmtime (&t);

  days = sd_getdays (gmt_tm);

  printf ("__Now__\n");
  printf ("Time = %s", asctime (gmt_tm));
  printf ("sd_gets = %s\n", sd_gets (gmt_tm));

/*  free(gmt_tm); */

/*  gmt_tm= malloc(sizeof(struct tm)); */
  printf ("\n");
  printf ("__November 2, 1996, 18:30 GMT__\n");

  gmt_tm->tm_year = 1996 - 1900;
  gmt_tm->tm_mon = 11 - 1;
  gmt_tm->tm_mday = 2;
  gmt_tm->tm_hour = 18;
  gmt_tm->tm_sec = 0;
  printf ("Time = %s", asctime (gmt_tm));
  days = sd_getdays (gmt_tm);
  printf ("sd_gets = %s\n", sd_gets (gmt_tm));


}

#endif
