/******************************************************************************
* Module    :   Used for debugging UNPOST, this routine will start doing
*               a MORE at the specified offset in the file.
*
* Author    :   John W. M. Stevens
******************************************************************************/

#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>

void    main(int    argc,
             char   **argv)
{
    register    int     i;
    register    int     j;
    auto        FILE    *FlPtr;
    auto        long    Ofs;
    static      char    Bfr[513];

    /*  Check the command line arguments.   */
    if (argc != 3)
    {
        fprintf(stderr,
                "%s %d : Error - Syntax is: mofs <+ofs> <file name>\n",
                __FILE__,
                __LINE__);
        exit( 1 );
    }

    /*  Get the offset. */
    if (argv[1][0] != '+')
    {
        fprintf(stderr,
                "%s %d : Error - Syntax is: mofs <+ofs> <file name>\n",
                __FILE__,
                __LINE__);
        exit( 1 );
    }
    Ofs = atol(argv[1] + 1);

    /*  Open the file to more.  */
    if ((FlPtr = fopen(argv[2], "r")) == NULL)
    {
        fprintf(stderr,
                "%s %d : Error - %s\n",
                __FILE__,
                __LINE__,
                sys_errlist[errno]);
        exit( 1 );
    }

    /*  Position the file pointer.  */
    if ( fseek(FlPtr, Ofs, SEEK_SET) )
    {
        fprintf(stderr,
                "%s %d : Error - %s\n",
                __FILE__,
                __LINE__,
                sys_errlist[errno]);
        exit( 1 );
    }

    /*  More the file.  */
    for ( ; ; )
    {
        /*  Dump out lines. */
        for (i = 0; i < 24; i++)
        {
            /*  Get a line. */
            if (fgets(Bfr, 512, FlPtr) == NULL)
                exit( 0 );

            /*  Check for auto scroll.  */
            j = strlen( Bfr );
            if (j > 80)
                i += j / 80;
            fputs(Bfr, stdout);
        }

        /*  Get the input from the user.    */
        fgets(Bfr, 512, stdin);
        if (*Bfr >= '0' && *Bfr <= '9')
        {
            /*  Get the offset. */
            Ofs = atol( Bfr );

            /*  Position the file pointer.  */
            if ( fseek(FlPtr, Ofs, SEEK_SET) )
            {
                fprintf(stderr,
                        "%s %d : Error - %s\n",
                        __FILE__,
                        __LINE__,
                        sys_errlist[errno]);
                exit( 1 );
            }
        }
        else if (*Bfr == 'q' || *Bfr == 'Q')
            break;
    }

    /*  Close the file. */
    fclose( FlPtr );
}
