/* NewsUUD v1.25 (c) 11/1993 by Andreas Krebs, Mathystr. 26a, 76133 Karlsruhe, Germany */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define DEC(c)  (((c)-' ')&0x3F)

#define ACT_QUIT        0
#define ACT_SKIP        1
#define ACT_SKIPFILE    2
#define ACT_RETRY       3
#define ACT_NEWNAME     4


static int decode(FILE *, FILE *);
static void outdec(char *,FILE *,int);
static int chkchr(char *);
static short ChooseAction(char *,char *);

main(int argc, char **argv)
{
  FILE *in,*out;
  char buf[256],dest[256];  /* enough for DOS */
  int mode,err,arg=1;
  short begin=0;

  printf("NewsUUD v1.25 (c) 11/1993 by Andreas Krebs, Email: s_krebs@iravcl.ira.uka.de\n");
  printf("                                                or uk13@rz.uni-karlsruhe.de\n");

  if(argc<2)
  {
    printf("  Usage: NewsUUD infile ... [infile]\n");
    exit(1);
  }

  do
  {
    if(!(in=fopen(argv[arg],"r")))
    {
      printf("  Can't open infile: \"%s\"\n",argv[arg]);
      goto nextfile;
    }

    printf("Working on infile \"%s\":\n",argv[arg]);

    for(;;)
    {
skip:
      do
      {
	if(!(fgets(buf,sizeof(buf),in)))
	{
	  fclose(in);
	  if(begin==0)
	  {
	    printf("  No begin found !\n");
	    goto nextfile;
	  }
	  else
	    goto nextfile;
	}
      }while(strncmp(buf,"begin ",6) && strncmp(&buf[1],"begin ",6));

      begin=1;
      if(buf[0]!='b')
	sscanf(&buf[1],"begin %o %s",&mode,dest);
      else
	sscanf(buf,"begin %o %s",&mode,dest);

newname:
      if((out=fopen(dest,"rb"))!=0)     /* is file already existing ? */
      {
	short action;

	fclose(out);
	printf("  Outfile \"%s\" already exists !\n",dest);

	action=ChooseAction("    (R)eplace, (N)ew name, (S)kip, Skip (i)nfile, (Q)uit: ",dest);
	if(action==ACT_RETRY)
	  goto retry;
	else if(action==ACT_SKIP)
	  goto skip;
	else if(action==ACT_NEWNAME)
	  goto newname;

	fclose(in);

	if(action==ACT_SKIPFILE)
	  goto nextfile;

	exit(1);
      }

retry:
      if(!(out=fopen(dest,"wb")))
      {
	short action;

	printf("  Can't open outfile: \"%s\"\n",dest);

	action=ChooseAction("    (R)etry, (N)ew name, (S)kip, Skip (i)nfile, (Q)uit: ",dest);
	if(action==ACT_RETRY)
	  goto retry;
	else if(action==ACT_NEWNAME)
	  goto newname;
	else if(action==ACT_SKIP)
	  goto skip;

	fclose(in);

	if(action==ACT_SKIPFILE)
	  goto nextfile;

	exit(1);
      }

      printf("  Decoding: %s -> %s ...",argv[1],dest);

      err=decode(in,out);
      if(err==0)
	printf(" done\n\n");

      fclose(out);
   }

nextfile:
    arg++;
  }while(arg<argc);

  return(0);
}

static int decode(FILE *in, FILE *out)
{
  char buf[80],*bp;     /* 80 chars is more than enough for a uue-line */
  int n,el=0;           /* el=1 if last line empty */

  for(;;)
  {
    if(!(fgets(buf,sizeof(buf),in)))
    {
      printf(" error\n  No end found !\n\n");
      return(10);
    }
     
    if(buf[0]<'a')
      n=DEC(buf[0]);
    else
      n=0;

    bp=&buf[1];

    if(buf[0]=='X' || buf[0]=='>' || buf[0]=='#')
	/* What other chars have you seen ? */
    {
      if(buf[1]<'a')
	n=DEC(buf[1]);
      else
	n=0;

      bp=&buf[2];
    }

    if(el==1 && (strcmp(buf,"end\n")==0 || strcmp(&buf[1],"end\n")==0))
      return(0);

    if(n==0 || buf[0]=='\n')    /* is this the blank line before the end line ? */
      el=1;
    else
      el=0;

    if(n<0 || n>45)
      n=0;

    if(n)
    {
      int c,l,minl;

      c=((n+2)/3)*4;
      minl=strlen(bp)-1;
      l=minl-2;

      while(minl>0 && (bp[minl-1]==' ' || bp[minl-1]=='\n'))
	minl--;                 /* size of line without spaces and '\n' at end */

      if(l>62 || l<1)
	n=0;
      else if(c<minl || c>l+3)
	n=0;
    }

    if(n && chkchr(bp)==1)
      n=0;

    while(n>0)
    {
      outdec(bp,out,n);
      bp+=4;
      n-=3;
    }
  }
}


static void outdec(char *p,FILE *out,int n)
{
  int c1,c2,c3;

  c1=(DEC(p[0])<<2) | (DEC(p[1])>>4);
  c2=(DEC(p[1])<<4) | (DEC(p[2])>>2);
  c3=(DEC(p[2])<<6) | DEC(p[3]);

  if(n>=1) putc(c1,out);
  if(n>=2) putc(c2,out);
  if(n>=3) putc(c3,out);
}

static int chkchr(char *p)
{
  while(*p!=0 && *p!='\n')
  {
    if((*p)<' ' || (*p)>='a')
      return(1);

    p++;
  }

  return(0);
}

static short ChooseAction(char *text,char *dest)
{
  short ret=-1;
  char ch[10];

  do
  {
    printf(text);
    scanf("%s",ch);

    switch(ch[0])
    {
      case 'N':
      case 'n':
	printf("    Enter new outfile name: ");
	scanf("%s",dest);
	ret=ACT_NEWNAME;
	break;
      case 'R':
      case 'r':
	ret=ACT_RETRY;
	break;
      case 'S':
      case 's':
	printf("\n");
	ret=ACT_SKIP;
	break;
      case 'I':
      case 'i':
	printf("\n");
	ret=ACT_SKIPFILE;
	break;
      case 'Q':
      case 'q':
	ret=ACT_QUIT;
	break;
    }
  }while(ret==-1);

  return(ret);
}
