		  .LFCOND ; List false conditionals.
		  PAGE 60,132 ; Page length 60, line 132.

COM EQU 0						; Assemble as .BIN file
D3 EQU 1 						; for Developer's Release.
;
CODESEG SEGMENT BYTE PUBLIC 'CODE'
		  ASSUME	 CS:CODESEG
;
PORTSWAP PROC	FAR
;
		  IF COM
		  	 ORG		0100H		; Originate at 0100H. 
		  ENDIF
;
START: PUSH ES ; Save environment.
		  PUSH		AX
		  PUSH		BX
		  PUSH		DI
;		
 		  MOV 		AX,40H 	; System stores critical operating
 									; parameters at segment 40H (absolute
 									; address 400H).
	 								; Load this segment address into AX.
		  PUSH 		AX			; Put it on the stack.
		  POP 		ES 		; Pop the segment id from the
 	                        ; stack into extra segment register.  
		  MOV 		DI,8H		; Port address of LPT1 and LPT2 are
 									; stored at offsets 8H and 0AH in
									; this segment.  Load DI with offset.
		  MOV 		AX,ES:[DI] 
									; Put the port address of the
                           ; first printer into the accumulator.
		  INC 		DI			; Increment the destination index 
 									; twice to point to port address
 		  INC 		DI 		; of the second printer.  
		  MOV 		BX,ES:[DI] 
									; Put the port address of the
 									; second printer into BX.
 		  MOV 		ES:[DI],AX
									; Poke the address of the first
 									; printer into the location of the 
 									; second printer.
 		  DEC 		DI			; Decrement DI twice to point to the
 		  DEC 		DI 		; location of the first printer
									; port address.
 		  MOV 		ES:[DI],BX 
									; Poke the address of the second
									; printer into the location of the
 									; first.
		  POP 		DI 		; Restore environment.
		  POP		   BX
		  POP		   AX
		  POP		   ES

		  IF		   COM
			 INT 20H 			; INT 20H if .COM file
		  ELSE
 		    RET 					; far return to dBASE III 
		  ENDIF 
;
PORTSWAP ENDP
CODESEG  ENDS
			END	   START
