/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
 f_ver.c Verification of database and index files
*/

#include <stdio.h>
#include <malloc.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <dos.h>
#if defined(__EMX__)
  #include <sys/types.h>
#endif
#if defined(__EMX__)
  #include <dirent.h>
#endif
#include <sys\stat.h>
#if defined(__EMX__)
  #include <fnmatch.h>
#endif
#if defined(__DJGPP__)
  #include <unistd.h>
  #include <dos.h>
#endif

#include <time.h>
#include "refs.h"
#include "abstr.h"
#include "str_fun.h"
#include "fl_ut.h"
#include "ix01_fun.h"
#include "ix02_fun.h"
#include "ix03_fun.h"
#include "ix04_fun.h"
#include "abbruch.h"
#include "cfg_fun.h"
#include "l_menu.h"
#include "fd.h"

#define FVERTITEL "REFERENCES VERSION 3.6 * CHECK DATABASE INTEGRITY"

#define MAX_BLOECKE 62

#define VERIFY_LOG "VERIFY.LOG"
 static char log_name[PFAD_LEN];
 static FILE * fplog;


 extern char journal_pix_name[PFAD_LEN];
 extern FILE * ix01file;

 extern char journal_name[PFAD_LEN];
 extern FILE  * fpjournal;

 extern char desc_name[PFAD_LEN];
 extern FILE  * fpdesc;

 extern char book_name[PFAD_LEN];
 extern FILE * fpbuch;

 extern char autorjl_name[PFAD_LEN];
 extern char autorbu_name[PFAD_LEN];
 extern FILE * fpautorjl;
 extern FILE * fpautorbu;

 extern char abstr_pix_name[PFAD_LEN];
 extern FILE * ix04file;

 extern char abstr_dat_name[PFAD_LEN];
 extern FILE * fpabs;

 extern char quell_pix_name[PFAD_LEN];
 extern FILE * ix02file;

 extern char quell_name[PFAD_LEN];
 extern FILE * fpquell;

 extern char stichw_pix_name[PFAD_LEN];
 extern FILE * ix03file;

 extern char stichw_name[PFAD_LEN];
 extern FILE * fpstichw;

 extern char formdef_name[PFAD_LEN];
 extern FILE * fpformdef;

 static FILE * fpbbt;

 extern refspix_rec ix01rec;
 extern journal_rec one_journal_rec;
 extern desc_rec one_desc_rec;
 extern buch_rec one_buch_rec;
 extern author_rec one_aued_rec;
 extern abstrpix_rec ix04rec;
 extern abstr_rec one_abstr_rec;
 extern quellpix_rec ix02rec;
 extern quell_rec one_quell_rec;
 extern keylist_rec one_stichw_rec;
 extern keylistpix_rec ix03rec;
 extern formdef_rec fd;
 static bbatchtable_rec one_bbt_rec;


 extern config_set one_config_set;

 extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN];

 /* Funktionen */
 int f_ver_main(char * datpath);
 static int duplicate_test(void);
 static int ixs_to_dats(void);
 static int ix_to_journal(void);
 static int ix_to_book(void);
 static int ix_to_autorjl(void);
 static int ix_to_autorbo(void);
 static int ix_to_desc(void);
 static int ix_to_abst(void);
 static int ix_to_source(void);
 static int ix_to_keyw(void);
 static int dats_to_ixs(void);
 static int journal_to_ix(void);
 static int abst_to_ix(void);
 static int source_to_ix(void);
 static int keyw_to_ix(void);
 static int db_information(void);
 static int datei_analysieren(const char * dn, int ds_groesse);
 static int alles_analysieren(void);
 static int test_formdef_dat(void);
 static int test_bbts(void);


int f_ver_main(char * datpath)
{
     static int menupos;
     int taste;
     strcpy(log_name,datpath); strcat(log_name,VERIFY_LOG);

     if ((fplog=fopen(log_name,"wt"))==NULL)
     {
         sprintf(fehlermeldung,"ERROR: cannot create %s",log_name);
         beenden(fehlermeldung,2);
     }
     do
     {
         cls_line(FVERTITEL);
         taste = lotus_menu_default(
            &menupos,
            "@DBaseInfo$Give information about the current database"
            "@1:IndxDupl$Check for duplicate entries and "
                        "for (ascending) order of keys in index files"
            "@2:RecordPtr$Check record pointers "
                        "(IX->DAT) and analyze database files (DAT)"
            "@3:IndxComplete$Test, if index files are complete (DAT->IX)"
            "@4:Batch$Test field lengths of Binary Batch Tables (BBT)"
            "@AllTests$Perform all tests: DBaseInfo, #1-#4"
                 );
             if (taste==1)
             {
                 db_information();
             }
             if (taste==2)
             {
                 duplicate_test();
             }
             if (taste==3)
             {
                 ixs_to_dats();
             }
             if (taste==4)
             {
                 dats_to_ixs();
             }
             if (taste==5)
             {
                 test_bbts();
             }

             if (taste==6)
             {
                 alles_analysieren();
             }
             if (taste!=0)
             {
                 wrtxt("\n\n[Please press any key]>");
                 tastelesen();
             }

     } while (taste!= 0);
     fclose(fplog);
     return 0;
}

static int duplicate_test(void)
{
   int test_ok;
   refspix_rec ix01rec_alt;
   abstrpix_rec ix04rec_alt;
   quellpix_rec ix02rec_alt;
   keylistpix_rec ix03rec_alt;

   long anzahl_records, byte_zeiger,i;

   test_ok=1;

   sprintf(wrtxtbu,"\n*** Function 'IndxDupl' ***\n");
   wrtxt(wrtxtbu);
   fprintf(fplog,"%s",wrtxtbu);


   if (filesize(journal_pix_name) < sizeof(ix01rec)*2)
   {
       sprintf(wrtxtbu,"\n%s < 2 index records, not analyzed.",journal_pix_name);
       wrtxt(wrtxtbu);
   }
   else
   {
       if (read_ix01(journal_pix_name)==0)
       {
          return 0;
       }

       rewind(ix01file);
       fseek(ix01file,0L,SEEK_END);
       byte_zeiger = ftell(ix01file);
       anzahl_records = byte_zeiger / sizeof(ix01rec);
       anzahl_records--;
       rewind(ix01file);

       memset(&ix01rec,0,sizeof(ix01rec));
       memset(&ix01rec_alt,0,sizeof(ix01rec_alt));

       sprintf(wrtxtbu,"\nAnalysis of index file %s:",journal_pix_name);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);

       sprintf(wrtxtbu,"\n%li records in %s [0..%li]",
                 anzahl_records+1,journal_pix_name,anzahl_records);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);

       rewind(ix01file);
       fread(&ix01rec,sizeof(ix01rec),1,ix01file);
       for (i=1;i<=anzahl_records;i++)
       {
           if (strlen(ix01rec.kennziffer) > KENNZIFFER_LEN ||
               strlen(ix01rec.kennziffer) == 0)
           {
               sprintf(wrtxtbu,"\nProblem with record %li: Key too long or empty",
                      i-1);
               wrtxt(wrtxtbu);
               fprintf(fplog,"%s",wrtxtbu);
               test_ok=0;

           }
           ix01rec_alt=ix01rec;
           fread(&ix01rec,sizeof(ix01rec),1,ix01file);
           if (strcmp(ix01rec.kennziffer,ix01rec_alt.kennziffer)<=0)
           {
               sprintf(wrtxtbu,"\nProblem (key order) with records %li: %s and %li: %s",
                         i-1,ix01rec_alt.kennziffer,i,ix01rec.kennziffer);
               wrtxt(wrtxtbu);
               fprintf(fplog,"%s",wrtxtbu);
               test_ok=0;

           }
       }


       close_ix01();
   }


   if (filesize(abstr_pix_name) < sizeof(ix04rec)*2)
   {
       sprintf(wrtxtbu,"\n%s < 2 index records, not analyzed.",abstr_pix_name);
       wrtxt(wrtxtbu);
   }
   else
   {
       if (read_ix04(abstr_pix_name)==0)
       {
          return 0;
       }
       rewind(ix04file);
       fseek(ix04file,0L,SEEK_END);
       byte_zeiger=ftell(ix04file);
       anzahl_records = byte_zeiger / sizeof(ix04rec);
       anzahl_records--;
       rewind(ix04file);

       memset(&ix04rec,0,sizeof(ix04rec));
       memset(&ix04rec_alt,0,sizeof(ix04rec_alt));

       sprintf(wrtxtbu,"\nAnalysis of index file %s:",abstr_pix_name);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);

       sprintf(wrtxtbu,"\n%li records in %s [0..%li]",
                 anzahl_records+1,abstr_pix_name,anzahl_records);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);

       rewind(ix04file);
       fread(&ix04rec,sizeof(ix04rec),1,ix04file);

       for (i=1;i<=anzahl_records;i++)
       {
           if (strlen(ix04rec.kennziffer) > KENNZIFFER_LEN ||
               strlen(ix04rec.kennziffer) == 0)
           {
               sprintf(wrtxtbu,"\nProblem with record %li: Key too long or empty",
                      i-1);
               wrtxt(wrtxtbu);
               fprintf(fplog,"%s",wrtxtbu);
               test_ok=0;
           }
           ix04rec_alt=ix04rec;
           fread(&ix04rec,sizeof(ix04rec),1,ix04file);
           if (strcmp(ix04rec.kennziffer,ix04rec_alt.kennziffer)<=0)
           {
               sprintf(wrtxtbu,"\nProblem (key order) with records %li: %s and %li: %s",
                         i-1,ix04rec_alt.kennziffer,i,ix04rec.kennziffer);
               wrtxt(wrtxtbu);
               fprintf(fplog,"%s",wrtxtbu);
               test_ok=0;

           }
       }

       close_ix04();
   }

   if (filesize(quell_pix_name) < sizeof(ix02rec)*2)
   {
       sprintf(wrtxtbu,"\n%s < 2 index records, not analyzed.",quell_pix_name);
       wrtxt(wrtxtbu);
   }
   else
   {
       if (read_ix02(quell_pix_name)==0)
       {
          return 0;
       }
       rewind(ix02file);
       fseek(ix02file,0L,SEEK_END);
       byte_zeiger=ftell(ix02file);
       anzahl_records = byte_zeiger / sizeof(ix02rec);
       anzahl_records--;
       rewind(ix02file);

       memset(&ix02rec,0,sizeof(ix02rec));
       memset(&ix02rec_alt,0,sizeof(ix02rec_alt));

       sprintf(wrtxtbu,"\nAnalysis of index file %s:",quell_pix_name);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);

       sprintf(wrtxtbu,"\n%li records in %s [0..%li]",
                 anzahl_records+1,quell_pix_name,anzahl_records);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);

       rewind(ix02file);
       fread(&ix02rec,sizeof(ix02rec),1,ix02file);

       for (i=1;i<=anzahl_records;i++)
       {
           if (strlen(ix02rec.quell_kuerzel) > QUELLKUERZEL_LEN ||
               strlen(ix02rec.quell_kuerzel) == 0)
           {
               sprintf(wrtxtbu,"\nProblem with record %li: Key too long or empty",
                      i-1);
               wrtxt(wrtxtbu);
               fprintf(fplog,"%s",wrtxtbu);
               test_ok=0;
           }
           ix02rec_alt=ix02rec;
           fread(&ix02rec,sizeof(ix02rec),1,ix02file);
           if (strcmp_fun(ix02rec.quell_kuerzel,ix02rec_alt.quell_kuerzel,
                  SSTRING)<=0)
           {
               sprintf(wrtxtbu,"\nProblem (key order) with records %li: %s and %li: %s",
                         i-1,ix02rec_alt.quell_kuerzel,
                         i,ix02rec.quell_kuerzel);
               wrtxt(wrtxtbu);
               fprintf(fplog,"%s",wrtxtbu);
               test_ok=0;

           }
       }

       close_ix02();

   }

   if (filesize(stichw_pix_name) < sizeof(ix03rec)*2)
   {
       sprintf(wrtxtbu,"\n%s < 2 index records, not analyzed.",stichw_pix_name);
       wrtxt(wrtxtbu);
   }
   else
   {
       if (read_ix03(stichw_pix_name)==0)
       {
          return 0;
       }

       rewind(ix03file);
       fseek(ix03file,0L,SEEK_END);
       byte_zeiger=ftell(ix03file);
       anzahl_records = byte_zeiger / sizeof(ix03rec);
       anzahl_records--;
       rewind(ix03file);

       memset(&ix03rec,0,sizeof(ix03rec));
       memset(&ix03rec_alt,0,sizeof(ix03rec_alt));

       sprintf(wrtxtbu,"\nAnalysis of index file %s:",stichw_pix_name);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);

       sprintf(wrtxtbu,"\n%li records in %s [0..%li]",
                 anzahl_records+1,stichw_pix_name,anzahl_records);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);

       rewind(ix03file);
       fread(&ix03rec,sizeof(ix03rec),1,ix03file);
       for (i=1;i<=anzahl_records;i++)
       {
           if (strlen(ix03rec.keywordsfield) > KEYWORDS_LEN ||
               strlen(ix03rec.keywordsfield) == 0)
           {
               sprintf(wrtxtbu,"\nProblem with record %li: Key too long or empty",
                      i-1);
               wrtxt(wrtxtbu);
               fprintf(fplog,"%s",wrtxtbu);
               test_ok=0;

           }
           ix03rec_alt=ix03rec;
           fread(&ix03rec,sizeof(ix03rec),1,ix03file);
           if (strcmp_fun(ix03rec.keywordsfield,ix03rec_alt.keywordsfield,
                  SSTRING)<=0)
           {
               sprintf(wrtxtbu,"\nProblem (key order) with records %li: %s and %li: %s",
                         i-1,ix03rec_alt.keywordsfield,
                         i,ix03rec.keywordsfield);
               wrtxt(wrtxtbu);
               fprintf(fplog,"%s",wrtxtbu);
               test_ok=0;

           }
       }

       close_ix03();
   }

   if (test_ok)
   {
     sprintf(wrtxtbu,"\n\nCompleted, no problems found.");
     fprintf(fplog,"%s",wrtxtbu);
     wrtxt(wrtxtbu);
   }
   else
   {
     sprintf(wrtxtbu,"\n\nAt least one problem was found! Please read %s",
          VERIFY_LOG);
     fprintf(fplog,"%s",wrtxtbu);
     wrtxt(wrtxtbu);
   }

   fprintf(fplog,"\n\n");
   return test_ok;
}

/*
 `ixs_to_dats': looks from index files into dat files:
 this function verifies correctness of index pointers

 1: Is the pointer within the allowed range [0..max]?
 2: Does the pointer point to a record with the same `kennziffer'?
*/
static int ixs_to_dats(void)
{
   int bisher_ok;

   sprintf(wrtxtbu,"\n*** Function 'RecordPtr' ***\n");
   wrtxt(wrtxtbu);
   fprintf(fplog,"%s",wrtxtbu);

   if (filesize(journal_pix_name) < (long) sizeof(ix01rec))
   {
       sprintf(wrtxtbu,"\nTest of %s not performed, 0 index records",
                        journal_pix_name);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);
       return 0;
   }
   if (read_ix01(journal_pix_name)==0)
   {
       bisher_ok=0;
   }
   else
   {
       bisher_ok=1;
   }
   if (bisher_ok)
   {
      bisher_ok = ix_to_journal();
   }
   if (bisher_ok)
   {
      bisher_ok = ix_to_desc();
   }
   if (bisher_ok)
   {
      bisher_ok = ix_to_book();
   }
   if (bisher_ok)
   {
      bisher_ok = ix_to_autorjl();
   }
   if (bisher_ok)
   {
      bisher_ok = ix_to_autorbo();
   }

   close_ix01();

   if (filesize(abstr_pix_name) < sizeof(ix04rec))
   {
       sprintf(wrtxtbu,"\nTest of %s not performed, 0 index records",
               abstr_pix_name);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);

       return 0;
   }

   if (read_ix04(abstr_pix_name)==0)
   {
      bisher_ok=0;
   }

   if (bisher_ok)
   {
      bisher_ok = ix_to_abst();
   }

   close_ix04();

   if (filesize(quell_pix_name) < sizeof(ix02rec))
   {
       sprintf(wrtxtbu,"\nTest of %s not performed, 0 index records",
              quell_pix_name);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);

       return 0;
   }

   if (read_ix02(quell_pix_name)==0)
   {
      bisher_ok=0;
   }

   if (bisher_ok)
   {
      bisher_ok = ix_to_source();
   }

   close_ix02();


   if (filesize(stichw_pix_name) < sizeof(ix03rec))
   {
       sprintf(wrtxtbu,"\nTest of %s not performed, 0 index records",
                       stichw_pix_name);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);
       return 0;
   }

   if (read_ix03(stichw_pix_name)==0)
   {
      bisher_ok=0;
   }

   if (bisher_ok)
   {
      bisher_ok = ix_to_keyw();
   }

   close_ix03();

   if (bisher_ok)
   {
      bisher_ok=test_formdef_dat();
   }

   if (bisher_ok)
   {
      sprintf(wrtxtbu,"\n\nCompleted, no problems found.");
   }
   else
   {
     sprintf(wrtxtbu,"\n\nAt least one problem was found! Please read %s",
          VERIFY_LOG);

   }
   fprintf(fplog,"%s",wrtxtbu);
   wrtxt(wrtxtbu);

   fprintf(fplog,"\n\n");

   return bisher_ok;
}

/*
 Size of DAT file?
 1: Is record pointer within the allowed range?
 2: is 'kennziffer'-field OK?
 3: is the record still 'in use' (i. e. not deleted)?
*/
static int ix_to_journal(void)
{

   int test_ok;
   long anzahl_records, byte_zeiger, max_rec_zeiger, i;
   test_ok=1;

   if ((fpjournal=fopen(journal_name,"rb"))==NULL)
   {
       sprintf(wrtxtbu,"\nProblem: unable to read %s",journal_name);
       fprintf(fplog,"%s",wrtxtbu);
       wrtxt(wrtxtbu);
       return 0;
   }

   rewind(fpjournal);
   fseek(fpjournal,0L,SEEK_END);
   byte_zeiger=ftell(fpjournal);
   anzahl_records=byte_zeiger / sizeof(one_journal_rec);
   anzahl_records--;
   /* biggest possible pointer value */
   max_rec_zeiger = anzahl_records;

   rewind(ix01file);
   fseek(ix01file,0L,SEEK_END);
   byte_zeiger = ftell(ix01file);
   anzahl_records = byte_zeiger / sizeof(ix01rec);
   anzahl_records--;
   rewind(ix01file);
   for (i=0;i<=anzahl_records;i++)
   {
      fread(&ix01rec,sizeof(ix01rec),1,ix01file);
      if (ix01rec.journal_rptr > max_rec_zeiger ||
          ix01rec.journal_rptr < 0)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(out of range)" ,
                 ix01rec.kennziffer,
                 ix01rec.journal_rptr);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
         continue;
      }
      byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
      if (strcmp(ix01rec.kennziffer,one_journal_rec.kennziffer)!=0)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(addresses record %s in %s)",
                 ix01rec.kennziffer,
                 ix01rec.journal_rptr,
                 one_journal_rec.kennziffer,
                 journal_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
      }
      if (one_journal_rec.in_use==0)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(record no more declared as 'in use' in %s)",
                 ix01rec.kennziffer,
                 ix01rec.journal_rptr,
                 journal_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
      }

      if (
          strlen(one_journal_rec.titel) > TITEL_LEN ||
          strlen(one_journal_rec.kuerzel) > KUERZEL_LEN ||
          strlen(one_journal_rec.jahrgang) > JAHRGANG_LEN ||
          strlen(one_journal_rec.monat) > MONAT_LEN ||
          strlen(one_journal_rec.tag) > TAG_LEN ||
          strlen(one_journal_rec.issue_nummer) > ISSUE_NUMMER_LEN ||
          strlen(one_journal_rec.band) > BAND_LEN ||
          strlen(one_journal_rec.seite_von) > SEITE_VON_LEN ||
          strlen(one_journal_rec.seite_bis) > SEITE_BIS_LEN ||
          strlen(one_journal_rec.reftyp) > REFTYP_LEN ||
          strlen(one_journal_rec.status) > STATUS_LEN
         )
      {
         sprintf(wrtxtbu,"\nDatabase file problem in record %s: at least one field "
                         "length out of range (%s)",
                 one_journal_rec.kennziffer,
                 journal_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
      }

   }
   if (test_ok==1)
   {
       sprintf(wrtxtbu,"\nNo problem found (Rptr->%s).",
            journal_name);
   }
   else
   {
       sprintf(wrtxtbu,"\nEnd of list (problems Rptr->%s).",
                   journal_name);
   }

   wrtxt(wrtxtbu);
   fprintf(fplog,"%s",wrtxtbu);

   fclose(fpjournal);
   if (!test_ok)
   {
       return 0;
   }
   else
   {
      return 1;
   }
}


static int ix_to_book(void)
{
   int test_ok;
   long anzahl_records, byte_zeiger, max_rec_zeiger, i;
   test_ok=1;

   if ((fpbuch=fopen(book_name,"rb"))==NULL)
   {
       sprintf(wrtxtbu,"\nProblem: unable to read %s",book_name);
       fprintf(fplog,"%s",wrtxtbu);
       wrtxt(wrtxtbu);
       return 0;
   }

   rewind(fpbuch);
   fseek(fpbuch,0L,SEEK_END);
   byte_zeiger=ftell(fpbuch);
   anzahl_records=byte_zeiger / sizeof(one_buch_rec);
   anzahl_records--;
   /* biggest possible pointer value */
   max_rec_zeiger = anzahl_records;

   if (anzahl_records==-1)
   {
      return 1;
      /* Insert message */
   }

   rewind(ix01file);
   fseek(ix01file,0L,SEEK_END);
   byte_zeiger = ftell(ix01file);
   anzahl_records = byte_zeiger / sizeof(ix01rec);
   anzahl_records--;
   rewind(ix01file);
   for (i=0;i<=anzahl_records;i++)
   {
      fread(&ix01rec,sizeof(ix01rec),1,ix01file);
      if (ix01rec.buch_rptr < 0)
      {
          continue;  /* Kein Verweis auf book.dat */
      }
      if (ix01rec.buch_rptr > max_rec_zeiger)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(out of range)" ,
                 ix01rec.kennziffer,
                 ix01rec.buch_rptr);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
         continue;
      }
      byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
      fseek(fpbuch,byte_zeiger,SEEK_SET);
      fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
      if (strcmp(ix01rec.kennziffer,one_buch_rec.kennziffer)!=0)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(addresses record %s in %s)",
                 ix01rec.kennziffer,
                 ix01rec.buch_rptr,
                 one_buch_rec.kennziffer,
                 book_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
      }
      if (one_buch_rec.in_use_bu==0)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(record no more declared as 'in use' in %s)",
                 ix01rec.kennziffer,
                 ix01rec.buch_rptr,
                 book_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
      }

   }
   if (
      strlen(one_buch_rec.titel_bu) > TITELBUCH_LEN ||
      strlen(one_buch_rec.publ_ort) > PUBLORT_LEN ||
      strlen(one_buch_rec.isbn) > ISBN_LEN ||
      strlen(one_buch_rec.verlag) > VERLAG_LEN
      )
   {
         sprintf(wrtxtbu,"\nDatabase file problem in record %s: at least one field "
                         "length out of range (%s)",
                 one_buch_rec.kennziffer,
                 book_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
   }

   if (test_ok==1)
   {
       sprintf(wrtxtbu,"\nNo problem found (Rptr->%s).",
            book_name);
   }
   else
   {
       sprintf(wrtxtbu,"\nEnd of list (problems Rptr->%s).",
                   book_name);
   }

   wrtxt(wrtxtbu);
   fprintf(fplog,"%s",wrtxtbu);


   fclose(fpbuch);
   if (!test_ok)
   {
       return 0;
   }
   else
   {
      return 1;
   }
}


static int ix_to_autorjl(void)
{
   int test_ok;
   long anzahl_records, byte_zeiger, max_rec_zeiger, i;
   short int anzahl_aued, j;

   test_ok=1;
   if ((fpautorjl=fopen(autorjl_name,"rb"))==NULL)
   {
       sprintf(wrtxtbu,"\nProblem: unable to read %s",autorjl_name);
       fprintf(fplog,"%s",wrtxtbu);
       wrtxt(wrtxtbu);
       return 0;
   }
   rewind(fpautorjl);
   fseek(fpautorjl,0L,SEEK_END);
   byte_zeiger=ftell(fpautorjl);
   anzahl_records=byte_zeiger / sizeof(one_aued_rec);
   anzahl_records--;
   max_rec_zeiger = anzahl_records;

   if (anzahl_records==-1)
   {
      return 1;
      /* Insert message */
   }
   rewind(ix01file);
   fseek(ix01file,0L,SEEK_END);
   byte_zeiger = ftell(ix01file);
   anzahl_records = byte_zeiger / sizeof(ix01rec);
   anzahl_records--;

   rewind(ix01file);
   for (i=0;i<=anzahl_records;i++)
   {
      fread(&ix01rec,sizeof(ix01rec),1,ix01file);
      if (ix01rec.autorjl_rptr < 0)
      {
          continue; /* Kein Verweis auf autorjl.dat */
      }
      if (ix01rec.autorjl_rptr > max_rec_zeiger)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(out of range)" ,
                 ix01rec.kennziffer,
                 ix01rec.autorjl_rptr);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
         continue;
      }
      byte_zeiger = ix01rec.autorjl_rptr * sizeof(one_aued_rec);
      fseek(fpautorjl,byte_zeiger,SEEK_SET);
      fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
      if (strcmp(ix01rec.kennziffer,one_aued_rec.au_kennziffer)!=0)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(addresses record %s in %s)",
                 ix01rec.kennziffer,
                 ix01rec.autorjl_rptr,
                 one_aued_rec.au_kennziffer,
                 autorjl_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
         continue;
      }

      if (one_aued_rec.au_i != 1)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                 "(does not address 1st author in %s)",
                 ix01rec.kennziffer,
                 ix01rec.autorjl_rptr,
                 autorjl_name);
          wrtxt(wrtxtbu);
          fprintf(fplog,"%s",wrtxtbu);
          test_ok=0;
          continue;
      }

      if (one_aued_rec.in_use_au==0)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(record no more declared as 'in use' in %s)",
                 ix01rec.kennziffer,
                 ix01rec.autorjl_rptr,
                 autorjl_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
         continue;
      }

      /* Hier Ueberpruefung der weiteren Autoren */

      anzahl_aued=one_aued_rec.au_n;
      fseek(fpautorjl,byte_zeiger,SEEK_SET);
      for (j=1;j<=anzahl_aued;j++)
      {
         if (fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl)!=1)
         {
           sprintf(wrtxtbu,"\nUnexpected database file problem in record %s: %i. author/editor "
                           "(Unable to read author/editor name in %s)",
                   one_aued_rec.au_kennziffer,
                   one_aued_rec.au_i,
                   autorjl_name);
           wrtxt(wrtxtbu);
           fprintf(fplog,"%s",wrtxtbu);
           test_ok=0;
         }

         if (strlen(one_aued_rec.au_nachname) > AUNAME_LEN ||
             strlen(one_aued_rec.au_vornamen) > AUVORNAMEN_LEN)
         {
           sprintf(wrtxtbu,"\nDatabase file problem in record %s: at least one field "
                           "length out of range (%s)",
                   one_aued_rec.au_kennziffer,
                   autorjl_name);
           wrtxt(wrtxtbu);
           fprintf(fplog,"%s",wrtxtbu);
           test_ok=0;
         }
         if (one_aued_rec.au_n > MAX_N_AUTHORS)
         {
           sprintf(wrtxtbu,"\nDatabase file problem in record %s: max. numbers of authors/"
                           "editors out of range (%s)",
                   one_aued_rec.au_kennziffer,
                   autorjl_name);
           wrtxt(wrtxtbu);
           fprintf(fplog,"%s",wrtxtbu);
           test_ok=0;
           continue;
         }

         if (one_aued_rec.au_i != j)
         {
           sprintf(wrtxtbu,"\nDatabase file problem in record %s: %i. author expected, "
                           "%i. author found (%s)",
                   one_aued_rec.au_kennziffer,
                   j,
                   one_aued_rec.au_i,
                   autorjl_name);
           wrtxt(wrtxtbu);
           fprintf(fplog,"%s",wrtxtbu);
           test_ok=0;
           continue;
         }
         if (strcmp(ix01rec.kennziffer,one_aued_rec.au_kennziffer)!=0)
         {
            sprintf(wrtxtbu,"\nDatabase file problem in record %s, %i. author/editor: "
                            "unexpected reference number: "
                            "(record %s in %s)",
                    ix01rec.kennziffer,
                    j,
                    one_aued_rec.au_kennziffer,
                    autorjl_name);
            wrtxt(wrtxtbu);
            fprintf(fplog,"%s",wrtxtbu);
            test_ok=0;
            continue;
         }
      }
   }

   if (test_ok==1)
   {
       sprintf(wrtxtbu,"\nNo problem found (Rptr->%s).",
            autorjl_name);
   }
   else
   {
       sprintf(wrtxtbu,"\nEnd of list (problems Rptr->%s).",
                   autorjl_name);
   }

   wrtxt(wrtxtbu);
   fprintf(fplog,"%s",wrtxtbu);

   fclose(fpautorjl);
   if (!test_ok)
   {
       return 0;
   }
   else
   {
      return 1;
   }
}


static int ix_to_autorbo(void)
{
   int test_ok;
   long anzahl_records, byte_zeiger, max_rec_zeiger, i;
   short int anzahl_aued, j;

   test_ok=1;
   if ((fpautorbu=fopen(autorbu_name,"rb"))==NULL)
   {
       sprintf(wrtxtbu,"\nProblem: unable to read %s",autorbu_name);
       fprintf(fplog,"%s",wrtxtbu);
       wrtxt(wrtxtbu);
       return 0;
   }
   rewind(fpautorbu);
   fseek(fpautorbu,0L,SEEK_END);
   byte_zeiger=ftell(fpautorbu);
   anzahl_records=byte_zeiger / sizeof(one_aued_rec);
   anzahl_records--;
   max_rec_zeiger = anzahl_records;

   if (anzahl_records==-1)
   {
      return 1;
      /* Insert message */
   }
   rewind(ix01file);
   fseek(ix01file,0L,SEEK_END);
   byte_zeiger = ftell(ix01file);
   anzahl_records = byte_zeiger / sizeof(ix01rec);
   anzahl_records--;

   rewind(ix01file);
   for (i=0;i<=anzahl_records;i++)
   {
      fread(&ix01rec,sizeof(ix01rec),1,ix01file);
      if (ix01rec.autorbu_rptr < 0)
      {
          continue; /* Kein Verweis auf autorbo.dat */
      }
      if (ix01rec.autorbu_rptr > max_rec_zeiger)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(out of range)" ,
                 ix01rec.kennziffer,
                 ix01rec.autorbu_rptr);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
         continue;
      }
      byte_zeiger = ix01rec.autorbu_rptr * sizeof(one_aued_rec);
      fseek(fpautorbu,byte_zeiger,SEEK_SET);
      fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
      if (strcmp(ix01rec.kennziffer,one_aued_rec.au_kennziffer)!=0)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(addresses record %s in %s)",
                 ix01rec.kennziffer,
                 ix01rec.autorbu_rptr,
                 one_aued_rec.au_kennziffer,
                 autorbu_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
         continue;
      }

      if (one_aued_rec.au_i != 1)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                 "(does not address 1st author in %s)",
                 ix01rec.kennziffer,
                 ix01rec.autorbu_rptr,
                 autorbu_name);
          wrtxt(wrtxtbu);
          fprintf(fplog,"%s",wrtxtbu);
          test_ok=0;
          continue;
      }

      if (one_aued_rec.in_use_au==0)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(record no more declared as 'in use' in %s)",
                 ix01rec.kennziffer,
                 ix01rec.autorbu_rptr,
                 autorbu_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
         continue;
      }

      /* Hier Ueberpruefung der weiteren Autoren */
      anzahl_aued=one_aued_rec.au_n;
      fseek(fpautorbu,byte_zeiger,SEEK_SET);
      for (j=1;j<=anzahl_aued;j++)
      {
         if (fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu)!=1)
         {
           sprintf(wrtxtbu,"\nUnexpected database file problem in record %s: %i. author/editor "
                           "(Unable to read author/editor name in %s)",
                   one_aued_rec.au_kennziffer,
                   one_aued_rec.au_i,
                   autorbu_name);
           wrtxt(wrtxtbu);
           fprintf(fplog,"%s",wrtxtbu);
           test_ok=0;
         }

         if (strlen(one_aued_rec.au_nachname) > AUNAME_LEN ||
             strlen(one_aued_rec.au_vornamen) > AUVORNAMEN_LEN)
         {
           sprintf(wrtxtbu,"\nDatabase file problem in record %s: at least one field "
                           "length out of range (%s)",
                   one_aued_rec.au_kennziffer,
                   autorbu_name);
           wrtxt(wrtxtbu);
           fprintf(fplog,"%s",wrtxtbu);
           test_ok=0;
         }
         if (one_aued_rec.au_n > MAX_N_AUTHORS)
         {
           sprintf(wrtxtbu,"\nDatabase file problem in record %s: max. numbers of authors/"
                           "editors out of range (%s)",
                   one_aued_rec.au_kennziffer,
                   autorbu_name);
           wrtxt(wrtxtbu);
           fprintf(fplog,"%s",wrtxtbu);
           test_ok=0;
           continue;
         }

         if (one_aued_rec.au_i != j)
         {
           sprintf(wrtxtbu,"\nDatabase file problem in record %s: %i. author expected, "
                           "%i. author found (%s)",
                   one_aued_rec.au_kennziffer,
                   j,
                   one_aued_rec.au_i,
                   autorbu_name);
           wrtxt(wrtxtbu);
           fprintf(fplog,"%s",wrtxtbu);
           test_ok=0;
           continue;
         }
         if (strcmp(ix01rec.kennziffer,one_aued_rec.au_kennziffer)!=0)
         {
            sprintf(wrtxtbu,"\nDatabase file problem in record %s, %i. author/editor: "
                            "unexpected reference number: "
                            "(record %s in %s)",
                    ix01rec.kennziffer,
                    j,
                    one_aued_rec.au_kennziffer,
                    autorbu_name);
            wrtxt(wrtxtbu);
            fprintf(fplog,"%s",wrtxtbu);
            test_ok=0;
            continue;
         }
      }
   }

   if (test_ok==1)
   {
       sprintf(wrtxtbu,"\nNo problem found (Rptr->%s).",
            autorbu_name);
   }
   else
   {
       sprintf(wrtxtbu,"\nEnd of list (problems Rptr->%s).",
                   autorbu_name);
   }

   wrtxt(wrtxtbu);
   fprintf(fplog,"%s",wrtxtbu);

   fclose(fpautorbu);
   if (!test_ok)
   {
       return 0;
   }
   else
   {
      return 1;
   }
}


static int ix_to_desc(void)
{
   int test_ok;
   long anzahl_records, byte_zeiger, max_rec_zeiger, i;
   short int anzahl_desc, j;

   test_ok=1;
   if ((fpdesc=fopen(desc_name,"rb"))==NULL)
   {
       sprintf(wrtxtbu,"\nProblem: unable to read %s",desc_name);
       fprintf(fplog,"%s",wrtxtbu);
       wrtxt(wrtxtbu);
       return 0;
   }
   rewind(fpdesc);
   fseek(fpdesc,0L,SEEK_END);
   byte_zeiger=ftell(fpdesc);
   anzahl_records=byte_zeiger / sizeof(one_desc_rec);
   anzahl_records--;
   max_rec_zeiger = anzahl_records;

   if (anzahl_records==-1)
   {
      return 1;
      /* Insert message */
   }
   rewind(ix01file);
   fseek(ix01file,0L,SEEK_END);
   byte_zeiger = ftell(ix01file);
   anzahl_records = byte_zeiger / sizeof(ix01rec);
   anzahl_records--;

   rewind(ix01file);
   for (i=0;i<=anzahl_records;i++)
   {
      fread(&ix01rec,sizeof(ix01rec),1,ix01file);
      if (ix01rec.desc_rptr < 0)
      {
          continue; /* Kein Verweis auf desc.dat */
      }
      if (ix01rec.desc_rptr > max_rec_zeiger)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(out of range)" ,
                 ix01rec.kennziffer,
                 ix01rec.desc_rptr);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
         continue;
      }
      byte_zeiger = ix01rec.desc_rptr * sizeof(one_desc_rec);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
      if (strcmp(ix01rec.kennziffer,one_desc_rec.kennziffer)!=0)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(addresses record %s in %s)",
                 ix01rec.kennziffer,
                 ix01rec.desc_rptr,
                 one_desc_rec.kennziffer,
                 desc_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
         continue;
      }

      if (one_desc_rec.desc_i != 1)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                 "(does not address 1st author in %s)",
                 ix01rec.kennziffer,
                 ix01rec.desc_rptr,
                 desc_name);
          wrtxt(wrtxtbu);
          fprintf(fplog,"%s",wrtxtbu);
          test_ok=0;
          continue;
      }

      if (one_desc_rec.in_use==0)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(record no more declared as 'in use' in %s)",
                 ix01rec.kennziffer,
                 ix01rec.desc_rptr,
                 desc_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
         continue;
      }

      /* Hier Ueberpruefung der weiteren Autoren */
      anzahl_desc=one_desc_rec.desc_n;
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      for (j=1;j<=anzahl_desc;j++)
      {
         if (fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc)!=1)
         {
           sprintf(wrtxtbu,"\nUnexpected database file problem in record %s: %i. author/editor "
                           "(Unable to read author/editor name in %s)",
                   one_desc_rec.kennziffer,
                   one_desc_rec.desc_i,
                   desc_name);
           wrtxt(wrtxtbu);
           fprintf(fplog,"%s",wrtxtbu);
           test_ok=0;
         }

         if (strlen(one_desc_rec.keywordsfield) > KEYWORDS_LEN)
         {
           sprintf(wrtxtbu,"\nDatabase file problem in record %s: at least one field "
                           "length out of range (%s)",
                   one_desc_rec.kennziffer,
                   desc_name);
           wrtxt(wrtxtbu);
           fprintf(fplog,"%s",wrtxtbu);
           test_ok=0;
         }
         if (one_desc_rec.desc_n > MAX_N_DESC)
         {
           sprintf(wrtxtbu,"\nDatabase file problem in record %s: max. numbers of KEYWORDS "
                           "out of range (%s)",
                   one_desc_rec.kennziffer,
                   desc_name);
           wrtxt(wrtxtbu);
           fprintf(fplog,"%s",wrtxtbu);
           test_ok=0;
           continue;
         }

         if (one_desc_rec.desc_i != j)
         {
           sprintf(wrtxtbu,"\nDatabase file problem in record %s: %i. KEYWORD expected, "
                           "%i. KEYWORD found (%s)",
                   one_desc_rec.kennziffer,
                   j,
                   one_desc_rec.desc_i,
                   desc_name);
           wrtxt(wrtxtbu);
           fprintf(fplog,"%s",wrtxtbu);
           test_ok=0;
           continue;
         }
         if (strcmp(ix01rec.kennziffer,one_desc_rec.kennziffer)!=0)
         {
            sprintf(wrtxtbu,"\nDatabase file problem in record %s, %i. KEYWORD: "
                            "unexpected reference number: "
                            "(record %s in %s)",
                    ix01rec.kennziffer,
                    j,
                    one_desc_rec.kennziffer,
                    desc_name);
            wrtxt(wrtxtbu);
            fprintf(fplog,"%s",wrtxtbu);
            test_ok=0;
            continue;
         }
      }
   }

   if (test_ok==1)
   {
       sprintf(wrtxtbu,"\nNo problem found (Rptr->%s).",
            desc_name);
   }
   else
   {
       sprintf(wrtxtbu,"\nEnd of list (problems Rptr->%s).",
                   desc_name);
   }

   wrtxt(wrtxtbu);
   fprintf(fplog,"%s",wrtxtbu);

   fclose(fpdesc);
   if (!test_ok)
   {
       return 0;
   }
   else
   {
      return 1;
   }
}


static int ix_to_abst(void)
{
   int test_ok;
   long anzahl_records, byte_zeiger, max_rec_zeiger, i;

   short int anzahl_bloecke, j;

   test_ok=1;

   if ((fpabs=fopen(abstr_dat_name,"rb"))==NULL)
   {
       sprintf(wrtxtbu,"\nProblem: unable to read %s",abstr_dat_name);
       fprintf(fplog,"%s",wrtxtbu);
       wrtxt(wrtxtbu);
       return 0;
   }

   rewind(fpabs);
   fseek(fpabs,0L,SEEK_END);
   byte_zeiger=ftell(fpabs);
   anzahl_records=byte_zeiger / sizeof(one_abstr_rec);
   anzahl_records--;
   max_rec_zeiger = anzahl_records;
   if (anzahl_records==-1)
   {
      return 1;
      /* Insert message */
   }

   rewind(ix04file);
   fseek(ix04file,0L,SEEK_END);
   byte_zeiger = ftell(ix04file);
   anzahl_records = byte_zeiger / sizeof(ix04rec);
   anzahl_records--;

   rewind(ix04file);

   for (i=0;i<=anzahl_records;i++)
   {
      fread(&ix04rec,sizeof(ix04rec),1,ix04file);
      if (ix04rec.abstr_rptr < 0)
      {
          continue; /* Kein Verweis auf autorjl.dat */
      }
      if (ix04rec.abstr_rptr > max_rec_zeiger)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(out of range)" ,
                 ix04rec.kennziffer,
                 ix04rec.abstr_rptr);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
         continue;
      }
      byte_zeiger = ix04rec.abstr_rptr * sizeof(one_abstr_rec);
      fseek(fpabs,byte_zeiger,SEEK_SET);
      fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
      if (strcmp(ix04rec.kennziffer,one_abstr_rec.kennziffer)!=0)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(addresses record %s in %s)",
                 ix04rec.kennziffer,
                 ix04rec.abstr_rptr,
                 one_abstr_rec.kennziffer,
                 abstr_dat_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
         continue;
      }

      if (one_abstr_rec.abstr_i != 1)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                 "(does not address 1st author in %s)",
                 ix04rec.kennziffer,
                 ix04rec.abstr_rptr,
                 abstr_dat_name);
          wrtxt(wrtxtbu);
          fprintf(fplog,"%s",wrtxtbu);
          test_ok=0;
          continue;
      }

      if (one_abstr_rec.in_use==0)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(record no more declared as 'in use' in %s)",
                 ix04rec.kennziffer,
                 ix04rec.abstr_rptr,
                 abstr_dat_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
         continue;
      }

      /* Hier Ueberpruefung der weiteren Autoren */
     anzahl_bloecke=one_abstr_rec.abstr_n;
     fseek(fpabs,byte_zeiger,SEEK_SET);
     for (j=1;j<=anzahl_bloecke;j++)
     {
       if (fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs)!=1)
       {
           sprintf(wrtxtbu,"\nUnexpected database file problem in record %s: %i. block "
                        "(Unable to read block in %s)",
               one_abstr_rec.kennziffer,
               one_abstr_rec.abstr_i,
               abstr_dat_name);
           wrtxt(wrtxtbu);
           fprintf(fplog,"%s",wrtxtbu);
           test_ok=0;
       }
       if (strlen(one_abstr_rec.abs_text) > ABSTEXT_LEN)
       {
           sprintf(wrtxtbu,"\nDatabase file problem in record %s: text field "
                           "length out of range (%s)",
                           one_abstr_rec.kennziffer,
                           abstr_dat_name
                           );
           wrtxt(wrtxtbu);
           fprintf(fplog,"%s",wrtxtbu);
           test_ok=0;
       }
       if (one_abstr_rec.abstr_n > MAX_BLOECKE)
       {
           sprintf(wrtxtbu,"\nDatabase file problem in record %s: max. numbers of blocks "
                           "out of range (%s)",
                   one_abstr_rec.kennziffer,
                   abstr_dat_name);
           wrtxt(wrtxtbu);
           fprintf(fplog,"%s",wrtxtbu);
           test_ok=0;
           continue;

       }
       if (one_abstr_rec.abstr_i != j)
       {
           sprintf(wrtxtbu,"\nDatabase file problem in record %s: %i. block expected, "
                           "%i. block found (%s)",
                   one_abstr_rec.kennziffer,
                   j,
                   one_abstr_rec.abstr_i,
                   abstr_dat_name);
           wrtxt(wrtxtbu);
           fprintf(fplog,"%s",wrtxtbu);
           test_ok=0;
           continue;
       }
       if (strcmp(ix04rec.kennziffer,one_abstr_rec.kennziffer)!=0)
       {
            sprintf(wrtxtbu,"\nDatabase file problem in record %s, %i. block: "
                            "unexpected reference number: "
                            "(record %s in %s)",
                    ix04rec.kennziffer,
                    j,
                    one_abstr_rec.kennziffer,
                    abstr_dat_name);
            wrtxt(wrtxtbu);
            fprintf(fplog,"%s",wrtxtbu);
            test_ok=0;
            continue;
       }

     }
   }

   if (test_ok==1)
   {
       sprintf(wrtxtbu,"\nNo problem found (Rptr->%s).",
            abstr_dat_name);
   }
   else
   {
       sprintf(wrtxtbu,"\nEnd of list (problems Rptr->%s).",
                   abstr_dat_name);
   }

   wrtxt(wrtxtbu);
   fprintf(fplog,"%s",wrtxtbu);

   fclose(fpabs);
   if (!test_ok)
   {
       return 0;
   }
   else
   {
      return 1;
   }

}

static int ix_to_source(void)
{
   int test_ok;
   long anzahl_records, byte_zeiger, max_rec_zeiger, i;
   test_ok=1;

   if ((fpquell=fopen(quell_name,"rb"))==NULL)
   {
       sprintf(wrtxtbu,"\nProblem: unable to read %s",quell_name);
       fprintf(fplog,"%s",wrtxtbu);
       wrtxt(wrtxtbu);
       return 0;
   }

   rewind(fpquell);
   fseek(fpquell,0L,SEEK_END);
   byte_zeiger=ftell(fpquell);
   anzahl_records=byte_zeiger / sizeof(one_quell_rec);
   anzahl_records--;
   /* biggest possible pointer value */
   max_rec_zeiger = anzahl_records;

   if (anzahl_records==-1)
   {
      return 1;
      /* Insert message */
   }

   rewind(ix02file);
   fseek(ix02file,0L,SEEK_END);
   byte_zeiger = ftell(ix02file);
   anzahl_records = byte_zeiger / sizeof(ix02rec);
   anzahl_records--;
   rewind(ix02file);
   for (i=0;i<=anzahl_records;i++)
   {
      fread(&ix02rec,sizeof(ix02rec),1,ix02file);
      if (ix02rec.quell_rptr < 0)
      {
          continue;  /* Kein Verweis auf quell.dat */
      }
      if (ix02rec.quell_rptr > max_rec_zeiger)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(out of range)" ,
                 ix02rec.quell_kuerzel,
                 ix02rec.quell_rptr);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
         continue;
      }
      byte_zeiger = ix02rec.quell_rptr * sizeof(one_quell_rec);
      fseek(fpquell,byte_zeiger,SEEK_SET);
      fread(&one_quell_rec,sizeof(one_quell_rec),1,fpquell);
      if (strcmp(ix02rec.quell_kuerzel,one_quell_rec.quell_kuerzel)!=0)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(addresses record %s in %s)",
                 ix02rec.quell_kuerzel,
                 ix02rec.quell_rptr,
                 one_quell_rec.quell_kuerzel,
                 quell_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
      }
      if (one_quell_rec.in_use_quell==0)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(record no more declared as 'in use' in %s)",
                 ix02rec.quell_kuerzel,
                 ix02rec.quell_rptr,
                 quell_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
      }
      if (
          strlen(one_quell_rec.quell_zeitschrift) > ZEITSCHRIFT_LEN ||
          strlen(one_quell_rec.quell_kurzform) > KURZFORM_LEN ||
          strlen(one_quell_rec.quell_issn) > ISSN_LEN
          )
      {
         sprintf(wrtxtbu,"\nDatabase file problem in record %s: at least one field "
                         "length out of range (%s)",
                 one_quell_rec.quell_kuerzel,
                 quell_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
      }

   }

   if (test_ok==1)
   {
       sprintf(wrtxtbu,"\nNo problem found (Rptr->%s).",
            quell_name);
   }
   else
   {
       sprintf(wrtxtbu,"\nEnd of list (problems Rptr->%s).",
                   quell_name);
   }

   wrtxt(wrtxtbu);
   fprintf(fplog,"%s",wrtxtbu);


   fclose(fpquell);
   if (!test_ok)
   {
       return 0;
   }
   else
   {
      return 1;
   }
}

static int ix_to_keyw(void)
{
   int test_ok;
   long anzahl_records, byte_zeiger, max_rec_zeiger, i;
   test_ok=1;

   if ((fpstichw=fopen(stichw_name,"rb"))==NULL)
   {
       sprintf(wrtxtbu,"\nProblem: unable to read %s",stichw_name);
       fprintf(fplog,"%s",wrtxtbu);
       wrtxt(wrtxtbu);
       return 0;
   }

   rewind(fpstichw);
   fseek(fpstichw,0L,SEEK_END);
   byte_zeiger=ftell(fpstichw);
   anzahl_records=byte_zeiger / sizeof(one_stichw_rec);
   anzahl_records--;
   /* biggest possible pointer value */
   max_rec_zeiger = anzahl_records;

   if (anzahl_records==-1)
   {
      return 1;
      /* Insert message */
   }

   rewind(ix03file);
   fseek(ix03file,0L,SEEK_END);
   byte_zeiger = ftell(ix03file);
   anzahl_records = byte_zeiger / sizeof(ix03rec);
   anzahl_records--;
   rewind(ix03file);
   for (i=0;i<=anzahl_records;i++)
   {
      fread(&ix03rec,sizeof(ix03rec),1,ix03file);
      if (ix03rec.keywords_rptr < 0)
      {
          continue;  /* Kein Verweis auf quell.dat */
      }
      if (ix03rec.keywords_rptr > max_rec_zeiger)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(out of range)" ,
                 ix03rec.keywordsfield,
                 ix03rec.keywords_rptr);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
         continue;
      }
      byte_zeiger = ix03rec.keywords_rptr * sizeof(one_stichw_rec);
      fseek(fpstichw,byte_zeiger,SEEK_SET);
      fread(&one_stichw_rec,sizeof(one_stichw_rec),1,fpstichw);
      if (strcmp(ix03rec.keywordsfield,one_stichw_rec.keywordsfield)!=0)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(addresses record %s in %s)",
                 ix03rec.keywordsfield,
                 ix03rec.keywords_rptr,
                 one_stichw_rec.keywordsfield,
                 stichw_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
      }
      if (one_stichw_rec.in_use==0)
      {
         sprintf(wrtxtbu,"\nIndex file problem in record %s: invalid RecPtr: %li "
                         "(record no more declared as 'in use' in %s)",
                 ix03rec.keywordsfield,
                 ix03rec.keywords_rptr,
                 stichw_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
      }
      if (strlen(one_stichw_rec.keywordsfield) > KEYWORDS_LEN)
      {
         sprintf(wrtxtbu,"\nDatabase file problem in record %s: at least one field "
                         "length out of range (%s)",
                 one_stichw_rec.keywordsfield,
                 stichw_name);
         wrtxt(wrtxtbu);
         fprintf(fplog,"%s",wrtxtbu);
         test_ok=0;
      }

   }

   if (test_ok==1)
   {
       sprintf(wrtxtbu,"\nNo problem found (Rptr->%s).",
            stichw_name);
   }
   else
   {
       sprintf(wrtxtbu,"\nEnd of list (problems Rptr->%s).",
                   stichw_name);
   }

   wrtxt(wrtxtbu);
   fprintf(fplog,"%s",wrtxtbu);


   fclose(fpstichw);
   if (!test_ok)
   {
       return 0;
   }
   else
   {
      return 1;
   }
}


static int dats_to_ixs(void)
{
   int bisher_ok;
   int ok;

   bisher_ok=1;

   sprintf(wrtxtbu,"\n*** Function 'IndxComplete' ***\n");
   wrtxt(wrtxtbu);
   fprintf(fplog,"%s",wrtxtbu);

   if (
        !isfile(journal_name) || filesize(journal_name)==0 ||
        !isfile(journal_pix_name) || filesize(journal_pix_name)==0 ||
        !isfile(abstr_dat_name) || filesize(abstr_dat_name)==0 ||
        !isfile(abstr_pix_name) || filesize(abstr_pix_name)==0 ||
        !isfile(quell_name) || filesize(quell_name)==0 ||
        !isfile(quell_pix_name) || filesize(quell_pix_name)==0 ||
        !isfile(stichw_name) || filesize(stichw_name)==0 ||
        !isfile(stichw_pix_name) || filesize(stichw_pix_name)==0
      )
   {
      sprintf(wrtxtbu,"\nUnable to perform this function: DAT/IX file(s) "
                      "empty or missing");
      wrtxt(wrtxtbu);
      fprintf(fplog,"%s",wrtxtbu);
      if (bisher_ok)
      {
        bisher_ok=0;
      }
   }
   else
   {
     ok=journal_to_ix();
     if (!ok)
     {
       bisher_ok=0;
     }
     ok=abst_to_ix();
     if (!ok)
     {
       bisher_ok=0;
     }
     ok=source_to_ix();
     if (!ok)
     {
       bisher_ok=0;
     }
     ok=keyw_to_ix();
     if (!ok)
     {
       bisher_ok=0;
     }
   }

   if (bisher_ok)
   {
      sprintf(wrtxtbu,"\n\nCompleted, no problems found.");
   }
   else
   {
     sprintf(wrtxtbu,"\n\nAt least one problem was found! Please read %s",
          VERIFY_LOG);

   }
   fprintf(fplog,"%s",wrtxtbu);
   wrtxt(wrtxtbu);

   fprintf(fplog,"\n\n");
   return bisher_ok;
}

static int journal_to_ix(void)
{
   long anzahl_records, byte_zeiger, rec_zeiger, i;
   int test_ok;
   char kzf[KENNZIFFER_LEN+1];

   test_ok=1;

   if (filesize(journal_name)< sizeof(one_journal_rec))
   {
      test_ok=0;
   }
   if (test_ok)
   {
     if (read_ix01(journal_pix_name)==0)
     {
        test_ok=0;
     }
   }
   if (test_ok)
   {
     if ((fpjournal=fopen(journal_name,"rb"))==NULL)
     {
         sprintf(wrtxtbu,"\nProblem: unable to read %s",journal_name);
         fprintf(fplog,"%s",wrtxtbu);
         wrtxt(wrtxtbu);
         return 0;
     }
     rewind(fpjournal);
     fseek(fpjournal,0L,SEEK_END);
     byte_zeiger=ftell(fpjournal);
     anzahl_records=byte_zeiger / sizeof(one_journal_rec);
     anzahl_records--;
     rewind(fpjournal);
     memset(&ix01rec,0,sizeof(ix01rec));
     for (i=0;i<=anzahl_records;i++)
     {
        fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
        if (one_journal_rec.in_use==1)
        {
          strlimcpy(kzf,one_journal_rec.kennziffer,KENNZIFFER_LEN);
          rec_zeiger = locate_ix01(kzf,&ix01rec);
          if (rec_zeiger < 0)
          {
             sprintf(wrtxtbu,"\nProblem in record %s of file %s: "
             "corresponding key not found in %s",
             one_journal_rec.kennziffer,
             journal_name, journal_pix_name);
             wrtxt(wrtxtbu);
             fprintf(fplog,"%s",wrtxtbu);
             test_ok = 0;
          }
        }
     }

     close_ix01();
     fclose(fpjournal);
   }
   if (test_ok)
   {
       sprintf(wrtxtbu,"\nNo problems found (%s\n-> key in %s).",
       journal_name, journal_pix_name);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);
   }
   else
   {
       sprintf(wrtxtbu,"\nEnd of list (Problems %s\n-> key in %s).",
       journal_name, journal_pix_name);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);
   }
   return test_ok;
}


static int abst_to_ix(void)
{
   long anzahl_records, byte_zeiger, rec_zeiger, i;
   int test_ok;
   char kzf[KENNZIFFER_LEN+1];

   test_ok=1;

   if (filesize(abstr_dat_name)< sizeof(one_abstr_rec))
   {
      test_ok=0;
   }
   if (test_ok)
   {
     if (read_ix04(abstr_pix_name)==0)
     {
        test_ok=0;
     }
   }
   if (test_ok)
   {
     if ((fpabs=fopen(abstr_dat_name,"rb"))==NULL)
     {
         sprintf(wrtxtbu,"\nProblem: unable to read %s",abstr_dat_name);
         fprintf(fplog,"%s",wrtxtbu);
         wrtxt(wrtxtbu);
         return 0;
     }
     rewind(fpabs);
     fseek(fpabs,0L,SEEK_END);
     byte_zeiger=ftell(fpabs);
     anzahl_records=byte_zeiger / sizeof(one_abstr_rec);
     anzahl_records--;
     rewind(fpabs);
     memset(&ix04rec,0,sizeof(ix04rec));
     for (i=0;i<=anzahl_records;i++)
     {
        fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
        if ((one_abstr_rec.in_use==1) && (one_abstr_rec.abstr_i==1))
        {
          strlimcpy(kzf,one_abstr_rec.kennziffer,KENNZIFFER_LEN);
          rec_zeiger = locate_ix04(kzf,&ix04rec);
          if (rec_zeiger < 0)
          {
             sprintf(wrtxtbu,"\nProblem in record %s of file %s: "
             "corresponding key not found in %s",
             one_abstr_rec.kennziffer,
             abstr_dat_name, abstr_pix_name);
             wrtxt(wrtxtbu);
             fprintf(fplog,"%s",wrtxtbu);
             test_ok = 0;
          }
        }
     }

     close_ix04();
     fclose(fpabs);
   }
   if (test_ok)
   {
       sprintf(wrtxtbu,"\nNo problems found (%s\n-> key in %s).",
       abstr_dat_name, abstr_pix_name);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);
   }
   else
   {
       sprintf(wrtxtbu,"\nEnd of list (Problems %s\n-> key in %s).",
       abstr_dat_name, abstr_pix_name);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);
   }
   return test_ok;
}

static int source_to_ix(void)
{
   long anzahl_records, byte_zeiger, rec_zeiger, i;
   int test_ok;
   char kzf[QUELLKUERZEL_LEN+1];

   test_ok=1;

   if (filesize(quell_name) < sizeof(one_quell_rec))
   {
      test_ok=0;
   }
   if (test_ok)
   {
     if (read_ix02(quell_pix_name)==0)
     {
        test_ok=0;
     }
   }
   if (test_ok)
   {
     if ((fpquell=fopen(quell_name,"rb"))==NULL)
     {
         sprintf(wrtxtbu,"\nProblem: unable to read %s",quell_name);
         fprintf(fplog,"%s",wrtxtbu);
         wrtxt(wrtxtbu);
         return 0;
     }
     rewind(fpquell);
     fseek(fpquell,0L,SEEK_END);
     byte_zeiger=ftell(fpquell);
     anzahl_records=byte_zeiger / sizeof(one_quell_rec);
     anzahl_records--;
     rewind(fpquell);
     memset(&ix02rec,0,sizeof(ix02rec));
     for (i=0;i<=anzahl_records;i++)
     {
        fread(&one_quell_rec,sizeof(one_quell_rec),1,fpquell);
        if (one_quell_rec.in_use_quell==1)
        {
          strlimcpy(kzf,one_quell_rec.quell_kuerzel,QUELLKUERZEL_LEN);
          rec_zeiger = locate_ix02(kzf,&ix02rec);
          if (rec_zeiger < 0)
          {
             sprintf(wrtxtbu,"\nProblem in record %s of file %s: "
             "corresponding key not found in %s",
             one_quell_rec.quell_kuerzel,
             quell_name, quell_pix_name);
             wrtxt(wrtxtbu);
             fprintf(fplog,"%s",wrtxtbu);
             test_ok = 0;
          }
        }
     }

     close_ix02();
     fclose(fpquell);
   }
   if (test_ok)
   {
       sprintf(wrtxtbu,"\nNo problems found (%s\n-> key in %s).",
       quell_name, quell_pix_name);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);
   }
   else
   {
       sprintf(wrtxtbu,"\nEnd of list (Problems %s\n-> key in %s).",
       quell_name, quell_pix_name);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);
   }
   return test_ok;
}

static int keyw_to_ix(void)
{
   long anzahl_records, byte_zeiger, rec_zeiger, i;
   int test_ok;
   char kzf[KEYWORDS_LEN+1];

   test_ok=1;

   if (filesize(stichw_name) < sizeof(one_stichw_rec))
   {
      test_ok=0;
   }
   if (test_ok)
   {
     if (read_ix03(stichw_pix_name)==0)
     {
        test_ok=0;
     }
   }
   if (test_ok)
   {
     if ((fpstichw=fopen(stichw_name,"rb"))==NULL)
     {
         sprintf(wrtxtbu,"\nProblem: unable to read %s",stichw_name);
         fprintf(fplog,"%s",wrtxtbu);
         wrtxt(wrtxtbu);
         return 0;
     }
     rewind(fpstichw);
     fseek(fpstichw,0L,SEEK_END);
     byte_zeiger=ftell(fpstichw);
     anzahl_records=byte_zeiger / sizeof(one_stichw_rec);
     anzahl_records--;
     rewind(fpstichw);
     memset(&ix03rec,0,sizeof(ix03rec));
     for (i=0;i<=anzahl_records;i++)
     {
        fread(&one_stichw_rec,sizeof(one_stichw_rec),1,fpstichw);
        if (one_stichw_rec.in_use==1)
        {
          strlimcpy(kzf,one_stichw_rec.keywordsfield,KEYWORDS_LEN);
          rec_zeiger = locate_ix03(kzf,&ix03rec);
          if (rec_zeiger < 0)
          {
             sprintf(wrtxtbu,"\nProblem in record %s of file %s: "
             "corresponding key not found in %s",
             one_stichw_rec.keywordsfield,
             stichw_name, stichw_pix_name);
             wrtxt(wrtxtbu);
             fprintf(fplog,"%s",wrtxtbu);
             test_ok = 0;
          }
        }
     }

     close_ix03();
     fclose(fpstichw);
   }
   if (test_ok)
   {
       sprintf(wrtxtbu,"\nNo problems found (%s\n-> key in %s).",
       stichw_name, stichw_pix_name);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);
   }
   else
   {
       sprintf(wrtxtbu,"\nEnd of list (Problems %s\n-> key in %s).",
       stichw_name, stichw_pix_name);
       wrtxt(wrtxtbu);
       fprintf(fplog,"%s",wrtxtbu);
   }
   return test_ok;
}

static int db_information(void)
{
#if defined(__EMX__)
   DIR * dirp;
   struct dirent * direntp;
#endif
#if defined(__DJGPP__)
   struct find_t fi;
#endif

   int ok, alles_ok;

   char dbase_name[PFAD_LEN+1];
   char datenpfad[PFAD_LEN+1];
   char bbt_pfad[PFAD_LEN+1];

   ok = 1;
   alles_ok=1;

   getcwd(datenpfad,PFAD_LEN-1);
   extractitem(countitem(datenpfad,"\\"),datenpfad,"\\",dbase_name);

   sprintf(wrtxtbu,"\n*** Function 'DBaseInfo' ***\n");
   wrtxt(wrtxtbu);
   fprintf(fplog,"%s",wrtxtbu);

   sprintf(wrtxtbu,"\nInformation on database '%s':",dbase_name);
   wrtxt(wrtxtbu);
   fprintf(fplog,"%s",wrtxtbu);

   sprintf(wrtxtbu,"\n\nWorking directory: %s\n\n",datenpfad);
   wrtxt(wrtxtbu);
   fprintf(fplog,"%s",wrtxtbu);

   ok=datei_analysieren(journal_name,sizeof(one_journal_rec));
   if (!ok) { alles_ok = 0; }
   ok=datei_analysieren(journal_pix_name,sizeof(ix01rec));
   if (!ok) { alles_ok = 0; }
   ok=datei_analysieren(desc_name,sizeof(one_desc_rec));
   if (!ok) { alles_ok = 0; }
   ok=datei_analysieren(book_name,sizeof(one_buch_rec));
   if (!ok) { alles_ok = 0; }
   ok=datei_analysieren(autorjl_name,sizeof(one_aued_rec));
   if (!ok) { alles_ok = 0; }
   ok=datei_analysieren(autorbu_name,sizeof(one_aued_rec));
   if (!ok) { alles_ok = 0; }
   ok=datei_analysieren(abstr_dat_name,sizeof(one_abstr_rec));
   if (!ok) { alles_ok = 0; }
   ok=datei_analysieren(abstr_pix_name,sizeof(ix04rec));
   if (!ok) { alles_ok = 0; }
   ok=datei_analysieren(quell_name,sizeof(one_quell_rec));
   if (!ok) { alles_ok = 0; }
   ok=datei_analysieren(quell_pix_name,sizeof(ix02rec));
   if (!ok) { alles_ok = 0; }
   ok=datei_analysieren(stichw_name,sizeof(one_stichw_rec));
   if (!ok) { alles_ok = 0; }
   ok=datei_analysieren(stichw_pix_name,sizeof(ix03rec));
   if (!ok) { alles_ok = 0; }
   ok=datei_analysieren(formdef_name,sizeof(formdef_rec));
   if (!ok) { alles_ok = 0; }


#if defined(__EMX__)

    dirp = opendir(datenpfad);
    if (dirp!=NULL)
    {
       for(;;)
       {
          direntp = readdir(dirp);
          if (direntp==NULL) break;
          if ((direntp->d_attr & (A_HIDDEN|A_SYSTEM|A_LABEL|A_DIR))==0
             && fnmatch("*.bbt",direntp->d_name,_FNM_IGNORECASE|_FNM_DOS)==0)
          {
              strcpy(bbt_pfad,direntp->d_name);
              upper(bbt_pfad);
              /* vor. Zeile eingefuegt 15.11.1998 */
              ok=datei_analysieren(bbt_pfad,sizeof(bbatchtable_rec));
              if (!ok) { alles_ok = 0; }
          }
       }
       closedir(dirp);
    }
#endif
#if defined(__DJGPP__)
    if ( !_dos_findfirst("*.bbt",_A_NORMAL,&fi) )
    {
       do
       {
          strcpy(bbt_pfad,fi.name);
          upper(bbt_pfad);
          ok=datei_analysieren(bbt_pfad,sizeof(bbatchtable_rec));
          if (!ok) { alles_ok = 0; }
       } while (!_dos_findnext(&fi));
    }
#endif



   fprintf(fplog,"\n");
   sprintf(wrtxtbu,"\nInformation has been written to %s."
                   ,VERIFY_LOG);
   wrtxt(wrtxtbu);
   return alles_ok;
}

static int datei_analysieren(const char * dn, int ds_groesse)
{
   time_t zeitstempel;
   struct stat datei_i_puffer;
   struct tm * zeit;
   off_t f_groesse;
   int rgwert;
   rgwert = 1;
#if defined(__EMX__)
   if (stat(dn,&datei_i_puffer)==-1)
#endif
#if defined(__DJGPP__)
   if (stat(dn,&datei_i_puffer)!=0)
#endif
   {
      sprintf(wrtxtbu,"Unable to analyze %s\n",dn);
      rgwert = 0;
   }
   else
   {
     zeitstempel = datei_i_puffer.st_mtime;
     f_groesse = datei_i_puffer.st_size;
     zeit = localtime(&zeitstempel);

#if defined(__EMX__)
     sprintf(wrtxtbu,"File: %s,\n      size: %li, last modification: %s",
                      dn,f_groesse,asctime(zeit));
#endif
#if defined(__DJGPP__)
     sprintf(wrtxtbu,"File: %s,\n      size: %i, last modification: %s",
                      dn,f_groesse,asctime(zeit));
#endif

     if (f_groesse % ds_groesse != 0)
     {
        rgwert = 0;
        beeps();
        strlimcat(wrtxtbu,"   -> Caution: incorrect file size, (corrupt file?).\n"
                          "      Please refer to the REFERENCES documentation!\n",
                           WRTXTBU_LEN-1);
     }
   }

   wrtxt(wrtxtbu);
   fprintf(fplog,"%s",wrtxtbu);

   return rgwert;
}

static int alles_analysieren(void)
{
   int ok;
   ok=1;

   ok= db_information();

   if (ok)
   {
      wrtxt("\n\n");
      ok = duplicate_test();
   }
   if (ok)
   {
      wrtxt("\n\n");
      ok=ixs_to_dats();
   }
   if (ok)
   {
      wrtxt("\n\n");
      ok=dats_to_ixs();
   }
   if (ok)
   {
      wrtxt("\n\n");
      ok=test_bbts();
   }

   if (ok)
   {
      sprintf(wrtxtbu," *** All tests: Completed, no problems found.");
   }
   else
   {
     beeps();
     sprintf(wrtxtbu," *** All tests: At least one problem was found! Please read %s",
          VERIFY_LOG);

   }
   wrtxt("\n\n");

   fprintf(fplog,"%s",wrtxtbu);
   wrtxt(wrtxtbu);
   return ok;
}

static int test_formdef_dat(void)
{

#define ABB1 {  \
               ok=0; \
               sprintf(wrtxtbu,"\nDatabase file problem in record %li: at " \
                               "least one text field length out of range %s", \
               i, \
               formdef_name); \
               wrtxt(wrtxtbu); \
               fprintf(fplog,"%s",wrtxtbu); \
               break;   \
             }
#define ABB2 if (ok==0) break;

   int ok;
   long anzahl_records, byte_zeiger,i;
   int j;

   ok = 1;
   if ((fpformdef=fopen(formdef_name,"rb"))==NULL)
   {
       sprintf(wrtxtbu,"\nProblem: unable to read %s",formdef_name);
       fprintf(fplog,"%s",wrtxtbu);
       wrtxt(wrtxtbu);
       return 0;
   }
   rewind(fpformdef);
   fseek(fpformdef,0L,SEEK_END);
   byte_zeiger=ftell(fpformdef);
   anzahl_records=byte_zeiger/sizeof(fd);
   anzahl_records--;
   rewind(fpformdef);
   for (i=0;i<=anzahl_records;i++)
   {
      fread(&fd,sizeof(fd),1,fpformdef);

      if (strlen(fd.formkennung) > FORMKENNUNG_LEN) ABB1
      if (strlen(fd.formatbeschreibung) > FORMATBESCHREIBUNG_LEN) ABB1
      if (strlen(fd.fdj1_str1) > TYP_STRING_LEN) ABB1
      if (strlen(fd.fdj1_str2) > TYP_STRING_LEN) ABB1
      if (strlen(fd.fdj1_str3) > TYP_STRING_LEN) ABB1
      if (strlen(fd.fdb1_str1) > TYP_STRING_LEN) ABB1
      if (strlen(fd.fdb1_str2) > TYP_STRING_LEN) ABB1
      if (strlen(fd.fdb1_str3) > TYP_STRING_LEN) ABB1
      if (strlen(fd.fdb2_str1) > TYP_STRING_LEN) ABB1
      if (strlen(fd.fdb2_str2) > TYP_STRING_LEN) ABB1
      if (strlen(fd.fdb2_str3) > TYP_STRING_LEN) ABB1
      if (strlen(fd.fdb2_str4) > TYP_STRING_LEN) ABB1
      if (strlen(fd.fdb2_str5) > TYP_STRING_LEN) ABB1
      for (j=0;j<J1_AUT_N;j++)
      {
         if (strlen(fd.j1_aut[j]) > FD_FELD_LEN) ABB1
      } ABB2
      for (j=0;j<J1_TIT_N;j++)
      {
         if (strlen(fd.j1_tit[j]) > FD_FELD_LEN) ABB1
      } ABB2
      for (j=0;j<J1_LOK_N;j++)
      {
         if (strlen(fd.j1_lok[j]) > FD_FELD_LEN) ABB1
      } ABB2

      for (j=0;j<B1_ED_N;j++)
      {
         if (strlen(fd.b1_ed[j]) > FD_FELD_LEN) ABB1
      } ABB2
      for (j=0;j<B1_TIT_N;j++)
      {
         if (strlen(fd.b1_tit[j]) > FD_FELD_LEN) ABB1
      } ABB2
      for (j=0;j<B1_LOK_N;j++)
      {
         if (strlen(fd.b1_lok[j]) > FD_FELD_LEN) ABB1
      } ABB2

      for (j=0;j<B2_AUT_N;j++)
      {
         if (strlen(fd.b2_aut[j]) > FD_FELD_LEN) ABB1
      } ABB2
      for (j=0;j<B2_TIT_N;j++)
      {
         if (strlen(fd.b2_tit[j]) > FD_FELD_LEN) ABB1
      } ABB2
      for (j=0;j<B2_ED_N;j++)
      {
         if (strlen(fd.b2_ed[j]) > FD_FELD_LEN) ABB1
      } ABB2
      for (j=0;j<B2_TITB_N;j++)
      {
         if (strlen(fd.b2_titb[j]) > FD_FELD_LEN) ABB1
      } ABB2
      for (j=0;j<B2_LOK_N;j++)
      {
         if (strlen(fd.b2_lok[j]) > FD_FELD_LEN) ABB1
      } ABB2
      if (strlen(fd.fdauttyp_j1) > AUTTYP_LEN) ABB1
      if (strlen(fd.fdauttyp_b1) > AUTTYP_LEN) ABB1
      if (strlen(fd.fdauttyp_b2au) > AUTTYP_LEN) ABB1
      if (strlen(fd.fdauttyp_b2ed) > AUTTYP_LEN) ABB1
      if (strlen(fd.fdbetwau_j1) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdbetwau_b1) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdbetwau_b2au) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdbetwau_b2ed) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdbetwaulast_j1) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdbetwaulast_b1) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdbetwaulast_b2au) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdbetwaulast_b2ed) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdv_j1) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdv_b1) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdv_b2au) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdv_b2ed) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdauvornach_j1) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdauvornach_b1) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdauvornach_b2au) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdauvornach_b2ed) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdaunachvor_j1) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdaunachvor_b1) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdaunachvor_b2au) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdaunachvor_b2ed) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdafterlastau_j1) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdafterlastau_b1) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdafterlastau_b2au) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdafterlastau_b2ed) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdweitereau_j1) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdweitereau_b1) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdweitereau_b2au) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdweitereau_b2ed) > FD_FELD_LEN) ABB1
      if (strlen(fd.fdau_n_j1) > ZIFFER_STRING_LEN) ABB1
      if (strlen(fd.fdau_n_b1) > ZIFFER_STRING_LEN) ABB1
      if (strlen(fd.fdau_n_b2au) > ZIFFER_STRING_LEN) ABB1
      if (strlen(fd.fdau_n_b2ed) > ZIFFER_STRING_LEN) ABB1
      if (strlen(fd.fdau_m_j1) > ZIFFER_STRING_LEN) ABB1
      if (strlen(fd.fdau_m_b1) > ZIFFER_STRING_LEN) ABB1
      if (strlen(fd.fdau_m_b2au) > ZIFFER_STRING_LEN) ABB1
      if (strlen(fd.fdau_m_b2ed) > ZIFFER_STRING_LEN) ABB1
   }

   fclose(fpformdef);
   if (ok==1)
   {
       sprintf(wrtxtbu,"\nNo problem found (%s).",
            formdef_name);
   }
   else
   {
       sprintf(wrtxtbu,"\nEnd of list (%s).",
             formdef_name);
   }

   wrtxt(wrtxtbu);
   fprintf(fplog,"%s",wrtxtbu);

#undef ABB1
#undef ABB2

   return ok;
}

static int test_bbts(void)
{

#if defined(__EMX__)
   DIR * dirp;
   struct dirent * direntp;
   char datenpfad[PFAD_LEN+1];
#endif
#if defined(__DJGPP__)
   struct find_t fi;
#endif

   char bbt_pfad[PFAD_LEN+1];
   long i, anzahl_records, byte_zeiger;

   int ok;


   ok=1;
   sprintf(wrtxtbu,"\n*** Function 'Batch' ***\n");
   wrtxt(wrtxtbu);
   fprintf(fplog,"%s",wrtxtbu);
   sprintf(wrtxtbu,"\nSearching BBT-files");
   wrtxt(wrtxtbu);
   fprintf(fplog,"%s",wrtxtbu);




#if defined(__EMX__)

    getcwd(datenpfad,PFAD_LEN-1);
    dirp = opendir(datenpfad);
    if (dirp!=NULL)
    {
       for(;;)
       {
          direntp = readdir(dirp);
          if (direntp==NULL) break;
          if ((direntp->d_attr & (A_HIDDEN|A_SYSTEM|A_LABEL|A_DIR))==0
             && fnmatch("*.bbt",direntp->d_name,_FNM_IGNORECASE|_FNM_DOS)==0)
          {
              strcpy(bbt_pfad,direntp->d_name);
              upper(bbt_pfad);
              /* vor. Zeile eingefuegt 15.11.1998 */
              if ((fpbbt=fopen(bbt_pfad,"rb"))==NULL)
              {
                 sprintf(wrtxtbu,"\nProblem: unable to read %s",bbt_pfad);
                 fprintf(fplog,"%s",wrtxtbu);
                 wrtxt(wrtxtbu);
                 ok =0;
              }

              rewind(fpbbt);
              fseek(fpbbt,0L,SEEK_END);
              byte_zeiger=ftell(fpbbt);
              anzahl_records=byte_zeiger / sizeof(one_bbt_rec);
              anzahl_records--;
              rewind(fpbbt);
              for (i=0;i<=anzahl_records;i++)
              {
                 fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
                 if (strlen(one_bbt_rec.kennziffer) > KENNZIFFER_LEN ||
                     strlen(one_bbt_rec.sortierfeld) > SORTIERFELD_LEN)
                 {
                   sprintf(wrtxtbu,"\nProblem with record %li: field too long",
                           i);
                   wrtxt(wrtxtbu);
                   fprintf(fplog,"%s",wrtxtbu);
                   ok=0;
                 }
              }
              fclose(fpbbt);

              if (ok)
              {
                  sprintf(wrtxtbu,"\nNo problems found (%s).",
                  bbt_pfad);
                  wrtxt(wrtxtbu);
                  fprintf(fplog,"%s",wrtxtbu);
              }
              else
              {
                  sprintf(wrtxtbu,"\nEnd of list (%s).",
                  bbt_pfad);
                  wrtxt(wrtxtbu);
                  fprintf(fplog,"%s",wrtxtbu);
              }

              if (!ok)
              {
                 break;
              }

          }
       }
       closedir(dirp);
    }
#endif

#if defined(__DJGPP__)

    if (!_dos_findfirst("*.bbt", _A_NORMAL, &fi))
    {
       do
       {
              strcpy(bbt_pfad,fi.name);
              upper(bbt_pfad);
              /* vor. Zeile eingefuegt 15.11.1998 */
              if ((fpbbt=fopen(bbt_pfad,"rb"))==NULL)
              {
                 sprintf(wrtxtbu,"\nProblem: unable to read %s",bbt_pfad);
                 fprintf(fplog,"%s",wrtxtbu);
                 wrtxt(wrtxtbu);
                 ok =0;
              }

              rewind(fpbbt);
              fseek(fpbbt,0L,SEEK_END);
              byte_zeiger=ftell(fpbbt);
              anzahl_records=byte_zeiger / sizeof(one_bbt_rec);
              anzahl_records--;
              rewind(fpbbt);
              for (i=0;i<=anzahl_records;i++)
              {
                 fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
                 if (strlen(one_bbt_rec.kennziffer) > KENNZIFFER_LEN ||
                     strlen(one_bbt_rec.sortierfeld) > SORTIERFELD_LEN)
                 {
                   sprintf(wrtxtbu,"\nProblem with record %li: field too long",
                           i);
                   wrtxt(wrtxtbu);
                   fprintf(fplog,"%s",wrtxtbu);
                   ok=0;
                 }
              }
              fclose(fpbbt);

              if (ok)
              {
                  sprintf(wrtxtbu,"\nNo problems found (%s).",
                  bbt_pfad);
                  wrtxt(wrtxtbu);
                  fprintf(fplog,"%s",wrtxtbu);
              }
              else
              {
                  sprintf(wrtxtbu,"\nEnd of list (%s).",
                  bbt_pfad);
                  wrtxt(wrtxtbu);
                  fprintf(fplog,"%s",wrtxtbu);
              }

              if (!ok)
              {
                 break;
              }

       } while (!_dos_findnext(&fi));
    }
#endif


   if (ok)
   {
      sprintf(wrtxtbu,"\n\nCompleted, no problems found.");
   }
   else
   {
     sprintf(wrtxtbu,"\n\nAt least one problem was found! Please read %s",
          VERIFY_LOG);

   }
   fprintf(fplog,"%s",wrtxtbu);
   wrtxt(wrtxtbu);

   fprintf(fplog,"\n\n");

   return ok;
}
