@11,0 ?? "Playing SY_MENU"
;*************************************************************************
;  Dynamic Menu System, Author:  Andrew Cunningham   31.Mar.93           *
;                        Email:  A.Cunningham@fs2.mbs.ac.uk              *
;  Uses Menu routines written by Harry Goldman of DataBase Designs Inc.  *
;                    (see au_utils.sc)                                   *
;                                                                        *
;                                                                        *
;*************************************************************************



;*************************************************************************
;Create initial menu table if none in current directory                  *
;*************************************************************************
proc Init_menu()
      Canvas Off
      @ 10,20 ?? "ͻ"
      @ 11,20 ?? "  Missing Menu Table is being created.   "
      @ 12,20 ?? "  Top level menu must have at least one  "
      @ 13,20 ?? "  entry. If none, choose:-               "
      @ 14,20 ?? "     'Edit Current Menu'                 "
      @ 15,20 ?? "                                         "
      @ 16,20 ?? "  Please Wait......                      "
      @ 17,20 ?? "ͼ"


      Paintcanvas Attribute 112 10,20,17,62
      PaintCanvas Border Attribute 79 10,20,17,62

   Canvas On
   DDir.a=directory()
  ; Create top level menu table
  if not istable("sys_menu") then
    create_menu("Sys_menu")
  endif

  ; copy loookup tables if the exist (use DOS copy in case files are protected)
  if isfile(sys_path+"sys_type.db")  and not istable("sys_type") then
     run norefresh "copy "+sys_path+"sys_type.* > temp"
  endif

  if isfile(sys_path+"sys_actn.db") and not istable("sys_actn") then
     run norefresh "copy "+sys_path+"sys_actn.* > temp"
  endif


  if not istable("sys_medt") then
     if isfile(sys_path+"sys_medt.db") then
       run norefresh  "copy "+sys_path+"sys_medt.*  > temp"
     else
     ; Create special edit menu table menu
       create_menu("sys_medt")
       edit "sys_medt"
       Menu {ValCheck} {Clear} {All}
       [description]="Add new menu table"
       [script]     ="Create_menu(\"\")"
       [type]       ="s"
       down
       [description]="Edit current Menu"   ; DO NOT CHANGE THIS STRING
       [table]      ="Sys_menu"
       [type]       ="E"
       [form]       ="F"
       down
       [description]="Add tables from another directory"
       [script]     ="Update_tbl_lst()"
       [type]       ="s"
       down
       [description]="Edit list of tables"
       [table]      ="Sy_list"
       [type]       ="E"
       down
       [description]="Exit"
       [type]       ="X"
       do_it!
       clearimage
     endif
  endif
endproc ;Init_menu
writelib SYLibName Init_menu
release procs Init_menu
?? "."


proc Create_menu(menu_table)
while isblank(menu_table)
   Prompt_box("  Enter menu table name:",8)
   if isblank(retval) or type(retval)="L" then
       return
   endif
   menu_table=retval
endwhile
if istable("sys_menu") then
     copy "sys_menu"  menu_table
     empty menu_table
else if isfile(sys_path+"sys_menu.db") then
       run norefresh "copy "+sys_path+"sys_menu.* "+menu_table+".* > temp"
       empty menu_table
     else    ; if table not found then create it but edit-form will be lost.
     create menu_table
     "Description"   :          "A40",
     "Script"        :          "A40",
     "Table"         :          "A53",  ; same size created by {Info}
     "Type"          :          "A1",   ;Drives switch 'case sctype =' below
     "Answer_table"  :          "A53",
     "Form"          :          "A1",
     "Report"        :          "A1",
     "Intro_script"  :          "A8",
     "Next_script"   :          "A8",
     "Action"        :          "A1",
     "Help_text"     :          "A255"
     endif
endif
clearimage
; Add to list of tables
 if not istable("Sy_list") then
        DDir.a=directory()
        GetTblNames.u("Tables") ; create fresh list of tables in LIST.DB
        rename "List" "Sy_list"
 else
        edit "Sy_list"
          ins
          [name]=menu_table
          [date]=today()
        Do_It!
        clearimage
 endif
return
endproc ;Create_menu
writelib SYLibName Create_menu
release procs Create_menu
?? "."

proc Prompt_box(p_msg,p_widt)
      Canvas Off
      @ 10,20 ?? "ͻ"
      @ 11,20 ?? "                                         "
      @ 12,20 ?? "                                         "
      @ 13,20 ?? "                                         "
      @ 14,20 ?? "                                         "
      @ 15,20 ?? "ͼ"
      @ 12,22 ?? p_msg

      Paintcanvas Attribute 112 10,20,15,62
      PaintCanvas Border Attribute 79 10,20,15,62


     cursor box
     @ 13,(41-p_widt/2) ??
     style attribute 63
     fmt="A"+strval(p_widt)
     Canvas On
     accept fmt to retval
     cursor off

endproc ;Prompt_box
writelib SYLibName Prompt_box
release procs Prompt_box
?? "."

;****************************************************************************
;         UPDATE List of tables in SY_LIST
;  Sy_list holds the current list of tables available to the menu system.
;  It is used as a 'Look-up' valcheck on the table fields of the menu tables.
;****************************************************************************
proc Update_tbl_lst()
   private p1,p2,path
   Prompt_box("  Enter Directory path:",40)
   if isblank(retval) or type(retval)="L" then
       DDir.a=directory()
       path=""
   else
      DDir.a=retval
      if direxists(DDir.a)=1 then
         if match(DDir.a,"..\\",p1,p2) then
           path=DDir.a
         else
           path=DDir.a+"\\"
         endif
      else
         warnmsg("Invalid directory name")
         DDir.a=""
         return
      endif
   endif
   GetTblNames.u("Tables") ; create list of tables in LIST.DB
   edit "List"   ; add path to table names
   scan
     [name]=path+[name]
   endscan
   Do_It!

  ; add "List" to "Sy_list" by query in case structures are different
   Query

       List | Name | Date |
            | _N   | _D   |
            |      |      |

    Sy_list | Name | Date |
    insert  | _N   | _D   |
            |      |      |

   Endquery
   Do_It!
   clearall

endproc ;Update_tbl_lst
writelib SYLibName Update_tbl_lst
release procs Update_tbl_lst
?? "."

;*************************************************************************
;Show help screen
;*************************************************************************
proc sho_help(help_msg)
 private h_row,h_col,curr_str,end_str,rem_str,h_word
 h_row=10
 h_col=13
 h_widt=50
 h_len=10
 Canvas Off
 @ h_row,h_col    ?? "HELPͻ"
 for i from 1 to h_len
 @ h_row+i,h_col  ?? "                                                     "
 endfor
 i=h_row+h_len+1
 @ i,h_col ??        "           Press any key to continue...              "
 @ i+1,h_col      ?? "ͼ"
  rem_str=help_msg
  if isblank(rem_str) then
    rem_str="No Help message available, Edit menu using Shift_F9"
  endif

  @ h_row+1,h_col+2 ?? "Option: "+[description]
  for i from 3 to h_len+2
     curr_str=""
     ;Look for a break in words just short of display width
     while  (true)
       if  match(rem_str,".. ..",h_word,end_str) then
          if len(curr_str)+len(h_word)+1 >h_widt then
             quitloop
          endif
          curr_str=curr_str+" "+h_word
          rem_str=end_str
       else       ; end of help message reached
          if len(curr_str)+len(rem_str)+1 >h_widt then
             quitloop
          endif
          curr_str=curr_str+" "+rem_str  ; add remainder of message
          rem_str=""
          quitloop          ; exit while
       endif
     endwhile
     ; Check for ovrlong string
     if len(curr_str)>h_widt then
        end_str=substr(curr_str,h_widt+1,len(curr_str)-h_widt+1)
        curr_str=substr(curr_str,1,h_widt) ; split string up
        rem_str=end_str+rem_str
     endif
     @ h_row+i,h_col+3 ?? curr_str
     if isblank(rem_str) then quitloop  ; any more message ?
     endif
  endfor
  Paintcanvas Attribute 112 h_row,h_col,h_row+h_len+2,h_col+h_widt+4
  PaintCanvas Border Attribute 79 h_row,h_col,h_row+h_len+2,h_col+h_widt+4
      Canvas On
      key_code=getchar(); wait for any key
endproc ;sho_help
writelib SYLibName sho_help
release procs sho_help
?? "."

 ;**********SHOW WARNING MESSAGE*************************
proc warnmsg(strg)
  if len(strg)>0 then
    Message.u(79,strg,2,0,false)
    warn_show=true
 else
    Message.u(111,strg,0,0,true)
    warn_show=false
 endif
endproc  ;warnmsg
writelib SYLibName warnmsg
release procs warnmsg
?? "."




;**********SHOW Prompt MESSAGE*************************
proc Promptmsg(strg)
   Message.u(32,strg,0,-1,true)
   keycode=retval
   if keycode<30 or keycode>200 then return false
   endif
   if upper(chr(keycode))="Y" then return true
   else return false
   endif
endproc  ;promptmsg

writelib SYLibName Promptmsg
release procs Promptmsg
?? "."

;**********CHECK FOR PASSWORD ERROR*******************************
proc Pass_error()
  private Errorproc
  if (Errorcode()=20)then
    @3,1 ?? "Enter Password: "
    canvas off
    accept "A15" to P_word
    clear
    canvas on
    Password P_word
    return 0
  else
    savevars all
    print file "savevars.sc" errorcode(),errormessage()
    message "Error occured- Please contact A.Cunningham (on E-mail)"
    quit
  endif
endproc  ; pass_error
writelib SYLibName pass_error
release procs pass_error
?? "."

;**********DISPLAY TABLE*******************************
proc sho_form(Prompt_2)
    private curr_table
    curr_table=table()
    PaintCanvas Attribute 111 0,0,24,79            ; Entire screen
    form_view=false
    Prompt_1=menu_select+": "+" Table "+sctable
    if not isblank(scform) and not isempty(table()) then  ; Check for display by form
       pickform scform
       form_view=true
    endif
    while true
      wait table
        prompt Prompt_1,Prompt_2
      until "F2","Esc" ,"F3","F4","F7"
      F_key=retval
      switch
        case F_key="F2":
          switch
             case sctype="E" or sctype="C" or sctype="A": Do_It!
          endswitch
          return true
        case F_key="Esc" or table() <> curr_table and not form_view:
          switch
             case sctype="E" or sctype="A": canceledit
             case sctype="C": Do_It!
          endswitch
          return false
      endswitch
      keypress F_key

    endwhile
endproc  ;sho_form
writelib SYLibName sho_form
release procs sho_form
?? "."

;*************************************************************************
;                                                                        *
;  Display corresponding table if a tilde var is found in a query field  *
;  Allow user to select from corresponding field set tilde var to value  *
;  of field.  Search all query forms showing for ~var.                   *
;*************************************************************************
proc sel_tilde()
  ass_found=false
  while imagetype()="Query"
    if colno()=1 then right; move off 1st column of query
    endif
    last_col=0
   ; echo slow
    while colno()<>last_col
     fld_valu=[]
     last_col=colno()
     sel_image=imageno()
     for i from 1 to len(fld_valu)
     if substr(fld_valu,i,1)="~" then ; Look for PAL variable name
       sel_table=table()
       sel_fld=field()
       sel_assign=substr(fld_valu,i+1,len(fld_valu)-i)+"=[]"
       view sel_table ; causes this table query image to become empty !!!
       tbl_image=imageno(); record table
       moveto tbl_image ; back to table
       moveto field sel_fld
       ; if there is more than one ~var, form spec must cater for
       ; all tables with ~var's must use same form no.
       if sho_form("Choose value from current column & press F2") then
       ; check for F2 exit from form
           execute sel_assign ; assign selected field contants to PAL variable
           ass_found=true
       else
           ansexit="Esc" ; abort if any tilde var not selected
           menuheader.u("")
           canvas on
           return false
       endif
       menuheader.u("")
       canvas on
       play scname   ; re_display because of query image being cleared !!!
       moveto sel_image
       moveto field sel_fld
       quitloop
     endif ; back to query
     endfor
     right
    endwhile ; colno()<>last_col
    if sel_image=1 then quitloop
    endif
    upimage ; current image is last image of a query after playing query
            ; so need to go up to previous query table
  endwhile ; imagetype = query
  return ass_found
endproc ;sel_tilde
writelib SYLibName sel_tilde
release procs sel_tilde
?? "."


;************************************************************
;                                                           *
;    Read menu list from table menu_table and set up        *
;    MenuItems.r for new (lower) level.                     *
;                                                           *
;************************************************************
proc SetMenu(menu_table,menu_level)
   private menu_offset
   menu_offset=menu_pointer[menu_level]
   if menu_level=1 then
     MenuItems.r[menu_offset]="Main Menu "    ;top level menu header
   else
     MenuItems.r[menu_offset]=menu_select     ; lower levels header
   endif
   max_width=len(MenuItems.r[menu_offset])
   if not isblank(menu_table) then   ;Build menu in array MenuItems.r
     view menu_table
     moveto [description]
     i=0
     scan
       i=i+1
       if menu_offset+i<max_menu_items  then
         MenuItems.r[menu_offset+i]=[]
         if len([])>max_width then
            max_width=len([])
         endif
       else
         warnmsg("Number of menu items exceed "+strval(max_menu_items))
         quitloop
       endif
     endscan
   endif
   i=i+1
   MenuItems.r[menu_offset+i]=""  ; leave a blank entry between menu's
   menu_pointer[menu_level+1]=menu_offset+i+1 ;next location in Menuitems.r
menu clearimage
   return max_width
endproc ;SetMenu
writelib SYLibName SetMenu
release procs SetMenu
?? "."

;************************************************************
;                                                           *
;    Main menu processor                                    *
;                                                           *
;    Author A.P.Cunningham                                  *
;************************************************************
proc sho_menu()
; AU_UTILS variables
RegMtr.n=96   ;Colour for printer message
RevMtr.n=79   ;Colour for printer not ready message
BlkMtr.n=32   ;Colour for table PW protected
; Display menu- Initialise
 menu_level=1
 array menu_table[8]
 array last_select[8]
 array menu_width[8]
 array menu_dir[8]     ; directory for menu level
 array menu_xitsc[8]   ; script to play on return from lower level
 array menu_pointer[9] ; position of menu in stack menuitems.r
 array menuitems.r[41] ; stack of options with empty entry between menu's
 array sys_flds[50]
 max_levels=8
 menu_pointer[1]=1     ; initialise for top level menu
 menu_dir[1]=directory()     ; menu dir as default (for top level)
 menu_xitsc[1]=""         ; no exit script for top level menu
 menu_table[1]="sys_menu" ;top level menu table name
 last_select[1]=0         ; nothing selected
 max_menu_items=40
 errorproc=""
 Menu_edit_table="sys_medt"
 Edit_menu=-92
 help_key=-59
 mnurow=5
 mnucol=19
 sctype=""
 nitems=0
 warn_show=false
 menuheader.u(menu_title)
 ;Check for list of tables table present
 if not istable("Sy_list") then
        DDir.a=directory()
        GetTblNames.u("Tables") ; create fresh list of tables in LIST.DB
        rename "List" "Sy_list"
 endif
 ; Display nested menu's
 while menu_level>0
   help.l=false
   ; Restore menu screen
   if sctype<>"M" then  ; repaint menu screen unless previous type a menu
     menuheader.u(menu_title)
     for i from 1 to menu_level-1
       Menu.u(mnurow+i,mnucol+i,menu_width[i]+2,i,False,0,menu_pointer[i])
     endfor
   endif
   if nitems=-1 then
      warnmsg("Press Shift-F9 to edit & add menu table name for next level")
   endif

   ; Check that menu table exists
   if istable(menu_table[menu_level]) then
      nitems=nrecords(menu_table[menu_level])
   else
      ; Menu table not present so create one if possible
      if isblank(menu_table[menu_level]) then ; (never blank @ level=1)
         warnmsg("Menu table name not in "+menu_table[menu_level-1])
         nitems=-1 ;  force to previous level
      else
         create_menu(menu_table[menu_level])
         nitems=0 ; zero will force menu edit menu
      endif
   endif

   ; Create menu data at new level
   menu_width[menu_level]=SetMenu(menu_table[menu_level],menu_level)

   ; Check for menu with options and show it
   if nitems>0 then
     Menu.u(mnurow+menu_level,mnucol+menu_level,menu_width[menu_level]+2,
            menu_level,true,last_select[menu_level],menu_pointer[menu_level])
     menu_item=retval
     last_select[menu_level]=menu_item
     if warn_show then warnmsg(""); cancel any warning message
     endif

   ; otherwise display blank menu and tell user to edit menu table
   else if nitems=0 then
          Menu.u(mnurow+menu_level,mnucol+menu_level,menu_width[menu_level]+2,
                menu_level,false,0,menu_pointer[menu_level])
          warnmsg("In future use Shift-F9 to edit menu")
          menu_item=Edit_menu
        endif
   endif
;*****************************************************
; Test for change current directory
;******************************************************
   if directory() <> menu_dir[menu_level] then
      setdir menu_dir[menu_level]
   endif

;******************************************************

; Process response to menu
;******************************************************
   switch
     case menu_item=0 or menu_item=-3 or nitems=-1:     ;Exit active menu
       if menu_level =1 then quit ;********Usual Exit from system************
       endif
       menu_level=menu_level-1         ; Go back up to previous menu
       sctype="X"
       ;Skip any blank menu's
       if menu_pointer[menu_level+1]-menu_pointer[menu_level]<3 and
                                                  menu_level>1 then
          ; move up to previous menu
          menu_level=menu_level-1
          if menu_level <1 then quit ; ********* Exit no. 1**********
          endif
       endif
       menu_item=last_select[menu_level]  ;Restore to option selected
       menu_select= MenuItems.r[menu_pointer[menu_level]]

     case help.l:   ; F1 pressed in menu
           ;Extract help message from menu action table
           view menu_table[menu_level]
           moveto record menu_item
           sctype=""
           nitems=0
           sho_help([help_text])

     otherwise:        ;An option has been selected from active menu

       if menu_item=Edit_menu then ;Shift_F9 special to edit current Memu
           edit Menu_edit_table
           scan for  [description]="Edit current Menu"
             [table]=menu_table[menu_level] ; set action table = current mnu
           endscan
           Do_It!
           clearimage
           sctype="M"  ; force submenu to menu edit menu
           opt_select="Edit Current Menu"; set option for next level title
           sctable=Menu_edit_table
           scaction=""
           scname=""
           screp=""
           scend=""
           scintro=""
           anstbl=""
       else            ; A normal option selected from active menu

           ;Extract info from menu action table
           view menu_table[menu_level]
           moveto record menu_item
           opt_select= [description]
           sctable=[table]        ; Table to operate on
           sctype=[type]          ; Main action code
           scdescr=[description]  ; Option name
           scintro=[intro_script]
           scname=[script] ;name of script or directory path for next menu level
           anstbl=[answer_table]  ; table with report for answer
           screp=[report]         ; report to use
           scform=[form]          ; form for edit/view
           scend =[next_script]   ; exit script
           scaction=[action]      ; terminating action
       endif
     if checktbl.l(sctable,false) and checktbl.l(anstbl,false) then
;******************************************************

       ; Process menu option as dictated by menu table
       clearimage

       ; Check for introductory script to play before main action
       if not isblank(scintro) then
           play scintro
       endif
       ansexit="F2"
       reptable=anstbl

       ;Process main action type
       switch
         case sctype="D":   ; RUN A DOS PROGRAM
                        run scname

         case sctype="B":   ; RUN A LARGE DOS PROGRAM
                        run big noshell scname

         case sctype="A":   ; ADD NEW RECORDS

                        Menu {Modify}{DataEntry}
                        select sctable
                        sho_form("F2=Do_It! Esc=Cancel")

         case sctype="E":    ; EDIT TABLE
                        edit sctable
                        sho_form("F2=Do_It! Esc=Cancel")

         case sctype="C":    ; CO-EDIT TABLE
                        coedit sctable
                        sho_form("F2=Do_It! Esc=Cancel")

         case sctype="V":    ; VIEW TABLE
                        view sctable
                        sho_form("F2=Do_It! Esc=Cancel")

         case sctype="R":   ; PRINT REPORT
                        reptable= sctable

         case sctype="S":   ;PLAY A SCRIPT
           play scname

         case sctype="s":   ;PLAY MINI-SCRIPT
           execute scname

         case sctype="Q":   ; PLAY A QUERY AND DO_IT!
           play scname
           Do_It!
                ; check for family  to be copied to answer table
                if not isblank(anstbl) then
                  Menu {Tools} {Copy} {JustFamily}
                  select anstbl select "answer" {replace}
                endif
                        reptable="answer"

         case sctype="p":   ;PLAY A QUERY AND SELECT ~VARS FROM TABLES
           play scname
           sel_pal=sel_tilde()
           if sel_pal then
                Do_It!
                ; check for family  to be copied to answer table
                if not isblank(anstbl) then
                  Menu {Tools} {Copy} {JustFamily}
                  select anstbl select "answer" {replace}
                endif
           else ansexit="Esc"
           endif
                        reptable="answer"

         case sctype="P":   ;PLAY A QUERY AND PAUSE FOR USER MODS
           play scname
           while (true)
             wait table
              Prompt scdescr,"Make changes and press F2 to continue (Esc quits)"
             until "F2","Esc","F3","F4","F6","F5"
             ansexit=retval
             switch
               case ansexit="Esc" : quitloop
               case ansexit="F2"  :
                           Do_It!
                           ; check for family  to be copied to answer table
                           if not isblank(anstbl) then
                             Menu {Tools} {Copy} {JustFamily}
                             select anstbl select "answer" {replace}
                           endif
                           reptable="answer"
                           quitloop
               case ansexit="F3"  : upimage
               case ansexit="F4"  : downimage
               otherwise: keypress ansexit
             endswitch
           endwhile
           menuheader.u("")
           canvas on

         case sctype="M": ;Show next level menu
           menu_level=menu_level+1               ; increase level
           menu_select=opt_select                ; save next level menu header
           if menu_level > max_levels then
              warnmsg("Number of nested menus exceeds "+strval(max_levels))
              menu_level=menu_level-1
           endif
           menu_table[menu_level]=sctable        ; save menu table name
           last_select[menu_level]=1             ; highlight 1st option
           menu_xitsc[menu_level]=scend          ;save exit script
           if direxists(scname)=1 and not isblank(scname) then
              menu_dir[menu_level]=scname
           else
              menu_dir[menu_level]=sdir()
           endif

         case sctype="X":  ; Exit to previous level menu
           ; move up to previous menu
           menu_level=menu_level-1
           if menu_level <1 then quit ;***********Exit from menu no.2**
           endif
           ;Skip any blank menu's
           if menu_pointer[menu_level+1]-menu_pointer[menu_level]<3 and
                                                  menu_level>1 then
              ; move up to previous menu
              menu_level=menu_level-1
              if menu_level <1 then quit ;********Exit from menu no.3**
              endif
           endif
           menu_item=last_select[menu_level]  ;Restore to option selected
           Menu_select= MenuItems.r[menu_pointer[menu_level]] ; Prev. header
           scend=menu_xitsc[menu_level]

       endswitch

     ; End of processing main actions

;******************************************************
     ; Check for terminating action

     if ansexit<>"Esc"and sctype<>"M" then ; Was main action aborted ?
     ; check for exit script in menu table
       if not isblank(scend) then
           play scend
       endif
       switch
         case scaction="Q":
              ; check for report to output to printer
              if istable(reptable) and not isblank(screp)
                                   and checkprinter.l() then
                     Report reptable screp
              endif
              quit ; **** Directed Exit from menu system  *********
         case scaction="P" and istable(reptable):
           ; Pause to view answer table
           clearall
           view reptable
           while (true)
             wait table
               Prompt scdescr,"Press F2 to continue (Esc cancels any printing)"
             until "F2","Esc","F3","F4"
             pausexit=retval
             switch
               case pausexit="Esc" : ansexit="" quitloop
               case pausexit="F2"  : quitloop
               case pausexit="F3"  : upimage
               case pausexit="F4"  : downimage
             endswitch
           endwhile
           if ansexit="F2" then
                ; check for report to output to printer - Quries only
              if not isblank(screp) and checkprinter.l() then
                        Report reptable screp
              endif
           endif
         otherwise:
              ; check for report to output to printer
              if not isblank(screp) and checkprinter.l()
                                    and istable(reptable) then
                     Report reptable screp
              endif
       endswitch
     endif ; if ansexit<>"Esc"
       clearall
   endif;  checktable
  endswitch ; checking return from menu.u

 endwhile ;menulevel>0

endproc ;sho_menu

writelib SYLibName sho_menu
release procs sho_menu
?? "."

