                       ------------------------------
                       DOCUMENTATION FOR PROGRAM 'AVG'
                       ------------------------------

                        Version 1.00 - Copyright 1992
                          Solar Terrestrial Dispatch


     The utility program AVG runs through the database created by the BCAST
software and generates a list of statistical averages based on the data
contained in the database file.  It will compute a user-defined numerical
average for almost every piece of data contained in the database file.

     AVG is executed using the following syntax:

      avg [#_of_days_to_average] [start_date:end_date] [R[:start_date]]

where the "R" is optional on the command line.  If present, it forces AVG to
compile an extensive report of running averages for the number of days
specified in the "#_of_days_to_average" parameter, beginning with the
start_date given following the "R".  The date is in the format "YYMMDD" and a
colon must separate the "R" from the starting date, if the date is given.  If
the starting date is not given, AVG will begin with the first record in the
database file.  For example, to compute the 20-day running averages starting
on July 1, 1992, you would issue the command: "avg 20 R:920701".  To compute
the 20-day running averages starting with the first date in the database, you
would use the command: "avg 20 R".

     Note that only one of the parameters "#_of_days_to_average" OR
"start_date:end_date" can be specified on the command line.  Both cannot be
used together.

     If "start_date:end_date" is used, AVG will compute the fixed average
between the two dates given.  If this option is used, you cannot include the
"R" (running average) option, since AVG will not compute the running average
between a fixed set of dates.  The dates given must be in the format: YYMMDD.
For example, to compute the fixed average between June 1, 1992 and June 30,
1992, you would use the command: "avg 920601:920630".

     Consult the list of examples given at the end of this manual for more
information regarding proper syntax.


FIXED AVERAGES VS RUNNING AVERAGES
----------------------------------
                
     AVG will generate two types of reports based on whether the "R" (or
"R"unning Average) command is included on the command line.

     A fixed average is simply the numerical average of all of the values
contained in the database file for the last xx number of days in the
database (where "xx" is specified on the command line to AVG), or between the
two dates given on the command line (if dates are used).

     For example, to compute the fixed 90-day average of all of data in the
database file, you would type at the DOS prompt: "avg 90".  AVG rapidly
computes the necessary information and sends the generated report to the
standard output device (your screen).  Alternatively, to compute the fixed
average between January 1, 1992 and June 1, 1992, you would type at the DOS
prompt: "avg 920101:920601".

     You can redirect the output of AVG to a file by appending the
redirection symbol ">" followed by the name of the file to use.  For example,
to compute the last 27-day fixed averages and save the report in the file
"output.txt", you would type:

                avg 27 > output.txt

     Running averages differ from fixed averages in that a stream of average
values are generated as opposed to a single value.

     For example, to compute the running 5-day averages of the data in the
database file and save the resulting report to the file "output.txt", you
would type:

                avg 5 R > output.txt

This would create an extensive and (depending on the size of your database
file) large report saved in the file "output.txt" containing the running
5-day averages for each of the values in the BCAST-maintained database file.

     When computing the running averages, AVG will automatically attempt to
detect invalid or missing data in the database file which might otherwise
influence the computed averages.  If invalid or missing data is detected, it
will ignore it and report the date of the ignored data on-screen.

     There is no limit to the number of days you may compute fixed or running
averages.

     AVG may be executed from any directory provided you have set the BCAST
environment variable to point to the area where the database file resides
(see the BCAST manual [BCAST.MAN] for more information regarding the BCAST
environment variable).


EXAMPLES
--------

        avg 5

Computes the 5-day averages and displays the averages on the screen.


        avg 90 > average.txt

Computes the 90-day fixed averages and saves the report in the file
"average.txt".


        avg 27 R > report.doc

Computes the 27-day running averages and saves the report in the file
"report.doc".


        avg 7 R:920710

Computes the 7-day running averages beginning with the report for July 10,
1992 and displays the results on the screen.


        avg 14 R:911224 > running.txt

Computes the 14-day running averages starting with the report for December 24,
1991 and saves the report to the file "running.txt".


        avg 920601:920630 > output.fil

Calculates the fixed averages for the dates between June 01, 1992 and
June 30, 1992 and saves the report to the file "output.fil".


        avg 911101:920701 > big_avg.txt

Computes the fixed averages between November 01, 1991 and July 01, 1992 and
saves the results to the file "big_avg.txt".


        avg 9999 > all_avg.txt

Computes the fixed averages spanning all of the dates in the database (AVG
will rescale the "9999" to the number of records existing in your database),
and saves the result to the file "all_avg.txt".

