#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <dos.h>
#include "cmdline.h"

#define MAXFILES 500

static char oldcwd[256];
static int oldDrive = 0;
static struct ffblk fileBlock;
static char **filelist=0;
static int filenum=0,filecount=0;

BOOL SetDir(char *dir)
{
  if (dir == 0)
    chdir(oldcwd);
  else
    chdir(dir);
  return(TRUE);
}
BOOL SetDrive(int drive)
{
  if (drive == -1)
    setdisk(oldDrive);
  else
    setdisk(drive);
  return(TRUE);
}
void ParseDir(char *spec, int *drive, char **dir, char **file)
{
   char *spec2;
   *drive = -1;
   *dir = 0;
   *file = 0;

   while (*spec == ' ') spec++;

   spec2 = spec;
   while (*spec2)
     *(spec2++) = toupper(*spec2);

   if (*spec) {
     if (*(spec+1) == ':') {
       *drive = *spec - 'A' ;
       *dir = spec + 2 ;
     }
     else
       *dir = spec;
   }

   if ((spec2 = strrchr(*dir,'\\')) != 0) {
     *spec2 = 0;
     *file = spec2+1;
   }
   else {
     *dir = 0;
     *file = spec;
   }
}
char *FirstFile(char *spec)
{
  if (findfirst(spec, &fileBlock, _A_NORMAL ))
    return(0);
  return(fileBlock.ff_name) ;
}
char *NextFile(void)
{
  if (findnext( &fileBlock))
    return(0);
  return(fileBlock.ff_name);
}
int rfsort(const void *elem1, const void *elem2)
{
	return(strcmp(*(char **)elem1, *(char **)elem2));
}
char *litlate(char *t)
{
	char *q;
	if (!t)
		return 0;
	q = malloc(strlen(t)+1);
	if (!q)
		fatal("out of memory");
	strcpy(q,t);
	return q;
}
void ClearFiles(void)
{
	int i;
	for (i= 0; i < filecount; i++)	
		free(filelist[i]);
	free(filelist);
	filelist = 0;
}
char *GrabFile(void)
{
	if (filenum < filecount) 
		return filelist[filenum++];
	return 0;
}
char *ReadFiles(char *spec)
{
	filelist = malloc(sizeof(char *)*MAXFILES);
	if (!filelist)
		fatal("no memory");
	filenum = 0;
	filecount = 0;
	if ((filelist[0] = litlate(FirstFile(spec))) == 0) {
		ClearFiles();
		return 0;
	}
	while((filelist[++filecount] = litlate(NextFile())) != 0)
		if (filecount >= MAXFILES-1)
			fatal("Too many files... qualify file names to limit to %d at a time",MAXFILES);
	qsort(filelist,filecount,sizeof(char *),rfsort);
	return GrabFile();
}
char *NewName( char *spec)
{
   static char namebuf[15];
   char *pos;
   strcpy(namebuf, spec);
   if (!(pos = strrchr(namebuf,'.')))
     strcat(namebuf,".~");
   else {
     *(pos+4) = 0;
     *(pos+3) = *(pos+2);
     *(pos+2) = *(pos+1);
     *(pos+1) = '~' ;
   }
   return(namebuf);
}
int FileRecurse( int count , char *FileNames[],
		char *Text, FILEFUNC routine, char *ext, BOOL backup )
{
  int i;
  oldDrive= getdisk();
  getcwd(oldcwd,256);
  for (i=0; i< count; i++) {
    char buffer[256];
    char *dir;
    char *file;
    char *fileName;
    int drive;

    strcpy(buffer,FileNames[i]);
		if (ext)
			AddExt(buffer,ext);
    ParseDir(buffer,&drive, &dir, &file);
    if (!SetDrive(drive) ) {
	fprintf(stderr,"Can't change to drive %c:", drive + 'A');
	continue;
    }
    getcwd(oldcwd,256);
    if (!SetDir(dir)) {
	fprintf(stderr,"Can't change to directory %s", dir);
	continue;
    }
    if ((fileName = ReadFiles(file)) == 0) {
       fprintf(stderr,"No Such Files %s.\n",FileNames[i]);
       continue;
    }
    do {
      if (backup) {
	char *newName = NewName(fileName);
	FILE *inf,*outf;
	if (Text)
		printf("%s %s to %s\n",Text, fileName, newName);
	outf = fopen(newName,"w");
	inf = fopen(fileName,"r");
	(*routine)(inf, outf, fileName, dir, oldDrive == drive ? -1 : drive);
	fclose (outf);
	fclose (inf);
	rename (newName,"ztbpjklx.xuz");
	rename (fileName, newName );
	rename ("ztbpjklx.xuz", fileName);
      }
      else {
	FILE *inf;
	if (Text)
		printf("%s %s\n", Text, fileName);
	inf = fopen(fileName,"r");
	(*routine)(inf, 0, fileName, dir, oldDrive == drive ? -1 : drive);
	fclose( inf );
      }

		  SetDir(0);
  		SetDrive(-1);
    } while ((fileName = GrabFile()) != 0);
		ClearFiles();
  }
  return(0);
}