#ifndef STORAGE_H
#define STORAGE_H
//DOC_BEGIN
//
//(C) Copyright 1995, Diego Ernesto Malpica Chauvet.
//              All rights reserved.

#include <stdio.h>
#include "btypes.h"
//DOC_END


class storage_page_C{
public:
	enum page_E { INVALID_PAGE=0,LAST_PAGE=1,DEL_PAGE=2,
					  SUN_PAGE=4,PARENT_PAGE=8,ROOT_PAGE=16,CK_PAGE=32};
	u_long_B itself;
	u_long_B  next_page;
	int_B    size;
	char_B   type;
	int_B   level;
	char_B data;
	void clear(void);
	void set_type(char);
	void clear_type (char);
	void init (int data_size=256);
	storage_page_C& operator=(u_long_B position);
	storage_page_C();
};

typedef bt_C<storage_page_C> storage_page_B;

class storage_control_C {
public:
	int_B    rl_c;     //read lock
	int_B    wl_trans; //write lock transaction indicator
	char_B   dl;       //del lock
	char_B   saved;    //saved flag
	char_B data;
	void clear(void);
	storage_control_C();
};

typedef bt_C<storage_control_C> storage_control_B;

class storage_control_header_C:public storage_control_C
{
};

typedef bt_C<storage_control_header_C> storage_control_header_B;

class storage_trans_control_C {
public:
	int_B  trans;
	int_B  operation;
	u_long_B prev_entry;
	u_long_B pos;
	int_B    level;
	char_B data;
	void clear(void);
	storage_trans_control_C();
};

typedef bt_C<storage_trans_control_C> storage_trans_control_B;

//DOC_BEGIN

class storage_C {
public:
	int open     (char* name,int mode_param=USE); //open the storage file
																 //name -> filename
																 //mode_param -> USE,CREATE
																 //increment the open_count
	int close    ();  // decrease open_count and close when open_count
							//reaches zero
   int stabilize();	//estabilize storage						
	int remove   ();  //remove the file

	int get_rl(void* dato,u_long_B& pos,int level_param=-1,int trans_param=-1);
	//get and read lock
	int get_wl(void* dato,u_long_B& pos,int level_param=-1,int trans_param=-1);
	//get and write lock
	int get   (void* dato,u_long_B& pos,int level_param=-1,int trans_param=-1);
	//get
	int modify(void* dato,u_long_B& pos,int level_param=-1,int trans_param=-1);
	//modify and write lock
	int put   (void* dato,u_long_B& pos,int level_param=-1,int trans_param=-1);
	//insert a new object and write lock
	int del      (u_long_B& pos,int level_param=-1,int trans_param=-1);
	//delete an object del lock
	int first    (u_long_B& pos,int level=-1);//get the pos of the first element
	int last     (u_long_B& pos,int level=-1);//get the pos of the last element
	int next     (u_long_B& pos,int level=-1);//get the pos of the next element
	int prev     (u_long_B& pos,int level=-1);//get the pos of the prev element
	int first    (void* dato,u_long_B& pos,int level=-1,int trans_param=-1);
	int last     (void* dato,u_long_B& pos,int level=-1,int trans_param=-1);
	int next     (void* dato,u_long_B& pos,int level=-1,int trans_param=-1);
	int prev     (void* dato,u_long_B& pos,int level=-1,int trans_param=-1);
	int first_rl    (void* dato,u_long_B& pos,int level=-1,int trans_param=-1);
	int last_rl     (void* dato,u_long_B& pos,int level=-1,int trans_param=-1);
	int next_rl     (void* dato,u_long_B& pos,int level=-1,int trans_param=-1);
	int prev_rl     (void* dato,u_long_B& pos,int level=-1,int trans_param=-1);
	int first_wl    (void* dato,u_long_B& pos,int level=-1,int trans_param=-1);
	int last_wl     (void* dato,u_long_B& pos,int level=-1,int trans_param=-1);
	int next_wl     (void* dato,u_long_B& pos,int level=-1,int trans_param=-1);
	int prev_wl     (void* dato,u_long_B& pos,int level=-1,int trans_param=-1);
	//trans_param is the number of the transaction
	//dato is a pointer to handler you are responsable that the pointer to a
	//a handler tha you pass is of a handler that could read the informantion
	//stored, if you are using named types you can read a sun from a parent
	//handler. (Polymorfic objects are suported).
	//all the medots that have de parameter dato do get of the object
	// the sufix rl stands for get and read lock
	// the sufix wl stands for get and  write lock
	//you can't get an object using  get if it is write locked
	//you cant  get a read locked or a write loked whit a get and write lock
	//level is level in which the operation is do, levels are independents

	int set_root (u_long_B& pos,int level_param=-1,int trans_param=-1);
	//set root   and lock root
	int get_root (u_long_B& pos,int level_param=-1,int trans_param=-1);
	//get root   if root is not locked
	//level_param is the level in wich the operation is do

//                          Transactions
	int begin_trans();
	int end_trans(int trans_param=-1,char commit_f=1);
	// end the transaction if comit_f is 1 then the transsaction is commited
	// if commit_f is 0 the transaction is not comited
	int commit_trans(int trans_param);
	// if you commit a not ending transaction old the transaction is undone
	// else the transaction is consolidated
	int set_active_trans(int trans_param);//set the default transaction
	void set_level (int level=-1);//set the default level

//                         Initialization

	void init (int data_size=512,int default_level=1,int levels=5,int trans=10);
	//storage must be initialiazed with init metod
	//data_size is size of the data zone in each page
	//default level set the deafault level in the various metods -1 is used to
	//select the default level (active level(.
	//levels the number of levels available for user data
	//trans  the numbers of levels available for transactions this number
	//determine the number of simultaneus transactions


	storage_C();
	~storage_C();
//DOC_END
protected:
	enum storage_E { BEGIN_TRANS=1,END_TRANS,RL_TRANS,WL_TRANS,DL_TRANS,
						MODIFY_TRANS,PUT_TRANS,ROOT_TRANS};
	virtual int undo(storage_trans_control_B& trans_param);
	virtual int commit(storage_trans_control_B& trans_param);
	int add_trans(storage_trans_control_B& trans,int operation);
	u_long_B root_page;
	int_B    active_trans;
private:
	bt_C<FILE*>        file;
	u_long_B  page_size,u_long_size,first_page;
	int_B     root_page_lt; //root pages lock transaction
	u_long_B  tail,last_page,state;
	string_B  name;
	char_B  mode;
	int_B  level,default_level;
	u_int_B   open_count;
	int_B   data_size;
	int_B   levels,trans;

	int get_nt      (void* dato,u_long_B& pos,int level);
	int modify_nt   (void* dato,u_long_B& pos,int level);
	int put_nt      (void* dato,u_long_B& pos,int level);
	int put_nt      (void* dato,u_long_B& pos,int level,storage_page_B& pc);
	int commit_put_nt  (storage_page_B& pc);
	int del_nt      (u_long_B& pos,int level);
	int set_root_nt (u_long_B& pos,int level);


	int read   (storage_page_B& page);
	int write  (storage_page_B& page);
	int del    (storage_page_B& page);
	int create (storage_page_B& page);
	int first  (storage_page_B& page);
	int next   (storage_page_B& page);
	int prev   (storage_page_B& page);
	int last   (storage_page_B& page);
//DOC_BEGIN
};

typedef bt_C<storage_C> storage_B; //type declaration of a handler

//DOC_END
#endif
