#ifndef  GENCODE_H
#define  GENCODE_H
//DOC_BEGIN
//
//(C) Copyright 1995, Diego Ernesto Malpica Chauvet.
//              All rights reserved.

#include <stdio.h>
#include "signal.h"

// the next two simbols can be defined in the gencode.cpp file
//#define XDR_LIBRARY //This symbol should be defined if you are planing to use
						  //and external data representation library SUN XDR.
						  //the simbol xdr_LIBRARY_BCPP should be undefined if
						  //this simbol is defined
//#define XDR_LIBRARY_BCPP  //This simbol should be defined if you haven't
									 //a XDR libary and you are using borland C++
									 //or if you want to use the you the XDR provided
									 //with types for borland C++ 4.0.
									 //You must undefine XDR_LIBRARY
									 //if you use this symbol.

//gencode_C encapsulates a set of routines used to encode, decode and size
//basic data types like int char long int float double, ...
//you can use this class in two ways you can use a file to the
//operations or you can use a memory dump.
//In order to use a memory dump you have to use the begin metod that have
//the dump_base_param, this is the base of the memory dump tha will be used
//if you want to use a file you must use the metod that have the file_param
//parameter.
//You can avoid using this begin metods but you have to supply at least the
//same funcionality ther provide.
//
//The parameter operation_param must be ENCODE , DECODE  or ENSIZE
//    that are enums defined in signal.h
//The parameter DR_param  must be LDR_CODE or XDR_CODE
//    that are enums defined in signal.h
//When you finish your encoding operations you must call the metod end


//For files and memory dumps:
//when you encode or decode data the pointer is moved.
//when you ensize data de pointer is not moved
//the base pointer is never moded


class gencode_C {
public:
	char* dump_base;  //Base of the dump of memory used in operations
	char* dump_pt;    //pointer mark the position of the next operation in the
							//memory dump
	FILE* file;       //pointer to the file
	unsigned long file_base; //pointer to the base position in the file
	unsigned long file_pt;   //pointer that marks the position of the next
									 //operation in the file
	int   operation;  //type of operation to be performed ENCODE DECODE ENSIXE
	int   size;       //size in bytes of the operation bytes
	int   DR;         //tyde of data representation to by used LD_CODE XDR_CODE
	void * lista;     //extra data for internal use. dont'modify it.
	gencode_C();

virtual	int begin(char* dump_base_param,int operation_param,int DR_param);
virtual  int begin(FILE* file_param,int operation_param,int DR_param);
virtual	int end();
//Code decode an size metods
	int dr_code(char& var,int n_elements=1);
	int dr_code(double& var,int n_elements=1);
	int dr_code(float& var,int n_elements=1);
	int dr_code(int& var,int n_elements=1);
	int dr_code(long& var,int n_elements=1);
	int dr_code(short& var,int n_elements=1);
	int dr_code(unsigned char& var,int n_elements=1);
	int dr_code(unsigned int& var,int n_elements=1);
	int dr_code(unsigned long& var,int n_elements=1);
protected:
	int ldr_code(char& var,int n_elements);
	int ldr_code(double& var,int n_elements);
	int ldr_code(float& var,int n_elements);
	int ldr_code(int& var,int n_elements);
	int ldr_code(long& var,int n_elements);
	int ldr_code(short& var,int n_elements);
	int ldr_code(unsigned char& var,int n_elements);
	int ldr_code(unsigned int& var,int n_elements);
	int ldr_code(unsigned long& var,int n_elements);
virtual	int xdr_code(char& var,int n_elements);
virtual	int xdr_code(double& var,int n_elements);
virtual	int xdr_code(float& var,int n_elements);
virtual	int xdr_code(int& var,int n_elements);
virtual	int xdr_code(long& var,int n_elements);
virtual	int xdr_code(short& var,int n_elements);
virtual	int xdr_code(unsigned char& var,int n_elements);
virtual	int xdr_code(unsigned int& var,int n_elements);
virtual	int xdr_code(unsigned long& var,int n_elements);

};

//DOC_END
#endif
