//
//(C) Copyright 1995, Diego Ernesto Malpica Chauvet.
//              All rights reserved.

//#define XDR_LIBRARY //This symbol should be defined if you are planing to use
							 //and external data representation library SUN XDR.
							 //the simbol XDR_LIBRARY_BCPP should be undefined if
							 //this simbol is defined
#define XDR_LIBRARY_BCPP //This simbol should be defined if you haven't
								 //a XDR libary and you are using borland C++
								 //or if you want to use the you the XDR provided
								 //with types for borland C++ 4.0.
								 //You must undefine XDR_LIBRARY
								 //if you use this symbol.
#include "gencode.h"
#include "types.h"
#ifdef XDR_LIBRARY
#include <rpc/xdr.h>
#endif

gencode_C::gencode_C()
{
	dump_base=NULL;
	dump_pt=NULL;
	file=NULL;
	file_base=NULL;
	file_pt=NULL;
	operation=0;
	size=0;
	DR=0;
	lista=NULL;
}



int gencode_C::begin(char* dump_base_param,int operation_param,int DR_param)
{
	dump_pt=dump_base=dump_base_param;
	operation=operation_param;
	DR=DR_param;
	size=0;
	return 1;
}

int gencode_C::begin(FILE* file_param,int operation_param,int DR_param)
{
	file=file_param;
	file_pt=file_base=ftell(file);
	operation=operation_param;
	DR=DR_param;
	size=0;
	return 1;
}

int gencode_C::end()
{
	if (file) fflush(file);
	return 1;
}


#ifndef XDR_LIBRARY_BCPP

#ifdef XDR_LIBRARY
int gencode_C::xdr_code(char& var,int n_elements)
#else
int gencode_C::xdr_code(char&,int)
#endif
{
#ifdef XDR_LIBRARY
	static int size=0;
	if (!size) {
		XDR xdr_new;
		xdrmem_create(&xdr_new,(char*)NULL,0,XDR_ENCODE);
		xdr_opaque(&xdr_new,&var,1);
		size=(int)-xdr_new.x_handy;
		xdr_destroy(&xdr_new);
	}
	if (operation!=ENSIZE)  {
		XDR xdr;
		switch(operation) {
			case ENCODE:xdrmem_create(&xdr,dump_pt,size*n_elements,XDR_ENCODE);
			  break;
			case DECODE:xdrmem_create(&xdr,dump_pt,size*n_elements,XDR_DECODE);
			  break;
		}
		xdr_opaque(&xdr,&var,n_elements);
		xdr_destroy(&xdr);
	}
	return n_elements*size;
#else
  printf("Error: XDR_LIBRARY simbol no defined.\n");
  exit(0);
  return 0;
#endif
}

#define   TYPE     double
#define   XDR_NAME xdr_double
#include  "xdr.h"
#define   TYPE     float
#define   XDR_NAME xdr_float
#include  "xdr.h"
#define   TYPE     int
#define   XDR_NAME xdr_int
#include  "xdr.h"
#define   TYPE     long
#define   XDR_NAME xdr_long
#include  "xdr.h"
#define   TYPE     short
#define   XDR_NAME xdr_short
#include  "xdr.h"
#define   TYPE     unsigned char
#define   XDR_NAME xdr_u_char
#include  "xdr.h"
#define   TYPE     unsigned int
#define   XDR_NAME xdr_u_int
#include  "xdr.h"
#define   TYPE     unsigned long
#define   XDR_NAME xdr_u_long
#include  "xdr.h"

#else // XDR_LIBRARY_BCPP
void flip32(char* a, char *b)
{
	int n;
	char c[4];
	for (n=0;n<4;n++) c[n]=a[n];

	b[0]=c[3];
	b[1]=c[2];
	b[2]=c[1];
	b[3]=c[0];

}

void flip64(char* a, char *b)
{
	int n;
	char c[8];
	for (n=0;n<8;n++) c[n]=a[n];

	b[0]=c[7];
	b[1]=c[6];
	b[2]=c[5];
	b[3]=c[4];
	b[4]=c[3];
	b[5]=c[2];
	b[6]=c[1];
	b[7]=c[0];
}



int gencode_C::xdr_code(char& var,		int n_elements)
{
	return ldr_code(var,n_elements);
}


int gencode_C::xdr_code(double& var,	int n_elements)
{
	int n;
	int result;
	double *var_pt=&var;
	for(n=0;n<n_elements;n++) flip64((char*)(var_pt+n),(char*)(var_pt+n));
	result=ldr_code(var,n_elements);
	for(n=0;n<n_elements;n++) flip64((char*)(var_pt+n),(char*)(var_pt+n));
	return result;
}


int gencode_C::xdr_code(float& var, 	int n_elements)
{
	int n;
	int result;
	float *var_pt=&var;
	for(n=0;n<n_elements;n++) flip32((char*)(var_pt+n),(char*)(var_pt+n));
	result=ldr_code(var,n_elements);
	for(n=0;n<n_elements;n++) flip32((char*)(var_pt+n),(char*)(var_pt+n));
	return result;
}


int gencode_C::xdr_code(int& var,		int n_elements)
{
	int n;
	int result=0;
	char* save_dump_pt=dump_pt;
	int *var_pt=&var;
	long tmp;
	for(n=0;n<n_elements;n++) {
	  tmp=var_pt[n];
	  flip32((char*)&tmp,(char*)&tmp);
	  result+=ldr_code(tmp,1);
	  dump_pt+=sizeof(long);
	  flip32((char*)&tmp,(char*)&tmp);
	  var_pt[n]=(int) tmp;
	}
	dump_pt=save_dump_pt;
	return result;
}


int gencode_C::xdr_code(long& var,		int n_elements)
{
	int n;
	int result;
	long *var_pt=&var;
	for(n=0;n<n_elements;n++) flip32((char*)(var_pt+n),(char*)(var_pt+n));
	result=ldr_code(var,n_elements);
	for(n=0;n<n_elements;n++) flip32((char*)(var_pt+n),(char*)(var_pt+n));
	return result;
}


int gencode_C::xdr_code(short& var,  	int n_elements)
{
	int n;
	int result=0;
	char* save_dump_pt=dump_pt;
	short *var_pt=&var;
	long tmp;
	for(n=0;n<n_elements;n++) {
	  tmp=var_pt[n];
	  flip32((char*)&tmp,(char*)&tmp);
	  result+=ldr_code(tmp,1);
	  dump_pt+=sizeof(long);
	  flip32((char*)&tmp,(char*)&tmp);
	  var_pt[n]=(short) tmp;
	}
	dump_pt=save_dump_pt;
	return result;

}

int gencode_C::xdr_code(unsigned char& var,	int n_elements)
{
	return ldr_code(var,n_elements);
}


int gencode_C::xdr_code(unsigned int& var,  	int n_elements)
{
	int n;
	int result=0;
	char* save_dump_pt=dump_pt;
	unsigned int *var_pt=&var;
	long tmp;
	for(n=0;n<n_elements;n++) {
	  tmp=var_pt[n];
	  flip32((char*)&tmp,(char*)&tmp);
	  result+=ldr_code(tmp,1);
	  dump_pt+=sizeof(long);
	  flip32((char*)&tmp,(char*)&tmp);
	  var_pt[n]=(unsigned int) tmp;
	}
	dump_pt=save_dump_pt;
	return result;
}


int gencode_C::xdr_code(unsigned long& var,  int n_elements)
{
	int n;
	int result;
	unsigned long *var_pt=&var;
	for(n=0;n<n_elements;n++) flip32((char*)(var_pt+n),(char*)(var_pt+n));
	result=ldr_code(var,n_elements);
	for(n=0;n<n_elements;n++) flip32((char*)(var_pt+n),(char*)(var_pt+n));
	return result;
}

#endif



#define   TYPE     char
#include  "ldr.h"
#define   TYPE     double
#include  "ldr.h"
#define   TYPE     float
#include  "ldr.h"
#define   TYPE     int
#include  "ldr.h"
#define   TYPE     long
#include  "ldr.h"
#define   TYPE     short
#include  "ldr.h"
#define   TYPE     unsigned char
#include  "ldr.h"
#define   TYPE     unsigned int
#include  "ldr.h"
#define   TYPE     unsigned long
#include  "ldr.h"

#define   TYPE     char
#include  "dr.h"
#define   TYPE     double
#include  "dr.h"
#define   TYPE     float
#include  "dr.h"
#define   TYPE     int
#include  "dr.h"
#define   TYPE     long
#include  "dr.h"
#define   TYPE     short
#include  "dr.h"
#define   TYPE     unsigned char
#include  "dr.h"
#define   TYPE     unsigned int
#include  "dr.h"
#define   TYPE     unsigned long
#include  "dr.h"
