#ifndef DLL_BAS_H
#define DLL_BAS_H
//
//(C) Copyright 1995, Diego Ernesto Malpica Chauvet.
//              All rights reserved.

template <class T>
class dln_BAS {
public:
  dln_BAS<T> *next,*prev;
  T* item;
  void clear(void);
  dln_BAS(T* item);
  dln_BAS(void);
};

template <class T>
class dll_BAS {
public:
  dln_BAS<T> *first_element,*last_element,*current_element;
  int DEL_ITEM;
  int n_elements;
  int position;
  int is_out(void);
  void out(void);
  int first(void);
  int last(void);
  int next(void);
  int prev(void);
  int insert_r(T* item);
  int del(void);
  void del_all(void);
  T* item(void);
  dll_BAS(void);
  ~dll_BAS(void);
};

template <class T>
void dln_BAS<T>::clear(void)
{
  next=prev=NULL;
  item=NULL;
}

template <class T>
dln_BAS<T>::dln_BAS(T* param)
{
   clear();
   item=param;
}

template <class T>
dln_BAS<T>::dln_BAS(void)
{
   clear();
}

template <class T>
dll_BAS<T>::dll_BAS(void)
{
  first_element=last_element=current_element=NULL;
  n_elements=0;
  position=0;
  DEL_ITEM=1;
}

template <class T>
dll_BAS<T>::~dll_BAS(void)
{
  del_all();
}

template <class T>
int dll_BAS<T>::first(void)
{
   if(n_elements>0) {
      current_element=first_element;
      return position=1;
   }
   current_element=NULL;
   return position=0;
}


template <class T>
int dll_BAS<T>::last(void)
{
   if(n_elements>0) {
      current_element=last_element;
      return position=n_elements;
   }
   current_element=NULL;
   return position= 0;
}

template <class T>
int dll_BAS<T>::next(void)
{
   if (!position)
      return first();
   if (position!=n_elements) {
      current_element=current_element->next;
      return ++position;
   }
   current_element=NULL;
   return position=0;
}

template <class T>
int dll_BAS<T>::prev(void)
{
   if (!position)
      return last();
   if (position!=1) {
    current_element=current_element->prev;
    return --position;
   }
   current_element=NULL;
   return position=0;
}

template <class T>
int dll_BAS<T>::insert_r(T* item)
{
   dln_BAS<T>  *new_node_ptr;

   chknew((new_node_ptr= new dln_BAS<T>(item)));

   n_elements++;

   if (last_element==NULL)
      first_element=last_element=new_node_ptr;
   else {
      if (current_element==NULL) {
    new_node_ptr->prev=last_element;
    last_element->next=new_node_ptr;
    last_element=new_node_ptr;
      }
      else {
    new_node_ptr->next=current_element->next;
    if (current_element->next)
       current_element->next->prev=new_node_ptr;
    current_element->next=new_node_ptr;
    new_node_ptr->prev=current_element;
    if (current_element==last_element) last_element=new_node_ptr;
      }
   }
   return 1;
}

template <class T>
int dll_BAS<T>::del(void)
{
   dln_BAS<T>  *paso;

   if (!position) return 0;

   if (position==1)
      first_element=current_element->next;
   else
      current_element->prev->next=current_element->next;

   if (position==n_elements)
      last_element=current_element->prev;
   else
      current_element->next->prev=current_element->prev;

   if (first_element==NULL) {
      delete current_element->item;
      delete current_element;
      position=n_elements=0;
      current_element=NULL;
      return 1;
   }

   paso=current_element;
   if (current_element->next==NULL)   {
      current_element=current_element->prev;
      position=0;
      current_element=NULL;
   }
   else
      current_element=current_element->next;
   n_elements--;
   if (DEL_ITEM) delete paso->item;
   delete paso;
   return 1;
}


template <class T>
void dll_BAS<T>::del_all(void)
{
   for(first();del();first());
}

template <class T>
T* dll_BAS<T>::item(void)
{
   return current_element->item;
}


template <class T>
int dll_BAS<T>::is_out(void)
{
  return !position;
}

template <class T>
void dll_BAS<T>::out(void)
{
  position=0;
  current_element=NULL;
}
#endif
