#ifndef _PRGLOBAL_            
#define _PRGLOBAL_         /* Mark this header already included */

#ifdef __cplusplus
 extern "C" {
#endif

extern void PR_TrapNULLProc (void);

extern PR_MATERIAL *last_material;
extern PR_VIEWPORT active_viewport;
extern PR_UCHAR *PR_ZBuffer;

extern PR_DWORD PR_WORKFACEFLAGS;

#define XAXIS 0
#define YAXIS 1
#define ZAXIS 2



void PR_Initialize (PR_DWORD maxpoly);
/* -----------------------------------------------------------------------
   Function:   PR_Initialize
   Purpose:    Initializes Power Render 
   Parameters: maxpoly - Maximum number of polygons per frame
   Return:     None
   ----------------------------------------------------------------------- */


void PR_ShutDown (void);
/* -----------------------------------------------------------------------
   Function:   PR_Shutdown
   Purpose:    Shuts down Power Render 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */

/* ----------------------------------------------------------------- */
/* Converts a floating point number to an integer by truncation, using
   the FISTP instruction */
extern PR_REAL PR_FCNV;
extern PR_DWORD PR_ICNV;

void PR_FLOAT_TO_INTASM (void);
#pragma aux PR_FLOAT_TO_INTASM = \
    "fld PR_FCNV" \
    "fistp PR_ICNV";

#define PR_FLOAT_TO_INT(inreal, outint) \
 {  PR_FCNV = (inreal); \
    PR_FLOAT_TO_INTASM (); \
    (outint) = PR_ICNV; }

#define PR_FLOAT_TO_FIXED(inreal, outint) \
 {  PR_FCNV = (inreal) * 65536.0; \
    PR_FLOAT_TO_INTASM (); \
    (outint) = PR_ICNV; }

#define PR_FLOAT_ADD_TO_INT(inreal, outint) \
 {  PR_FCNV = (inreal); \
    PR_FLOAT_TO_INTASM (); \
    (outint) += PR_ICNV; }
/* ----------------------------------------------------------------- */

#ifdef __cplusplus
}
#endif

#endif


