#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <alloc.h>
#include <dir.h>
#include "d:\tge\tge.h"

/*
ͻ
             ۲ WordUp Graphics Toolkit V4.0               
 Conversion Utility   Copyright 1994 WordUp Software Productions 
Ķ
 Program:      spr2tge.c                                         
 Description:  Utility for converting a WGT sprite file to       
               The Graphics Engine (by Matthew Hildebrand)       
                                                                 
 Written by:   Chris Egerter                                     
ͼ
*/


void far *sprites[2001];
void convertsprites(char *,char *);
void loadsprites(char *,void far *loadspr[]);
void testsprites();
void freesprites(void far *freespr[]);
void forceExtension(char *filename, char *extention);
int maxx,maxy,colours;


void main (int argc, char *argv[])
{
  if (argc < 2)				/* Parse command line */
  {
    printf("WGT Sprite File to TGE converter\n\nUsage:  spr2tge driver\n\n");
    exit(1);
  }

  forceExtension(argv[1], ".DRV");	/* Load the specified driver */
  if (!loadGraphDriver(argv[1]))
  {
    printf("Error loading \"%s\".\n\n", argv[1]);
    exit(1);
  }

  maxx = _grSystemDrv->maxx+1;		/* set up variables */
  maxy = _grSystemDrv->maxy+1;
  colours = _grSystemDrv->colours+1;

  if (!initGraphics())			/* initialize graphics mode */
  {
    printf("Unable to initialize graphics hardware.\n\n");
    exit(1);
  }

   convertsprites("sprtconv.spr","out.spr");
   loadsprites("out.spr",sprites);
   testsprites();
   freesprites(sprites);


   /* clean up */
  deInitGraphics();			/* restore text and quit */
  unloadGraphDriver();
}

void forceExtension(char *filename, char *extention)
{
  char fileDrive[MAXDRIVE];
  char fileDir[MAXDIR];
  char fileFile[MAXFILE];
  char fileExt[MAXEXT];

  fnsplit(filename, fileDrive, fileDir, fileFile, fileExt);

  if (strcmpi(fileExt, extention))
    fnmerge(filename, fileDrive, fileDir, fileFile, extention);
}

void convertsprites(char *infile,char *outfile)
{
FILE *in;   /* 256 color sprite file */
FILE *out;  /* converted sprite file */
unsigned char palette[768]; 		/* 256 * 3 (RGB values) */
int maxcolor;
int maxsprite;
long size;

unsigned char far *temp;
int a,b,i,spritemade;
char buf[14];
int x,y;
int startingsprite;

    /* Open the files */
    if ((in = fopen (infile, "rb")) == NULL)
	   {
	   deInitGraphics();			/* restore text and quit */
	   unloadGraphDriver();
	   printf("Could not open 256 color sprite file");
	   exit(1);
	   }
    if ((out = fopen (outfile, "wb")) == NULL)
	   {
	   deInitGraphics();			/* restore text and quit */
	   unloadGraphDriver();
	   printf("Could not open converted sprite file");
	   exit(1);
	   }

 fread(&a, 1, 2, in);
     /* Get the version number, and change the startingsprite accordingly.
     If version <= 3, maxsprite contains the maximum number of sprites
     that can be stored in a file.  If version > 4, maxsprite contains
     the number of the highest sprite in the file. (empty sprites at
     the end are not kept in the file. */
 if (a <= 3)
   startingsprite = 1;
 else startingsprite = 0;    /* Version 4 starts at sprite 0 */


    fread (buf, 1, 13, in); /* sprite header */
    if (0 == strnicmp (" Sprite File ", buf, 13)) /* see if it is a sprite file */
    {
	fread(palette,1,768,in); /* Read in 256 color palette */
	maxcolor=colours;
        fwrite(&maxcolor, 1, 2, out);
        /* Write the number of colors stored in file */

	for (i = 0; i < maxcolor; i++) /* read in the palette */
        {
	   fputc(palette[i*3],out);    /* Write out Red */
	   fputc(palette[i*3+1],out);  /* Green */
	   fputc(palette[i*3+2],out);  /* And Blue color values */

        }
        
        fread(&maxsprite, 1, 2, in); /* maximum sprites in this file */
        fwrite(&maxsprite, 1, 2, out);
	for (i = startingsprite; i <= maxsprite; i++) /* load them in */
	{
            fread(&spritemade, 1, 2, in); /* flag to see if sprite exists */
            fwrite(&spritemade, 1, 2, out);
	    if (spritemade == 1)
	    {
		filledRect(0,0,319,199,0);  /* maximum sprite size */
                fread(&a, 1, 2, in); /* get width and height */
                fread(&b, 1, 2, in);
                fwrite(&a, 1, 2, out); /* put width and height */
                fwrite(&b, 1, 2, out);

		/* Read in the image data. Each byte represents a color
		from 0-255. Obviously converting sprites that use more colors
		than the current mode allows will not work. Draw sprites using
		only the first colors (eg 0-16), up to maxcolors of the mode you're using. */
		for (y=0; y<b; y++)
		  for (x=0; x<a; x++)
		     putPixel(x,y,fgetc(in));


		size = imageSize(0, 0, a-1, b-1); /* get byte size of image */
		if ((temp = farmalloc(size)) == NULL)
		    {
		      deInitGraphics();
		      unloadGraphDriver();
		      printf("Error: not enough heap space in convertsprites.\n");
		      exit(1);
		   }
		getImage(0, 0, a-1, b-1,temp); /* Get the image in new mode */
		fwrite(temp,size,1,out); /* Write the data in getimage format */
		farfree(temp);
	    }
        }
    }
    fclose (in);
    fclose (out);
}

void loadsprites(char *infile,void far *loadspr[])
{
FILE *in;   /* converted color sprite file */
int maxsprite;
unsigned char pal[768];
int maxcolor;
long size;

int a,b,i,spritemade;

    /* Open the files */
    if ((in = fopen (infile, "rb")) == NULL)
	   {
	   deInitGraphics();			/* restore text and quit */
	   unloadGraphDriver();
	   printf("Could not load converted color sprite file");
	   exit(1);
	   }

	fread(&maxcolor, 1, 2, in);

	fread(pal,3*maxcolor,1,in);
	for (i = 0; i < maxcolor*3; i++)
	   pal[i]*=4;
	/* We need to multiply the colour values by 4 since WGT has an
	   intensity range of 0-64 while TGE uses 0-255. */

	setBlockPalette(0,256,pal);
	
	fread (&maxsprite, 1, 2, in);
           /* maximum sprites in this file */

	for (i = 0; i < maxsprite; i++) /* load them in */
	{
	    fread (&spritemade, 1, 2, in);
             /* flag to see if sprite exists */

	    if (spritemade == 1)
	    {
		fread(&a, 1, 2, in); /* get width and height */
		fread(&, 1, 2, in);


		size = imageSize(0, 0, a-1, b-1); /* get byte size of image */
		if ((loadspr[i] = farmalloc(size)) == NULL)
		    {
		      deInitGraphics();			/* restore text and quit */
		      unloadGraphDriver();
		      printf("Error: not enough heap space in loadsprites().\n");
		      freesprites(loadspr);
		      exit(1);
		   }
		fread(loadspr[i],size,1,in);
	    } 
	    else loadspr[i]=NULL;
	
    }
    fclose(in);
}




void testsprites(void)
/* Loops through 10 sprites, displaying them on the screen
   using the putimage method. Press a key to go to the next sprite. */
{
int i,j;

for (i=0; i<10; i++) 
  {
  clearGraphics(0);
  
   if (sprites[i] !=NULL)
     {
     for (j=1; j<20; j++)
       putImage(rand() % maxx,rand() % maxy,sprites[i]);
       /* Put the converted image on the screen */
     getch();
     }
  }
}

void freesprites(void far *freespr[])
{
int i;

for (i = 0; i < 2001; i++)
  {
  if (freespr[i] !=NULL)
    farfree(freespr[i]);
  }
}