/* Power Render 3Dfx State Interface */

#ifndef _PRSTATE3DFX_
#define _PRSTATE3DFX_

#ifdef __cplusplus
  extern "C" {
#endif

/* Initialized the texture mapping coordinates, using either environment
   mapping or copying from the face data */
#define SET_TMAP(mat, renderpoly1, renderpoly2, renderpoly3, vptr1, vptr2, vptr3, vptr1data, vptr2data, vptr3data, facedata) { \
       ADDPRIV_tmap = 1;                                                  \
       if (mat->environment_map)                                          \
         {                                                                \
          if (mat->environment_axis == ZAXIS)                             \
            {                                                             \
             (renderpoly1)->s0 = ((vptr1)->wnx >> 3) + 128.0f;            \
             (renderpoly1)->t0 =-((vptr1)->wny >> 3) + 128.0f;            \
             (renderpoly2)->s0 = ((vptr2)->wnx >> 3) + 128.0f;            \
             (renderpoly2)->t0 =-((vptr2)->wny >> 3) + 128.0f;            \
             (renderpoly3)->s0 = ((vptr3)->wnx >> 3) + 128.0f;            \
             (renderpoly3)->t0 =-((vptr3)->wny >> 3) + 128.0f;            \
            }                                                             \
          else if (mat->environment_axis == XAXIS)                        \
            {                                                             \
             (renderpoly1)->s0 = ((vptr1)->wnz >> 3) + 128.0f;            \
             (renderpoly1)->t0 =-((vptr1)->wny >> 3) + 128.0f;            \
             (renderpoly2)->s0 = ((vptr2)->wnz >> 3) + 128.0f;            \
             (renderpoly2)->t0 =-((vptr2)->wny >> 3) + 128.0f;            \
             (renderpoly3)->s0 = ((vptr3)->wnz >> 3) + 128.0f;            \
             (renderpoly3)->t0 =-((vptr3)->wny >> 3) + 128.0f;            \
            }                                                             \
          if (mat->environment_axis == YAXIS)                             \
            {                                                             \
             (renderpoly1)->s0 = ((vptr1)->wnx >> 3) + 128.0f;            \
             (renderpoly1)->t0 =-((vptr1)->wnz >> 3) + 128.0f;            \
             (renderpoly2)->s0 = ((vptr2)->wnx >> 3) + 128.0f;            \
             (renderpoly2)->t0 =-((vptr2)->wnz >> 3) + 128.0f;            \
             (renderpoly3)->s0 = ((vptr3)->wnx >> 3) + 128.0f;            \
             (renderpoly3)->t0 =-((vptr3)->wnz >> 3) + 128.0f;            \
            }                                                             \
         }                                                                \
         else                                                             \
         {                                                                \
             (renderpoly1)->s0 = facedata->u[0];                          \
             (renderpoly1)->t0 = facedata->v[0];                          \
             (renderpoly2)->s0 = facedata->u[1];                          \
             (renderpoly2)->t0 = facedata->v[1];                          \
             (renderpoly3)->s0 = facedata->u[2];                          \
             (renderpoly3)->t0 = facedata->v[2];                          \
         }                                                               }


/* Multiply texture coordinates by 1/z (required by 3Dfx) */
#define FIX_TMAP(vert1, vert2, vert3) { \
    (vert1)->s0 *= (vert1)->ooz;        \
    (vert1)->t0 *= (vert1)->ooz;        \
    (vert2)->s0 *= (vert2)->ooz;        \
    (vert2)->t0 *= (vert2)->ooz;        \
    (vert3)->s0 *= (vert3)->ooz;        \
    (vert3)->t0 *= (vert3)->ooz;        }


/* Make sure the colors are in the correct range */
#define CLAMP_RGB {    \
  if (ADDPRIV_r > 255.0f) \
    ADDPRIV_r = 255.0f;   \
  if (ADDPRIV_g > 255.0f) \
    ADDPRIV_g = 255.0f;   \
  if (ADDPRIV_b > 255.0f) \
    ADDPRIV_b = 255.0f;   \
  if (ADDPRIV_r < 0.0f)   \
    ADDPRIV_r = 0.0f;     \
  if (ADDPRIV_g < 0.0f)   \
    ADDPRIV_g = 0.0f;     \
  if (ADDPRIV_b < 0.0f)   \
    ADDPRIV_b = 0.0f;   }


void PR_CalcFaceLighting3Dfx (PR_FACE *face);
/* Calculates the lighting value for a given face */

void PR_CalcVertexLighting3Dfx (PR_VERTEX *vert, PR_VERTEX_DATA *vertdata);
/* Calculates the lighting value for a given vertex */

/* These are the globals used for rendering.   */
extern PR_FACE_DATA_REAL * ADDPRIV_facedatareal; /* Face Data in floating point format */
extern PR_FACE *        ADDPRIV_face;         /* Pointer to the current face */
extern PR_MATERIAL *    ADDPRIV_mat;          /* Pointer to the current material */
extern PR_VERTEX *      ADDPRIV_vptr1;        /* Pointer to vertices */
extern PR_VERTEX *      ADDPRIV_vptr2;
extern PR_VERTEX *      ADDPRIV_vptr3;
extern PR_VERTEX_DATA * ADDPRIV_vptr1data;    /* Pointer to vertex data */
extern PR_VERTEX_DATA * ADDPRIV_vptr2data;
extern PR_VERTEX_DATA * ADDPRIV_vptr3data;
extern PR_DWORD         ADDPRIV_tmap;         /* Set to TRUE if tmapped */
extern PR_UWORD         ADDPRIV_material_num; /* Current material number */
extern PR_REAL          ADDPRIV_r;            /* RGB color of the current vertex */
extern PR_REAL          ADDPRIV_g;
extern PR_REAL          ADDPRIV_b;
extern PR_DWORD         ADDPRIV_setup_data;   /* TRUE if color and texture data is to be initialized */
extern PR_DWORD         ADDPRIV_setup_state;  /* TRUE if the blending functions are to be initialized */

#ifdef __cplusplus
}
#endif

#endif

