#ifndef __BGI_PAINT_H_
#define __BGI_PAINT_H_

/*  Adapted Paint class for usage with BGI, Win GDI or other library.
    We suppose that this library is already initiated before functions call.
*/

/////////////////////////////////////////////////////////////////////////////
/* List of graphics libraries. Could be continued. To use concrete library,
   unremark concrete line. Or use Options - Compiler - Code generation -
   Defines to define the necessary variable
*/
//#define DOS_BGI
//#define WIN_GDI

#include "simple.h"
//////////////// Common color ref. and fill code ////////////////////////
#ifndef RGB

#define COLORREF unsigned long
#define BYTE uchar
#define WORD unsigned short
#define DWORD unsigned long

#define RGB(r,g,b) ((COLORREF)(((BYTE)(r)|((WORD)(g)<<8))| \
    (((DWORD)(BYTE)(b))<<16)))

#endif RGB
////////////////////////////////////////////////////////////////////////////
#ifdef DOS_BGI

#define PS_SOLID                SOLID_LINE
#define PS_DASH	                DASHED_LINE
#define PS_DOT                  DOTTED_LINE
#define PS_DASHDOT              CENTER_LINE
#define PS_DASHDOTDOT           CENTER_LINE
#define PS_NULL	                SOLID_LINE
#define PS_INSIDEFRAME          SOLID_LINE


#define HS_BDIAGONAL	        SLASH_FILL
#define HS_CROSS	        HATCH_FILL
#define HS_DIAGCROSS	        XHATCH_FILL
#define HS_FDIAGONAL	        BKSLASH_FILL
#define HS_HORIZONTAL           LINE_FILL
#define HS_VERTICAL	        LTSLASH_FILL

#endif DOS_BGI
///////////////////////////
#ifdef WIN_GDI
#define SOLID_FILL              1

#define SOLID_LINE              PS_SOLID
#define DASHED_LINE             PS_DASH
#define DOTTED_LINE             PS_DOT
#define CENTER_LINE             PS_DASHDOT


#define SLASH_FILL              HS_BDIAGONAL
#define HATCH_FILL              HS_CROSS
#define XHATCH_FILL             HS_DIAGCROSS
#define BKSLASH_FILL            HS_FDIAGONAL
#define LINE_FILL               HS_HORIZONTAL
#define LTSLASH_FILL            HS_VERTICAL

#endif WIN_GDI
////////////////////////////////////////////////////////////////////////////
#define HS_SOLID                SOLID_FILL
//////////////////////////////////////////////////////////
#if !defined(__COLORS)
#define __COLORS

enum COLORS { BLACK, BLUE, GREEN, CYAN, RED, MAGENTA, BROWN, LIGHTGRAY,
    DARKGRAY, LIGHTBLUE, LIGHTGREEN, LIGHTCYAN, LIGHTRED, LIGHTMAGENTA,
    YELLOW, WHITE };
#endif __COLORS
////////////////////////////////////////////////////////////////////////////
struct color_to_16
    {
    int color;
    COLORREF colorref;
    };

extern color_to_16 tricolors[16];
////////////////////////////////////////////////////////////////////////////

///////////////////////////// Code for DOS BGI /////////////////////////////
#ifdef DOS_BGI
#include "paint.h"
#include <graphics.h>


struct To_Paint
    {
    To_Paint() { ::setcolor(BLACK); ::setfillstyle(SOLID_FILL, BLACK); }
    int getx() { return ::getx(); }
    int gety() { return ::gety(); }
    int getcolor() { return ::getcolor(); }
    int getcolor(COLORREF color);
    COLORREF getcolorref() { return tricolors[::getcolor()].colorref; }

    void setcolor(int color) { ::setcolor(color); }
    void setcolor(int r, int g, int b)
	{ setcolor(getcolor(RGB(r,g,b))); }

    void putpixel(int x, int y) { ::putpixel(x, y, getcolor()); }
    void setlinestyle(int width, int style)
	{  ::setlinestyle(style, 1, width); }
    void setlinestyle(int style, unsigned int p, int width)
	{  ::setlinestyle(style, p, width); }
    void setfillstyle(int pattern, int col)
	{ ::setfillstyle(pattern, col); }
    void setfillstyle(int style, COLORREF col)
	{
	setfillstyle(style, getcolor(col));
	}

    void moveto(int x, int y) { ::moveto(x, y); }
    void lineto(int x, int y) { ::lineto(x, y); }
    void fillpoly(int numpoints, int* polypoints)
	{ ::fillpoly(numpoints, polypoints); }
    void drawpoly(int numpoints, int far* points)
	{ ::drawpoly(numpoints, points); }
    };
#endif DOS_BGI
//////////////////////////// End of DOS BGI part ////////////////////////////
//////////////////////////// Code for Windows GDI ///////////////////////////
#ifdef WIN_GDI

#define WIN31

#undef COLORREF 
#undef BYTE 
#undef WORD 
#undef DWORD

#undef RGB

#include <owl.h>   // Or <windows.h>
#include "paint.h"

struct To_Paint
    {
    int PenSize;
    int PenStyle;
    COLORREF color;

    int pattern_num;
    COLORREF BrushColor;

    HDC DC;
    /////////////////////////////////
    To_Paint() { pattern_num = SOLID_FILL; PenSize = 1; PenStyle = PS_SOLID;
		 color = RGB(0,0,0); BrushColor = RGB(0,0,0); }
    /////////////////////////////////
    int getx() { POINT p; ::GetCurrentPositionEx(DC, &p); return p.x; }
    int gety() { POINT p; ::GetCurrentPositionEx(DC, &p); return p.y; }
    COLORREF getcolorref() { return color; }
    int getcolor(COLORREF col);
    int getcolor() { return getcolor(color); }

    void setcolor(int r, int g, int b)	{ color = RGB(r,g,b); }
    void setcolor(int c)
	{ color = tricolors[c].colorref; }

    void putpixel(int x, int y) { ::SetPixel(DC, x, y, getcolorref()); }
    void setlinestyle(int width, int style)
	{ PenSize = width; PenStyle = style; }
    void setlinestyle(int style, unsigned int, int width)
	{ PenSize = width; PenStyle = style; }

    void setfillstyle(int style, int col)
	{
	pattern_num = style;
	BrushColor = tricolors[col].colorref;
	}
    void setfillstyle(int style, COLORREF col)
	{
	pattern_num = style;
	BrushColor = col;
	}

    void moveto(int x, int y) { ::MoveTo(DC, x, y); }
    void lineto(int x, int y);
    void fillpoly(int numpoints, int* polypoints);
    void drawpoly(int numpoints, int far* points);
    };

#endif WIN_GDI
///////////////////// End of Windows GDI part /////////////////////////

/////////////////////////////////////////////////////////////////////////////
/*  KH_Paint class could draw graphics primitives using different libraries,
    zoom, scroll, rotate (including complex rotations) and so on.
*/

class KH_Paint : public To_Paint, public Paint
    {
    public:
	KH_Paint();

        int getx();
        int gety();
	loc get_CP();
	void putpixel(int x, int y);
	void line(int xstart, int ystart, int xend, int yend)
	    { moveto(xstart, ystart); lineto(xend, yend); }

	void lineto(int x, int y);
	void moveto(int x, int y);
	void circle(int x, int y, int radius)
            { ellipse(x, y, 0, 360, radius, radius); }
	void ellipse(int x, int y, int stangle, int endangle, int xr, int yr);
	void rectangle(int left, int top, int right, int bottom);
	void drawpoly(int numpoints, int far* points);
	void fillpoly(int numpoints, int far* points)
	    { int f = fill; fill = ON; drawpoly(numpoints, points);
	    fill = f; }
	void bar3d(int l, int t, int r, int b, int d, int top);
	virtual void outtext(uchar far* str, int dir = 0);

    };

#endif __BGI_PAINT_H_
