/****************************************************************************/
/* MSGBOX                                                                   */
/*--------------------------------------------------------------------------*/
/* Opens a message box and waits for the user to press a button             */
/****************************************************************************/

#ifndef _MSGBOX_H_
#define _MSGBOX_H_


  #ifdef __JPTUI__
    #include "Sound.h"
  #else
    #include "JPTui.h"
  #endif

/*ͻ*/
/*                                 CONSTANTS                              */
/*ͼ*/

/*--------------*/
/* window_style */
/*--------------*/

// Style (color) of the dialog box :

// DIALOG1, DIALOG2, HELP, ALERT...
// See TWindow.h (in JPTui.h)

/*----------------------------------------*/
/* type = buttons | icon | default button */
/*----------------------------------------*/

// buttons

#define MB_OK               0
#define MB_OKCANCEL         1     //0000 0000 0000 0001
#define MB_OKQUIT           2     //0000 0000 0000 0010
#define MB_ABORTRETRYIGNORE 3     //0000 0000 0000 0011
#define MB_YESNOCANCEL      4     //0000 0000 0000 0100
#define MB_YESNO	    5     //0000 0000 0000 0101
#define MB_RETRYCANCEL      6     //0000 0000 0000 0110

// icon

#define MB_NOICON	    0     //0000 0000 0001 0000
#define MB_ICONSTOP        16     //0000 0000 0001 0000
#define MB_ICONQUESTION    32     //0000 0000 0010 0000
#define MB_ICONEXCLAMATION 48     //0000 0000 0011 0000
#define MB_ICONINFORMATION 64     //0000 0000 0100 0000

// default button

#define MB_DEFBUTTON1       0
#define MB_DEFBUTTON2     256     //0000 0001 0000 0000
#define MB_DEFBUTTON3     512     //0000 0010 0000 0000

/*------------*/
/* sound_type */
/*------------*/

// sound to play when the dialog box opens :

// ERROR_SOUND, BIP1...
// See Sound.h (in JPTui.h)


/*----------------*/
/* Returned value */
/*----------------*/

#define OK_BUTTON         1
#define CANCEL_BUTTON     2
#define QUIT_BUTTON       3
#define ABORT_BUTTON	  4
#define RETRY_BUTTON	  5
#define IGNORE_BUTTON	  6
#define YES_BUTTON	  7
#define NO_BUTTON	  8

/*ͻ*/
/*                                 FUNCTIONS                              */
/*ͼ*/

int MessageBox(char *title,
	       char *message,
	       int window_style,
	       int type=MB_OK,
	       TSound sound_type=NO_SOUND);

#endif