// File from page 245 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT02.ZIP 4/11/95
// (Original ECKELT01.ZIP dated 2/21/95)
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: MANIPS.CPP -- FORMAT.CPP using manipulators
#include <fstream.h>
#include <iomanip.h>

main() {
  ofstream T("trace.out");
  int i = 47;
  float f = 2300114.414159;
  char* s = "Is there any more?";

  T << setiosflags(
         ios::unitbuf | ios::stdio
         | ios::showbase | ios::uppercase
         | ios::showpos
       );
  T << i << endl; // Default to dec
  T << hex << i << endl;
  T << resetiosflags(ios::uppercase)
    << oct << i << endl;
  T.setf(ios::left, ios::adjustfield);
  T << resetiosflags(ios::showbase)
    << dec << setfill('0');
  T << "fill char: " << T.fill() << endl;
  T << setw(10) << i << endl;
  T.setf(ios::right, ios::adjustfield);
  T << setw(10) << i << endl;
  T.setf(ios::internal, ios::adjustfield);
  T << setw(10) << i << endl;
  T << i << endl; // Without setw(10)
  
  T << resetiosflags(ios::showpos)
    << setiosflags(ios::showpoint)
    << "prec = " << T.precision() << endl;
  T.setf(ios::scientific, ios::floatfield);
  T << f << endl;
  T.setf(ios::fixed, ios::floatfield);
  T << f << endl;
  T.setf(0, ios::floatfield); // Automatic
  T << f << endl;
  T << setprecision(20);
  T << "prec = " << T.precision() << endl;
  T << f << endl;
  T.setf(ios::scientific, ios::floatfield);
  T << f << endl;
  T.setf(ios::fixed, ios::floatfield);
  T << f << endl;
  T.setf(0, ios::floatfield); // Automatic
  T << f << endl;
 
  T << setw(10) << s << endl;
  T << setw(40) << s << endl;
  T.setf(ios::left, ios::adjustfield);
  T << setw(40) << s << endl;

  T << resetiosflags(
         ios::showpoint | ios::unitbuf 
         | ios::stdio
       );
}
